/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.AvalUser;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.dto.AvalUserInfo;
import com.geoway.landteam.landcloud.core.model.user.dto.RegUserInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.UserArea;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.pub.AvalUserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfOrgRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.repository.user.YXUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.VertifyServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.geoway.landteam.landcloud.core.service.util.SMSUtilHuawei;
import com.gw.base.data.GwValidateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MSecurityService {
    @Autowired
    LandUserService landUserService;
    @Autowired
    YXUserRepository yxUserRepository;
    @Autowired
    FriendsServiceImpl friendsService;
    @Autowired
    LandRegUserRepository landRegUserRepository;
    @Autowired
    UserRoleInfoRepository userRoleInfoRepository;
    @Autowired
    VertifyServiceImpl vertifyService;
    @Autowired
    RegionService regionService;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    UserAreaRepository userAreaRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    Organization2UserRepository organization2UserRepository;
    @Autowired
    AvalUserRepository avalUserRepository;
    @Autowired
    LandRegUserService landRegUserService;
    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;
    @Autowired
    UserCloudAreaRepository userCloudAreaDao;
    @Autowired
    UserApplicationRepository userApplicationRepository;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Autowired
    SysConfigService sysConfigService;

    private boolean isMyFriend(Long ownerId, Long userId) throws Exception {
        List friends = this.friendsService.getMyFriends(ownerId);
        if (friends.isEmpty()) {
            return false;
        }
        for (LandUser myFriend : friends) {
            if (!myFriend.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public void updateToken(Long userId) {
        YXUser yxUser = this.yxUserRepository.findOneByUserId(userId);
        if (yxUser != null) {
            String result = CloudMsgUtil.refreshToken((String)yxUser.getAccid());
            Map map = (Map)JSON.parse((String)result, (Feature[])new Feature[0]);
            String newToken = (String)((Map)map.get("info")).get("token");
            yxUser.setToken(newToken);
            this.yxUserRepository.save((Object)yxUser);
        }
    }

    public void register(RegUserInfo user) throws Exception {
        LandRegUser landRegUser = this.landRegUserRepository.queryOneByPhoneNum(user.getPhone());
        if (landRegUser != null) {
            throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
        List userOfPhone = this.landUserRepository.queryNormalUserByPhone(user.getPhone());
        if (!userOfPhone.isEmpty()) {
            throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
        LandRegUser landRegUser1 = this.landRegUserRepository.findOneByName(user.getName());
        if (landRegUser1 != null) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        List userOfName = this.landUserRepository.queryUserByName(user.getName());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (StringUtils.isBlank((CharSequence)user.getRoleIds())) {
            throw new RuntimeException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getSjsf())) {
            throw new RuntimeException("\u6240\u5728\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties((Object)user, (Object)newUser);
        if (user.getRoleIds().equals("10007")) {
            newUser.setSjsf("1");
            newUser.setPostId(null);
        } else {
            if (StringUtils.isBlank((CharSequence)user.getPostId())) {
                throw new RuntimeException("\u6240\u5728\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List list = this.organizationRepository.queryOneByName(user.getPostId());
            for (Organization organization : list) {
                if (!StringUtils.isBlank((CharSequence)organization.getRegionCode()) && organization.getRegionCode().equals(user.getSjsf())) continue;
                throw new RuntimeException("\u5176\u4ed6\u884c\u653f\u533a\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + user.getPostId() + "]\u7684\u5355\u4f4d");
            }
        }
        newUser.setState(Integer.valueOf(0));
        newUser.setCreateTime(new Date());
        this.landRegUserRepository.save((Object)newUser);
    }

    public void register1(RegUserInfo user) throws Exception {
        if (this.isPhoneRegistered(user.getPhone())) {
            throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c");
        }
        List userOfName = this.landUserRepository.queryUserByName(user.getName());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        LandRegUser landRegUser1 = this.landRegUserRepository.findOneByName(user.getName());
        if (landRegUser1 != null) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (StringUtils.isBlank((CharSequence)user.getRoleIds())) {
            throw new RuntimeException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)user.getSjsf())) {
            throw new RuntimeException("\u6240\u5728\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties((Object)user, (Object)newUser);
        newUser.setDepName(user.getDepName());
        if (user.getRoleIds().equals("10007")) {
            SysConfig publicConfig = this.sysConfigService.findOne("publicConfig");
            String bizId = "";
            String unitId = "";
            if (publicConfig != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)publicConfig.getValue());
                bizId = jsonObject.getString("zngl");
                unitId = jsonObject.getString("unit");
            }
            newUser.setDepNo(unitId);
            if (StringUtils.isNotBlank((CharSequence)newUser.getBizRegion())) {
                JSONObject js = new JSONObject();
                js.put(bizId, (Object)newUser.getBizRegion());
                String code = newUser.getBizRegion().substring(0, 6);
                newUser.setSjsf(code);
                newUser.setRegionCode(code);
                JSONObject js1 = new JSONObject();
                js1.put("zngl", (Object)bizId);
                newUser.setBusiness(js1.toJSONString());
                newUser.setBizRegion(js.toJSONString());
            }
        } else {
            if (StringUtils.isBlank((CharSequence)user.getPostId())) {
                throw new RuntimeException("\u5355\u4f4d\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)user.getDepNo())) {
                if (StringUtils.isBlank((CharSequence)user.getParentDepNo())) {
                    throw new RuntimeException("\u65b0\u5efa\u5355\u4f4d\u7236\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List list = this.organizationRepository.queryOneByName(user.getPostId());
                for (Organization organization : list) {
                    if (!StringUtils.isBlank((CharSequence)organization.getRegionCode()) && organization.getRegionCode().equals(user.getSjsf())) continue;
                    throw new RuntimeException("\u5176\u4ed6\u884c\u653f\u533a\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + user.getPostId() + "]\u7684\u5355\u4f4d");
                }
            }
        }
        newUser.setState(Integer.valueOf(0));
        newUser.setCreateTime(new Date());
        newUser.setUserId(Long.valueOf(1L));
        this.landRegUserRepository.save((Object)newUser);
    }

    @Transactional
    public void reviewRegister(Long adminId, AvalUserInfo info) throws Exception {
        LandRegUser regUser = this.landRegUserRepository.findById((Object)info.getId()).orElse(null);
        regUser.setState(info.getState());
        regUser.setReason(info.getReason());
        if (StringUtils.isNotBlank((CharSequence)info.getSjsf())) {
            regUser.setSjsf(info.getSjsf());
        }
        regUser.setRoleIds(info.getRoleIds());
        if ("1".equals(info.getState().toString())) {
            if (!info.getRoleIds().equals("10007")) {
                if (StringUtils.isBlank((CharSequence)info.getDepNo()) && StringUtils.isBlank((CharSequence)info.getPostId())) {
                    throw new RuntimeException("\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa");
                }
                if (!StringUtils.isBlank((CharSequence)info.getDepNo())) {
                    Organization organization = this.organizationRepository.findById((Object)info.getDepNo()).orElse(null);
                    if (organization == null) {
                        throw new RuntimeException("\u5355\u4f4d[" + info.getPostId() + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efa");
                    }
                } else if (!StringUtils.isBlank((CharSequence)info.getPostId())) {
                    List organizations = this.organizationRepository.queryOneByName(info.getPostId());
                    if (organizations.size() == 0) {
                        throw new RuntimeException("\u5355\u4f4d[" + info.getPostId() + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efa");
                    }
                    if (organizations.size() > 1) {
                        throw new RuntimeException("\u5355\u4f4d[" + info.getPostId() + "]\u91cd\u590d\uff0c\u65e0\u6cd5\u5ba1\u6838");
                    }
                    Organization organization = (Organization)organizations.get(0);
                    info.setDepNo(organization.getId());
                }
            }
            regUser.setDepNo(info.getDepNo());
            this.saveFormalUserInfo(regUser, info);
            String appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
            UserApplication userApplication = new UserApplication();
            userApplication.setUserId(regUser.getUserId());
            userApplication.setApplicationId(appkey);
            this.userApplicationRepository.save((Object)userApplication);
            if (info.getRoleIds().contains("10020")) {
                Organization organization = this.organizationRepository.findById((Object)info.getDepNo()).orElse(null);
                if (organization == null) {
                    throw new RuntimeException("\u5355\u4f4d\u4e0d\u5b58\u5728");
                }
                ArrayList<String> orgIdList = new ArrayList<String>();
                orgIdList.add(organization.getId());
            }
            String templateParas = "[\"" + regUser.getName() + "\"]";
            String telphone = regUser.getPhone();
            if (!telphone.startsWith("+86")) {
                telphone = "+86" + telphone;
            }
            SMSUtilHuawei.sendSMS((String)"csms18120613", (String)"6b55c247446849a898ded08b578abc4f", (String)templateParas, (String)telphone);
        } else if ("2".equals(info.getState().toString())) {
            if (StringUtils.isBlank((CharSequence)info.getReason())) {
                throw new RuntimeException("\u4e0d\u540c\u610f\u7533\u8bf7\u65f6\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String templateParas = "[\"" + regUser.getName() + "\",\"" + info.getReason() + "\"]";
            String telphone = regUser.getPhone();
            if (!telphone.startsWith("+86")) {
                telphone = "+86" + telphone;
            }
            SMSUtilHuawei.sendSMS((String)"csms18120613", (String)"9f172e268a064b4f9b3a6cce263d35a5", (String)templateParas, (String)telphone);
        } else if ("0".equals(info.getState().toString())) {
            regUser.setPostId(info.getPostId());
            regUser.setDepNo(info.getDepNo());
        }
        this.landRegUserRepository.save((Object)regUser);
        if ("2".equals(info.getState().toString())) {
            AvalUser avalUser = new AvalUser();
            avalUser.setApproverId(adminId);
            avalUser.setOpinion(info.getReason());
            avalUser.setRegUserId(regUser.getId());
            this.avalUserRepository.save((Object)avalUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFormalUserInfo(LandRegUser regUser, AvalUserInfo info) throws Exception {
        String[] roleArr;
        LandUser user = new LandUser();
        user.setPassword(regUser.getPassword());
        user.setName(regUser.getName());
        user.setIsdel(Integer.valueOf(0));
        user.setRname(regUser.getName());
        user.setPhone(regUser.getPhone());
        user.setDepId(info.getPostId());
        user.setSjsf(regUser.getSjsf());
        user.setState(Integer.valueOf(1));
        user.setCreateTime(new Date());
        MSecurityService mSecurityService = this;
        synchronized (mSecurityService) {
            String[] users = this.landUserRepository.queryUserByName(regUser.getName());
            if (users != null && users.size() > 0) {
                throw new GwValidateException("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
            }
            this.landUserRepository.save((Object)user);
        }
        regUser.setUserId(user.getId());
        regUser.setRname(user.getName());
        this.landRegUserRepository.save((Object)regUser);
        for (String roleId : roleArr = regUser.getRoleIds().split(",")) {
            UserRoleInfo ur = new UserRoleInfo();
            ur.setId(UUID.randomUUID().toString());
            ur.setRoleinfoid(roleId);
            ur.setUserid(user.getId());
            this.userRoleInfoRepository.save((Object)ur);
        }
        String roleCloudIds = info.getCloudRoles();
        if (StringUtils.isNotBlank((CharSequence)roleCloudIds)) {
            String[] ids;
            for (String id : ids = roleCloudIds.split(",")) {
                RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
                roleCloudQueryRel.setCid(id);
                roleCloudQueryRel.setUid(user.getId().toString());
                this.roleCloudQueryRelRepository.save((Object)roleCloudQueryRel);
            }
        }
        UserArea userArea = new UserArea();
        userArea.setUserId(user.getId());
        userArea.setCode(regUser.getSjsf());
        userArea.setCreateTime(new Date());
        userArea.setState(Integer.valueOf(1));
        this.userAreaRepository.save((Object)userArea);
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(user.getId());
        userCloudArea.setCode(regUser.getSjsf());
        userCloudArea.setCreateTime(new Date());
        userCloudArea.setState(Integer.valueOf(1));
        this.userCloudAreaDao.save((Object)userCloudArea);
        if (StringUtils.isNotBlank((CharSequence)info.getDepNo())) {
            Organization organization = this.organizationRepository.findById((Object)info.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(organization.getId());
            organization2User.setUserId(user.getId());
            this.organization2UserRepository.save((Object)organization2User);
        }
    }

    public boolean isPhoneRegistered(String phone) throws Exception {
        LandRegUser regUser = this.landRegUserRepository.queryOneByPhoneNum(phone);
        if (regUser != null) {
            return true;
        }
        List landUsers = this.landUserRepository.queryNormalUserByPhone(phone);
        return !landUsers.isEmpty();
    }

    public void renewPhoneNum(Long userId, String newPhoneNum, String verifyCode) throws Exception {
        LandUser user = this.landUserRepository.findById((Object)userId).orElse(null);
        if (user == null) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (this.isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
        }
        List curVerty = this.vertifyService.findByFilter(newPhoneNum, verifyCode);
        if (curVerty.size() == 0) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        user.setPhone(newPhoneNum);
        this.landUserRepository.save((Object)user);
        LandRegUser regUser = this.landRegUserRepository.queryOneByUserId(userId);
        if (regUser != null) {
            regUser.setPhone(newPhoneNum);
            this.landRegUserRepository.save((Object)regUser);
        }
    }

    public int renewPhoneNumSafe(Long userId, String newPhoneNum, String verifyCode, String oldVerify, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (this.isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
        }
        LandUser user = this.landUserRepository.findById((Object)userId).orElse(null);
        if (user == null) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!this.checkVerifySession(request, oldVerify, "SIMPLE_SMSCODE_SESSION_KEY").booleanValue()) {
            return 1;
        }
        if (!this.checkVerifySession(request, verifyCode, "SIMPLE_SMSCODE_CHANGEPHONE_KEY").booleanValue()) {
            return 2;
        }
        user.setPhone(newPhoneNum);
        this.landUserRepository.save((Object)user);
        List landRegUsers = this.landRegUserRepository.queryRegUserByName(user.getName());
        if (landRegUsers.size() > 0) {
            LandRegUser landRegUser = (LandRegUser)landRegUsers.get(0);
            landRegUser.setPhone(newPhoneNum);
            this.landRegUserRepository.save((Object)landRegUser);
        }
        return 3;
    }

    public LandUser getUserDetailByUserIdOrName(String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new RuntimeException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (key.matches("[0-9]+")) {
            LandUser user = this.landUserRepository.findById((Object)Long.valueOf(key)).orElse(null);
            if (user == null) {
                return this.getUserDetailByName(key);
            }
            return this.landRegUserService.getReviewDetailByUserId(user.getId());
        }
        return this.getUserDetailByName(key);
    }

    private LandUser getUserDetailByName(String userName) throws Exception {
        List landUsers = this.landUserRepository.queryUserByName(userName);
        if (landUsers.isEmpty()) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long userId = ((LandUser)landUsers.get(0)).getId();
        return this.landRegUserService.getReviewDetailByUserId(userId);
    }

    public Boolean checkVerifySession(HttpServletRequest request, String verifyCode, String key) {
        Object smsCodeObj = request.getSession().getAttribute(key);
        JSONObject smsCodeJson = null;
        if (smsCodeObj != null) {
            smsCodeJson = JSON.parseObject((String)smsCodeObj.toString());
            return verifyCode.equalsIgnoreCase(smsCodeJson.getString("verifyCode"));
        }
        return false;
    }
}

