/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.dto.RegionDto;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.user.entity.UserArea;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MUserAreaService {
    @Autowired
    UserAreaRepository userAreaDao;
    @Autowired
    TaskNoticeRepository taskNoticeDao;
    @Autowired
    TaskNoticeUserRepository userDao;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;

    public void updateState(Integer state, Long sendUserId, Long userId, String code) {
        this.userAreaDao.updateState(state, userId, code);
        String receiveId = userId.toString();
        String title = "\u533a\u57df\u5ba1\u6838\u901a\u77e5";
        String xzqmc = "";
        if (code != null && !code.isEmpty()) {
            RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
            xzqmc = this.regionDao.getNameByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        }
        String content = "";
        if (state == 1) {
            content = "\u4f60\u6062\u590d\u4e86" + xzqmc + "(" + code + ")\u533a\u57df\u7684\u64cd\u4f5c\u6743\u9650";
        } else if (state == 0) {
            content = "\u4f60\u5df2\u7ecf\u88ab" + xzqmc + "(" + code + ")\u533a\u57df\u7ba1\u7406\u5458\u64a4\u9500\u4e86\u8be5\u533a\u57df\u7684\u64cd\u4f5c\u6743\u9650";
        }
        this.addTaskNotice(title, content, sendUserId, 1, 4, receiveId, code, 1);
    }

    private TaskNotice addTaskNotice(String title, String content, long sendUserId, int state, int type, String receiveIds, String xzqdm, int action) {
        Date time = new Date();
        TaskNotice taskNotice = null;
        TaskNotice notice = new TaskNotice();
        notice.setTitle(title);
        notice.setSendTime(time);
        notice.setSendUser(Long.valueOf(sendUserId));
        notice.setState(Integer.valueOf(state));
        notice.setType(Integer.valueOf(type));
        notice.setRegion(xzqdm);
        notice.setAction(Integer.valueOf(action));
        if (type == 3) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] ids = content.split(",");
            for (int j = 0; j < ids.length; ++j) {
                arrayList.add(ids[j]);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tag", (Object)1);
            jsonObject.put("data", arrayList);
            notice.setContent(jsonObject.toString());
        } else {
            notice.setContent(content);
        }
        taskNotice = (TaskNotice)this.taskNoticeDao.save((Object)notice);
        String[] receiveId = receiveIds.split(",");
        String noticeId = taskNotice.getId();
        for (int i = 0; i < receiveId.length; ++i) {
            if (receiveId[i].isEmpty()) continue;
            long userId = Long.parseLong(receiveId[i]);
            TaskNoticeUser noticeUser = new TaskNoticeUser();
            noticeUser.setNoticeId(noticeId);
            noticeUser.setUserId(String.valueOf(userId));
            noticeUser.setState(Integer.valueOf(0));
            this.userDao.save((Object)noticeUser);
        }
        return taskNotice;
    }

    public String getUserRegionCode(Long userId) {
        GutilAssert.state((userId != null && userId > -1L ? 1 : 0) != 0, (String)"parameter: [userId] can not be null and must larger then -1");
        String regionCode = "";
        List myAreas = this.userAreaDao.getMyArea(userId);
        if (!GutilCollection.isEmpty((Collection)myAreas)) {
            regionCode = ((UserArea)myAreas.get(0)).getCode();
        }
        return regionCode;
    }

    public List<RegionDto> userRoleRegions(List<String> areas, String version) {
        ArrayList<RegionDto> list = new ArrayList<RegionDto>();
        for (String s : areas) {
            if ("1".equalsIgnoreCase(s)) continue;
            RegionDto regionDto = new RegionDto();
            if (s.length() <= 6) {
                regionDto = version != null ? this.getRegionByVersion(s, version) : this.getRegion(s);
            } else if (s.length() == 9) {
                regionDto = version != null ? this.getRegionTownAndVersion(s, version) : this.getRegionTown(s);
            } else if (s.length() == 12) {
                regionDto = version != null ? this.getRegionVillageAndVersion(s, version) : this.getRegionVillage(s);
            }
            list.add(regionDto);
        }
        return list;
    }

    public List<RegionDto> regionDtos(List<String> areas) {
        ArrayList<RegionDto> list = new ArrayList<RegionDto>();
        for (String s : areas) {
            if ("1".equalsIgnoreCase(s)) continue;
            RegionDto regionDto = new RegionDto();
            if (s.length() <= 6) {
                regionDto = this.gerParent(this.getRegion(s));
            } else if (s.length() == 9) {
                regionDto = this.gerParent(this.getRegionTown(s));
            } else if (s.length() == 12) {
                regionDto = this.gerParent(this.getRegionVillage(s));
            }
            boolean check = true;
            for (int i = 0; i < list.size(); ++i) {
                if (!regionDto.getCode().equalsIgnoreCase(((RegionDto)list.get(i)).getCode())) continue;
                check = false;
                ((RegionDto)list.get(i)).setChildren(this.distinctList1(((RegionDto)list.get(i)).getChildren(), regionDto.getChildren()));
            }
            if (!check) continue;
            list.add(regionDto);
        }
        return list;
    }

    public List<RegionDto> distinctList(List<RegionDto> list1, List<RegionDto> list2) {
        ArrayList<RegionDto> newList = new ArrayList<RegionDto>();
        if (!list1.containsAll(list2) || list2.containsAll(list1)) {
            for (RegionDto r1 : list1) {
                for (RegionDto r2 : list2) {
                    if (r1.getCode().equalsIgnoreCase(r2.getCode())) {
                        return this.distinctList(r1.getChildren(), r2.getChildren());
                    }
                    newList = new ArrayList<RegionDto>(Arrays.asList(new RegionDto[list1.size()]));
                    Collections.copy(newList, list1);
                    newList.add(r2);
                }
            }
        }
        return newList;
    }

    public List<RegionDto> distinctList1(List<RegionDto> list1, List<RegionDto> list2) {
        if (!list1.containsAll(list2) || list2.containsAll(list1)) {
            for (RegionDto r1 : list1) {
                for (RegionDto r2 : list2) {
                    if (r1.getCode().equalsIgnoreCase(r2.getCode())) {
                        r1.setChildren(this.distinctList(r1.getChildren(), r2.getChildren()));
                        continue;
                    }
                    ArrayList<RegionDto> newList = new ArrayList<RegionDto>(Arrays.asList(new RegionDto[list1.size()]));
                    Collections.copy(newList, list1);
                    newList.add(r2);
                    list1 = newList;
                }
            }
        }
        return list1;
    }

    public static List<RegionDto> distinct(List<RegionDto> list) {
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                RegionDto map = list.get(i);
                for (int j = 1; j < list.size(); ++j) {
                    RegionDto map2 = list.get(j);
                    if (!map.equals(map2)) continue;
                    list.remove(j);
                }
            }
        }
        return list;
    }

    public RegionDto gerParent(RegionDto regionDto) {
        if (regionDto.getPcode() == null || regionDto.getPcode().equalsIgnoreCase("-1")) {
            return regionDto;
        }
        RegionDto pareRegionDto = new RegionDto();
        pareRegionDto = regionDto.getPcode().length() == 9 ? this.getRegionTown(regionDto.getPcode()) : this.getRegion(regionDto.getPcode());
        ArrayList<RegionDto> list = new ArrayList<RegionDto>();
        list.add(regionDto);
        pareRegionDto.setChildren(list);
        return this.gerParent(pareRegionDto);
    }

    public RegionDto copyProperties1(String code) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        RegionDto RegionDto2 = new RegionDto();
        ArrayList<RegionDto> list = new ArrayList<RegionDto>();
        Region region = this.regionDao.findByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        if (region != null) {
            RegionDto regionDto = new RegionDto();
            BeanUtil.copyProperties((Object)region, (Object)regionDto, (boolean)false);
            list.add(regionDto);
        }
        RegionDto2.setChildren(list);
        RegionDto2.setCode(region.getPcode());
        return RegionDto2;
    }

    public List<RegionDto> copyProperties(String code) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        ArrayList<RegionDto> list = new ArrayList<RegionDto>();
        Region region = this.regionDao.findByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        if (region != null) {
            RegionDto regionDto = new RegionDto();
            BeanUtil.copyProperties((Object)region, (Object)regionDto, (boolean)false);
            list.add(regionDto);
        }
        return list;
    }

    public RegionDto getRegion(String code) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        Region region = this.regionDao.findByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        RegionDto regionDto = new RegionDto();
        if (region != null) {
            BeanUtil.copyProperties((Object)region, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionByVersion(String code, String version) {
        Region region = this.regionDao.findByCodeAndVersion(code, version);
        RegionDto regionDto = new RegionDto();
        if (region != null) {
            BeanUtil.copyProperties((Object)region, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionTown(String code) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        RegionTown regionTown = this.regionTownRepository.getByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        RegionDto regionDto = new RegionDto();
        if (regionTown != null) {
            BeanUtil.copyProperties((Object)regionTown, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionTownAndVersion(String code, String version) {
        RegionTown regionTown = this.regionTownRepository.getByCodeAndVersion(code, version);
        RegionDto regionDto = new RegionDto();
        if (regionTown != null) {
            BeanUtil.copyProperties((Object)regionTown, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionVillage(String code) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        RegionVillage regionVillage = this.regionVillageRepository.getByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        RegionDto regionDto = new RegionDto();
        if (regionVillage != null) {
            BeanUtil.copyProperties((Object)regionVillage, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionVillageAndVersion(String code, String version) {
        RegionVillage regionVillage = this.regionVillageRepository.getByCodeAndVersion(code, version);
        RegionDto regionDto = new RegionDto();
        if (regionVillage != null) {
            BeanUtil.copyProperties((Object)regionVillage, (Object)regionDto, (boolean)false);
        }
        return regionDto;
    }

    public RegionDto getRegionDto(String code, String version) {
        RegionDto regionDto = new RegionDto();
        if (code.length() <= 6) {
            regionDto = this.getRegionByVersion(code, version);
        } else if (code.length() == 9) {
            regionDto = this.getRegionTownAndVersion(code, version);
        } else if (code.length() == 12) {
            regionDto = this.getRegionVillageAndVersion(code, version);
        }
        return regionDto;
    }
}

