/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.NoticeNewRepository;
import com.geoway.landteam.customtask.repository.task.NoticeRepository;
import com.geoway.landteam.customtask.repository.task.NoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.NoticeTopicRepository;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.customtask.task.entity.NoticeNew;
import com.geoway.landteam.customtask.task.entity.NoticeSubscribe;
import com.geoway.landteam.customtask.task.entity.NoticeTopic;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.entity.CloudDiskOfGroup;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroup;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroupMember;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfGroupRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Department2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupRepository;
import com.geoway.landteam.landcloud.core.repository.user.YXUserRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgGroupUtil;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MWorkGroupService {
    @Autowired
    WorkGroupRepository workGroupDao;
    @Autowired
    WorkGroupMemberRepository workGroupMemberDao;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    OrganizationRepository organizationDao;
    @Autowired
    YXUserRepository yxUserDao;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    FriendsServiceImpl friendsService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    CloudDiskOfGroupRepository cloudDiskOfGroupDao;
    @Autowired
    UserAreaRepository userAreaDao;
    @Autowired
    Department2UserRepository department2UserDao;
    @Autowired
    TaskNoticeServiceImpl taskNoticeService;
    @Autowired
    NoticeRepository noticeRepository;
    @Autowired
    NoticeTopicRepository noticeTopicRepository;
    @Autowired
    NoticeNewRepository noticeNewRepository;
    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;
    @Autowired
    UserNameService userNameService;

    public WorkGroup createWorkGroup(Long userId, String ids, String groupName) throws Exception {
        WorkGroup workGroup = new WorkGroup();
        workGroup.setId(UUID.randomUUID().toString());
        workGroup.setName(groupName);
        workGroup.setState(Integer.valueOf(0));
        workGroup.setCreateTime(new Date());
        HashSet<String> idSet = new HashSet<String>();
        for (String id : ids.split(",")) {
            if (userId.toString().equals(id)) continue;
            idSet.add(id);
        }
        workGroup.setAccid(this.createYXGroup(userId, idSet, groupName));
        this.workGroupDao.save((Object)workGroup);
        ArrayList<WorkGroupMember> memberList = new ArrayList<WorkGroupMember>();
        WorkGroupMember workGroupOwner = new WorkGroupMember();
        workGroupOwner.setId(UUID.randomUUID().toString());
        workGroupOwner.setRole(Integer.valueOf(2));
        workGroupOwner.setCreateTime(new Date());
        workGroupOwner.setUserId(userId);
        workGroupOwner.setGroupId(workGroup.getId());
        memberList.add(workGroupOwner);
        for (String id : idSet) {
            WorkGroupMember member = new WorkGroupMember();
            member.setId(UUID.randomUUID().toString());
            member.setRole(Integer.valueOf(0));
            member.setCreateTime(new Date());
            member.setUserId(Long.valueOf(id));
            member.setGroupId(workGroup.getId());
            memberList.add(member);
        }
        this.workGroupMemberDao.saveAll(memberList);
        return workGroup;
    }

    private String buildCronExpression() {
        Date now = new Date();
        Date DateOf30DaysLater = DateUtils.addMinutes((Date)now, (int)5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String format = sdf.format(DateOf30DaysLater);
        StringBuilder cronExpression = new StringBuilder();
        String[] strArr = format.split("-");
        return cronExpression.append(strArr[5]).append(" ").append(strArr[4]).append(" ").append(strArr[3]).append(" ").append(strArr[2]).append(" ").append(strArr[1]).append(" ").append("?").append(" ").append(strArr[0]).toString();
    }

    private String createYXGroup(Long userId, Set<String> idSet, String groupName) {
        String members = this.generateMemberJsonStr(idSet, userId);
        YXUser owner = this.yxUserDao.findById((Object)userId).orElse(null);
        String result = CloudMsgGroupUtil.createYxGroup((String)groupName, (String)owner.getAccid(), (String)members, (String)"\u9080\u8bf7\u4fe1\u606f", (String)"0", (String)"0");
        Map map = (Map)JSON.parse((String)result, (Feature[])new Feature[0]);
        if (map == null || map.get("tid") == null) {
            throw new RuntimeException("\u521b\u5efa\u4e91\u4fe1\u5de5\u4f5c\u7ec4\u5931\u8d25!");
        }
        return map.get("tid").toString();
    }

    private String generateMemberJsonStr(Set<String> idSet, Long operaterId) {
        StringBuilder sb = new StringBuilder("[");
        for (String userId : idSet) {
            if (operaterId.toString().equals(userId)) continue;
            YXUser yxUser = this.yxUserDao.findById((Object)Long.valueOf(userId)).orElse(null);
            LandUser landUser = this.landUserDao.findById((Object)Long.valueOf(userId)).orElse(null);
            if (yxUser != null && landUser != null && landUser.getState() != 0) {
                sb.append("'" + yxUser.getAccid() + "'");
                sb.append(",");
                continue;
            }
            if (landUser != null && landUser.getState() == 0) {
                throw new RuntimeException("\u7528\u6237 [" + landUser.getName() + "] \u4e3a\u7981\u7528\u8d26\u53f7");
            }
            throw new RuntimeException("\u7528\u6237 [" + landUser.getName() + "] \u6ca1\u6709\u4e91\u4fe1\u8d26\u53f7,\u8bf7\u5148\u6ce8\u518c\u8d26\u53f7");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append("]").toString();
    }

    private String generateMemberJsonStr1(List<Long> idList) {
        StringBuilder sb = new StringBuilder("[");
        for (Long userId : idList) {
            YXUser yxUser = this.yxUserDao.findById((Object)userId).orElse(null);
            if (yxUser == null) {
                LandUser landUser = this.landUserDao.findById((Object)userId).orElse(null);
                throw new RuntimeException("\u7528\u6237 [" + landUser.getName() + "] \u672a\u542f\u7528\u8d26\u53f7");
            }
            sb.append("'" + yxUser.getAccid() + "'");
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append("]").toString();
    }

    public Page<WorkGroup> getWorkGroupsICreate(Long userId, String filterParam, String sortParam, int start, int limit) {
        List groupIds = this.workGroupMemberDao.queryGroupIdOfICreate(userId);
        Page<WorkGroup> workGroups = this.getWorkGroupByGroupIds(groupIds, filterParam = filterParam + ";Q_state_N_EQ=0", sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups) {
                this.completeWorkGroupInfo(workGroup, userId);
            }
        }
        return workGroups;
    }

    public Page<WorkGroup> getWorkGroupsIHave(Long userId, String filterParam, String sortParam, int start, int limit) {
        List groupIds = this.workGroupMemberDao.queryGroupIdOfIHave(userId);
        Page<WorkGroup> workGroups = this.getWorkGroupByGroupIds(groupIds, filterParam = filterParam + ";Q_state_N_EQ=0", sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups) {
                this.completeWorkGroupInfo(workGroup, userId);
            }
        }
        return workGroups;
    }

    public void updateUserRole(String workGroupId, String userId, Integer role) {
        if (role.equals(2)) {
            throw new RuntimeException("\u4e0d\u80fd\u8bbe\u7f6e\u521b\u5efa\u8005\u89d2\u8272");
        }
        WorkGroupMember workGroupMember = this.workGroupMemberDao.queryByUserIdAndGroupId(Long.valueOf(userId), workGroupId);
        workGroupMember.setRole(role);
        this.workGroupMemberDao.save((Object)workGroupMember);
    }

    public Page<WorkGroup> getMyWorkGroups(Long userId, String groupname, int pageIndex, int rows) {
        List groupIds = this.workGroupMemberDao.queryGroupIdOfIHave(userId);
        StringBuilder stringBuilder = new StringBuilder();
        if (!"".equals(groupname)) {
            stringBuilder.append("Q_name_S_LK=" + groupname);
        }
        stringBuilder.append(";Q_state_N_EQ=0");
        String filterParam = stringBuilder.toString();
        Page<WorkGroup> workGroups = this.getWorkGroupByGroupIds(groupIds, filterParam, null, pageIndex, rows);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups) {
                this.completeWorkGroupInfo(workGroup, userId);
            }
        }
        return workGroups;
    }

    public Page<WorkGroup> getWorkGroupsIManage(Long userId, String filterParam, String sortParam, int start, int limit) {
        List groupIds = this.workGroupMemberDao.queryGroupIdIManage(userId);
        Page<WorkGroup> workGroups = this.getWorkGroupByGroupIds(groupIds, filterParam = filterParam + ";Q_state_N_EQ=0", sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups) {
                this.completeWorkGroupInfo(workGroup, userId);
            }
        }
        return workGroups;
    }

    private void completeWorkGroupInfo(WorkGroup workGroup, Long userId) {
        WorkGroupMember member;
        Long ownerId = this.workGroupMemberDao.queryOwnerId(workGroup.getId());
        workGroup.setOwner(ownerId);
        workGroup.setOwnerName(this.userNameService.getUserRealNameByUserId(ownerId.toString()));
        List organization2Users = this.organization2UserDao.queryByUserId(ownerId);
        if (!organization2Users.isEmpty()) {
            String organizationId = ((Organization2User)organization2Users.get(0)).getOrganizationId();
            workGroup.setOrgIdOfOwner(organizationId);
            Organization organization = this.organizationDao.findById((Object)organizationId).orElse(null);
            if (organization != null) {
                workGroup.setOrgNameOfOwner(organization.getName());
            }
        }
        List memberIdList = this.workGroupMemberDao.querySomeOfMembers(workGroup.getId());
        String str = "";
        int count = 0;
        for (Long memberId : memberIdList) {
            String memberName = this.userNameService.getUserRealNameByUserId(memberId.toString());
            str = str + memberName + ",";
            if (++count < 6) continue;
            str = str.substring(0, str.length() - 1);
            str = str + "\u7b49";
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            workGroup.setSomeOfmembers(str.endsWith(",") ? str.substring(0, str.length() - 1) : str);
        }
        if ((member = this.workGroupMemberDao.queryByUserIdAndGroupId(userId, workGroup.getId())) != null) {
            workGroup.setMyRole(member.getRole());
        }
        List list = this.workGroupMemberDao.queryByWorkGroupId(workGroup.getId());
        workGroup.setMembersNum(Integer.valueOf(list.size()));
        List glylist = list.stream().filter(r -> r.getRole() == 1 || r.getRole() == 2).map(r -> r.getUserId()).collect(Collectors.toList());
        if (!glylist.isEmpty() && glylist.indexOf(userId) > -1) {
            workGroup.setIsowner(true);
        } else {
            workGroup.setIsowner(false);
        }
    }

    private Page<WorkGroup> getWorkGroupByGroupIds(List<String> groupIds, String filterParam, String sortParam, int start, int limit) {
        if (groupIds.isEmpty()) {
            filterParam = filterParam + ";Q_state_N_EQ=-1";
            return this.workGroupDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String groupId : groupIds) {
            stringBuilder.append(groupId);
            stringBuilder.append(",");
        }
        filterParam = filterParam + ";Q_state_N_EQ=0;Q_id_S_IN=" + stringBuilder.toString();
        return this.workGroupDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    public void deleteWorkGroup(String id, Long userId) throws Exception {
        WorkGroupMember member = this.workGroupMemberDao.queryOfICreate(id, userId);
        if (member == null) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6563\u4e0d\u662f\u81ea\u5df1\u521b\u5efa\u7684\u5de5\u4f5c\u7ec4");
        }
        this.deleteWorkGroupNotice(id, userId);
        WorkGroup myWorkGroup = this.workGroupDao.findById((Object)id).orElse(null);
        myWorkGroup.setState(Integer.valueOf(1));
        this.workGroupDao.save((Object)myWorkGroup);
        YXUser yxUser = this.yxUserDao.findById((Object)userId).orElse(null);
        String result = CloudMsgGroupUtil.deleteYxGroup((String)myWorkGroup.getAccid(), (String)yxUser.getAccid());
        this.checkYXResult(result);
        CloudDiskOfGroup cloudDiskOfGroup = this.cloudDiskOfGroupDao.findById((Object)id).orElse(null);
        if (cloudDiskOfGroup != null) {
            cloudDiskOfGroup.setIsDeleted(Integer.valueOf(1));
            this.cloudDiskOfGroupDao.save((Object)cloudDiskOfGroup);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String content = String.format("\u3010\u5de5\u4f5c\u7ec4\u89e3\u6563\u901a\u77e5\u3011\u3002%s\u5de5\u4f5c\u7ec4\uff0c\u5df2\u88ab\u7fa4\u4e3b%s\u89e3\u6563\uff0c\u65f6\u95f4\uff1a%s", myWorkGroup.getName(), this.userNameService.getUserRealNameByUserId(userId.toString()), format.format(new Date()));
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(myWorkGroup.getAccid());
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(Integer.valueOf(1));
        taskNotice.setSendUser(userId);
        taskNotice.setTitle("\u5de5\u4f5c\u7ec4\u89e3\u6563\u901a\u77e5");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(Integer.valueOf(7));
        taskNotice.setAction(Integer.valueOf(18));
        taskNotice = this.taskNoticeService.save(taskNotice);
        ArrayList<String> alias = new ArrayList<String>();
        List workGroupMembers = this.workGroupMemberDao.queryByWorkGroupId(id);
        for (int i = 0; i < workGroupMembers.size(); ++i) {
            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            JSONObject data = new JSONObject();
            taskNoticeUser.setData(data.toJSONString());
            taskNoticeUser.setState(Integer.valueOf(0));
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setNoticeId(taskNotice.getId());
            taskNoticeUser.setUserId(((WorkGroupMember)workGroupMembers.get(i)).getUserId().toString());
            this.taskNoticeService.save(taskNoticeUser);
            alias.add(((WorkGroupMember)workGroupMembers.get(i)).getUserId().toString());
        }
        this.workGroupMemberDao.deleteByGroupId(id);
        HashMap<String, Integer> message = new HashMap<String, Integer>();
        message.put("type", 2);
        MixPushServer.sendNotifyToAlias(alias, (String)"\u5de5\u4f5c\u7ec4\u89e3\u6563\u901a\u77e5", (String)content, (String)JSON.toJSONString(message));
    }

    public void addUsers(Long ownerId, String workGroupId, String userIds) {
        WorkGroupMember workGroupMember = this.workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (workGroupMember == null) {
            throw new RuntimeException("\u65e0\u6743\u9650");
        }
        List memberIds = this.workGroupMemberDao.queryMembersId(workGroupId);
        HashSet<String> idSet = new HashSet<String>();
        for (String id : userIds.split(",")) {
            if (memberIds.contains(Long.valueOf(id))) continue;
            idSet.add(id);
        }
        if (idSet.isEmpty()) {
            return;
        }
        for (String userId : idSet) {
            WorkGroupMember member = new WorkGroupMember();
            member.setId(UUID.randomUUID().toString());
            member.setRole(Integer.valueOf(0));
            member.setCreateTime(new Date());
            member.setUserId(Long.valueOf(userId));
            member.setGroupId(workGroupId);
            this.workGroupMemberDao.save((Object)member);
        }
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() != 0) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4\u4e0d\u5b58\u5728");
        }
        String membersJsonStr = this.generateMemberJsonStr(idSet, ownerId);
        if (!"]".equals(membersJsonStr)) {
            String result = CloudMsgGroupUtil.addUsersToYxGroup((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)membersJsonStr, (String)"0", (String)"\u9080\u8bf7\u52a0\u5165\u7fa4\u804a");
            this.checkYXResult(result);
        }
    }

    public void addUser(String workGroupId, Long userId) {
        WorkGroup workGroup = this.workGroupDao.queryByID(workGroupId);
        if (workGroup == null) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4\u5df2\u89e3\u6563");
        }
        List memberIds = this.workGroupMemberDao.queryMembersId(workGroupId);
        if (memberIds.contains((long)userId)) {
            throw new RuntimeException("\u65e0\u9700\u52a0\u5165\uff0c\u5df2\u5728\u5de5\u4f5c\u7ec4\u5185");
        }
        WorkGroupMember member = new WorkGroupMember();
        member.setId(UUID.randomUUID().toString());
        member.setRole(Integer.valueOf(0));
        member.setCreateTime(new Date());
        member.setUserId(Long.valueOf(userId));
        member.setGroupId(workGroupId);
        this.workGroupMemberDao.save((Object)member);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(userId.toString());
        String membersJsonStr = this.generateMemberJsonStr(idSet, 0L);
        if (!"]".equals(membersJsonStr)) {
            String result = CloudMsgGroupUtil.addUsersToYxGroup((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)membersJsonStr, (String)"0", (String)"\u9080\u8bf7\u52a0\u5165\u7fa4\u804a");
            this.checkYXResult(result);
        }
    }

    public void removeUsers(Long ownerId, String workGroupId, String userIds) {
        List adminIdList = this.workGroupMemberDao.queryAdminAndOwnerId(workGroupId);
        if (!adminIdList.contains(ownerId)) {
            throw new RuntimeException("\u65e0\u6743\u9650");
        }
        HashSet<String> idSet = new HashSet<String>();
        for (String id : userIds.split(",")) {
            idSet.add(id);
        }
        for (String id : idSet) {
            WorkGroupMember member = this.workGroupMemberDao.queryByWorkGroupIdAndUserId(workGroupId, Long.valueOf(id));
            if (member == null) continue;
            this.workGroupMemberDao.delete((Object)member);
        }
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() != 0) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4\u4e0d\u5b58\u5728");
        }
        String memberJsonStr = this.generateMemberJsonStr(idSet, ownerId);
        if (!"]".equals(memberJsonStr)) {
            String result = CloudMsgGroupUtil.removeUsersFromYxGroup((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)memberJsonStr);
            this.checkYXResult(result);
        }
    }

    public void quitFromWorkGroup(Long ownerId, String workGroupId, String nextGroupOwnerId) {
        WorkGroupMember workGroupMember = this.workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (workGroupMember == null) {
            throw new RuntimeException("\u5df2\u7ecf\u4e0d\u5728\u6b64\u5de5\u4f5c\u7ec4");
        }
        Long creatorId = this.workGroupMemberDao.queryOwnerId(workGroupId);
        if (workGroupMember.getRole() == 2) {
            WorkGroupMember nextLeader = null;
            if (StringUtils.isBlank((CharSequence)nextGroupOwnerId)) {
                List admins = this.workGroupMemberDao.getAdmins(workGroupId);
                if (admins.isEmpty()) {
                    throw new RuntimeException("\u9000\u51fa\u7fa4\u7ec4\u5931\u8d25\uff01\u5f53\u524d\u5de5\u4f5c\u7ec4\u4e2d\u6ca1\u6709\u53ef\u63a5\u66ff\u7fa4\u4e3b\u7684\u7ba1\u7406\u5458\uff0c\u8bf7\u5148\u6307\u5b9a\u7ba1\u7406\u5458\u540e\u9000\u51fa\uff01");
                }
                nextLeader = (WorkGroupMember)admins.get(0);
            } else {
                nextLeader = this.workGroupMemberDao.queryByUserIdAndGroupId(Long.valueOf(nextGroupOwnerId), workGroupId);
                if (nextLeader == null || nextLeader.getRole() != 1) {
                    throw new RuntimeException("\u5fc5\u987b\u6307\u5b9a\u5de5\u4f5c\u7ec4\u7ba1\u7406\u5458\u4e3a\u7fa4\u4e3b");
                }
            }
            nextLeader.setRole(Integer.valueOf(2));
            this.workGroupMemberDao.save((Object)nextLeader);
            this.workGroupMemberDao.delete((Object)workGroupMember);
            WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
            YXUser yxUserOfOwner = this.yxUserDao.findById((Object)ownerId).orElse(null);
            YXUser yxUserOfNextOwner = this.yxUserDao.findById((Object)nextLeader.getUserId()).orElse(null);
            if (yxUserOfOwner != null && yxUserOfNextOwner != null) {
                CloudMsgGroupUtil.changeOwner((String)workGroup.getAccid(), (String)yxUserOfOwner.getAccid(), (String)yxUserOfNextOwner.getAccid(), (String)"1");
            }
        } else if (workGroupMember.getRole() == 1) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(workGroupMember.getUserId());
            this.removeAdmins(list, workGroupId, creatorId);
            this.removeUsers(creatorId, workGroupId, ownerId.toString());
        } else {
            this.removeUsers(creatorId, workGroupId, ownerId.toString());
        }
    }

    public Map<String, Object> getMembers(String workGroupId, int start, int limit, String filterParam, String sortParam, String username) {
        JSONObject jsonObject;
        List members = this.workGroupMemberDao.queryByWorkGroupId(workGroupId);
        if (members.isEmpty()) {
            return new HashMap<String, Object>();
        }
        StringBuilder userIds = new StringBuilder();
        ArrayList<Long> membersIdList = new ArrayList<Long>();
        for (WorkGroupMember member : members) {
            userIds.append(member.getUserId());
            userIds.append(",");
            membersIdList.add(member.getUserId());
        }
        List landUsers = StringUtils.isBlank((CharSequence)username) ? this.landUserDao.queryUserForWorkGroup(membersIdList, workGroupId) : ((jsonObject = JSONObject.parseObject((String)username)) != null && jsonObject.get((Object)"type").equals("username") ? this.landUserDao.queryForWorkGroupWithUserName(membersIdList, workGroupId, "%" + jsonObject.get((Object)"name") + "%") : (jsonObject != null && jsonObject.get((Object)"type").equals("rname") ? this.landUserDao.queryForWorkGroupWithRName(membersIdList, workGroupId, "%" + jsonObject.get((Object)"name") + "%") : new ArrayList()));
        ArrayList result = new ArrayList();
        int currIdx = start > 0 ? start * limit : 0;
        for (int i = 0; i < limit && i < landUsers.size() - currIdx; ++i) {
            result.add(landUsers.get(currIdx + i));
        }
        for (Object user : result) {
            for (Object member : members) {
                if (!user.getId().equals(member.getUserId())) continue;
                user.setWorkGroupRole(member.getRole());
            }
        }
        for (Object user : result) {
            YXUser yxUser = this.yxUserDao.findById((Object)user.getId()).orElse(null);
            if (yxUser == null) continue;
            user.setAccid(yxUser.getAccid());
        }
        ArrayList<Long> userIds1 = new ArrayList<Long>();
        for (LandUser curUser : result) {
            userIds1.add(curUser.getId());
        }
        if (userIds1.size() != 0) {
            List xzqObjs = this.userAreaDao.getNameByIds(userIds1);
            List departObjs = this.department2UserDao.getDepartByIds(userIds1);
            block6: for (LandUser curUser : result) {
                String lsUserId;
                String name;
                for (Object[] xzqObj : xzqObjs) {
                    name = xzqObj[0].toString();
                    lsUserId = xzqObj[1].toString();
                    if (!curUser.getId().toString().equals(lsUserId)) continue;
                    curUser.setSjsf(name);
                    break;
                }
                for (Object[] departObj : departObjs) {
                    name = departObj[0].toString();
                    lsUserId = departObj[1].toString();
                    if (!curUser.getId().toString().equals(lsUserId)) continue;
                    curUser.setDepNo(name);
                    continue block6;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", landUsers.size());
            map.put("content", result);
            return map;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", 0);
        map.put("content", Collections.emptyList());
        return map;
    }

    public Long getMemberCount(String workGroupId) {
        return this.workGroupMemberDao.count((Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get("groupId"), (Object)workGroupId));
    }

    public Map<String, Object> getContactsForWorkGroup(Long ownerId, String workGroupId) throws Exception {
        List myFriends = this.friendsService.getMyFriends(ownerId);
        Page myColleagues = this.landUserService.getMyColleagues1(ownerId, 0, 500, "", "SORT_name_ASC");
        List workGroupMembers = this.workGroupMemberDao.queryByWorkGroupId(workGroupId);
        for (WorkGroupMember member : workGroupMembers) {
            for (LandUser friend : myFriends) {
                if (!member.getUserId().equals(friend.getId())) continue;
                friend.setWorkGroupRole(member.getRole());
            }
            for (LandUser colleague : myColleagues) {
                if (!member.getUserId().equals(colleague.getId())) continue;
                colleague.setWorkGroupRole(member.getRole());
            }
        }
        HashMap<String, Object> myContacts = new HashMap<String, Object>();
        myContacts.put("myFriends", myFriends);
        myContacts.put("myColleagues", myColleagues.getContent());
        return myContacts;
    }

    private void checkYXResult(String result) {
        Map map = (Map)JSON.parse((String)result, (Feature[])new Feature[0]);
        if (map == null || !"200".equals(map.get("code").toString())) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25! \u539f\u56e0:" + result);
        }
    }

    public void updateUsers(Long ownerId, String workGroupId, String newUserIds) {
        List oldUserIds = this.workGroupMemberDao.queryMembersId(workGroupId);
        StringBuilder userIdsOfAdd = new StringBuilder();
        StringBuilder userIdsOfRemove = new StringBuilder();
        HashSet oldUserIdSet = new HashSet(oldUserIds);
        HashSet<Long> newUserIdSet = new HashSet<Long>();
        Long creatorId = this.workGroupMemberDao.queryOwnerId(workGroupId);
        newUserIds = newUserIds + "," + creatorId.toString() + "," + ownerId.toString();
        for (String userId : newUserIds.split(",")) {
            newUserIdSet.add(Long.valueOf(userId));
        }
        HashSet<Long> tempSet = new HashSet<Long>();
        tempSet.addAll(newUserIdSet);
        tempSet.removeAll(oldUserIdSet);
        for (Long userIdOfAdd : tempSet) {
            userIdsOfAdd.append(userIdOfAdd);
            userIdsOfAdd.append(",");
        }
        tempSet.clear();
        tempSet.addAll(oldUserIds);
        tempSet.removeAll(newUserIdSet);
        for (Long userIdOfRemove : tempSet) {
            userIdsOfRemove.append(userIdOfRemove);
            userIdsOfRemove.append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)userIdsOfAdd)) {
            this.addUsers(creatorId, workGroupId, userIdsOfAdd.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)userIdsOfRemove)) {
            this.checkCreatorOrAdmin(ownerId, workGroupId);
            this.removeUsers(creatorId, workGroupId, userIdsOfRemove.toString());
        }
    }

    private WorkGroupMember checkCreator(Long ownerId, String workGroupId) {
        WorkGroupMember member = this.workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (member == null || member.getRole() != 2) {
            throw new RuntimeException("\u65e0\u6743\u9650");
        }
        return member;
    }

    private WorkGroupMember checkCreatorOrAdmin(Long ownerId, String workGroupId) {
        WorkGroupMember member = this.workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (member == null || member.getRole() < 1) {
            throw new RuntimeException("\u65e0\u6743\u9650");
        }
        return member;
    }

    public void updateAdmins(Long ownerId, String workGroupId, String adminIds) {
        this.checkCreator(ownerId, workGroupId);
        if (StringUtils.isBlank((CharSequence)adminIds)) {
            this.workGroupMemberDao.removeAllAdmins(workGroupId);
            return;
        }
        List adminsIdList = this.workGroupMemberDao.queryAdminIds(workGroupId);
        HashSet oldAdminIdSet = new HashSet(adminsIdList);
        HashSet<Long> newAdminIdSet = new HashSet<Long>();
        for (String adminId : adminIds.split(",")) {
            newAdminIdSet.add(Long.valueOf(adminId));
        }
        HashSet<Long> tempSet = new HashSet<Long>();
        tempSet.addAll(newAdminIdSet);
        tempSet.removeAll(oldAdminIdSet);
        ArrayList<Long> idsOfAddAdminList = new ArrayList<Long>(tempSet);
        if (!idsOfAddAdminList.isEmpty()) {
            this.addAdmins(idsOfAddAdminList, workGroupId, ownerId);
        }
        tempSet.clear();
        tempSet.addAll(oldAdminIdSet);
        tempSet.removeAll(newAdminIdSet);
        ArrayList<Long> idsOfRemoveAdminList = new ArrayList<Long>(tempSet);
        if (!idsOfRemoveAdminList.isEmpty()) {
            this.removeAdmins(idsOfRemoveAdminList, workGroupId, ownerId);
        }
    }

    public void addAdmins(List<Long> idsOfAddAdminList, String workGroupId, Long ownerId) {
        this.workGroupMemberDao.addAdmins(idsOfAddAdminList, workGroupId);
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        String memberJsonStr = this.generateMemberJsonStr1(idsOfAddAdminList);
        String result = CloudMsgGroupUtil.addAdmins((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)memberJsonStr);
        this.checkYXResult(result);
    }

    public void removeAdmins(List<Long> idsOfRemoveAdminList, String workGroupId, Long ownerId) {
        this.workGroupMemberDao.removeAdmins(idsOfRemoveAdminList, workGroupId);
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        String memberJsonStr = this.generateMemberJsonStr1(idsOfRemoveAdminList);
        String result = CloudMsgGroupUtil.removeAdmins((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)memberJsonStr);
        this.checkYXResult(result);
    }

    public void deleteWorkGroupsInTime() throws Exception {
    }

    public WorkGroup getWorkGroupById(String workGroupId, Long userId) throws Exception {
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        if (workGroup == null) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4\u5df2\u88ab\u89e3\u6563");
        }
        Map<String, Object> map = this.getMembers(workGroupId, 0, 1000, "", "SORT_name_ASC", "");
        if (!map.isEmpty()) {
            workGroup.setMembers((List)map.get("content"));
            workGroup.setMembersNum((Integer)map.get("total"));
            this.completeWorkGroupInfo(workGroup, userId);
        }
        return workGroup;
    }

    public WorkGroup rename(String workGroupId, Long ownerId, String newName) {
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() == 1) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4\u4e0d\u5b58\u5728");
        }
        workGroup.setName(newName);
        this.workGroupDao.save((Object)workGroup);
        String result = CloudMsgGroupUtil.renameYxGroup((String)workGroup.getAccid(), (String)this.getCreatorAccid(workGroupId), (String)newName);
        this.checkYXResult(result);
        return workGroup;
    }

    private String getCreatorAccid(String workGroupId) {
        Long creatorId = this.workGroupMemberDao.queryOwnerId(workGroupId);
        if (creatorId == null) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4id\u6709\u8bef");
        }
        YXUser yxUserOfCreator = this.yxUserDao.findById((Object)creatorId).orElse(null);
        if (yxUserOfCreator == null) {
            throw new RuntimeException("\u7fa4\u4e3b\u65e0\u4e91\u4fe1\u8d26\u53f7");
        }
        return yxUserOfCreator.getAccid();
    }

    public Map<String, Object> getYxMembers(String workGroupId) {
        WorkGroup workGroup = this.workGroupDao.findById((Object)workGroupId).orElse(null);
        String result = CloudMsgGroupUtil.getYxGroup((String)workGroup.getAccid());
        JSONObject map = JSON.parseObject((String)result);
        return map;
    }

    public Page<WorkGroup> getMyWorkGroupsTree(Long ownerId) {
        List groupIds = this.workGroupMemberDao.queryGroupIdOfIHave(ownerId);
        Page<WorkGroup> workGroups = this.getWorkGroupByGroupIds(groupIds, "", "SORT_createTime_ASC", 0, 100);
        if (workGroups.getContent().isEmpty()) {
            return workGroups;
        }
        for (WorkGroup workGroup : workGroups) {
            Map<String, Object> menbersMap = this.getMembers(workGroup.getId(), 0, 200, "", "SORT_createTime_ASC", "");
            if (menbersMap.isEmpty()) continue;
            List members = (List)menbersMap.get("content");
            workGroup.setMembers(members);
        }
        return workGroups;
    }

    public List<String> getMyWorkGroupIdsByUserId(Long userId) {
        return this.workGroupMemberDao.queryGroupIdOfIHave(userId);
    }

    public List<WorkGroup> getMyWorkGroupsByUserId(Long userId) {
        List ids = this.workGroupMemberDao.queryGroupIdByUserId(userId);
        List<Object> wgs = new ArrayList<WorkGroup>();
        if (ids != null && !ids.isEmpty()) {
            wgs = this.workGroupDao.queryWorkGroupByIds(ids);
        }
        return wgs;
    }

    @Transactional
    public void deleteWorkGroupNotice(String workGroupId, Long userId) {
        List userIds = this.workGroupMemberDao.queryMembersId(workGroupId);
        if (!userIds.isEmpty()) {
            NoticeTopic noticeTopic = new NoticeTopic();
            String id = UUID.randomUUID().toString();
            noticeTopic.setId(id);
            noticeTopic.setDate(new Date());
            noticeTopic.setType("anc");
            this.noticeTopicRepository.save((Object)noticeTopic);
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setTopicId(id);
            noticeNew.setSendUser(userId.toString());
            noticeNew.setSendDate(new Date());
            noticeNew.setTitle("\u5de5\u4f5c\u7ec4\u89e3\u6563\u901a\u77e5");
            WorkGroup workGroup = this.workGroupDao.queryByID(workGroupId);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            noticeNew.setContent(String.format("\u3010\u5de5\u4f5c\u7ec4\u89e3\u6563\u901a\u77e5\u3011\u3002%s\u5de5\u4f5c\u7ec4\uff0c\u5df2\u88ab\u7fa4\u4e3b%s\u89e3\u6563\uff0c\u65f6\u95f4\uff1a%s", workGroup.getName(), this.userNameService.getUserRealNameByUserId(userId.toString()), simpleDateFormat.format(new Date())));
            this.noticeNewRepository.save((Object)noticeNew);
            ArrayList<NoticeSubscribe> noticeSubscribes = new ArrayList<NoticeSubscribe>();
            for (Long uId : userIds) {
                NoticeSubscribe noticeSubscribe = new NoticeSubscribe();
                noticeSubscribe.setCreateTime(new Date());
                noticeSubscribe.setTopicId(id);
                noticeSubscribe.setUserId(uId.toString());
                noticeSubscribes.add(noticeSubscribe);
            }
            this.noticeSubscribeRepository.saveAll(noticeSubscribes);
        }
    }
}

