/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.cloudquery.servface.pub.RoleCloudQueryService;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeSubscribe;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.repository.task.NoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.NoticeTopicRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.NoticeSubscribe;
import com.geoway.landteam.customtask.task.entity.NoticeTopic;
import com.geoway.landteam.customtask.task.entity.TskRightArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.User2Biz;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.CloudDiskOfOrg;
import com.geoway.landteam.landcloud.core.model.pub.entity.ImportUserResultInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserBizSupervision;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppTaskBizRepository;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfOrgRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SysRoleInfoRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UisApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserBizSupervisionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.RoleRightService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.core.service.base.ApplicationCodeService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.user.RegisterServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.UserAreaServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CheckUtil;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.servface.user.MIUserManageService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeNewService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MIUserManageServiceImpl
implements MIUserManageService {
    private final GiLoger logger = GwLoger.getLoger(MIUserManageServiceImpl.class);
    private final String CHINA_REGION_CODE = "1";
    protected String uploadDir;
    @Value(value="${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;
    protected String appkey;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    LandUserService userService;
    @Autowired
    LandRegUserService regUserService;
    @Autowired
    LandRegUserRepository landRegUserDao;
    @Autowired
    RegionService regionService;
    @Autowired
    RoleRightService roleRightService;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;
    @Autowired
    AppTaskBizRepository appTaskBizRepository;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ApplicationCodeService applicationCodeService;
    @Autowired
    UserApplicationRepository userApplicationDao;
    @Autowired
    TskTaskBizRepository tskTaskBizDao;
    @Autowired
    User2BizRepository userBiz2Dao;
    @Autowired
    UserBizSupervisionRepository userBizSupervisionDao;
    @Autowired
    UisApplicationRepository UisApplicationDao;
    @Autowired
    SysRoleInfoRepository SysRoleInfoDao;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;
    @Autowired
    RoleCloudQueryService roleCloudQueryService;
    @Autowired
    RegisterServiceImpl registerService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;
    @Autowired
    UserAreaServiceImpl userAreaService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    NoticeTopicRepository noticeTopicRepository;
    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;
    @Autowired
    Organization2UserRepository organization2UserRepository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;

    public List<ImportUserResultInfo> HomesteadImportUserBatch(String filePath, Long userId) throws IOException, InvalidFormatException {
        Workbook workbook = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        ArrayList<ImportUserResultInfo> userResultInfos = new ArrayList<ImportUserResultInfo>();
        try {
            File file = new File(filePath);
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            inputStream = new FileInputStream(file);
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            List<ImportUserResultInfo> appResultList = this.readSheet(workbook, false);
            userResultInfos.addAll(appResultList);
            List<ImportUserResultInfo> webResultList = this.readSheet(workbook, true);
            userResultInfos.addAll(webResultList);
            outputStream = new FileOutputStream(file);
            workbook.write(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return userResultInfos;
    }

    private List<ImportUserResultInfo> readSheet(Workbook workbook, boolean isWebManagerSheet) {
        Sheet sheet;
        Row row;
        ArrayList<ImportUserResultInfo> userResultInfos = new ArrayList<ImportUserResultInfo>();
        SysConfig publicConfig = this.sysConfigService.findOne("publicConfig");
        String bizId = "";
        String unitId = "";
        if (publicConfig != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)publicConfig.getValue());
            bizId = jsonObject.getString("zngl");
            unitId = jsonObject.getString("unit");
        }
        if ((row = (sheet = workbook.getSheet(isWebManagerSheet ? "web\u7ba1\u7406\u5458\u6ce8\u518c" : "app\u4f5c\u4e1a\u5458\u6ce8\u518c")).getRow(0)) == null) {
            return userResultInfos;
        }
        int columnNum = row.getPhysicalNumberOfCells();
        int rowCount = sheet.getPhysicalNumberOfRows();
        this.createImportResultColumn(workbook, sheet, columnNum);
        for (int i = 2; i < rowCount; ++i) {
            ImportUserResultInfo resultInfo = new ImportUserResultInfo();
            resultInfo.setRow(i);
            row = sheet.getRow(i);
            if (row == null) continue;
            try {
                UserAddInfo userInfo = new UserAddInfo();
                userInfo.setBiz(bizId);
                userInfo.setPassword(Md5Util.calFileMd5ByByte((byte[])"gtdcy123".getBytes()));
                userInfo.setCreateTime(new Date());
                JSONObject bizRole = new JSONObject();
                if (isWebManagerSheet) {
                    resultInfo = this.readWebRegisterRow(workbook, row, columnNum, unitId, userInfo);
                    bizRole.put(bizId, (Object)Character.valueOf('1'));
                    userInfo.setBizRoles(bizRole.toJSONString());
                } else {
                    resultInfo = this.readAppRegisterRow(workbook, row, columnNum, unitId, userInfo);
                    bizRole.put(bizId, (Object)Character.valueOf('3'));
                    userInfo.setBizRoles(bizRole.toJSONString());
                }
                resultInfo.setRow(i);
                if (resultInfo.getState() == 2) {
                    userResultInfos.add(resultInfo);
                    continue;
                }
                if (resultInfo.getState() == 3) {
                    String info = "";
                    info = this.updateUserArea(userInfo).booleanValue() ? (isWebManagerSheet ? "\u7528\u6237\u5df2\u5b58\u5728\uff0c\u4e3a\u6b64\u7528\u6237\u8d4b\u4e88\u5b85\u57fa\u5730\u4f5c\u4e1a\u533a\u7ba1\u7406\u5458\u6743\u9650" : "\u7528\u6237\u5df2\u5b58\u5728\uff0c\u4e3a\u6b64\u7528\u6237\u8d4b\u4e88\u5b85\u57fa\u5730\u4f5c\u4e1a\u533a\u4f5c\u4e1a\u5458\u6743\u9650") : "\u624b\u673a\u53f7\u5df2\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55";
                    resultInfo.setState(1);
                    userResultInfos.add(resultInfo);
                    this.writeSuccessInfo(workbook, row, columnNum, info);
                    continue;
                }
                this.addNewUser(userInfo);
                resultInfo.setState(1);
                this.writeSuccessInfo(workbook, row, columnNum);
                userResultInfos.add(resultInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Throwable)e);
                resultInfo.setState(2);
                resultInfo.setErrorInfo(e.getMessage());
                this.writeErrorInfo(workbook, row, columnNum, e.getMessage());
                userResultInfos.add(resultInfo);
            }
        }
        return userResultInfos;
    }

    private ImportUserResultInfo readAppRegisterRow(Workbook wb, Row row, int colNumber, String deptId, UserAddInfo userInfo) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = this.findCellValue(row.getCell(0));
        String depValue = this.findCellValue(row.getCell(1));
        String phoneValue = this.findCellValue(row.getCell(2));
        String regionCodeValue = this.findCellValue(row.getCell(3));
        String bizRegionCodeValue = this.findCellValue(row.getCell(4));
        if (StringUtils.isBlank((CharSequence)nameValue) && StringUtils.isBlank((CharSequence)depValue) && StringUtils.isBlank((CharSequence)phoneValue) && StringUtils.isBlank((CharSequence)regionCodeValue) && StringUtils.isBlank((CharSequence)bizRegionCodeValue)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            this.writeErrorInfo(wb, row, colNumber, "\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            return resultInfo;
        }
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        userInfo.setRname(nameValue);
        List userOfName = this.landUserDao.queryUserByName(nameValue);
        if (!userOfName.isEmpty()) {
            nameValue = nameValue + String.valueOf(userOfName.size() + 1);
        }
        userInfo.setUsername(nameValue);
        if (StringUtils.isBlank((CharSequence)phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u79fb\u52a8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u79fb\u52a8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        if (!CheckUtil.isMobile((String)phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u79fb\u52a8\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
            this.writeErrorInfo(wb, row, colNumber, "\u79fb\u52a8\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
            return resultInfo;
        }
        LandRegUser user1 = this.landRegUserDao.queryOneByPhoneNum(phoneValue);
        LandUser user2 = this.userService.queryAppUserByPhone(phoneValue);
        if (user2 != null) {
            resultInfo.setState(3);
            userInfo.setId(user2.getId() + "");
        }
        if (user1 != null && user2 == null) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c,\u5f85\u5ba1\u6838\u4e2d");
            this.writeErrorInfo(wb, row, colNumber, "\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c,\u5f85\u5ba1\u6838\u4e2d");
            return resultInfo;
        }
        userInfo.setPhone(phoneValue);
        if (StringUtils.isBlank((CharSequence)regionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u53bf\u7ea7\u533a\u5212\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u53bf\u7ea7\u533a\u5212\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        if (StringUtils.isBlank((CharSequence)depValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        userInfo.setDepname(depValue);
        if (StringUtils.isBlank((CharSequence)bizRegionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        if ("1".equalsIgnoreCase(regionCodeValue)) {
            userInfo.setRegionCode(regionCodeValue);
            userInfo.setCloudArea(regionCodeValue);
        } else {
            Region region = this.regionService.getRegion(regionCodeValue.trim());
            if (region == null) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("\u884c\u653f\u533a\u5212\u4ee3\u7801\u3010" + regionCodeValue + "\u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                this.writeErrorInfo(wb, row, colNumber, "\u884c\u653f\u533a\u5212\u4ee3\u7801\u3010" + regionCodeValue + "\u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                return resultInfo;
            }
            if (region.getLevel() != 3) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("\u53bf\u7ea7\u533a\u5212\u4ee3\u7801\u9700\u586b\u5199\u5230\u53bf\u7ea7");
                this.writeErrorInfo(wb, row, colNumber, "\u53bf\u7ea7\u533a\u5212\u4ee3\u7801\u9700\u586b\u5199\u5230\u53bf\u7ea7");
                return resultInfo;
            }
            userInfo.setRegionCode(region.getCode());
            userInfo.setCloudArea(region.getCode());
        }
        Object[] workAreaCodes = bizRegionCodeValue.split("/");
        if (workAreaCodes.length > 0) {
            ArrayList<String> errorWorkAreaCodes = new ArrayList<String>();
            for (String string : workAreaCodes) {
                String code = regionCodeValue.trim() + string.trim();
                RegionVillage region = this.regionService.findRegionsVillageByXzqdm(code);
                if (region != null) continue;
                errorWorkAreaCodes.add(string);
            }
            if (errorWorkAreaCodes.size() > 0) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801 \u3010" + StringUtils.join((Object[])workAreaCodes, (char)',') + " \u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                this.writeErrorInfo(wb, row, colNumber, "\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801 \u3010" + StringUtils.join((Object[])workAreaCodes, (char)',') + " \u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                return resultInfo;
            }
        } else {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u4e61\uff08\u9547\uff09\u6751\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        bizRegionCodeValue = StringUtils.join(Arrays.asList(workAreaCodes).stream().map(r -> regionCodeValue.trim() + r.trim()).collect(Collectors.toList()), (CharSequence)",");
        JSONObject bizJsonObj = new JSONObject();
        bizJsonObj.put(userInfo.getBiz(), (Object)bizRegionCodeValue);
        userInfo.setBizRegion(bizJsonObj.toJSONString());
        if (StringUtils.isNotBlank((CharSequence)deptId)) {
            userInfo.setDepNo(deptId);
        }
        String roleId = "10007";
        userInfo.setRoleIds(roleId);
        String cloudQueryId = "1000";
        userInfo.setCloudQueryConfig(cloudQueryId);
        return resultInfo;
    }

    private ImportUserResultInfo readWebRegisterRow(Workbook wb, Row row, int colNumber, String deptId, UserAddInfo userInfo) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = this.findCellValue(row.getCell(0));
        String deptName = this.findCellValue(row.getCell(1));
        String phoneValue = this.findCellValue(row.getCell(2));
        String regionCodeValue = this.findCellValue(row.getCell(3));
        String bizRegionCodeValue = this.findCellValue(row.getCell(4));
        if (StringUtils.isBlank((CharSequence)nameValue) && StringUtils.isBlank((CharSequence)phoneValue) && StringUtils.isBlank((CharSequence)regionCodeValue) && StringUtils.isBlank((CharSequence)deptName)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            this.writeErrorInfo(wb, row, colNumber, "\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            return resultInfo;
        }
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        userInfo.setRname(nameValue);
        List userOfName = this.landUserDao.queryUserByName(nameValue);
        if (!userOfName.isEmpty()) {
            nameValue = nameValue + userOfName.size() + 1;
        }
        userInfo.setUsername(nameValue);
        if (StringUtils.isBlank((CharSequence)phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u79fb\u52a8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u79fb\u52a8\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        if (!CheckUtil.isMobile((String)phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u79fb\u52a8\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
            this.writeErrorInfo(wb, row, colNumber, "\u79fb\u52a8\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
            return resultInfo;
        }
        LandRegUser user1 = this.landRegUserDao.queryOneByPhoneNum(phoneValue);
        LandUser user2 = this.userService.queryAppUserByPhone(phoneValue);
        if (user2 != null) {
            resultInfo.setState(3);
            userInfo.setId(user2.getId() + "");
        }
        if (user1 != null && user2 == null) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c,\u5f85\u5ba1\u6838\u4e2d");
            this.writeErrorInfo(wb, row, colNumber, "\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c,\u5f85\u5ba1\u6838\u4e2d");
            return resultInfo;
        }
        userInfo.setPhone(phoneValue);
        if (StringUtils.isBlank((CharSequence)regionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u53bf\u7ea7\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u53bf\u7ea7\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        if ("1".equalsIgnoreCase(regionCodeValue)) {
            userInfo.setRegionCode(regionCodeValue);
            userInfo.setCloudArea(regionCodeValue);
        } else {
            Region region = this.regionService.getRegion(regionCodeValue);
            if (region == null) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("\u884c\u653f\u533a\u5212\u4ee3\u7801\u3010" + regionCodeValue + "\u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                this.writeErrorInfo(wb, row, colNumber, "\u884c\u653f\u533a\u5212\u4ee3\u7801\u3010" + regionCodeValue + "\u3011\u8f93\u5165\u9519\u8bef\u6216\u4e0d\u5728\u7cfb\u7edf\u4e2d");
                return resultInfo;
            }
            userInfo.setRegionCode(region.getCode());
            userInfo.setCloudArea(region.getCode());
        }
        List zyqs = Arrays.asList(bizRegionCodeValue.split("/")).stream().filter(r -> StringUtils.isNotBlank((CharSequence)r)).map(r -> regionCodeValue + r).collect(Collectors.toList());
        if (!zyqs.isEmpty()) {
            bizRegionCodeValue = StringUtils.join(zyqs, (CharSequence)",");
            JSONObject bizJsonObj = new JSONObject();
            bizJsonObj.put(userInfo.getBiz(), (Object)bizRegionCodeValue);
            userInfo.setBizRegion(bizJsonObj.toJSONString());
        }
        if (StringUtils.isBlank((CharSequence)deptName)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            this.writeErrorInfo(wb, row, colNumber, "\u6240\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            return resultInfo;
        }
        boolean existedDept = false;
        List curOrg = this.organizationRepository.queryOneByName(deptName);
        if (curOrg.size() > 0) {
            existedDept = true;
            userInfo.setDepNo(((Organization)curOrg.get(0)).getId());
        }
        if (existedDept) {
            if ("1".equalsIgnoreCase(regionCodeValue)) {
                userInfo.setRoleIds("10012");
                userInfo.setCloudQueryConfig("1002");
            } else if (userInfo.getRegionCode().endsWith("0000")) {
                userInfo.setRoleIds("10003");
                userInfo.setCloudQueryConfig("1001");
            } else if (userInfo.getRegionCode().endsWith("00")) {
                userInfo.setRoleIds("10018");
                userInfo.setCloudQueryConfig("1005");
            } else {
                userInfo.setRoleIds("10019");
                userInfo.setCloudQueryConfig("1006");
            }
        } else {
            userInfo.setDepNo(deptId);
            userInfo.setDepname(deptName);
            String roleId = "10007";
            userInfo.setRoleIds(roleId);
            String cloudQueryId = "1000";
            userInfo.setCloudQueryConfig(cloudQueryId);
        }
        return resultInfo;
    }

    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    cellValue = String.valueOf((long)cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                default: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber) {
        Cell cell;
        if (workbook != null && row != null && colNumber > -1 && (cell = row.createCell(colNumber)) != null) {
            cell.setCellValue("\u65b0\u589e\u7528\u6237\u6210\u529f");
            cell.setCellStyle(this.createSuceessinfocellstyle(workbook));
        }
    }

    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber, String info) {
        Cell cell;
        if (workbook != null && row != null && colNumber > -1 && (cell = row.createCell(colNumber)) != null) {
            cell.setCellValue(info);
            cell.setCellStyle(this.createSuceessinfocellstyle(workbook));
        }
    }

    private void writeErrorInfo(Workbook workbook, Row row, int colNumber, String errorInfo) {
        Cell cell;
        if (workbook != null && row != null && colNumber > -1 && StringUtils.isNotBlank((CharSequence)errorInfo) && (cell = row.createCell(colNumber)) != null) {
            cell.setCellValue("\u521b\u5efa\u7528\u6237\u5931\u8d25\uff0c" + errorInfo);
            cell.setCellStyle(this.createErrorInfoCellStyle(workbook));
        }
    }

    private void createImportResultColumn(Workbook workbook, Sheet sheet, int colNumber) {
        if (workbook != null && sheet != null) {
            Row row = sheet.getRow(1);
            Cell cell = row.createCell(colNumber);
            cell.setCellValue("\u7ed3\u679c");
            cell.setCellStyle(this.creatersultecolumnheadercellstyle(workbook));
        }
    }

    private XSSFCellStyle createCommonCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = null;
        if (wb != null && (cellStyle = (XSSFCellStyle)wb.createCellStyle()) != null) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            XSSFFont font = (XSSFFont)wb.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setBold(true);
            font.setFontHeightInPoints((short)11);
            cellStyle.setFont((Font)font);
            cellStyle.setWrapText(true);
        }
        return cellStyle;
    }

    private CellStyle creatersultecolumnheadercellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            cellStyle.setFillForegroundColor((short)13);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.getFont().setFontHeightInPoints((short)12);
        }
        return cellStyle;
    }

    private CellStyle createErrorInfoCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            // empty if block
        }
        return cellStyle;
    }

    private CellStyle createSuceessinfocellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            // empty if block
        }
        return cellStyle;
    }

    private Boolean updateUserArea(UserAddInfo userInfo) {
        if (StringUtils.isNotBlank((CharSequence)userInfo.getId())) {
            Long userId = Long.valueOf(userInfo.getId());
            List bizIdByUserId = this.userBiz2Dao.getByBizidAndUserid(userInfo.getBiz(), userId);
            List collect = bizIdByUserId.stream().map(r -> r.getRole().toString()).collect(Collectors.toList());
            if (StringUtils.isNotBlank((CharSequence)userInfo.getBizRoles())) {
                JSONObject bizRoleJson = JSONObject.parseObject((String)userInfo.getBizRoles());
                ArrayList list = new ArrayList();
                for (String key : bizRoleJson.keySet()) {
                    Arrays.asList(bizRoleJson.getString(key).split(",")).stream().filter(r -> !collect.contains(r)).forEach(r -> list.add(new User2Biz(UUID.randomUUID().toString(), userId, key, Integer.valueOf(Integer.parseInt(r)))));
                }
                if (!list.isEmpty()) {
                    this.userBiz2Dao.saveAll(list);
                }
            }
            return this.appendBizArea(userInfo.getBizRegion(), userInfo.getId());
        }
        return false;
    }

    private void addNewUser(UserAddInfo userInfo) throws Exception {
        List appIds;
        List<String> keys;
        UserBizSupervision userApp;
        ArrayList<UserBizSupervision> userAppLists;
        LandUser landUser = this.userService.addUser(userInfo);
        if (StringUtils.isNotBlank((CharSequence)userInfo.getBizRoles())) {
            JSONObject bizRoleJson = JSONObject.parseObject((String)userInfo.getBizRoles());
            ArrayList list = new ArrayList();
            for (String key : bizRoleJson.keySet()) {
                Arrays.asList(bizRoleJson.getString(key).split(",")).stream().forEach(r -> list.add(new User2Biz(UUID.randomUUID().toString(), landUser.getId(), key, Integer.valueOf(Integer.parseInt(r)))));
            }
            this.userBiz2Dao.saveAll(list);
            ArrayList<TaskNoticeSubscribe> noticeSubscribes = new ArrayList<TaskNoticeSubscribe>();
            for (int i = 0; i < list.size(); ++i) {
                TaskNoticeSubscribe subscribe = new TaskNoticeSubscribe();
                subscribe.setId(UUID.randomUUID().toString());
                subscribe.setUserid(landUser.getId().toString());
                subscribe.setTopic("tsk|" + ((User2Biz)list.get(i)).getBizid());
                subscribe.setDate(new Date());
                noticeSubscribes.add(subscribe);
            }
            this.mTaskNoticeNewService.addSubscribe(noticeSubscribes);
        }
        ArrayList<String> ywCodes = new ArrayList<String>();
        String zxyw = userInfo.getZxyw();
        if (StringUtils.isNotBlank((CharSequence)zxyw)) {
            String sql = "";
            String[] split = zxyw.split(",");
            if (zxyw.indexOf(";") > -1) {
                split = zxyw.split(";");
            }
            userAppLists = new ArrayList();
            for (int i = 0; i < split.length; ++i) {
                ywCodes.add(split[i]);
                String uid = UUID.randomUUID().toString();
                userApp = new UserBizSupervision();
                userApp.setId(uid);
                userApp.setTaskcode(split[i]);
                userApp.setUserid(landUser.getId());
                userAppLists.add(userApp);
            }
            this.userBizSupervisionDao.saveAll(userAppLists);
        }
        this.appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
        if (ywCodes.size() > 0) {
            keys = this.applicationCodeService.getKeyByCode(ywCodes);
            if (keys.indexOf(this.appkey) < 0) {
                keys.add(this.appkey);
            }
            appIds = this.UisApplicationDao.getIdByAppKey(keys);
            userAppLists = new ArrayList<UserBizSupervision>();
            for (String key : appIds) {
                userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                userAppLists.add(userApp);
            }
            if (userAppLists.size() > 0) {
                this.userApplicationDao.saveAll(userAppLists);
            }
        } else {
            keys = new ArrayList();
            keys.add(this.appkey);
            appIds = this.UisApplicationDao.getIdByAppKey(keys);
            for (String key : appIds) {
                UserApplication userApp2 = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp2.setId(uid);
                userApp2.setApplicationId(key);
                userApp2.setUserId(landUser.getId());
                this.userApplicationDao.save((Object)userApp2);
            }
        }
        String config = userInfo.getCloudQueryConfig();
        if (StringUtils.isNotBlank((CharSequence)config)) {
            String[] strs = config.split(",");
            ArrayList<RoleCloudQueryRel> list = new ArrayList<RoleCloudQueryRel>();
            for (int i = 0; i < strs.length; ++i) {
                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                ucc.setUid(landUser.getId().toString());
                ucc.setCid(strs[i].trim());
                list.add(ucc);
            }
            this.roleCloudQueryRelRepository.saveAll(list);
        }
        if (userInfo.getRoleIds().contains("10012")) {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            list.add(new BigDecimal(landUser.getId()));
        }
        if (userInfo.getRoleIds().contains("10020")) {
            Organization organization = this.organizationRepository.findById((Object)userInfo.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            CloudDiskOfOrg cloudDiskOfOrg = this.cloudDiskOfOrgDao.findById((Object)organization.getId()).orElse(null);
            if (cloudDiskOfOrg == null) {
                ArrayList<String> orgIdList = new ArrayList<String>();
                orgIdList.add(organization.getId());
            }
        }
        this.addBizArea(userInfo.getBizRegion(), landUser.getId().toString());
    }

    private Boolean appendBizArea(String bizRegion, String userId) {
        Boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)bizRegion)) {
            JSONObject obj = JSONObject.parseObject((String)bizRegion);
            for (String key : obj.keySet()) {
                flag = flag | this.tskTaskBizService.appendRightArea(key, userId, obj.getString(key));
            }
        }
        return flag;
    }

    private void addBizArea(String bizRegion, String userId) {
        if (StringUtils.isNotBlank((CharSequence)bizRegion)) {
            JSONObject obj = JSONObject.parseObject((String)bizRegion);
            for (String key : obj.keySet()) {
                this.tskTaskBizService.changeRightArea(key, userId, obj.getString(key));
            }
        }
    }

    @Transactional
    public void modifyUserBiz(UserUpdateInfo userInfo, Long currentUserid) {
        String roleIds = userInfo.getRoleIds();
        List bizIdByUserId = this.userBiz2Dao.getBizIdByUserId(currentUserid);
        List userBizs = this.userBiz2Dao.getBizIdByUserId(userInfo.getUserId());
        if (userBizs.size() > 0) {
            userBizs = userBizs.stream().filter(biz -> bizIdByUserId.contains(biz)).collect(Collectors.toList());
        }
        Long userid = userInfo.getUserId();
        String biz2 = userInfo.getBiz();
        List<Object> delList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)biz2)) {
            boolean isXian;
            User2Biz userBiz;
            int i;
            List<String> arrays = Arrays.asList(biz2.split(";"));
            for (int i2 = 0; i2 < userBizs.size(); ++i2) {
                if (arrays.contains(userBizs.get(i2))) continue;
                delList.add(userBizs.get(i2));
            }
            if (delList.size() > 0) {
                this.userBiz2Dao.deleteByBizidAndUserIds(delList, userid);
            }
            ArrayList<String> addList = new ArrayList<String>();
            for (int i3 = 0; i3 < arrays.size(); ++i3) {
                if (!bizIdByUserId.contains(arrays.get(i3)) || userBizs.contains(arrays.get(i3))) continue;
                addList.add(arrays.get(i3));
            }
            ArrayList<User2Biz> list = new ArrayList<User2Biz>();
            for (i = 0; i < addList.size(); ++i) {
                userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(userid);
                userBiz.setRole(Integer.valueOf(3));
                userBiz.setBizid((String)addList.get(i));
                list.add(userBiz);
            }
            if (roleIds.contains("10020") || roleIds.contains("10022")) {
                for (i = 0; i < addList.size(); ++i) {
                    userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(Integer.valueOf(1));
                    userBiz.setBizid((String)addList.get(i));
                    list.add(userBiz);
                }
            }
            boolean bl = isXian = StringUtils.isNotBlank((CharSequence)userInfo.getRegionCode()) && userInfo.getRegionCode().length() == 6 && Integer.valueOf(new StringBuilder(userInfo.getRegionCode()).reverse().toString()).toString().length() == 6;
            if (isXian && !roleIds.contains("10020") && !roleIds.contains("10022") && addList.size() > 0) {
                List filterBizs = this.tskTaskBizDao.findByIds(addList);
                List tskRightAreas = filterBizs.stream().filter(tskTaskBiz -> tskTaskBiz.getGranularity() == 3).map(tskTaskBiz -> new TskRightArea(userInfo.getRegionCode(), tskTaskBiz.getId(), userInfo.getUserId().toString())).collect(Collectors.toList());
                for (TskRightArea tskRightArea : tskRightAreas) {
                    this.tskTaskBizService.saveRightArea(tskRightArea, userid.toString());
                }
            }
            if (delList.size() > 0) {
                for (String s : delList) {
                    this.tskTaskBizService.deleteRightAreaByTaskId(s, userInfo.getUserId().toString());
                }
            }
            this.userBiz2Dao.saveAll(list);
        } else {
            delList = userBizs;
            if (delList.size() > 0) {
                this.userBiz2Dao.deleteByBizidAndUserIds(delList, userid);
            }
        }
    }

    @Transactional
    public void updateUserBiz(UserUpdateInfo userInfo) {
        String roleIds = userInfo.getRoleIds();
        Long userid = userInfo.getUserId();
        String biz = userInfo.getBiz();
        this.userBiz2Dao.deleteByUserIdLeftTskTaskBiz(userid);
        if (StringUtils.isNotBlank((CharSequence)biz) && !"".equalsIgnoreCase(biz)) {
            User2Biz userBiz;
            int i;
            List<String> arrays = Arrays.asList(biz.split(","));
            ArrayList<User2Biz> list = new ArrayList<User2Biz>();
            for (i = 0; i < arrays.size(); ++i) {
                userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(userid);
                userBiz.setRole(Integer.valueOf(3));
                userBiz.setBizid(arrays.get(i));
                list.add(userBiz);
            }
            if (roleIds.contains("10020") || roleIds.contains("10022")) {
                for (i = 0; i < arrays.size(); ++i) {
                    userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(Integer.valueOf(1));
                    userBiz.setBizid(arrays.get(i));
                    list.add(userBiz);
                }
            }
            this.userBiz2Dao.saveAll(list);
        }
    }

    @Transactional
    public void addUserBiz(UserAddInfo userInfo) {
        if (StringUtils.isNotBlank((CharSequence)userInfo.getBiz())) {
            boolean isXian;
            Long userid = Long.valueOf(userInfo.getId());
            String[] split = null;
            split = userInfo.getBiz().indexOf(",") != -1 ? userInfo.getBiz().split(",") : userInfo.getBiz().split(";");
            ArrayList<User2Biz> list = new ArrayList<User2Biz>();
            for (int i = 0; i < split.length; ++i) {
                User2Biz userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(Long.valueOf(userInfo.getId()));
                userBiz.setBizid(split[i]);
                userBiz.setRole(Integer.valueOf(3));
                list.add(userBiz);
            }
            String roleIds = userInfo.getRoleIds();
            if (roleIds.contains("10020") || roleIds.contains("10022")) {
                this.saveNoticeTopicAndNoticeSub(userInfo.getRegionCode(), userInfo.getId(), userInfo.getBiz(), 1);
                for (int i = 0; i < split.length; ++i) {
                    User2Biz userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(Integer.valueOf(1));
                    userBiz.setBizid(split[i]);
                    list.add(userBiz);
                }
            }
            boolean bl = isXian = StringUtils.isNotBlank((CharSequence)userInfo.getRegionCode()) && userInfo.getRegionCode().length() == 6 && Integer.valueOf(new StringBuilder(userInfo.getRegionCode()).reverse().toString()).toString().length() == 6;
            if (isXian && !roleIds.contains("10020") && !roleIds.contains("10022")) {
                if (split.length > 0) {
                    List filterBizs = this.tskTaskBizDao.findByIds(Arrays.asList(split));
                    List tskRightAreas = filterBizs.stream().filter(tskTaskBiz -> tskTaskBiz.getGranularity() == 3).map(tskTaskBiz -> new TskRightArea(userInfo.getRegionCode(), tskTaskBiz.getId(), userid.toString())).collect(Collectors.toList());
                    for (TskRightArea tskRightArea : tskRightAreas) {
                        this.tskTaskBizService.saveRightArea(tskRightArea, userid.toString());
                    }
                }
            } else if (userInfo.getOptUserid() != null) {
                String orgId = this.organization2UserRepository.findOrgIdByUserId(Long.valueOf(userInfo.getOptUserid()));
                Organization one = this.organizationRepository.findById((Object)orgId).orElse(null);
                String regionCode = one.getRegionCode();
                ArrayList<TskRightArea> rightAreas = new ArrayList<TskRightArea>();
                for (int i = 0; i < split.length; ++i) {
                    TskRightArea tskRightArea = new TskRightArea();
                    tskRightArea.setUserId(userInfo.getId());
                    tskRightArea.setXzqdm(regionCode);
                    tskRightArea.setTaskId(split[i]);
                    tskRightArea.setId(UUID.randomUUID().toString());
                    rightAreas.add(tskRightArea);
                }
                this.tskRightAreaRepository.saveAll(rightAreas);
            }
            this.userBiz2Dao.saveAll(list);
        }
    }

    public Map<String, Object> getRoleByUseridAndBizid(Long userId, String bizId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean cjz = false;
        boolean gly = false;
        boolean shy = false;
        boolean zyy = false;
        boolean fhy = false;
        String region = null;
        List workRegion = null;
        List userBiz2s = this.userBiz2Dao.getByBizidAndUserid(bizId, userId);
        if (!userBiz2s.isEmpty()) {
            List roles = userBiz2s.stream().map(r -> r.getRole()).collect(Collectors.toList());
            if (roles.indexOf(0) > -1) {
                cjz = true;
            }
            if (roles.indexOf(1) > -1) {
                gly = true;
                region = this.userAreaService.getUserRegionCode(userId);
            }
            if (roles.indexOf(2) > -1) {
                shy = true;
            }
            if (roles.indexOf(3) > -1) {
                zyy = true;
                workRegion = this.tskRightAreaRepository.findByTaskIdAndUserId(bizId, userId.toString()).stream().map(r -> r.getXzqdm()).collect(Collectors.toList());
            }
            if (roles.indexOf(4) > -1) {
                fhy = true;
            }
        }
        List bizArea = this.bizAreaRepository.findByBizId(bizId).stream().distinct().collect(Collectors.toList());
        map.put("cjz", cjz);
        map.put("gly", gly);
        map.put("shy", shy);
        map.put("zyy", zyy);
        map.put("fhy", fhy);
        map.put("region", region);
        map.put("workRegion", workRegion);
        map.put("bizArea", bizArea);
        return map;
    }

    @Transactional
    public void saveNoticeTopicAndNoticeSub(String region, String userId, String bizS, Integer role) {
        Integer userRole = null;
        userRole = role == 3 ? Integer.valueOf(4) : (role == 4 ? Integer.valueOf(8) : role);
        ArrayList<NoticeTopic> noticeTopics = new ArrayList<NoticeTopic>();
        List<Object> regions = new ArrayList();
        regions = this.getRegionList(region);
        ArrayList<NoticeSubscribe> noticeSubscribes = new ArrayList<NoticeSubscribe>();
        String[] bizs = bizS.split(",");
        for (int i = 0; i < bizs.length; ++i) {
            TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(bizs[i]);
            if (tskTaskBiz == null) continue;
            for (String string : regions) {
                List tempNoticeTopics = this.noticeTopicRepository.queryNoticeTopicByBizidAndRegionAndRoleAndType(bizs[i], string, userRole, "tsk");
                NoticeTopic noticeTopic = null;
                if (!tempNoticeTopics.isEmpty()) {
                    noticeTopic = (NoticeTopic)tempNoticeTopics.get(0);
                }
                String topicId = null;
                if (noticeTopic != null) {
                    topicId = noticeTopic.getId();
                } else {
                    topicId = UUID.randomUUID().toString();
                    NoticeTopic tempTopic = new NoticeTopic();
                    tempTopic.setType("tsk");
                    tempTopic.setRole(userRole);
                    tempTopic.setId(topicId);
                    this.setRegionDetail(tempTopic, string);
                    tempTopic.setDate(new Date());
                    tempTopic.setBizid(bizs[i]);
                    noticeTopics.add(tempTopic);
                }
                NoticeSubscribe noticeSubscribe = new NoticeSubscribe();
                noticeSubscribe.setUserId(userId);
                noticeSubscribe.setTopicId(topicId);
                noticeSubscribe.setCreateTime(new Date());
                noticeSubscribes.add(noticeSubscribe);
            }
        }
        this.noticeSubscribeRepository.saveAll(noticeSubscribes);
        this.noticeTopicRepository.saveAll(noticeTopics);
    }

    public List<String> getRegionList(String region) {
        ArrayList<String> regions = new ArrayList<String>();
        if (region.length() >= 6) {
            regions.add(region.substring(0, 2) + "0000");
            regions.add(region.substring(0, 4) + "00");
            regions.add(region.substring(0, 6));
        }
        if (region.length() >= 9) {
            regions.add(region.substring(0, 9));
        }
        if (region.length() >= 12) {
            regions.add(region);
        }
        if (region.equals("1")) {
            regions.add(region);
        }
        return regions.stream().distinct().collect(Collectors.toList());
    }

    public NoticeTopic setRegionDetail(NoticeTopic noticeTopic, String region) {
        noticeTopic.setRegion(region);
        if (region.length() == 6) {
            if (region.endsWith("0000")) {
                noticeTopic.setRegionSheng(region.substring(0, 2) + "0000");
            } else if (region.endsWith("00")) {
                noticeTopic.setRegionSheng(region.substring(0, 2) + "0000");
                noticeTopic.setRegionShi(region.substring(0, 4) + "00");
            } else {
                noticeTopic.setRegionSheng(region.substring(0, 2) + "0000");
                noticeTopic.setRegionShi(region.substring(0, 4) + "00");
                noticeTopic.setRegionXian(region);
            }
        }
        if (region.length() == 9) {
            noticeTopic.setRegionSheng(region.substring(0, 2) + "0000");
            noticeTopic.setRegionShi(region.substring(0, 4) + "00");
            noticeTopic.setRegionXian(region.substring(0, 6));
            noticeTopic.setRegionXiang(region);
        }
        return noticeTopic;
    }
}

