/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.service.task.TaskNoticeNewService;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorValue;
import com.geoway.landteam.landcloud.core.model.user.dto.UserProsecuteDTO;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecute;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecuteAppeal;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecuteAttach;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserProsecuteAppealRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserProsecuteAttachRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserProsecuteRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.EnumeratorValueServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.SMSUtilHuawei;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.user.MUserProsecuteService;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilCollection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MUserProsecuteServiceImpl
implements MUserProsecuteService {
    @Autowired
    UserProsecuteRepository userProsecuteRepository;
    @Autowired
    UserProsecuteAttachRepository userProsecuteAttachRepository;
    @Autowired
    UserProsecuteAppealRepository userProsecuteAppealRepository;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    UserRoleInfoRepository userRoleInfoRepository;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;
    @Autowired
    TaskNoticeNewService taskNoticeNewService;
    @Autowired
    LandRegUserService regUserService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    UserNameService userNameService;

    public UserProsecute findUserProsecutebyId(String id) {
        return this.userProsecuteRepository.findById((Object)id).orElse(null);
    }

    public void saveUserProsecute(Long userId, Long prosecuteUserId, String prosecuteType, String prosecuteImages, String remark) throws Exception {
        List lists = this.userProsecuteRepository.findByUserIdAndProsecuteUserIdAndType(userId, prosecuteUserId, prosecuteType);
        if (!lists.isEmpty()) {
            throw new RuntimeException("\u8be5\u7528\u6237\u5df2\u88ab\u4f60\u4e3e\u62a5\u8fc7\uff0c\u4e0d\u7528\u91cd\u590d\u4e3e\u62a5");
        }
        UserProsecute userProsecute = new UserProsecute();
        userProsecute.setUserId(prosecuteUserId);
        userProsecute.setProsecuteUserId(userId);
        userProsecute.setStatus(Integer.valueOf(0));
        userProsecute.setProsecuteType(prosecuteType);
        userProsecute.setRemark(remark);
        userProsecute.setCreateTime(new Timestamp(System.currentTimeMillis()));
        UserProsecute bean = (UserProsecute)this.userProsecuteRepository.save((Object)userProsecute);
        if (prosecuteImages != null && !"".equals(prosecuteImages)) {
            this.saveUserProsecuteAttach(bean.getId(), userId, prosecuteImages);
        }
        this.sendMessage(userId, bean.getId());
    }

    public void sendMessage(Long userId, String prosecuteId) {
        String title = "\u4e3e\u62a5\u901a\u77e5";
        String content = String.format("\u3010\u4e3e\u62a5\u901a\u77e5\u3011\u60a8\u5df2\u63d0\u4ea4\u4e3e\u62a5\u4fe1\u606f\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01", new Object[0]);
        TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
        taskNoticeUserNew.setSenduser(userId.toString());
        taskNoticeUserNew.setTitle(title);
        taskNoticeUserNew.setContent(content);
        taskNoticeUserNew.setReceiveuser(userId.toString());
        taskNoticeUserNew.setData(prosecuteId);
        taskNoticeUserNew.setAction(Integer.valueOf(1));
        taskNoticeUserNew.setSenddate(new Date());
        this.taskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
        HashMap<String, Integer> message = new HashMap<String, Integer>();
        message.put("type", 8);
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId.toString());
        try {
            if (userIds.size() > 0) {
                MixPushServer.sendNotifyToAlias(userIds, (String)title, (String)content, (String)JSON.toJSONString(message));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONArray findUserProsecuteinfo(Long userId) {
        List lists = this.userProsecuteRepository.findTypeByUserId(userId);
        JSONArray arr = new JSONArray();
        if (!lists.isEmpty()) {
            EnumeratorValue ev = this.enumeratorValueService.findOneByKey("DIC_JBLX");
            List result = this.enumeratorDomainService.findByDicno(ev.getDicno());
            for (EnumeratorDomain ed : result) {
                JSONObject obj = new JSONObject();
                lists.forEach(a -> {
                    if (a.equals(ed.getCode())) {
                        obj.put("id", (Object)ed.getCode());
                        obj.put("text", (Object)ed.getName());
                        arr.add((Object)obj);
                    }
                });
            }
        }
        return arr;
    }

    public void submitAppealApply(Long userId, String appealInfo) {
        JSONArray jsonArray = JSONArray.parseArray((String)appealInfo, (Feature[])new Feature[0]);
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String type = jsonObject.get((Object)"type").toString();
                String state = jsonObject.get((Object)"state").toString();
                String images = jsonObject.get((Object)"images").toString();
                String remark = jsonObject.get((Object)"remark").toString();
                List objects = this.userProsecuteRepository.findTypeByUserIdAndType(userId, type);
                if (objects.isEmpty()) continue;
                for (Object[] object : objects) {
                    if (object[2] == null) {
                        UserProsecuteAppeal bean = new UserProsecuteAppeal();
                        bean.setProsecuteId(object[1].toString());
                        bean.setRemark(remark);
                        bean.setState(Integer.valueOf(state));
                        bean.setStatus(Integer.valueOf(0));
                        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        bean.setUserId(userId);
                        UserProsecuteAppeal save = (UserProsecuteAppeal)this.userProsecuteAppealRepository.save((Object)bean);
                        if (images == null || "".equals(images)) continue;
                        this.saveUserProsecuteAttach(save.getId(), userId, images);
                        continue;
                    }
                    UserProsecuteAppeal one = this.userProsecuteAppealRepository.findById((Object)object[2].toString()).orElse(null);
                    one.setRemark(remark);
                    one.setState(Integer.valueOf(state));
                    one.setStatus(Integer.valueOf(0));
                    one.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                    this.userProsecuteAppealRepository.save((Object)one);
                    if (images == null || "".equals(images)) continue;
                    this.saveUserProsecuteAttach(one.getId(), userId, images);
                }
            }
        }
    }

    public Map<String, Object> getUserProsecuteRecords(Long userId, Integer prosecuteStatus, Integer appealStatus, String prosecuteUserName, String userName, Integer page, Integer rows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        StringBuffer countSql = new StringBuffer();
        sql.append("select u.f_id prosecuteId,a.f_id appealId,u.f_userid userId,u.f_prosecuteuserid prosecuteUserId,u.f_prosecutetype prosecuteType,u.f_createtime prosecuteTime,u.f_status prosecuteStatus,a.f_status appealStatus,a.f_audittime appealAuditTime,u.f_audittime prosecuteAuditTime from tb_user_prosecute u LEFT JOIN tb_user_prosecute_appeal a on (u.f_id = a.f_prosecuteid)");
        countSql.append("select count(1) from tb_user_prosecute u LEFT JOIN tb_user_prosecute_appeal a on (u.f_id = a.f_prosecuteid) ");
        sql.append(" where 1 =1 ");
        countSql.append(" where 1 =1 ");
        if (prosecuteStatus != null) {
            sql.append(" and u.f_status =" + prosecuteStatus);
            countSql.append(" and u.f_status =" + prosecuteStatus);
        }
        if (appealStatus != null) {
            sql.append(" and u.f_status =" + appealStatus);
            countSql.append(" and u.f_status =" + appealStatus);
        }
        if (userName != null) {
            sql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_userid and (pp.f_username like '%" + userName + "%' or pp.f_rname like '%" + userName + "%'  )) ");
            countSql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_userid and (pp.f_username like '%" + userName + "%' or pp.f_rname like '%" + userName + "%'  )) ");
        }
        if (prosecuteUserName != null) {
            sql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_prosecuteuserid and (pp.f_username like '%" + prosecuteUserName + "%' or pp.f_rname like '%" + prosecuteUserName + "%'  )) ");
            countSql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_prosecuteuserid and (pp.f_username like '%" + prosecuteUserName + "%' or pp.f_rname like '%" + prosecuteUserName + "%'  )) ");
        }
        String orgIdByUserId = this.organization2UserDao.findOrgIdByUserId(userId);
        List users = new ArrayList();
        if (orgIdByUserId != null) {
            List roleIdsByUserId = this.userRoleInfoRepository.getRoleIdsByUserId(userId);
            if (roleIdsByUserId.contains("10022")) {
                users = this.organization2UserDao.queryOrUserTwo(orgIdByUserId);
                List orgIds = this.organizationRepository.getOrganizationsByPid(orgIdByUserId);
                if (!orgIds.isEmpty()) {
                    users.addAll(this.organization2UserDao.queryManagers(orgIds));
                }
            } else if (roleIdsByUserId.contains("10020")) {
                users = this.organization2UserDao.queryOrUser(orgIdByUserId);
            }
        }
        if (!users.isEmpty()) {
            sql.append(" and u.f_userid in(" + StringUtils.join((Object[])users.toArray(), (String)",") + ") ");
            countSql.append(" and u.f_userid in(" + StringUtils.join((Object[])users.toArray(), (String)",") + ") ");
        }
        sql.append(" ORDER BY u.f_createtime desc LIMIT " + rows + " OFFSET " + (page - 1) * rows);
        List resultList = this.jdbcTemplate.queryForList(sql.toString());
        ArrayList<UserProsecuteDTO> list = new ArrayList<UserProsecuteDTO>();
        if (!GutilCollection.isEmpty((Collection)resultList)) {
            for (Map map : resultList) {
                try {
                    LandUser landUser;
                    UserProsecuteDTO bean = new UserProsecuteDTO();
                    bean.setProsecuteId(map.get("prosecuteId") != null ? map.get("prosecuteId").toString() : "");
                    bean.setAppealId(map.get("appealId") != null ? map.get("appealId").toString() : "");
                    bean.setUserId(map.get("userId") != null ? Long.valueOf(map.get("userId").toString()) : null);
                    if (map.get("userId") != null) {
                        landUser = this.regUserService.getReviewDetailByUserId(Long.valueOf(map.get("userId").toString()));
                        bean.setUserName(this.userNameService.getUserRealNameByUserId(map.get("userId").toString()));
                        bean.setLandUser(landUser);
                    }
                    bean.setProsecuteUserId(map.get("prosecuteUserId") != null ? Long.valueOf(map.get("prosecuteUserId").toString()) : null);
                    if (map.get("prosecuteUserId") != null) {
                        landUser = this.landUserDao.findById((Object)Long.valueOf(map.get("prosecuteUserId").toString())).orElse(null);
                        bean.setProsecuteUserName(this.userNameService.getUserRealNameByUserId(map.get("prosecuteUserId").toString()));
                        bean.setProsecuteUserPhone(this.userNameService.getUserPhoneByUserId(map.get("prosecuteUserId").toString()));
                    }
                    bean.setProsecuteType(map.get("prosecuteType") != null ? map.get("prosecuteType").toString() : null);
                    bean.setProsecuteTime(map.get("prosecuteTime") != null ? Timestamp.valueOf(map.get("prosecuteTime").toString()) : null);
                    bean.setProsecuteStatus(map.get("prosecuteStatus") != null ? Integer.valueOf(map.get("prosecuteStatus").toString()) : null);
                    bean.setAppealStatus(map.get("appealStatus") != null ? Integer.valueOf(map.get("appealStatus").toString()) : null);
                    bean.setAppealAuditTime(map.get("appealAuditTime") != null ? Timestamp.valueOf(map.get("appealAuditTime").toString()) : null);
                    bean.setProsecuteAuditTime(map.get("prosecuteAuditTime") != null ? Timestamp.valueOf(map.get("prosecuteAuditTime").toString()) : null);
                    list.add(bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Long count = (Long)this.jdbcTemplate.queryForObject(countSql.toString(), Long.class);
        resultMap.put("list", list);
        resultMap.put("count", count);
        return resultMap;
    }

    public UserProsecute getProsecuteInfo(String prosecuteId) throws Exception {
        UserProsecute userProsecute = this.userProsecuteRepository.findById((Object)prosecuteId).orElse(null);
        if (userProsecute == null) {
            throw new RuntimeException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5id");
        }
        List attachs = this.userProsecuteAttachRepository.findAttachByProsecuteId(prosecuteId);
        if (!attachs.isEmpty()) {
            attachs.forEach(a -> {
                if (a.getFileUrl() != null && !"".equals(a.getFileUrl()) && !a.getFileUrl().contains("AccessKeyId")) {
                    a.setFileNoConversionUrl(a.getFileUrl());
                    String url = this.temporarySignedUrlService.getTemporarySignedUrl("", a.getFileUrl(), null);
                    a.setFileUrl(url);
                }
            });
            userProsecute.setAttachs(attachs);
        }
        if (userProsecute.getUserId() != null) {
            userProsecute.setUserName(this.userNameService.getUserRealNameByUserId(userProsecute.getUserId().toString()));
        }
        if (userProsecute.getAuditUseId() != null) {
            userProsecute.setAuditUserName(this.userNameService.getUserRealNameByUserId(userProsecute.getAuditUseId().toString()));
        }
        if (userProsecute.getProsecuteType() != null) {
            EnumeratorValue ev = this.enumeratorValueService.findOneByKey("DIC_JBLX");
            List result = this.enumeratorDomainService.findByDicno(ev.getDicno());
            result.forEach(a -> {
                if (a.getCode().equals(userProsecute.getProsecuteType())) {
                    userProsecute.setProsecuteTypeName(a.getName());
                }
            });
        }
        return userProsecute;
    }

    public UserProsecuteAppeal getAppealInfo(String prosecuteId) throws Exception {
        List attachs;
        UserProsecuteAppeal userProsecuteAppeal = this.userProsecuteAppealRepository.findById((Object)prosecuteId).orElse(null);
        if (userProsecuteAppeal == null) {
            throw new GwValidateException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5id");
        }
        UserProsecute userProsecute = this.userProsecuteRepository.findById((Object)userProsecuteAppeal.getProsecuteId()).orElse(null);
        if (userProsecute != null) {
            userProsecuteAppeal.setProsecuteType(userProsecute.getProsecuteType());
        }
        if (userProsecuteAppeal.getAuditUseId() != null) {
            userProsecuteAppeal.setAuditUserName(this.userNameService.getUserRealNameByUserName(userProsecuteAppeal.getAuditUseId().toString()));
        }
        if (!(attachs = this.userProsecuteAttachRepository.findAttachByProsecuteId(prosecuteId)).isEmpty()) {
            attachs.forEach(a -> {
                if (a.getFileUrl() != null && !"".equals(a.getFileUrl()) && !a.getFileUrl().contains("AccessKeyId")) {
                    a.setFileNoConversionUrl(a.getFileUrl());
                    String url = this.temporarySignedUrlService.getTemporarySignedUrl("", a.getFileUrl(), null);
                    a.setFileUrl(url);
                }
            });
            userProsecuteAppeal.setAttachs(attachs);
        }
        return userProsecuteAppeal;
    }

    public void prosecuteAudit(Long userId, String id, Integer type, Integer status, String auditOpinion) throws Exception {
        if (type == 1) {
            UserProsecute userProsecute = this.userProsecuteRepository.findById((Object)id).orElse(null);
            if (userProsecute == null) {
                throw new RuntimeException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5id");
            }
            userProsecute.setStatus(status);
            userProsecute.setAuditUseId(userId);
            userProsecute.setAuditTime(new Timestamp(System.currentTimeMillis()));
            userProsecute.setAuditOpinion(auditOpinion);
            this.userProsecuteRepository.save((Object)userProsecute);
        } else if (type == 2) {
            UserProsecuteAppeal userProsecuteAppeal = this.userProsecuteAppealRepository.findById((Object)id).orElse(null);
            if (userProsecuteAppeal == null) {
                throw new RuntimeException("\u8be5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5id");
            }
            userProsecuteAppeal.setStatus(status);
            userProsecuteAppeal.setAuditUseId(userId);
            userProsecuteAppeal.setAuditTime(new Timestamp(System.currentTimeMillis()));
            userProsecuteAppeal.setAuditOpinion(auditOpinion);
            this.userProsecuteAppealRepository.save((Object)userProsecuteAppeal);
            Integer count = this.userProsecuteRepository.countByUserId(userProsecuteAppeal.getUserId());
            if (count <= 0) {
                String telphone = this.userNameService.getUserPhoneByUserId(userProsecuteAppeal.getUserId().toString());
                String rname = this.userNameService.getUserRealNameByUserId(userProsecuteAppeal.getUserId().toString());
                if (StringUtils.isNotBlank((CharSequence)telphone)) {
                    if (!telphone.startsWith("+86")) {
                        telphone = "+86" + telphone;
                    }
                    if (status == 1) {
                        String templateParas = "[\"" + rname + "\",\"" + rname + "\"]";
                        SMSUtilHuawei.sendSMS((String)"csms18120613", (String)"e2c707cb3a7148279a903d3789795f6c", (String)templateParas, (String)telphone);
                    }
                }
            }
        }
    }

    public void auditSendMessage(Long userId, UserProsecute userProsecute) {
        String title = "\u4e3e\u62a5\u901a\u77e5";
        String content = "";
        TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
        taskNoticeUserNew.setSenduser(userId.toString());
        EnumeratorValue ev = this.enumeratorValueService.findOneByKey("DIC_JBLX");
        List result = this.enumeratorDomainService.findByDicno(ev.getDicno());
        result.forEach(a -> {
            if (a.getCode().equals(userProsecute.getProsecuteType())) {
                userProsecute.setProsecuteTypeName(a.getName());
            }
        });
        if (userProsecute.getUserId() != null) {
            userProsecute.setUserName(this.userNameService.getUserRealNameByUserId(userProsecute.getUserId().toString()));
        }
        if (userProsecute.getStatus() == 1) {
            content = String.format("\u4e3e\u62a5\u5bf9\u8c61\uff1a" + userProsecute.getUserName() + "\n\u4e3e\u62a5\u5185\u5bb9\uff1a" + userProsecute.getProsecuteTypeName() + "\u3002\n\u5ba1\u6838\u7ed3\u679c\uff1a\u7ecf\u5ba1\u6838\uff0c\u786e\u8ba4\u4e3e\u62a5\u5bf9\u8c61\u6709\u8fdd\u89c4\u884c\u4e3a\u3002\u5df2\u5bf9\u5176\u8fdb\u884c\u529f\u80fd\u9650\u5236\u5904\u7406\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301\uff01\n", new Object[0]);
            taskNoticeUserNew.setAction(Integer.valueOf(2));
        } else {
            content = String.format("\u4e3e\u62a5\u5bf9\u8c61\uff1a" + userProsecute.getUserName() + "\n\u4e3e\u62a5\u5185\u5bb9\uff1a" + userProsecute.getProsecuteTypeName() + "\u3002\n\u5ba1\u6838\u7ed3\u679c\uff1a\u7ecf\u5ba1\u6838\uff0c\u786e\u8ba4\u4e3e\u62a5\u5bf9\u8c61\u4e0d\u5b58\u5728\u8fdd\u89c4\u884c\u4e3a\uff0c\u611f\u8c22\u60a8\u7684\u53c2\u4e0e\uff01\n", new Object[0]);
            taskNoticeUserNew.setAction(Integer.valueOf(3));
        }
        taskNoticeUserNew.setTitle(title);
        taskNoticeUserNew.setContent(content);
        taskNoticeUserNew.setReceiveuser(userProsecute.getProsecuteUserId().toString());
        taskNoticeUserNew.setData(userProsecute.getId());
        taskNoticeUserNew.setSenddate(new Date());
        this.taskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
        HashMap<String, Integer> message = new HashMap<String, Integer>();
        message.put("type", 8);
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId.toString());
        try {
            if (userIds.size() > 0) {
                MixPushServer.sendNotifyToAlias(userIds, (String)title, (String)content, (String)JSON.toJSONString(message));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<UserProsecuteAppeal> findUserAppealRecords(Long userId) {
        List list = this.userProsecuteAppealRepository.findUserAppealRecordsByUserId(userId, Integer.valueOf(0));
        return list;
    }

    public void saveUserProsecuteAttach(String id, Long userId, String prosecuteImages) {
        ArrayList lists = new ArrayList();
        List<String> listString = Arrays.asList(prosecuteImages.split(","));
        if (!listString.isEmpty()) {
            listString.forEach(a -> {
                UserProsecuteAttach userProsecuteAttach = new UserProsecuteAttach();
                userProsecuteAttach.setFileUrl(a);
                userProsecuteAttach.setProsecuteId(id);
                userProsecuteAttach.setUserId(userId);
                userProsecuteAttach.setCreateTime(new Timestamp(System.currentTimeMillis()));
                lists.add(userProsecuteAttach);
            });
        }
        if (!GutilCollection.isEmpty(lists)) {
            this.userProsecuteAttachRepository.saveAll(lists);
        }
    }
}

