/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static boolean deleteFileAndDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteFileAndDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> fileList = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDirName + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (!readfile.isDirectory()) {
                    tempName = readfile.getName();
                    if (!FileUtil.wildcardMatch(targetFileName, tempName)) continue;
                    fileList.add(readfile.getAbsolutePath());
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                fileList.addAll(FileUtil.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
            }
        }
        return fileList;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (FileUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static byte[] fileToByte(String filePath) {
        byte[] buffer = null;
        try {
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1];
            int read = fis.read(bytes);
            while (read != -1) {
                bos.write(bytes, 0, read);
                read = fis.read(bytes);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static byte[] fileToByteOld(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byteToFile(byte[] bfile, String filePath, String fileName) {
        block6: {
            BufferedOutputStream bos = null;
            FileOutputStream fos = null;
            File file = null;
            try {
                File dir = new File(filePath);
                if (!dir.exists() && dir.isDirectory()) {
                    dir.mkdirs();
                }
                file = new File(filePath + "\\" + fileName);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bfile);
                IOUtils.closeQuietly((OutputStream)bos);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }
}

