/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.util.geometry.SRWKTTemplate;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GeometryTrasnUtil {
    public static int getProjNum(Geometry geom) throws Exception {
        int projNo = (int)((geom.getCentroid().getX() - 1.5) / 3.0) + 1;
        return projNo;
    }

    public static CoordinateReferenceSystem getCgcsPrjCoordinateReferenceSystem(int projNum) throws Exception {
        CoordinateReferenceSystem destCRS = null;
        String srwkt = SRWKTTemplate.findCGS2000GaussPrjSRWKTWithPrjNo((int)projNum);
        try {
            destCRS = CRS.parseWKT((String)srwkt);
        }
        catch (FactoryException var4) {
            var4.printStackTrace();
        }
        return destCRS;
    }

    public static CoordinateReferenceSystem getCgcsPrjCoordinateReferenceSystem(Geometry geom) throws Exception {
        CoordinateReferenceSystem destCRS = null;
        int projNo = (int)((geom.getCentroid().getX() - 1.5) / 3.0) + 1;
        String srwkt = SRWKTTemplate.findCGS2000GaussPrjSRWKTWithPrjNo((int)projNo);
        try {
            destCRS = CRS.parseWKT((String)srwkt);
        }
        catch (FactoryException var5) {
            var5.printStackTrace();
        }
        return destCRS;
    }

    public static CoordinateReferenceSystem getXa80PrjCoordinateReferenceSystem(int projNum) throws Exception {
        CoordinateReferenceSystem destCRS = null;
        String srwkt = SRWKTTemplate.findXian80GaussWithPrjNoWKTTemplate((int)projNum);
        try {
            destCRS = CRS.parseWKT((String)srwkt);
        }
        catch (FactoryException var4) {
            var4.printStackTrace();
        }
        return destCRS;
    }

    public static Geometry transCgcs2000ToPrj(Geometry geom, CoordinateReferenceSystem destCRS) throws Exception {
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return JTS.transform((Geometry)geom, (MathTransform)transform);
    }

    public static Geometry transCgcs2000ToGeo(Geometry geom, CoordinateReferenceSystem sourCRS) throws Exception {
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        return JTS.transform((Geometry)geom, (MathTransform)transform);
    }

    public static String transCgcsToPrj(String sourceWkt, Integer sourceSrid, Integer targetSrid) throws Exception {
        Geometry geo = GeometryTrasnUtil.parseGeometry(sourceWkt, sourceSrid);
        return GeometryTrasnUtil.transCgcsToPrj(geo, sourceSrid, targetSrid).toText();
    }

    public static Geometry transCgcsToPrj(Geometry source, Integer sourceSrid, Integer targetSrid) throws Exception {
        int projNo = 0;
        if (targetSrid == null) {
            double lon = source.getCentroid().getX();
            projNo = (int)((lon - 1.5) / 3.0) + 1;
        } else {
            projNo = targetSrid - 4513 + 25;
        }
        CoordinateReferenceSystem destCRS = GeometryTrasnUtil.findDestProjectCRSByLon(projNo);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return JTS.transform((Geometry)source, (MathTransform)transform);
    }

    private static CoordinateReferenceSystem findDestProjectCRSByLon(int projNo) throws FactoryException {
        if (projNo > 60) {
            return null;
        }
        CoordinateReferenceSystem destCRS = null;
        String wkt = SRWKTTemplate.findCGS2000GaussPrjSRWKTWithPrjNo((int)projNo);
        destCRS = CRS.parseWKT((String)wkt);
        return destCRS;
    }

    private static Geometry parseGeometry(String wkt, Integer srid) throws ParseException {
        if (StringUtils.isBlank((CharSequence)wkt)) {
            throw new IllegalArgumentException("\u53c2\u6570wkt\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WKTReader reader = new WKTReader();
        Geometry geo = reader.read(wkt);
        geo.setSRID(srid.intValue());
        return geo;
    }
}

