/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.service.util.MyX509TrustManager;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;

public class HttpUtil {
    public static final String ContentType_Form = "application/x-www-form-urlencoded; charset=UTF-8";
    public static final String ContentType_JSON = "application/json; charset=UTF-8";
    private final GiLoger logger = GwLoger.getLoger(HttpUtil.class);

    public static byte[] fileConvertToByteArray(File file) throws Exception {
        int len;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = fis.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        byte[] data = baos.toByteArray();
        fis.close();
        baos.close();
        return data;
    }

    public static byte[] fileConvertToByteArray(InputStream inputStream) throws Exception {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        byte[] data = baos.toByteArray();
        inputStream.close();
        baos.close();
        return data;
    }

    public static String httpsRequestPost(String requestUrl, String requestMethod, byte[] bytes, String ContentType2) throws Exception {
        String result = null;
        HttpURLConnection conn = null;
        try {
            Throwable throwable;
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(requestMethod);
            if (StringUtils.isNotEmpty((CharSequence)ContentType2) && ContentType2.contains(":")) {
                conn.setRequestProperty("Content-Type", ContentType2.split(":")[1]);
            }
            conn.connect();
            if (bytes != null) {
                throwable = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(bytes);
                    os.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (InputStream is = conn.getInputStream();
                 ByteArrayOutputStream bytestream = new ByteArrayOutputStream();){
                int ch;
                byte[] bb = new byte[2048];
                while ((ch = is.read(bb)) != -1) {
                    bytestream.write(bb, 0, ch);
                }
                byte[] by = bytestream.toByteArray();
                result = new String(by, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileExists(String path) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            int responseCode = conn.getResponseCode();
            System.out.println("Response Code : " + responseCode);
            if (responseCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return false;
    }
}

