/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.service.util.RedisCacheUtils;
import com.gw.base.user.GwNoLoginException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component
public class RedisSessionTestUtils {
    @Resource
    private RedisCacheUtils<AuthUserInfo> redisCache;
    private static RedisCacheUtils<AuthUserInfo> redisCacheUtils;

    @PostConstruct
    public void init() {
        redisCacheUtils = this.redisCache;
    }

    public static Long checkWebLogin(HttpServletRequest request) {
        AuthUserInfo authUserInfo;
        boolean hasAppsId;
        HttpSession session = request.getSession(true);
        String appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
        boolean bl = hasAppsId = request.getHeader("appsId") != null && StringUtils.isNotBlank((CharSequence)request.getHeader("appsId"));
        if (hasAppsId) {
            appkey = request.getHeader("appsId");
            session.setAttribute("appsId" + appkey, (Object)appkey);
        }
        if ((authUserInfo = RedisSessionTestUtils.getAuthUserInfo(request)) == null) {
            try {
                if (request.getHeader("access_token") != null && StringUtils.isNotBlank((CharSequence)request.getHeader("access_token")) && !"undefined".equalsIgnoreCase(request.getHeader("access_token"))) {
                    String token = request.getHeader("access_token");
                    AuthUserInfo authUserInfo1 = redisCacheUtils.getObject(token);
                    if (authUserInfo1 != null) {
                        return authUserInfo1.getUserId();
                    }
                    throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
                }
            }
            catch (Exception e) {
                throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
        }
        return authUserInfo.getUserId();
    }

    public static Long checkAppOrWebLogin(HttpServletRequest request) {
        return RedisSessionTestUtils.checkWebLogin(request);
    }

    public static int getLevel(HttpServletRequest request) {
        int level = -1;
        Object obj = request.getSession(true).getAttribute("user-level");
        if (obj == null || !(obj instanceof Integer)) {
            throw new GwNoLoginException("\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
        }
        level = (Integer)obj;
        return level;
    }

    public static AuthUserInfo getAuthUserInfo(HttpServletRequest request) {
        try {
            AuthUserInfo busUserInfo = (AuthUserInfo)request.getSession().getAttribute("authUserInfo");
            return busUserInfo;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

