/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.UisService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.service.util.RedisCacheUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.user.GwNoLoginException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisSessionUtils {
    private static final GiLoger logger = GwLoger.getLoger(RedisSessionUtils.class);
    @Resource
    private RedisCacheUtils<AuthUserInfo> redisCache;
    @Autowired
    UisService uisService;
    private static UisService uis;
    private static RedisCacheUtils<AuthUserInfo> redisCacheUtils;
    public static final String SESSION_KEY_REDIRECT_URL = "redirect_url";
    public static final String SESSION_KEY_GAS_PROVIDER = "gas_provider";
    public static final String SESSION_KEY_GAS_PROVIDER_SS01 = "gas_providerSSO1";

    @PostConstruct
    public void init() {
        redisCacheUtils = this.redisCache;
        uis = this.uisService;
    }

    public static Long checkWebLogin(HttpServletRequest reques) {
        return RedisSessionUtils.checkAppOrWebLogin(reques);
    }

    public static Long checkAppOrWebLogin(HttpServletRequest request) {
        AuthUserInfo authUserInfo = RedisSessionUtils.getAuthUserInfo(request);
        return authUserInfo == null ? null : authUserInfo.getUserId();
    }

    public static AuthUserInfo getAuthUserInfo(String sessionId, String appIds) {
        try {
            AuthUserInfo busUserInfo = redisCacheUtils.getObject(sessionId);
            if (busUserInfo == null) {
                throw new GwNoLoginException("appId:" + appIds + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            return busUserInfo;
        }
        catch (Exception ex) {
            throw new GwNoLoginException("appId:;\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
        }
    }

    public static AuthUserInfo getAuthUserInfo(HttpServletRequest request) {
        try {
            boolean hasAppsId;
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            String appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
            boolean bl = hasAppsId = request.getHeader("appsId") != null && StringUtils.isNotBlank((CharSequence)request.getHeader("appsId"));
            if (hasAppsId) {
                appkey = request.getHeader("appsId");
            }
            Object accessToken = null;
            if (!hasAppsId) {
                appkey = "";
            }
            if ((accessToken = session.getAttribute(appkey + "accessToken")) == null) {
                throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            logger.info("getAuthUserInfo sessionId:" + sessionId + " key:" + accessToken.toString(), new Object[0]);
            AuthUserInfo busUserInfo = redisCacheUtils.getObject(accessToken.toString());
            if (busUserInfo == null) {
                throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            redisCacheUtils.setObject(accessToken.toString(), busUserInfo, 86400L);
            return busUserInfo;
        }
        catch (Exception ex) {
            throw new GwNoLoginException("appId:;\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
        }
    }

    public static AuthUserInfo getErrAuthUserInfo(HttpServletRequest request) {
        try {
            boolean hasAppsId;
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            String appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
            boolean bl = hasAppsId = request.getHeader("appsId") != null && StringUtils.isNotBlank((CharSequence)request.getHeader("appsId"));
            if (hasAppsId) {
                appkey = request.getHeader("appsId");
            }
            Object accessToken = null;
            if (!hasAppsId) {
                appkey = "";
            }
            logger.warn("getAuthUserInfo2 sessionId:" + sessionId, new Object[0]);
            accessToken = session.getAttribute(appkey + "accessToken");
            if (accessToken == null) {
                throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            AuthUserInfo busUserInfo = redisCacheUtils.getObject(accessToken.toString());
            if (busUserInfo == null) {
                throw new GwNoLoginException("appId:" + appkey + ";" + "\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
            }
            return busUserInfo;
        }
        catch (Exception ex) {
            throw new GwNoLoginException("appId:;\u672a\u767b\u9646\u7cfb\u7edf\u6216\u767b\u9646\u5df2\u8d85\u65f6!");
        }
    }

    public static void setSessionAtt(HttpSession session, String key, Object value) {
        session.setAttribute(key, value);
    }

    public static Object getSessionAtt(HttpSession session, String key) {
        return session.getAttribute(key);
    }
}

