/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;

public final class SM3Util {
    private SM3Util() {
    }

    private static byte[] sm3(byte[] srcData) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(hash, 0);
        return hash;
    }

    public static String encrypt(byte[] srcData) {
        byte[] hash = SM3Util.sm3(srcData);
        String hexString = Hex.toHexString((byte[])hash);
        return hexString;
    }

    private static byte[] hmacSm3(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] hash = new byte[mac.getMacSize()];
        mac.doFinal(hash, 0);
        return hash;
    }

    public static String encrypt(byte[] key, byte[] srcData) {
        byte[] hash = SM3Util.hmacSm3(key, srcData);
        String hexString = Hex.toHexString((byte[])hash);
        return hexString;
    }

    private static byte[] sm3bc(byte[] srcData) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "BC");
        byte[] digest = messageDigest.digest(srcData);
        return digest;
    }

    public static String encryptBC(byte[] srcData) throws Exception {
        byte[] hash = SM3Util.sm3bc(srcData);
        String hexString = Hex.toHexString((byte[])hash);
        return hexString;
    }

    public static String encrypt(File file) {
        byte[] srcData;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int n;
            fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            srcData = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("file not found!");
        }
        finally {
            SM3Util.closeResoruce(fis, bos);
        }
        return SM3Util.encrypt(srcData);
    }

    private static void closeResoruce(FileInputStream fis, ByteArrayOutputStream bos) {
        if (null != fis) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != bos) {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String encrypt(String src) {
        return ByteUtils.toHexString((byte[])SM3Util.getEncryptBySrcByte(src.getBytes()));
    }

    public static byte[] getEncryptBySrcByte(byte[] srcByte) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        byte[] encryptByte = new byte[sm3.getDigestSize()];
        sm3.doFinal(encryptByte, 0);
        return encryptByte;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

