/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.geoway.landteam.landcloud.service.util.Txt2Geo;
import com.geoway.landteam.landcloud.service.util.ZipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ShapeFile2Geo {
    String uploadDir;
    private String crsSourceCode = "EPSG:4524";
    private String crsSourceWkt = "";
    BigDecimal area = new BigDecimal(0);

    public String getCrsSourceCode() {
        return this.crsSourceCode;
    }

    public void setCrsSourceCode(String crsSourceCode) {
        this.crsSourceCode = crsSourceCode;
    }

    public BigDecimal getArea() {
        return this.area;
    }

    public ShapeFile2Geo(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public Map<String, Object> parsingShapeFile(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator iter = multiRequest.getFileNames();
                while (iter.hasNext()) {
                    Geometry geometry = null;
                    String key = (String)iter.next();
                    MultipartFile shapeFile = multiRequest.getFile(key);
                    if (shapeFile == null) continue;
                    String fileName = shapeFile.getOriginalFilename();
                    if (fileName.endsWith(".zip")) {
                        geometry = this.shapeFile(shapeFile, key);
                    } else if (fileName.endsWith(".txt")) {
                        File txtFile = this.getFileFromMultipartFile(shapeFile, ".txt");
                        Txt2Geo txt2Geo = new Txt2Geo();
                        geometry = txt2Geo.readTxtFile(txtFile);
                        if ("file".equals(key) || "bound".equals(key)) {
                            this.area = txt2Geo.getArea();
                        }
                    }
                    if ("file".equalsIgnoreCase(key)) {
                        result.put("message", "\u8fb9\u754c\u6570\u636e\u6587\u4ef6 " + fileName + " \u4e0a\u4f20\u6210\u529f");
                    }
                    result.put(key, geometry);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("message", "\u8fb9\u754c\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            this.area = new BigDecimal(0);
        }
        return result;
    }

    public Geometry shapeFile(MultipartFile shapeFile, String key) throws Exception {
        List<String> dbfFileList;
        String wkt;
        Object shpFile = null;
        File zipFile = this.getFileFromMultipartFile(shapeFile, ".zip");
        File[] files = ZipUtils.unZip(zipFile, this.uploadDir);
        if (files == null) {
            return null;
        }
        List<Geometry> geoms = null;
        List<Map> fields = null;
        String zipDirFileName = this.uploadDir + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
        File zipDirFile = new File(zipDirFileName);
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
        ShapefileDataStore shpDataStore = new ShapefileDataStore(new File(shpFileList.get(0)).toURI().toURL());
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        this.crsSourceWkt = wkt = sourceCRS.toWKT();
        ShapeOprate shapeOprate = new ShapeOprate();
        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp(shpFileList.get(0));
        }
        if ((dbfFileList = FileUtil.findFiles(zipDirFileName, "*.dbf")) != null && dbfFileList.size() > 0) {
            fields = shapeOprate.readDBF(dbfFileList.get(0));
        }
        FileUtil.deleteFileAndDir(zipDirFile);
        GeometryFactory factory = new GeometryFactory();
        List<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < geoms.size(); ++i) {
            CoordinateSystem coordinateSystem = sourceCRS.getCoordinateSystem();
            Set identifiers1 = sourceCRS.getIdentifiers();
            Set identifiers = coordinateSystem.getIdentifiers();
            Iterator iterator = identifiers.iterator();
            Map<String, String> crsDataMap = StrUtil.splitCrsData(coordinateSystem.toString().toLowerCase());
            String crsId = StrUtil.getCrsId(crsDataMap).toString();
            this.crsSourceCode = "EPSG:" + crsId;
            if (!"4490".equals(crsId)) {
                if ("file".equals(key) || "bound".equals(key)) {
                    this.area = this.area.add(new BigDecimal(geoms.get(i).getArea()));
                }
                polygons = this.getPolygon(polygons, geoms.get(i), true, factory);
                continue;
            }
            if ("file".equals(key) || "bound".equals(key)) {
                this.area = this.area.add(new BigDecimal(this.projectTransform2(geoms.get(i)).getArea()));
            }
            polygons = this.getPolygon(polygons, geoms.get(i), false, factory);
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private List<Polygon> getPolygon(List<Polygon> polygons, Geometry geometry, boolean transform, GeometryFactory factory) throws Exception {
        if ("MultiPolygon".equals(geometry.getGeometryType()) && geometry.getNumGeometries() > 0) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                polygons = this.getPolygon(polygons, geometry.getGeometryN(i), transform, factory);
            }
        } else if ("Polygon".equals(geometry.getGeometryType())) {
            if (transform) {
                polygons.add((Polygon)GeoUtils.geoTransform(geometry, this.crsSourceWkt, "EPSG:4490"));
            } else {
                polygons.add((Polygon)geometry);
            }
        }
        return polygons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public Geometry projectTransform2(Geometry geometry) throws FactoryException, MismatchedDimensionException, TransformException {
        CoordinateReferenceSystem crsSource = CRS.decode((String)"EPSG:4490");
        CoordinateReferenceSystem crsTarget = CRS.decode((String)this.getEPSG(geometry));
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crsSource, (CoordinateReferenceSystem)crsTarget);
        geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
        return geometry;
    }

    public static Point createPoint(double longitude, double latitude) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(longitude, latitude);
        Point point = gf.createPoint(coord);
        return point;
    }

    public String getEPSG(Geometry geometry) {
        int srid = 4524;
        try {
            double x = geometry.getCentroid().getX();
            int dh = (int)((x + 1.5) / 3.0);
            srid = 4513 + dh - 25;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "EPSG:" + srid;
    }
}

