/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.util.geometry.GeometryUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.service.util.ShpObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShpUtil {
    public static Map<String, String> getShpToTableColumns(ShapefileDataStore shpDataStore) throws IOException {
        String[] typeNames = shpDataStore.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType featureType = shpDataStore.getSchema(typeName);
        String shapeField = featureType.getGeometryDescriptor().getLocalName();
        List ads = featureType.getAttributeDescriptors();
        List fieldNames = ads.stream().map(descriptor -> descriptor.getLocalName()).collect(Collectors.toList());
        HashMap<String, String> mapFields = new HashMap<String, String>();
        for (String f : fieldNames) {
            if (f.equals(shapeField)) {
                mapFields.put("f_shape", "public.geometry NOT NULL");
                continue;
            }
            mapFields.put(f, "varchar(100) NULL");
        }
        return mapFields;
    }

    public static Map<String, Object> getFromSimpleFeature(SimpleFeature sf, List<String> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Geometry geo = (Geometry)sf.getDefaultGeometry();
        geo.setSRID(4490);
        for (String f : fields) {
            if (f.equals("f_shape")) continue;
            map.put(f, sf.getAttribute(f));
        }
        map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
        return map;
    }

    public static Map<String, Object> getFromSimpleFeatureWithoutShape(SimpleFeature sf, List<String> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String f : fields) {
            if (f.equals("f_shape")) continue;
            map.put(f, sf.getAttribute(f));
        }
        return map;
    }

    public static void writeShape(String shpPath, String encode, String geoType, String shpKey, List<String> attrKeys, List<Map<String, Object>> data, int consumerCount, Consumer<Integer> consumer) throws Exception {
        if (data == null || data.size() == 0) {
            return;
        }
        HashMap<String, URL> params = null;
        ShapefileDataStore ds = null;
        FeatureWriter writer = null;
        SimpleFeatureTypeBuilder tb = null;
        SimpleFeature feature = null;
        Map<String, Object> row = null;
        Geometry geom = null;
        WKTReader wktReader = new WKTReader();
        try {
            File file = new File(shpPath);
            params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            tb = new SimpleFeatureTypeBuilder();
            String coorWkt = "GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]";
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)coorWkt);
            tb.setCRS(coordinateReferenceSystem);
            tb.setDefaultGeometry("the_geom");
            tb.setName("shapefile");
            tb = GeometryUtil.createType((SimpleFeatureTypeBuilder)tb, (String)geoType);
            for (String field : attrKeys) {
                tb.add(field, String.class);
            }
            ds.createSchema(tb.buildFeatureType());
            Charset charset = Charset.forName(encode);
            ds.setCharset(charset);
            writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            for (int i = 0; i < data.size(); ++i) {
                feature = (SimpleFeature)writer.next();
                row = data.get(i);
                String wkt = row.get(shpKey).toString();
                geom = wktReader.read(wkt);
                feature.setAttribute("the_geom", (Object)geom);
                for (String key : row.keySet()) {
                    if (key.equals(shpKey)) continue;
                    if (row.get(key) != null && StringUtils.isNotBlank((CharSequence)row.get(key).toString())) {
                        if (key.length() >= 10) {
                            feature.setAttribute(key.substring(0, 10), (Object)row.get(key).toString());
                            continue;
                        }
                        feature.setAttribute(key, (Object)row.get(key).toString());
                        continue;
                    }
                    if (key.length() >= 10) {
                        feature.setAttribute(key.substring(0, 10), (Object)"");
                        continue;
                    }
                    feature.setAttribute(key, (Object)"");
                }
                if (i % consumerCount != 0) continue;
                consumer.accept(i);
            }
            writer.write();
            writer.close();
            ds.dispose();
            consumer.accept(data.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (params != null) {
                params = null;
            }
            if (tb != null) {
                tb = null;
            }
            if (feature != null) {
                feature = null;
            }
            if (row != null) {
                row = null;
            }
            if (geom != null) {
                geom = null;
            }
            if (ds != null) {
                ds.dispose();
                ds = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    public static ShpObject createShape(String shpPath, String encode, String geoType, String shpKey, List<String> attrKeys) throws Exception {
        ShpObject shpObject = new ShpObject();
        HashMap<String, URL> params = null;
        ShapefileDataStore ds = null;
        SimpleFeatureTypeBuilder tb = null;
        try {
            File file = new File(shpPath);
            params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            tb = new SimpleFeatureTypeBuilder();
            String coorWkt = "GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]";
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)coorWkt);
            tb.setCRS(coordinateReferenceSystem);
            tb.setDefaultGeometry(shpKey);
            tb.setName("the_geom");
            tb = GeometryUtil.createType((SimpleFeatureTypeBuilder)tb, (String)geoType);
            for (String field : attrKeys) {
                tb.add(field, String.class);
            }
            Charset charset = Charset.forName(encode);
            ds.setCharset(charset);
            ds.createSchema(tb.buildFeatureType());
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            shpObject.setDataStore(ds);
            shpObject.setWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer);
            ShpObject shpObject2 = shpObject;
            return shpObject2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (params != null) {
                params = null;
            }
            if (tb != null) {
                tb = null;
            }
        }
    }

    public static void appendShape(ShpObject shpObject, String shpKey, List<Map<String, Object>> data, List<String> fields, int consumerCount, Consumer<Integer> consumer) throws Exception {
        if (data == null || data.size() == 0) {
            return;
        }
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = shpObject.getWriter();
        SimpleFeature feature = null;
        Map<String, Object> row = null;
        Geometry geom = null;
        WKTReader wktReader = new WKTReader();
        try {
            for (int i = 0; i < data.size(); ++i) {
                feature = (SimpleFeature)writer.next();
                row = data.get(i);
                String wkt = row.get(shpKey).toString();
                geom = wktReader.read(wkt);
                feature.setAttribute("the_geom", (Object)geom);
                for (String key : row.keySet()) {
                    if (!fields.contains(key) || key.equals(shpKey)) continue;
                    if (row.get(key) != null && StringUtils.isNotBlank((CharSequence)row.get(key).toString())) {
                        if (key.length() >= 10) {
                            feature.setAttribute(key.substring(0, 10), (Object)row.get(key).toString());
                            continue;
                        }
                        feature.setAttribute(key, (Object)row.get(key).toString());
                        continue;
                    }
                    if (key.length() >= 10) {
                        feature.setAttribute(key.substring(0, 10), (Object)"");
                        continue;
                    }
                    feature.setAttribute(key, (Object)"");
                }
                if (i % consumerCount != 0) continue;
                consumer.accept(i);
            }
            consumer.accept(data.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (feature != null) {
                feature = null;
            }
            if (row != null) {
                row = null;
            }
            if (geom != null) {
                geom = null;
            }
        }
    }

    public static void dispose(ShpObject shpObject) throws IOException {
        shpObject.getWriter().write();
        shpObject.getWriter().close();
        shpObject.getDataStore().dispose();
    }
}

