/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static GiLoger logger = GwLoger.getLoger(SpringContextHolder.class);
    private static ApplicationContext applicationContext = null;
    private static HashMap mapContainer = new HashMap();

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        logger.debug("\u4eceSpringContextHolder\u4e2d\u53d6\u51faBean:" + name, new Object[0]);
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static void clearHolder() {
        logger.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext, new Object[0]);
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (SpringContextHolder.applicationContext != null) {
            logger.warn("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext, new Object[0]);
        }
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.");
        }
    }

    public static Object getAttribute(String key) {
        return mapContainer.get(key);
    }

    public static void setAttribute(String key, Object obj) {
        if (StringUtils.isBlank((CharSequence)key)) {
            mapContainer.put(key, obj);
        }
    }
}

