/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;

public class TimeUtils {
    public static final String Y = "yyyy-01-01";
    public static final String YM = "yyyy-MM-01";
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMD_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String YMD_H = "yyyy-MM-dd HH";
    public static final String YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_HMS_ZORE = "yyyy-MM-dd 00:00:00";
    public static final String YMD_HMS_ZORE_ZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";

    public static String dateToString(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat();
        String ymd = "";
        try {
            simpleDateFormat1.applyPattern(pattern);
            ymd = simpleDateFormat1.format(date);
        }
        catch (Exception e) {
            return "";
        }
        return ymd;
    }

    public static Date StringToDate(String dateStr, String pattern) {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat();
        Date date = null;
        try {
            simpleDateFormat2.applyPattern(pattern);
            date = simpleDateFormat2.parse(dateStr);
        }
        catch (ParseException e) {
            if (e instanceof ParseException && (YMD_HMS.equals(pattern) || YMD_HMS_ZORE.equals(pattern))) {
                try {
                    simpleDateFormat2.applyPattern(YMD);
                    date = simpleDateFormat2.parse(dateStr);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date adapterConvert(String dateStr) {
        Date date;
        block7: {
            SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat();
            date = null;
            try {
                simpleDateFormat3.applyPattern(YMD_HMS);
                date = simpleDateFormat3.parse(dateStr);
            }
            catch (ParseException ex) {
                if (!(ex instanceof ParseException)) break block7;
                try {
                    simpleDateFormat3.applyPattern(YMD_HMS_ZORE);
                    date = simpleDateFormat3.parse(dateStr);
                }
                catch (ParseException ex1) {
                    if (!(ex1 instanceof ParseException)) break block7;
                    try {
                        simpleDateFormat3.applyPattern(YMD);
                        date = simpleDateFormat3.parse(dateStr);
                    }
                    catch (ParseException parseException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date getTodayDate(int day) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, day);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        Date todayOfDate = cal.getTime();
        return todayOfDate;
    }

    public static Pair<Date, Date> getNearOneWeek() {
        Calendar.getInstance().getFirstDayOfWeek();
        Date startDate = null;
        Date endDate = null;
        int dayNumberOfWeek = Calendar.getInstance().get(7);
        if (dayNumberOfWeek == 2) {
            endDate = TimeUtils.getTodayDate(0);
            startDate = TimeUtils.getTodayDate(-7);
        } else {
            endDate = TimeUtils.getTodayDate(0);
            startDate = TimeUtils.getTodayDate(2 - dayNumberOfWeek);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Pair<Date, Date> getDayBefore(int n) {
        Date endDate = TimeUtils.getTodayDate(0);
        Date startDate = TimeUtils.getTodayDate(-n);
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Date getNowWeekStartTime() {
        Date startDate = null;
        int dayNumberOfWeek = Calendar.getInstance().get(7);
        startDate = dayNumberOfWeek == 2 ? TimeUtils.getTodayDate(0) : TimeUtils.getTodayDate(2 - dayNumberOfWeek);
        return startDate;
    }

    public static Pair<Date, Date> getNearOneMonth() {
        Date startDate = null;
        Date endDate = null;
        int i = Calendar.getInstance().get(5);
        if (i == 1) {
            startDate = TimeUtils.getLastMonthStartTime(-1);
            endDate = TimeUtils.getTodayDate(0);
        } else {
            startDate = TimeUtils.getTodayDate(1 - i);
            endDate = TimeUtils.getTodayDate(0);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Pair<Date, Date> getNearThreeMonth() {
        Date startDate = null;
        Date endDate = null;
        int i = Calendar.getInstance().get(5);
        if (i == 1) {
            startDate = TimeUtils.getLastMonthStartTime(-3);
            endDate = TimeUtils.getTodayDate(0);
        } else {
            startDate = TimeUtils.getLastMonthStartTime(-2);
            endDate = TimeUtils.getTodayDate(0);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Date getLastMonthStartTime(int i) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, i);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastMonthEndTime(int i) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, i);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Pair<String, String> getLastNatureWeek() {
        Calendar c = Calendar.getInstance();
        c.set(7, 2);
        Date endTime = c.getTime();
        c.add(5, -7);
        Date startTime = c.getTime();
        return Pair.of((Object)TimeUtils.dateToString(startTime, YMD_HMS_ZORE), (Object)TimeUtils.dateToString(endTime, YMD_HMS_ZORE));
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static List<Date> getOneDayDayListBetween(Date startDate, Date endDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        ArrayList<Date> list = new ArrayList<Date>();
        list.add(instance.getTime());
        while (!instance.getTime().toString().equals(endDate.toString())) {
            instance.add(5, 1);
            list.add(instance.getTime());
        }
        return list;
    }

    public static List<Pair<String, String>> getLastNatureWeekList(int i, String applyType) {
        ArrayList<String> timeList = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        c.set(7, 2);
        Date endTime = c.getTime();
        String s = TimeUtils.dateToString(endTime, applyType);
        timeList.add(s);
        for (int j = 1; j <= i; ++j) {
            c.add(5, -7);
            Date time = c.getTime();
            String s1 = TimeUtils.dateToString(time, applyType);
            timeList.add(s1);
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        Collections.reverse(timeList);
        for (int i1 = 0; i1 < timeList.size() - 1; ++i1) {
            pairs.add((Pair<String, String>)Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    public static Pair<Date, Date> getNearOneYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        if (month == 1 && day == 1) {
            Timestamp beginTime = Timestamp.valueOf(LocalDateTime.of(year - 1, 1, 1, 0, 0, 1));
            Timestamp endTime = Timestamp.valueOf(LocalDateTime.of(year - 1, 12, 31, 23, 59, 59));
            Date startDate = new Date(beginTime.getTime());
            Date endDate = new Date(endTime.getTime());
            return Pair.of((Object)startDate, (Object)endDate);
        }
        Timestamp beginTime = Timestamp.valueOf(LocalDateTime.of(year, 1, 1, 0, 0, 1));
        Date startDate = new Date(beginTime.getTime());
        Date endDate = TimeUtils.getTodayDate(0);
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Pair<String, String> getNearWeekByDate(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        Date startDate = cal.getTime();
        cal.add(5, 6);
        Date endDate = cal.getTime();
        return Pair.of((Object)TimeUtils.dateToString(startDate, YMD), (Object)TimeUtils.dateToString(endDate, YMD));
    }

    public static List<Pair<String, String>> getNearWeekList(int i, String applyType) {
        List<Object> lastNatureWeekList = new ArrayList();
        Calendar cal = Calendar.getInstance();
        int weekday = cal.get(7);
        if (weekday == 2) {
            lastNatureWeekList = TimeUtils.getLastNatureWeekList(i, applyType);
        } else if (i == 1) {
            Pair<Date, Date> nearOneWeek = TimeUtils.getNearOneWeek();
            lastNatureWeekList.add((Pair<String, String>)Pair.of((Object)TimeUtils.dateToString((Date)nearOneWeek.getLeft(), YMD), (Object)TimeUtils.dateToString((Date)nearOneWeek.getRight(), YMD)));
        } else {
            lastNatureWeekList = TimeUtils.getLastNatureWeekList(i - 1, applyType);
            Pair of = Pair.of((Object)((Pair)lastNatureWeekList.get(lastNatureWeekList.size() - 1)).getRight(), (Object)TimeUtils.dateToString(new Date(), applyType));
            lastNatureWeekList.add(of);
        }
        return lastNatureWeekList;
    }

    public static List<Pair<String, String>> getNearMonthList(int i, String applyType) {
        Date time;
        int j;
        ArrayList<String> timeList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        int dayOfMonth = cal.get(5);
        if (dayOfMonth == 1) {
            for (j = i; j >= 1; --j) {
                cal.add(2, -1);
                time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
        } else {
            for (j = i - 1; j >= 1; --j) {
                cal.add(2, -1);
                time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
            timeList.add(TimeUtils.dateToString(new Date(), YMD));
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (int i1 = 0; i1 < timeList.size() - 1; ++i1) {
            pairs.add((Pair<String, String>)Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    public static List<Pair<String, String>> getNearYearList(int i, String applyType) {
        Date time;
        int j;
        ArrayList<String> timeList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        int monthOfYear = cal.get(2);
        int dayOfMonth = cal.get(5);
        if (dayOfMonth == 1 && monthOfYear == 1) {
            for (j = i; j >= 1; --j) {
                cal.add(1, -1);
                time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
        } else {
            for (j = i - 1; j >= 1; --j) {
                cal.add(1, -1);
                time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
            timeList.add(TimeUtils.dateToString(new Date(), YMD));
        }
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (int i1 = 0; i1 < timeList.size() - 1; ++i1) {
            pairs.add((Pair<String, String>)Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    public static Pair<Date, Date> getCompleteTimePeroid(Date date, String type) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        int year = instance.get(1);
        int month = instance.get(2);
        Date startDate = null;
        Date endDate = null;
        switch (type) {
            case "year": {
                instance.set(year, 0, 1);
                startDate = instance.getTime();
                instance.set(year, 11, 31);
                endDate = instance.getTime();
                break;
            }
            case "month": {
                instance.set(year, month, 1);
                startDate = instance.getTime();
                int maximum = instance.getActualMaximum(5);
                instance.set(year, month, maximum);
                endDate = instance.getTime();
                break;
            }
            case "week": {
                int dayOfWeek = instance.get(7);
                if (dayOfWeek == 1) {
                    endDate = instance.getTime();
                    instance.add(5, -6);
                    startDate = instance.getTime();
                    break;
                }
                instance.add(5, 2 - dayOfWeek);
                startDate = instance.getTime();
                instance.add(5, 6);
                endDate = instance.getTime();
                break;
            }
        }
        return Pair.of(startDate, endDate);
    }

    public static List<Pair<String, String>> getLastNatureWeekListFromTime(Date startTime) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        Calendar instance = Calendar.getInstance();
        for (int i = 1; i <= 5; ++i) {
            instance.setTime(startTime);
            instance.add(6, -7 * (i - 1));
            Date time = instance.getTime();
            Pair<String, String> nearWeekByDate = TimeUtils.getNearWeekByDate(time);
            list.add(nearWeekByDate);
        }
        Collections.reverse(list);
        return list;
    }

    public static Pair<Date, Date> getCompleteWeekByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        Date startDate = cal.getTime();
        cal.add(5, 7);
        Date endDate = cal.getTime();
        return Pair.of((Object)TimeUtils.StringToDate(TimeUtils.dateToString(startDate, YMD_HMS_ZORE), YMD_HMS_ZORE), (Object)TimeUtils.StringToDate(TimeUtils.dateToString(endDate, YMD_HMS_ZORE), YMD_HMS_ZORE));
    }

    public static long getDifferDays(Date startDate, Date endDate) throws Exception {
        long endTime;
        long startTime = startDate.getTime();
        if (startTime > (endTime = endDate.getTime())) {
            throw new Exception("\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u6bd4\u7ed3\u675f\u65e5\u671f\u5927");
        }
        double days = (double)(endTime - startTime) * 1.0 / 24.0 / 60.0 / 60.0 / 1000.0;
        double ceil = Math.ceil(days);
        return (long)ceil;
    }

    public static void main(String[] args) throws Exception {
        TimeUtils.convertDateAndTimeFromOther("1710916575824");
        Pair<Date, Date> huanBiDate = TimeUtils.getHuanBiDate("2023-10-09 00:00:00", "2023-10-15 00:00:00");
        System.out.println(huanBiDate);
        long differDays = TimeUtils.getDifferDays(TimeUtils.StringToDate("2023-10-10 00:00:00", YMD_HMS), TimeUtils.StringToDate("2023-10-15 00:00:00", YMD_HMS));
        System.out.println(differDays);
        Pair<Date, Date> completeWeekByDate = TimeUtils.getCompleteWeekByDate(TimeUtils.StringToDate("2023-10-15 23:59:59", YMD_HMS));
        System.out.println(completeWeekByDate);
        Date date = TimeUtils.StringToDate("2023-06-11T16:00:00.000Z", "yyyy-MM-ddTHH:mm:ssZ");
        System.out.println("---------------");
        Pair<String, String> nearWeekByDate1 = TimeUtils.getNearWeekByDate(TimeUtils.StringToDate("2023-03-12 23:59:59", YMD_HMS));
        List<Pair<String, String>> lastNatureWeekListFromTime = TimeUtils.getLastNatureWeekListFromTime(TimeUtils.StringToDate("2022-11-11 00:00:00", YMD_HMS_ZORE));
        Pair<Date, Date> completeTimePeroid = TimeUtils.getCompleteTimePeroid(TimeUtils.StringToDate("2021-2-7 00:00:00", YMD_HMS), "week");
        Pair<String, String> nearWeekByDate = TimeUtils.getNearWeekByDate(new Date());
        List<Pair<String, String>> nearYearList = TimeUtils.getNearYearList(4, Y);
        List<Pair<String, String>> nearMonthList = TimeUtils.getNearMonthList(4, YM);
        List<Pair<String, String>> nearWeekList = TimeUtils.getNearWeekList(4, YMD);
        Pair<Date, Date> nearOneYear = TimeUtils.getNearOneYear();
        TimeUtils.getNearOneWeek();
        TimeUtils.getNearOneMonth();
        TimeUtils.getNearThreeMonth();
        List<Pair<String, String>> lastNatureWeekList = TimeUtils.getLastNatureWeekList(3, YMD);
        System.out.println("--------------------");
        System.out.println(TimeUtils.getLastNatureWeek());
        String startTime = "2022-06-01 00:00:00";
        String endTime = "2022-08-31 00:00:00";
        TimeUtils.getOneDayDayListBetween(TimeUtils.StringToDate(startTime, YMD_HMS_ZORE), TimeUtils.StringToDate(endTime, YMD_HMS_ZORE));
    }

    public static Pair<Date, Date> getHuanBiDate(String startTime, String endTime) throws Exception {
        Date startDate = TimeUtils.StringToDate(startTime, YMD_HMS);
        Date endDate = TimeUtils.StringToDate(endTime, YMD_HMS);
        int differDays = (int)TimeUtils.getDifferDays(startDate, endDate);
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        instance.add(5, -differDays);
        Date resStartDate = instance.getTime();
        instance.setTime(endDate);
        instance.add(5, -differDays);
        Date resEndDate = instance.getTime();
        return Pair.of((Object)resStartDate, (Object)resEndDate);
    }

    public static String convertDateAndTimeFromOther(String time) {
        try {
            long l = Long.parseLong(time);
            if (time.length() == 10) {
                l *= 1000L;
            }
            Date date = new Date(l);
            return TimeUtils.dateToString(date, YMD_HMS);
        }
        catch (NumberFormatException e) {
            return time;
        }
    }
}

