/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Txt2Geo {
    private Map<String, String> attribute;
    private BigDecimal area = new BigDecimal(0);
    private List<List<Double[]>> points = new ArrayList<List<Double[]>>();
    private List<List<String[]>> points2 = new ArrayList<List<String[]>>();
    private Geometry geometry = null;
    private String crsSourceCode;
    private String crsTargetCode = "EPSG:4490";

    public String getCrsSourceCode() {
        return this.crsSourceCode;
    }

    public void setCrsSourceCode(String crsSourceCode) {
        this.crsSourceCode = crsSourceCode;
    }

    public BigDecimal getArea() {
        return this.area;
    }

    public Txt2Geo() {
        this.attribute = new HashMap<String, String>();
    }

    public Geometry readTxtFile(File file) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
        String lineTxt = null;
        String startKey = "";
        int readStartKey = 0;
        int i = -1;
        boolean flag = false;
        boolean flag2 = false;
        while ((lineTxt = br.readLine()) != null) {
            if (readStartKey == 1) {
                startKey = lineTxt.split(",")[0] + ",";
                readStartKey = 2;
            }
            if (readStartKey != 0 && lineTxt.contains(startKey)) {
                if (!flag2) {
                    ++i;
                    ArrayList list = new ArrayList();
                    ArrayList list2 = new ArrayList();
                    this.points.add(list);
                    this.points2.add(list2);
                } else {
                    this.readLineTxt(lineTxt, i);
                }
                boolean bl = flag2 = !flag2;
            }
            if (!flag && lineTxt.contains("=")) {
                String[] arr = lineTxt.split("=");
                String key = "";
                String value = "";
                if (arr.length > 1) {
                    key = arr[0];
                    value = arr[1];
                    this.attribute.put(key, value);
                }
            } else if (flag && flag2 && !lineTxt.contains("@")) {
                this.readLineTxt(lineTxt, i);
            }
            if (!lineTxt.contains("@")) continue;
            flag = true;
            if (readStartKey != 0) continue;
            readStartKey = 1;
        }
        br.close();
        String wkt = this.getWkt(this.points);
        String wkt2 = this.getWkt2(this.points2);
        this.geometry = this.wktToGeometry(wkt);
        Geometry geometry = this.wktToGeometry(wkt2);
        this.area = new BigDecimal(geometry.getArea()).setScale(4, 4);
        return this.geometry;
    }

    public void readLineTxt(String lineTxt, int i) throws Exception {
        String a = lineTxt.split(",")[2];
        String b = lineTxt.split(",")[3];
        Point point = (Point)this.projectTransform((Geometry)this.createPoint(Double.parseDouble(b), Double.parseDouble(a)));
        Double[] arr = new Double[]{point.getX(), point.getY()};
        String[] arr2 = new String[]{a, b};
        this.points.get(i).add(arr);
        this.points2.get(i).add(arr2);
    }

    public Geometry projectTransform(Geometry geometry) throws FactoryException, MismatchedDimensionException, TransformException {
        this.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsSource = CRS.decode((String)this.crsSourceCode);
        CoordinateReferenceSystem crsTarget = CRS.decode((String)this.crsTargetCode);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crsSource, (CoordinateReferenceSystem)crsTarget);
        geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
        return geometry;
    }

    private void getCoordinateReferenceSystem() {
        Integer zoning = Integer.parseInt(this.attribute.get("\u51e0\u5ea6\u5206\u5e26"));
        Integer zoningNum = Integer.parseInt(this.attribute.get("\u5e26\u53f7"));
        String crs = this.attribute.get("\u5750\u6807\u7cfb");
        Integer crsId = null;
        if (zoning == 3 && "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb".equals(crs)) {
            crsId = 4513 + zoningNum - 25;
        }
        this.crsSourceCode = "EPSG:" + String.valueOf(crsId);
    }

    public Point createPoint(double longitude, double latitude) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(longitude, latitude);
        Point point = gf.createPoint(coord);
        return point;
    }

    private Geometry wktToGeometry(String wktString) {
        StringBuffer sbBuffer = new StringBuffer();
        WKTReader fromText = new WKTReader();
        String wkt = sbBuffer.append(wktString).toString();
        Geometry geom = null;
        try {
            geom = fromText.read(wkt);
            geom.setSRID(4490);
        }
        catch (Exception e) {
            throw new RuntimeException("Not a WKT string:" + wktString);
        }
        return geom;
    }

    private String getWkt(List<List<Double[]>> points) {
        String wkt = "MULTIPOLYGON (";
        boolean flag = true;
        for (List<Double[]> list : points) {
            wkt = wkt + "((";
            for (Double[] arr : list) {
                wkt = wkt + arr[0] + " " + arr[1] + ",";
            }
            wkt = wkt.substring(0, wkt.lastIndexOf(","));
            wkt = wkt + ")),";
        }
        wkt = wkt.substring(0, wkt.lastIndexOf(","));
        wkt = wkt + ")";
        return wkt;
    }

    private String getWkt2(List<List<String[]>> points) {
        String wkt = "MULTIPOLYGON (";
        boolean flag = true;
        for (List<String[]> list : points) {
            wkt = wkt + "((";
            for (String[] arr : list) {
                wkt = wkt + arr[0] + " " + arr[1] + ",";
            }
            wkt = wkt.substring(0, wkt.lastIndexOf(","));
            wkt = wkt + ")),";
        }
        wkt = wkt.substring(0, wkt.lastIndexOf(","));
        wkt = wkt + ")";
        return wkt;
    }
}

