/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class UserRedisSessionUtil {
    public static final Long USERNAME_LOCK_OUTTIME = 600L;

    public static Boolean checkUserNameLock(RedisTemplate redisTemplate, String userName) {
        Boolean tag = false;
        String key = "UserName" + userName;
        if (redisTemplate.hasKey((Object)key).booleanValue()) {
            Long num = redisTemplate.opsForSet().size((Object)key);
            if (num >= 4L) {
                tag = true;
            } else {
                num = num + 1L;
                redisTemplate.opsForSet().add((Object)key, new Object[]{num.toString()});
            }
        } else {
            redisTemplate.opsForSet().add((Object)key, new Object[]{"1"});
            redisTemplate.expire((Object)key, USERNAME_LOCK_OUTTIME.longValue(), TimeUnit.SECONDS);
        }
        return tag;
    }

    public static void removeUserNameLock(RedisTemplate redisTemplate, String userName) {
        String key = "UserName" + userName;
        if (redisTemplate.hasKey((Object)key).booleanValue()) {
            redisTemplate.delete((Object)key);
        }
    }

    public static Long getUserNameLockNum(RedisTemplate redisTemplate, String userName) {
        Long num = 0L;
        String key = "UserName" + userName;
        if (redisTemplate.hasKey((Object)key).booleanValue()) {
            num = redisTemplate.opsForSet().size((Object)key);
        }
        return num;
    }
}

