/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.unzip.UnzipUtil;
import org.apache.commons.lang3.StringUtils;

public class Zip4jUtils {
    private static final int CACHE_SIZE = 1024;

    public static void unzip(String zipFilePath, String dest, String passwd) throws Exception {
        ZipFile zFile = new ZipFile(zipFilePath);
        String encoding = Zip4jUtils.getEncoding(zipFilePath);
        zFile.setFileNameCharset(encoding);
        if (zFile.isEncrypted()) {
            zFile.setPassword(passwd.toCharArray());
        }
        List fileHeaderList = zFile.getFileHeaders();
        for (FileHeader fileHeader : fileHeaderList) {
            if (fileHeader != null) {
                String name = fileHeader.getFileName();
                if (name.contains("/")) {
                    name = name.substring(name.lastIndexOf("/") + 1);
                }
                String outFilePath = dest + File.separator + name;
                File outFile = new File(outFilePath);
                if (fileHeader.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                File parentDir = outFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                ZipInputStream is = zFile.getInputStream(fileHeader);
                FileOutputStream os = new FileOutputStream(outFile);
                int readLen = -1;
                byte[] buff = new byte[1024];
                while ((readLen = is.read(buff)) != -1) {
                    ((OutputStream)os).write(buff, 0, readLen);
                }
                ((OutputStream)os).close();
                os = null;
                is.close();
                is = null;
                UnzipUtil.applyFileAttributes((FileHeader)fileHeader, (File)outFile);
                System.out.println("Done extracting: " + fileHeader.getFileName());
                continue;
            }
            System.err.println("fileheader is null. Shouldn't be here");
        }
    }

    public static String zip(String src) {
        return Zip4jUtils.zip(src, null);
    }

    public static String zip(String src, String passwd) {
        return Zip4jUtils.zip(src, null, passwd);
    }

    public static String zip(String src, String dest, String passwd) {
        return Zip4jUtils.zip(src, dest, true, passwd);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd) {
        File srcFile = new File(src);
        dest = Zip4jUtils.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!StringUtils.isEmpty((CharSequence)passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        if (StringUtils.isEmpty((CharSequence)destParam)) {
            if (srcFile.isDirectory()) {
                destParam = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = srcFile.getParent() + File.separator + fileName + ".zip";
            }
        } else {
            Zip4jUtils.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    private static String getEncoding(String path) throws Exception {
        String encoding = "GBK";
        ZipFile zipFile = new ZipFile(path);
        zipFile.setFileNameCharset(encoding);
        List list = zipFile.getFileHeaders();
        for (int i = 0; i < list.size(); ++i) {
            FileHeader fileHeader = (FileHeader)list.get(i);
            String fileName = fileHeader.getFileName();
            if (!Zip4jUtils.isMessyCode(fileName)) continue;
            encoding = "UTF-8";
            break;
        }
        return encoding;
    }

    private static boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\ufffd') continue;
            return true;
        }
        return false;
    }
}

