/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    private static final String CHINESE_CHARSET = "GBK";
    private static final int CACHE_SIZE = 1024;

    public static void zip(String sourceFolder, String zipFilePath) throws Exception {
        FileOutputStream out = new FileOutputStream(zipFilePath);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)bos);
        zos.setEncoding(CHINESE_CHARSET);
        File file = new File(sourceFolder);
        String basePath = null;
        basePath = file.isDirectory() ? file.getPath() : file.getParent();
        ZipUtils.zipFile(file, basePath, zos);
        zos.closeEntry();
        zos.close();
        bos.close();
        ((OutputStream)out).close();
    }

    private static void zipFile(File parentFile, String basePath, ZipOutputStream zos) throws Exception {
        File[] files = new File[]{};
        files = parentFile.isDirectory() ? parentFile.listFiles() : new File[]{parentFile};
        byte[] cache = new byte[1024];
        for (File file : files) {
            String pathName;
            if (file.isDirectory()) {
                pathName = file.getPath().substring(basePath.length() + 1) + "/";
                zos.putNextEntry(new ZipEntry(pathName));
                ZipUtils.zipFile(file, basePath, zos);
                continue;
            }
            pathName = file.getPath().substring(basePath.length() + 1);
            FileInputStream is = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(is);
            zos.putNextEntry(new ZipEntry(pathName));
            int nRead = 0;
            while ((nRead = bis.read(cache, 0, 1024)) != -1) {
                zos.write(cache, 0, nRead);
            }
            bis.close();
            ((InputStream)is).close();
        }
    }

    public static String getDirectoryName(String zipFilePath) throws Exception {
        String dirName = "";
        ZipFile zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
        Enumeration emu = zipFile.getEntries();
        while (emu.hasMoreElements()) {
            String name;
            ZipEntry entry = (ZipEntry)emu.nextElement();
            if (!entry.isDirectory() || !(name = entry.getName()).contains("/")) continue;
            dirName = name.substring(0, name.lastIndexOf("/"));
            break;
        }
        return dirName;
    }

    public static void unZip(String zipFilePath, String destDir) throws Exception {
        ZipFile zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
        Enumeration emu = zipFile.getEntries();
        byte[] cache = new byte[1024];
        while (emu.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)emu.nextElement();
            String name = entry.getName();
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            if (entry.isDirectory()) {
                new File(destDir + File.separator + name).mkdirs();
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = new File(destDir + File.separator + name);
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            int nRead = 0;
            while ((nRead = bis.read(cache, 0, 1024)) != -1) {
                fos.write(cache, 0, nRead);
            }
            bos.flush();
            bos.close();
            fos.close();
            bis.close();
        }
        zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File[] unZip(File zipFile, String parent) {
        File[] fileArray;
        ZipInputStream zis = null;
        FilterOutputStream bos = null;
        try {
            String folder = parent + File.separator + FilenameUtils.getBaseName((String)zipFile.getName());
            Charset gbk = Charset.forName(CHINESE_CHARSET);
            zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), gbk);
            java.util.zip.ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String target = folder + File.separator + entry.getName();
                File file = new File(target);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                bos = new BufferedOutputStream(new FileOutputStream(file));
                int read = 0;
                byte[] buffer = new byte[10240];
                while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                    ((BufferedOutputStream)bos).write(buffer, 0, read);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
            }
            zis.closeEntry();
            fileArray = new File(folder).listFiles();
            IOUtils.closeQuietly((InputStream)zis);
        }
        catch (Exception e) {
            File[] fileArray2 = null;
            return fileArray2;
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        zipFile.delete();
        return fileArray;
        finally {
            IOUtils.closeQuietly(zis);
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            zipFile.delete();
        }
    }
}

