/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.code;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64 {
    static final char[] charTab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String encode(byte[] data) {
        return Base64.encode(data, 0, data.length, null).toString();
    }

    public static StringBuffer encode(byte[] data, int start, int len, StringBuffer buf) {
        if (null != data && data.length != 0) {
            int d;
            int i;
            if (buf == null) {
                buf = new StringBuffer(data.length * 3 / 2);
            }
            int end = len - 3;
            int n = 0;
            for (i = start; i <= end; i += 3) {
                d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8 | data[i + 2] & 0xFF;
                buf.append(charTab[d >> 18 & 0x3F]);
                buf.append(charTab[d >> 12 & 0x3F]);
                buf.append(charTab[d >> 6 & 0x3F]);
                buf.append(charTab[d & 0x3F]);
                if (n++ < 14) continue;
                n = 0;
                buf.append("\r\n");
            }
            if (i == start + len - 2) {
                d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8;
                buf.append(charTab[d >> 18 & 0x3F]);
                buf.append(charTab[d >> 12 & 0x3F]);
                buf.append(charTab[d >> 6 & 0x3F]);
                buf.append("=");
            } else if (i == start + len - 1) {
                d = (data[i] & 0xFF) << 16;
                buf.append(charTab[d >> 18 & 0x3F]);
                buf.append(charTab[d >> 12 & 0x3F]);
                buf.append("==");
            }
            return buf;
        }
        return new StringBuffer();
    }

    static int decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 26 + 26;
        }
        switch (c) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
            case '=': {
                return 0;
            }
        }
        throw new RuntimeException("unexpected code: " + c);
    }

    public static byte[] decode(String s) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Base64.decode(s, bos);
        }
        catch (IOException var3) {
            throw new RuntimeException();
        }
        return bos.toByteArray();
    }

    public static void decode(String s, OutputStream os) throws IOException {
        int i = 0;
        int len = s.length();
        while (true) {
            if (i < len && s.charAt(i) <= ' ') {
                ++i;
                continue;
            }
            if (i == len) break;
            int tri = (Base64.decode(s.charAt(i)) << 18) + (Base64.decode(s.charAt(i + 1)) << 12) + (Base64.decode(s.charAt(i + 2)) << 6) + Base64.decode(s.charAt(i + 3));
            os.write(tri >> 16 & 0xFF);
            if (s.charAt(i + 2) == '=') break;
            os.write(tri >> 8 & 0xFF);
            if (s.charAt(i + 3) == '=') break;
            os.write(tri & 0xFF);
            i += 4;
        }
    }
}

