/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.code;

import com.geoway.landteam.landcloud.service.util.code.Cipher;
import com.geoway.landteam.landcloud.service.util.code.SM2;
import com.geoway.landteam.landcloud.service.util.code.SM2KeyVO;
import com.geoway.landteam.landcloud.service.util.code.Util;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2EncDecUtils {
    public static SM2KeyVO generateKeyPair() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = null;
        while (((ECPrivateKeyParameters)(key = sm2.ecc_key_pair_generator.generateKeyPair()).getPrivate()).getD().toByteArray().length != 32) {
        }
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        SM2KeyVO sm2KeyVO = new SM2KeyVO();
        sm2KeyVO.setPublicKey(publicKey);
        sm2KeyVO.setPrivateKey(privateKey);
        return sm2KeyVO;
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey != null && publicKey.length != 0) {
            if (data != null && data.length != 0) {
                byte[] source = new byte[data.length];
                System.arraycopy(data, 0, source, 0, data.length);
                Cipher cipher = new Cipher();
                SM2 sm2 = SM2.Instance();
                ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
                ECPoint c1 = cipher.Init_enc(sm2, userKey);
                cipher.Encrypt(source);
                byte[] c3 = new byte[32];
                cipher.Dofinal(c3);
                return Util.byteToHex(c1.getEncoded(false)) + Util.byteToHex(c3) + Util.byteToHex(source);
            }
            return null;
        }
        return null;
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey != null && privateKey.length != 0) {
            if (encryptedData != null && encryptedData.length != 0) {
                String data = Util.byteToHex(encryptedData);
                byte[] c1Bytes = Util.hexToByte(data.substring(0, 130));
                int c2Len = encryptedData.length - 97;
                byte[] c3 = Util.hexToByte(data.substring(130, 194));
                byte[] c2 = Util.hexToByte(data.substring(194, 194 + 2 * c2Len));
                SM2 sm2 = SM2.Instance();
                BigInteger userD = new BigInteger(1, privateKey);
                ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
                Cipher cipher = new Cipher();
                cipher.Init_dec(userD, c1);
                cipher.Decrypt(c2);
                cipher.Dofinal(c3);
                return c2;
            }
            return null;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String plainText = "ILoveYou11";
        byte[] sourceData = plainText.getBytes();
        String prik = "4cf170068e9c47ebdb521fb9fc62c4a55a5773fb9da33b0acf8129e28d09d205";
        String pubk = "04aabda53043e8dcb86d42f690b61a4db869821dadf9f851ec3c5c43d0c8f95a6677fdba984afc3bb010a8436b1d17cefc2011a34e01e9e801124d29ffa928d803";
        String publicKey = "04BB34D657EE7E8490E66EF577E6B3CEA28B739511E787FB4F71B7F38F241D87F18A5A93DF74E90FF94F4EB907F271A36B295B851F971DA5418F4915E2C1A23D6E";
        String privatekey = "0B1CE43098BC21B8E82B5C065EDB534CB86532B1900A49D49F3C53762D2997FA";
        System.out.println("\u52a0\u5bc6: ");
        String cipherText = SM2EncDecUtils.encrypt(Util.hexToByte(publicKey), sourceData);
        System.out.println(cipherText);
        System.out.println("\u89e3\u5bc6: ");
        plainText = new String(SM2EncDecUtils.decrypt(Util.hexToByte(privatekey), Util.hexToByte(cipherText)));
        System.out.println(plainText);
    }
}

