/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.code;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;

public class SM3Utils {
    public static String sm3(byte[] data) {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        return s.toUpperCase();
    }

    public static String sm3(String data) {
        byte[] md = new byte[32];
        byte[] msg1 = data.getBytes(StandardCharsets.UTF_8);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        return s.toUpperCase();
    }

    public static String sm3(InputStream data) throws IOException {
        int read;
        int bufferLength = 8096;
        byte[] buffer = new byte[bufferLength];
        byte[] md = new byte[32];
        SM3Digest sm3Digest = new SM3Digest();
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            sm3Digest.update(buffer, 0, read);
        }
        sm3Digest.doFinal(md, 0);
        String s = new String(Hex.encode((byte[])md));
        return s.toUpperCase();
    }

    public static String sm3(File dataFile) throws IOException {
        String var2;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dataFile);
            var2 = SM3Utils.sm3(fis);
        }
        catch (IOException var11) {
            var11.printStackTrace();
            throw new IOException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException var10) {
                    var10.printStackTrace();
                }
            }
        }
        return var2;
    }
}

