/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.service.util.excel.EnumTextLocation;
import com.geoway.landteam.landcloud.service.util.excel.ExcelColData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelRowData;
import com.gw.base.util.GutilAssert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static WritableWorkbook CreateExcel(String tempFilePath, String fileName) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);
        WritableWorkbook wwb = Workbook.createWorkbook((File)file);
        return wwb;
    }

    public static XSSFWorkbook CreateXSSExcel() throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook CreateSXSSExcel() throws Exception {
        SXSSFWorkbook workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
        workbook.setCompressTempFiles(true);
        return workbook;
    }

    public static XSSFSheet createSheet(XSSFWorkbook wwb, String sheetName) {
        XSSFSheet sheet = wwb.createSheet(sheetName);
        return sheet;
    }

    public static WritableSheet createSheet(WritableWorkbook wwb, String sheetName, int sheetIndex) {
        WritableSheet sheet = wwb.createSheet(sheetName, sheetIndex);
        return sheet;
    }

    public static Sheet createSheet(SXSSFWorkbook wwb, String sheetName) {
        SXSSFSheet sheet = wwb.createSheet(sheetName);
        return sheet;
    }

    public static void write(WritableSheet sheet, List<ExcelRowData> rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row : rows) {
                List<ExcelColData> cols = row.getColDataList();
                for (ExcelColData col : cols) {
                    if (col.isSkip()) continue;
                    WritableFont font = new WritableFont(WritableFont.ARIAL, col.getFontSize(), col.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD);
                    WritableCellFormat wcf = new WritableCellFormat(font);
                    wcf.setAlignment(ExcelUtil.getAlignment(col.getTextLocation()));
                    wcf.setVerticalAlignment(jxl.format.VerticalAlignment.CENTRE);
                    wcf.setWrap(true);
                    wcf.setBorder(Border.ALL, BorderLineStyle.THIN);
                    sheet.addCell((WritableCell)new Label(col.getColIndex(), row.getRowIndex(), col.getValue(), (CellFormat)wcf));
                    if (!col.isMergeCell()) continue;
                    sheet.mergeCells(col.getStartCol(), col.getStartRow(), col.getEndCol(), col.getEndRow());
                }
            }
        }
    }

    public static void write(XSSFSheet sheet, List<ExcelRowData> rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row : rows) {
                XSSFRow xrow = sheet.createRow(row.getRowIndex());
                List<ExcelColData> cols = row.getColDataList();
                for (ExcelColData col : cols) {
                    if (col.isSkip()) continue;
                    XSSFWorkbook workbook = sheet.getWorkbook();
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    XSSFFont font = workbook.createFont();
                    font.setBold(col.isBold());
                    font.setFontHeightInPoints((short)col.getFontSize());
                    cellStyle.setAlignment(ExcelUtil.getHorizontalAlignment(col.getTextLocation()));
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setFont((Font)font);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    XSSFCell xcell = xrow.createCell(col.getColIndex());
                    xcell.setCellValue(col.getValue());
                    xcell.setCellStyle((CellStyle)cellStyle);
                    if (!col.isMergeCell()) continue;
                    CellRangeAddress range = new CellRangeAddress(col.getStartRow(), col.getEndRow(), col.getStartCol(), col.getEndCol());
                    sheet.addMergedRegion(range);
                }
            }
        }
    }

    public static void write(Sheet sheet, List<ExcelRowData> rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row : rows) {
                Row xrow = sheet.createRow(row.getRowIndex());
                if (row.getRowHeight() > 0) {
                    xrow.setHeightInPoints((float)row.getRowHeight());
                }
                List<ExcelColData> cols = row.getColDataList();
                for (ExcelColData col : cols) {
                    if (col.isSkip()) continue;
                    CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
                    Font font = sheet.getWorkbook().createFont();
                    font.setBold(col.isBold());
                    font.setFontHeightInPoints((short)col.getFontSize());
                    cellStyle.setFont(font);
                    cellStyle.setWrapText(true);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    cellStyle.setFont(font);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    if (col.getColor() != null) {
                        cellStyle.setFillForegroundColor(col.getColor().shortValue());
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    Cell xcell = xrow.createCell(col.getColIndex());
                    xcell.setCellValue(col.getValue());
                    xcell.setCellStyle(cellStyle);
                    if (!col.isMergeCell()) continue;
                    CellRangeAddress range = new CellRangeAddress(col.getStartRow(), col.getEndRow(), col.getStartCol(), col.getEndCol());
                    sheet.addMergedRegion(range);
                }
            }
        }
    }

    private static Alignment getAlignment(EnumTextLocation textLocation) {
        switch (textLocation) {
            case left: {
                return Alignment.LEFT;
            }
            case right: {
                return Alignment.RIGHT;
            }
            case middle: {
                return Alignment.CENTRE;
            }
        }
        return Alignment.CENTRE;
    }

    private static HorizontalAlignment getHorizontalAlignment(EnumTextLocation textLocation) {
        switch (textLocation) {
            case left: {
                return HorizontalAlignment.LEFT;
            }
            case right: {
                return HorizontalAlignment.RIGHT;
            }
            case middle: {
                return HorizontalAlignment.CENTER;
            }
        }
        return HorizontalAlignment.CENTER;
    }

    private static short getHorizontalAlignmentIndex(EnumTextLocation textLocation) {
        switch (textLocation) {
            case left: {
                return 1;
            }
            case right: {
                return 3;
            }
            case middle: {
                return 2;
            }
        }
        return 2;
    }

    public static String CreateExcel(List<Map<String, Object>> data, String tempFilePath, String fileName, String col, String header, String sheetName) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);
        String[] columns = col.split(",");
        String[] columnsHeader = header.split(",");
        WritableWorkbook wwb = Workbook.createWorkbook((File)file);
        WritableSheet ws = wwb.createSheet(sheetName, 0);
        WritableCellFormat wcf = new WritableCellFormat();
        wcf.setBackground(Colour.YELLOW);
        ws.getSettings().setDefaultColumnWidth(20);
        if (columns != null && columns.length > 0 && columnsHeader != null && columnsHeader.length > 0) {
            int i;
            for (i = 0; i < columnsHeader.length; ++i) {
                ws.addCell((WritableCell)new Label(i, 0, columnsHeader[i], (CellFormat)wcf));
            }
            for (i = 0; i < data.size(); ++i) {
                Map<String, Object> temp = data.get(i);
                JSONObject json = new JSONObject(temp);
                for (int j = 0; j < columns.length; ++j) {
                    Object obj = json.get((Object)columns[j]);
                    if (obj == null) continue;
                    ws.addCell((WritableCell)new Label(j, i + 1, obj.toString()));
                }
            }
            wwb.write();
            wwb.close();
        }
        if (file.exists()) {
            return filePath;
        }
        return null;
    }

    public static void createAndWriteExcelMultipleSheets(WritableWorkbook wwb, List<ExcelData> datas) throws Exception {
        for (ExcelData data : datas) {
            int i;
            WritableSheet ws = wwb.createSheet(data.getSheetName(), data.getSheetIndex());
            WritableCellFormat wcf = new WritableCellFormat();
            wcf.setBackground(Colour.YELLOW);
            String[] columns = data.getCol().split(",");
            String[] columnsHeader = data.getHeader().split(",");
            ws.getSettings().setDefaultColumnWidth(20);
            if (columns == null || columns.length <= 0 || columnsHeader == null || columnsHeader.length <= 0) continue;
            for (i = 0; i < columnsHeader.length; ++i) {
                ws.addCell((WritableCell)new Label(i, 0, columnsHeader[i], (CellFormat)wcf));
            }
            for (i = 0; i < data.getData().size(); ++i) {
                Map<String, Object> temp = data.getData().get(i);
                JSONObject json = new JSONObject(temp);
                for (int j = 0; j < columns.length; ++j) {
                    Object obj = json.get((Object)columns[j]);
                    if (obj == null) continue;
                    ws.addCell((WritableCell)new Label(j, i + 1, obj.toString()));
                }
            }
        }
    }

    public static String CreateExcel(String tempFilePath, String fileName, List<ExcelData> datas) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);
        WritableWorkbook wwb = Workbook.createWorkbook((File)file);
        for (ExcelData data : datas) {
            int i;
            WritableSheet ws = wwb.createSheet(data.getSheetName(), data.getSheetIndex());
            WritableCellFormat wcf = new WritableCellFormat();
            wcf.setBackground(Colour.YELLOW);
            String[] columns = data.getCol().split(",");
            String[] columnsHeader = data.getHeader().split(",");
            ws.getSettings().setDefaultColumnWidth(20);
            if (columns == null || columns.length <= 0 || columnsHeader == null || columnsHeader.length <= 0) continue;
            for (i = 0; i < columnsHeader.length; ++i) {
                ws.addCell((WritableCell)new Label(i, 0, columnsHeader[i], (CellFormat)wcf));
            }
            for (i = 0; i < data.getData().size(); ++i) {
                Map<String, Object> temp = data.getData().get(i);
                JSONObject json = new JSONObject(temp);
                for (int j = 0; j < columns.length; ++j) {
                    Object obj = json.get((Object)columns[j]);
                    if (obj == null) continue;
                    ws.addCell((WritableCell)new Label(j, i + 1, obj.toString()));
                }
            }
        }
        wwb.write();
        wwb.close();
        if (file.exists()) {
            return filePath;
        }
        return null;
    }

    public static String CreateExcelXlsx(String tempFilePath, String fileName, String sheetName, Map<String, String> columnNameToHeaderMap, List<Map<String, Object>> mapList) throws Exception {
        GutilAssert.notNull(mapList, (String)"mapList can not be null ");
        GutilAssert.notNull((Object)tempFilePath, (String)"tempFilePath can not be null ");
        GutilAssert.notNull((Object)fileName, (String)"fileName can not be null ");
        GutilAssert.notNull(columnNameToHeaderMap, (String)"col can not be null ");
        GutilAssert.notNull((Object)sheetName, (String)"header can not be null ");
        int maxRowsSize = 120000;
        String filePath = "";
        SXSSFWorkbook workbook = null;
        SXSSFSheet sheet = null;
        Row row = null;
        Cell cell = null;
        Map<String, Object> map = null;
        JSONObject jsonObject = null;
        OutputStream os = null;
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> columnsHeader = new ArrayList<String>();
        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist((String)tempFilePath);
            for (String key : columnNameToHeaderMap.keySet()) {
                columns.add(key);
                columnsHeader.add(columnNameToHeaderMap.get(key));
            }
            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            workbook.setCompressTempFiles(true);
            sheet = workbook.createSheet(sheetName);
            for (int i = 0; i < mapList.size() && i < maxRowsSize; ++i) {
                if (i == 0) {
                    row = sheet.createRow(i);
                    for (int k = 0; k < columnsHeader.size(); ++k) {
                        cell = row.createCell(k);
                        cell.setCellValue((String)columnsHeader.get(k));
                    }
                }
                row = sheet.createRow(i + 1);
                map = mapList.get(i);
                if (map == null || (jsonObject = new JSONObject(map)) == null || columns == null || columns.size() <= 0 || columnsHeader == null || columnsHeader.size() <= 0) continue;
                for (int j = 0; j < columnsHeader.size(); ++j) {
                    if (!jsonObject.containsKey(columns.get(j)) || jsonObject.get(columns.get(j)) == null) continue;
                    cell = row.createCell(j);
                    cell.setCellValue(jsonObject.get(columns.get(j)).toString());
                }
            }
            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
                os.close();
                workbook.dispose();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (workbook != null) {
                workbook.dispose();
            }
            if (os != null) {
                os.close();
            }
        }
        return filePath;
    }

    public static String CreateMultiSheetExcelXlsx(String tempFilePath, String fileName, List data) throws Exception {
        GutilAssert.notNull((Object)tempFilePath, (String)"tempFilePath can not be null ");
        GutilAssert.notNull((Object)fileName, (String)"fileName can not be null ");
        JSONArray mateData = JSONArray.parseArray((String)JSON.toJSONString((Object)data), (Feature[])new Feature[0]);
        int maxRowsSize = 120000;
        String filePath = "";
        SXSSFWorkbook workbook = null;
        OutputStream os = null;
        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist((String)tempFilePath);
            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            workbook.setCompressTempFiles(true);
            for (Object object : mateData) {
                JSONObject mate = JSONObject.parseObject((String)JSON.toJSONString(object));
                GutilAssert.notNull((Object)mate.getJSONArray("mapList"), (String)"mapList can not be null ");
                GutilAssert.notNull((Object)mate.getJSONObject("columnNameToHeaderMap"), (String)"col can not be null ");
                GutilAssert.notNull((Object)mate.getString("sheetName"), (String)"header can not be null ");
                String sheetName = mate.getString("sheetName");
                JSONArray sortedHeaders = mate.getJSONArray("sortedHeaders");
                JSONObject columnNameToHeaderMap = mate.getJSONObject("columnNameToHeaderMap");
                JSONArray mapList = mate.getJSONArray("mapList");
                SXSSFSheet sheet = null;
                Row row = null;
                Cell cell = null;
                JSONObject jsonObject = null;
                JSONObject map = null;
                ArrayList<String> columns = new ArrayList<String>();
                ArrayList<String> columnsHeader = new ArrayList<String>();
                if (sortedHeaders == null || sortedHeaders.isEmpty() || sortedHeaders.size() != columnNameToHeaderMap.size()) {
                    sortedHeaders = new JSONArray();
                    sortedHeaders.addAll((Collection)columnNameToHeaderMap.keySet());
                }
                for (Object key : sortedHeaders) {
                    if (key.toString().startsWith("tb.")) {
                        key = key.toString().substring(3);
                    }
                    columns.add(key.toString());
                    columnsHeader.add(columnNameToHeaderMap.get(key).toString());
                }
                sheet = workbook.createSheet(sheetName);
                for (int i = 0; i < mapList.size() && i < maxRowsSize; ++i) {
                    if (i == 0) {
                        row = sheet.createRow(i);
                        for (int k = 0; k < columnsHeader.size(); ++k) {
                            cell = row.createCell(k);
                            cell.setCellValue((String)columnsHeader.get(k));
                        }
                    }
                    row = sheet.createRow(i + 1);
                    map = mapList.getJSONObject(i);
                    if (map == null || (jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map))) == null || columns == null || columns.size() <= 0 || columnsHeader == null || columnsHeader.size() <= 0) continue;
                    for (int j = 0; j < columnsHeader.size(); ++j) {
                        cell = row.createCell(j);
                        if (jsonObject.containsKey(columns.get(j)) && jsonObject.get(columns.get(j)) != null && !"null".equals(jsonObject.get(columns.get(j)))) {
                            cell.setCellValue(jsonObject.get(columns.get(j)).toString());
                            continue;
                        }
                        cell.setCellValue("");
                    }
                }
            }
            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
                os.close();
                workbook.dispose();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (workbook != null) {
                workbook.dispose();
            }
            if (os != null) {
                os.close();
            }
        }
        return filePath;
    }

    public static void writeDataToTemplateOutputStream(File excelTemplate, List<List<Object>> data, OutputStream outputStream) throws Exception {
        org.apache.poi.ss.usermodel.Workbook book = ExcelUtil.getWorkbookFromExcel(excelTemplate);
        ExcelUtil.writeDataToWorkbook(null, data, book, 0);
        ExcelUtil.writeWorkbookToOutputStream(book, outputStream);
    }

    public static org.apache.poi.ss.usermodel.Workbook getWorkbookFromExcel(File excelFile) throws Exception {
        if (excelFile.getName().endsWith(XLS)) {
            FileInputStream inputStream = new FileInputStream(excelFile);
            return new HSSFWorkbook((InputStream)inputStream);
        }
        if (excelFile.getName().endsWith(XLSX)) {
            return new XSSFWorkbook(excelFile);
        }
        throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
    }

    public static Sheet createSheet(org.apache.poi.ss.usermodel.Workbook workbook, String name) {
        Sheet sheet = workbook.createSheet(name);
        return sheet;
    }

    public static Sheet getSheet(org.apache.poi.ss.usermodel.Workbook workbook, String name) {
        Sheet sheet = workbook.getSheet(name);
        return sheet;
    }

    public static void writeDataToWorkbook(List<List<Object>> data, org.apache.poi.ss.usermodel.Workbook book, int rowIndex, String sheetName) {
        Sheet sheet = book.getSheet(sheetName);
        Row row = null;
        Cell cell = null;
        List<Object> rowData = null;
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.getRow(rowIndex);
            if (null == row) {
                row = sheet.createRow(rowIndex);
            }
            if (null == (rowData = data.get(i))) continue;
            for (int j = 0; j < rowData.size(); ++j) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                ExcelUtil.setValue(cell, rowData.get(j));
            }
            ++rowIndex;
        }
    }

    public static void writeWorkbookToOutputStream(org.apache.poi.ss.usermodel.Workbook book, OutputStream outputStream) throws IOException {
        book.write(outputStream);
    }

    public static void writeDataToWorkbook(List<String> title, List<List<Object>> data, File targetFile) throws IOException {
        if (!targetFile.exists() && !targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        Row row = null;
        Cell cell = null;
        if (null != title && !title.isEmpty()) {
            row = sheet.getRow(0);
            if (null == row) {
                row = sheet.createRow(0);
            }
            for (int i = 0; i < title.size(); ++i) {
                cell = row.getCell(i);
                if (null == cell) {
                    cell = row.createCell(i);
                }
                cell.setCellValue(title.get(i));
            }
        }
        List<Object> rowData = null;
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.getRow(i + 1);
            if (null == row) {
                row = sheet.createRow(i + 1);
            }
            if (null == (rowData = data.get(i))) continue;
            for (int j = 0; j < rowData.size(); ++j) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                ExcelUtil.setValue(cell, rowData.get(j));
            }
        }
        FileOutputStream out = new FileOutputStream(targetFile);
        workbook.write((OutputStream)out);
        out.close();
    }

    public static void writeDataToWorkbook(List<String> title, List<List<Object>> data, org.apache.poi.ss.usermodel.Workbook book, int page) {
        Sheet sheet = book.getSheetAt(page);
        Row row = null;
        Cell cell = null;
        if (null != title && !title.isEmpty()) {
            row = sheet.getRow(0);
            if (null == row) {
                row = sheet.createRow(0);
            }
            for (int i = 0; i < title.size(); ++i) {
                cell = row.getCell(i);
                if (null == cell) {
                    cell = row.createCell(i);
                }
                cell.setCellValue(title.get(i));
            }
        }
        List<Object> rowData = null;
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.getRow(i + 1);
            if (null == row) {
                row = sheet.createRow(i + 1);
            }
            if (null == (rowData = data.get(i))) continue;
            for (int j = 0; j < rowData.size(); ++j) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                ExcelUtil.setValue(cell, rowData.get(j));
            }
        }
    }

    public static List<List<Object>> readExcelFirstSheet(String pathname) throws IOException {
        File file = new File(pathname);
        return ExcelUtil.readExcelFirstSheet(file);
    }

    public static List<List<Object>> readExcelFirstSheet(File file) throws IOException {
        Throwable throwable = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            if (file.getName().endsWith(XLS)) {
                List<List<Object>> list = ExcelUtil.readXlsFirstSheet(inputStream);
                return list;
            }
            if (file.getName().endsWith(XLSX)) {
                List<List<Object>> list = ExcelUtil.readXlsxFirstSheet(inputStream);
                return list;
            }
            try {
                throw new IOException("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static List<List<Object>> readXls(InputStream inputStream, String sheetName) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        return ExcelUtil.readExcel((org.apache.poi.ss.usermodel.Workbook)workbook, sheetName);
    }

    public static List<List<Object>> readXlsx(InputStream inputStream, String sheetName) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        return ExcelUtil.readExcel((org.apache.poi.ss.usermodel.Workbook)workbook, sheetName);
    }

    public static List<List<Object>> readXlsFirstSheet(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        return ExcelUtil.readExcelFirstSheet((org.apache.poi.ss.usermodel.Workbook)workbook);
    }

    public static List<List<Object>> readXlsxFirstSheet(InputStream inputStream) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        return ExcelUtil.readExcelFirstSheet((org.apache.poi.ss.usermodel.Workbook)workbook);
    }

    public static List<List<Object>> readExcelFirstSheet(org.apache.poi.ss.usermodel.Workbook book) {
        return ExcelUtil.readExcel(book, 0);
    }

    public static List<List<Object>> readExcel(org.apache.poi.ss.usermodel.Workbook book, int page) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Sheet sheet = book.getSheetAt(page);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            boolean isnull = true;
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                Object value = ExcelUtil.getValue(cell, null);
                columns.add(value);
                if (value == null || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
                isnull = false;
            }
            if (isnull) continue;
            list.add(columns);
        }
        return list;
    }

    public static List<List<Object>> readExcel(org.apache.poi.ss.usermodel.Workbook book, String sheetName) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        Sheet sheet = book.getSheet(sheetName);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            boolean isnull = true;
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                Object value = ExcelUtil.getValue(cell, null);
                columns.add(value);
                if (value == null || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
                isnull = false;
            }
            if (isnull) continue;
            list.add(columns);
        }
        return list;
    }

    public static Object getValue(Cell cell, String cellType) {
        if (null == cell) {
            return null;
        }
        Object value = null;
        CellType type = cell.getCellType();
        switch (type) {
            case BLANK: {
                value = null;
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                value = cell.getErrorCellValue();
                break;
            }
            case FORMULA: {
                if (StringUtils.isNotBlank((CharSequence)cellType)) {
                    switch (cellType) {
                        case "text": {
                            value = ExcelUtil.getStr(cell);
                            break;
                        }
                        case "number": {
                            value = ExcelUtil.getDouble(cell);
                            break;
                        }
                        case "time": {
                            value = ExcelUtil.getTime(cell);
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                }
                if (value != null) break;
                String str = ExcelUtil.getStr(cell);
                if (StringUtils.isNotBlank((CharSequence)str)) {
                    value = str;
                    break;
                }
                Double dou = ExcelUtil.getDouble(cell);
                if (dou != null) {
                    value = dou;
                    break;
                }
                Date time = ExcelUtil.getTime(cell);
                if (time == null) break;
                value = time;
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            default: {
                value = cell.toString();
            }
        }
        return value;
    }

    private static String getStr(Cell cell) {
        String value = "";
        try {
            value = cell.getStringCellValue();
            return value;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static Date getTime(Cell cell) {
        try {
            Date value = cell.getDateCellValue();
            if (value instanceof Date) {
                return value;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Double getDouble(Cell cell) {
        try {
            double value = cell.getNumericCellValue();
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void setValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (null == value) {
            cell.setCellValue((String)null);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue(FORMAT.format((Date)value));
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }
}

