/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.FileDetailInfo;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.FileInfo;
import com.google.common.collect.Lists;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class Hdfs {
    GiLoger logger = GwLoger.getLoger(this.getClass());
    private FileSystem fs;
    private final String url;
    private int maxretries = 10;
    private int timeout = 3000;

    public Hdfs(String url) {
        this.url = url;
    }

    public void open() {
        try {
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", this.url);
            conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.maxretries);
            conf.setInt("ipc.client.connect.timeout", this.timeout);
            conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            this.fs = FileSystem.get((Configuration)conf);
            this.logger.info("[Hadoop]\u521b\u5efa\u5b9e\u4f8b\u6210\u529f:" + this.url, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("[Hadoop]\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25" + this.url, new Object[]{e});
        }
    }

    public void close() {
        try {
            if (null != this.fs) {
                this.fs.close();
                this.logger.info("[Hadoop]\u5173\u95ed\u5b9e\u4f8b\u6210\u529f", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("[Hadoop]\u5173\u95ed\u5b9e\u4f8b\u5931\u8d25", new Object[]{e});
        }
    }

    public boolean isConnected() throws IOException {
        return this.fs.exists(new Path("/"));
    }

    public boolean exists(String path) throws IOException {
        Path hdfsPath = new Path(path);
        return this.fs.exists(hdfsPath);
    }

    public FileStatus getFileStatus(String path) throws IOException {
        Path hdfsPath = new Path(path);
        return this.fs.getFileStatus(hdfsPath);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        ContentSummary contentSummary = null;
        Path hdfsPath = new Path(path);
        if (this.fs.exists(hdfsPath)) {
            contentSummary = this.fs.getContentSummary(hdfsPath);
        }
        return contentSummary;
    }

    public List<String> listFileName() throws IOException {
        FileStatus[] fileStatuses;
        ArrayList res = Lists.newArrayList();
        for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(new Path("/"))) {
            res.add(fileStatus.getPath() + "\uff1a\u7c7b\u578b--" + (fileStatus.isDirectory() ? "\u6587\u4ef6\u5939" : "\u6587\u4ef6"));
        }
        return res;
    }

    public void rmdir(String hdfsp) throws IOException {
        String desinfo = "Despath : " + hdfsp;
        String existPath = "Existpath : " + this.fs.delete(new Path(this.url + hdfsp), true);
    }

    public char separatorChar() {
        return '/';
    }

    public boolean isDirectory(String path) throws IOException {
        return this.fs.isDirectory(new Path(this.url + path));
    }

    public List<FileInfo> catChildfile(String hdfsp, Boolean isDetail) throws IOException {
        FileStatus[] listStatus;
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        Path path = new Path(this.url + hdfsp);
        FileStatus[] var7 = listStatus = this.fs.listStatus(path);
        int var8 = listStatus.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            FileStatus fileStatus = var7[var9];
            FileInfo fileInfo = isDetail != false ? new FileDetailInfo() : new FileInfo();
            fileInfo.setName(fileStatus.getPath().getName());
            fileInfo.setModificationtime(fileStatus.getModificationTime() != 0L ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(fileStatus.getModificationTime()) : "0");
            fileInfo.setIsdir(fileStatus.isDirectory() ? "true" : "false");
            if (isDetail.booleanValue()) {
                FileDetailInfo fileDetailInfo = (FileDetailInfo)fileInfo;
                if (fileStatus.isDirectory()) {
                    ContentSummary contentSummary = this.fs.getContentSummary(fileStatus.getPath());
                    fileDetailInfo.setDirCount(contentSummary.getDirectoryCount());
                    fileDetailInfo.setFileCount(contentSummary.getFileCount());
                    fileDetailInfo.setLength(contentSummary.getLength());
                } else {
                    fileDetailInfo.setDirCount(0L);
                    fileDetailInfo.setFileCount(0L);
                    fileDetailInfo.setLength(fileStatus.getLen());
                }
            }
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    public Pair<FileSystem, InputStream> getInputStream(String hdfsp) throws IOException {
        FSDataInputStream is = this.fs.open(new Path(this.url + hdfsp));
        return new ImmutablePair((Object)this.fs, (Object)is);
    }

    public OutputStream getOutputStream(String hdfsp) throws IOException {
        FSDataOutputStream os = this.fs.create(new Path(this.url + hdfsp));
        return os;
    }

    public String getFileName(String hdfsp) {
        Path path = new Path(this.url + hdfsp);
        return path.getName();
    }

    public List<String> getSubFilpaths(String hdfsp) throws IOException {
        Path path = new Path(this.url + hdfsp);
        return Arrays.stream(this.fs.listStatus(path)).map(fileStatus -> fileStatus.getPath().toUri().getPath()).collect(Collectors.toList());
    }

    public synchronized void mksubdirByName(String hdfsp, int beginindex, int endindex) throws IOException {
        FileStatus[] fss;
        Path path = new Path(this.url + hdfsp);
        FileStatus[] var7 = fss = this.fs.listStatus(path);
        int var8 = fss.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            FileStatus subfss = var7[var9];
            String subname = subfss.getPath().getName().substring(beginindex, endindex);
            Path newPath = new Path(path.toString() + this.separatorChar() + subname);
            if (!this.fs.exists(newPath)) {
                this.fs.mkdirs(newPath);
            }
            this.fs.rename(subfss.getPath(), new Path(newPath.toString() + this.separatorChar() + subfss.getPath().getName()));
        }
    }

    public synchronized void renamesubBySplit(String hdfsp, int beginindex, int endindex) throws IOException {
        FileStatus[] fss;
        Path path = new Path(this.url + hdfsp);
        FileStatus[] var7 = fss = this.fs.listStatus(path);
        int var8 = fss.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            FileStatus subfss = var7[var9];
            String subname = subfss.getPath().getName().substring(beginindex, endindex);
            this.fs.rename(subfss.getPath(), new Path(path.toString() + this.separatorChar() + subname));
        }
    }

    public Boolean existFile(String hdfsp) throws IOException {
        return this.fs.exists(new Path(this.url + hdfsp));
    }
}

