/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsFactory;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.HdfsPoolConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HdfsConfig {
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int maxWaitMillis = 3;
    private boolean testWhileIdle = false;
    private long minEvictableIdleTimeMillis = 60000L;
    private long timeBetweenEvictionRunsMillis = 30000L;
    private int numTestsPerEvictionRun = -1;

    @Bean
    public HdfsPoolConfig HdfsPoolConfig() {
        HdfsPoolConfig hdfsPoolConfig = new HdfsPoolConfig();
        hdfsPoolConfig.setTestWhileIdle(this.testWhileIdle);
        hdfsPoolConfig.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        hdfsPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        hdfsPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        hdfsPoolConfig.setMaxTotal(this.maxTotal);
        hdfsPoolConfig.setMaxIdlePerKey(this.maxIdle);
        hdfsPoolConfig.setMinIdlePerKey(this.minIdle);
        hdfsPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        return hdfsPoolConfig;
    }

    @Bean
    public HdfsFactory HdfsFactory() {
        return new HdfsFactory();
    }
}

