/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.SrcFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

public class SmbFSystemImpl
implements SrcFileSystem {
    @Override
    public List<String> getSubFilpaths(String path) throws MalformedURLException, SmbException {
        SmbFile smbFile = this.getSmbFile(path.endsWith(String.valueOf(this.separatorChar())) ? path : path + this.separatorChar(), new String[0]);
        return Arrays.stream(smbFile.list()).map(filename -> path + this.separatorChar() + filename).collect(Collectors.toList());
    }

    @Override
    public String getFilename(String path) {
        int lastindex = path.lastIndexOf(this.separatorChar());
        if (lastindex == path.length() - 1) {
            int startindex = path.substring(0, path.length() - 1).lastIndexOf(this.separatorChar());
            assert (startindex != -1);
            return path.substring(startindex + 1, lastindex);
        }
        return path.substring(lastindex + 1);
    }

    @Override
    public boolean isDirectory(String path) throws SmbException, MalformedURLException {
        SmbFile smbFile = this.getSmbFile(path, new String[0]);
        return smbFile.isDirectory();
    }

    @Override
    public char separatorChar() {
        return '\\';
    }

    @Override
    public boolean mkdir(String path) throws SmbException, MalformedURLException {
        SmbFile smbFile = this.getSmbFile(path, new String[0]);
        if (smbFile.exists()) {
            return false;
        }
        smbFile.mkdirs();
        return true;
    }

    private SmbFile getSmbFile(String shareUrl, String ... userinfo) throws MalformedURLException {
        SmbFile smbFile = null;
        String smburl = "smb:" + shareUrl.replace("\\", "/");
        if (userinfo != null && userinfo.length == 2) {
            NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication((String)null, userinfo[0], userinfo[1]);
            smbFile = new SmbFile(smburl, ntlmPasswordAuthentication);
        } else {
            smbFile = new SmbFile(smburl);
        }
        return smbFile;
    }

    @Override
    public InputStream getInputStream(String shareUrl, String ... userinfo) throws IOException {
        SmbFile smbFile = this.getSmbFile(shareUrl, new String[0]);
        return smbFile.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(String shareUrl, String ... userinfo) throws IOException {
        SmbFile smbFile = this.getSmbFile(shareUrl, new String[0]);
        smbFile.createNewFile();
        return smbFile.getOutputStream();
    }
}

