/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.util.hdfs;

import java.util.function.Function;

public abstract class Result<T> {
    private Result() {
    }

    public static <T> Result<T> ok(T value) {
        return new OK<T>(value);
    }

    public static Result err(Throwable error) {
        return new ERROR(error);
    }

    public boolean isOk() {
        return this instanceof OK;
    }

    public boolean isErr() {
        return this instanceof ERROR;
    }

    public T unwrap() {
        if (this.isOk()) {
            return this.get();
        }
        throw new RuntimeException((Throwable)this.get());
    }

    public <R> Result<R> map(Function<T, R> mapper) {
        if (this.isOk()) {
            return Result.ok(mapper.apply(this.get()));
        }
        throw new RuntimeException((Throwable)this.get());
    }

    public T unwrapElse(Function<Throwable, T> func) {
        if (this.isOk()) {
            return this.get();
        }
        return func.apply((Throwable)this.get());
    }

    protected abstract T get();

    public static class ERROR<T>
    extends Result<Throwable> {
        private final Throwable e;

        public ERROR(Throwable e) {
            this.e = e;
        }

        @Override
        protected Throwable get() {
            return this.e;
        }
    }

    public static class OK<T>
    extends Result<T> {
        private final T value;

        public OK(T value) {
            this.value = value;
        }

        @Override
        protected T get() {
            return this.value;
        }
    }
}

