/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.wpzf.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRecordRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DownloadFileDailyTaskService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.giht.dto.Data;
import com.geoway.landteam.landcloud.model.giht.dto.Head;
import com.geoway.landteam.landcloud.model.giht.dto.Message;
import com.geoway.landteam.landcloud.model.giht.enm.WpzfDicEnum;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtCgtj;
import com.geoway.landteam.landcloud.model.giht.entity.TbtskTaskDkpw;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtCgtjRepository;
import com.geoway.landteam.landcloud.repository.gjht.TbtskTaskDkpwRepository;
import com.geoway.landteam.landcloud.servface.wpzf.WpzfCallBackService;
import com.geoway.landteam.landcloud.service.util.EncryptionTools;
import com.geoway.landteam.landcloud.service.util.SM3Util;
import com.geoway.landteam.landcloud.service.util.TimeUtils;
import com.geoway.landteam.landcloud.service.util.Zip4jUtils;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class WpzfCallBackServiceImpl
implements WpzfCallBackService {
    @Value(value="${project.tempDir}")
    protected String tempDir;
    @Value(value="${gjck.url}")
    protected String gjckUrl;
    @Value(value="${gjck.key}")
    protected String gjckKey;
    @Value(value="${gjck.secret}")
    protected String gjckSecret;
    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Resource
    protected TskTaskBizService tskTaskBizService;
    @Resource
    protected TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    RegionService regionService;
    @Autowired
    DownloadFileDailyTaskService downloadFileDailyTaskService;
    @Autowired
    OssConfigRepository ossConfigRepository;
    @Autowired
    TbGjhtCgtjRepository tbGjhtCgtjRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Resource
    TbtskTaskDkpwRepository tbtskTaskDkpwRepository;
    @Autowired
    LandUserRepository landUserRepository;

    public boolean sendResultToJinAo(int xh, String taskId, String regionCode, Map<String, Object> info) throws Exception {
        TbGjhtCgtj tbGjhtCgtj = new TbGjhtCgtj();
        tbGjhtCgtj.setId(UUID.randomUUID().toString());
        tbGjhtCgtj.setBizid(taskId);
        tbGjhtCgtj.setOpertime(new Date());
        tbGjhtCgtj.setSfcg(Integer.valueOf(0));
        tbGjhtCgtj.setYear(Long.valueOf(2023L));
        tbGjhtCgtj.setMsg("\u521d\u59cb\u5316");
        tbGjhtCgtj.setXzqdm(regionCode);
        try {
            info.put("status", false);
            info.put("idlist", new ArrayList());
            TskTaskBiz one = this.tskTaskBizService.findByTaskId(taskId);
            if (one == null || StringUtils.isBlank((CharSequence)one.getTableId())) {
                throw new Exception("\u53c2\u6570\u5f02\u5e38\u6216\u4efb\u52a1\u5f02\u5e38");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            List<Map<String, Object>> mapList = this.getLastWeekendsForSubmitData(one, regionCode);
            String result = this.buildZipFile(xh, mapList, map, regionCode);
            List idList = mapList.stream().map(u -> u.get("f_id").toString()).collect(Collectors.toList());
            info.put("idlist", idList);
            String join = String.join((CharSequence)",", idList);
            tbGjhtCgtj.setTbid(join);
            tbGjhtCgtj.setUrl(result);
            tbGjhtCgtj.setCount(Long.valueOf(mapList.size()));
            String zipFileFullPath = map.get("zipFileFullPath");
            boolean isSuccess = this.sendHttpRequest(tbGjhtCgtj, xh, idList.size(), 2023, result.substring(result.lastIndexOf("/") + 1, result.lastIndexOf(".")), result, "2E5F07B4-09E5-334D-4304-9C9217AA5E4C", WpzfCallBackServiceImpl.getMD5Checksum(zipFileFullPath));
            if (isSuccess) {
                tbGjhtCgtj.setSfcg(Integer.valueOf(1));
            } else {
                tbGjhtCgtj.setSfcg(Integer.valueOf(2));
            }
            this.tbGjhtCgtjRepository.save((Object)tbGjhtCgtj);
        }
        catch (Exception e) {
            tbGjhtCgtj.setMsg(e.getMessage());
            this.tbGjhtCgtjRepository.save((Object)tbGjhtCgtj);
            return false;
        }
        info.put("status", true);
        return true;
    }

    private String buildZipFile(int xh, List<Map<String, Object>> mapList, HashMap<String, String> memmap, String regionCode) throws Exception {
        String xmlPath;
        File tartDirFile;
        String firstDir;
        String rootPath = "";
        String secondDir = "";
        if (StringUtils.isBlank((CharSequence)regionCode)) {
            rootPath = WpzfCallBackServiceImpl.getRootDirName(xh, "220000");
            firstDir = "220000";
            String fixDir = this.tempDir + File.separator + rootPath + File.separator + firstDir;
            Map<String, List<Map>> xzqdmList = mapList.stream().collect(Collectors.groupingBy(u -> {
                String f_xzqdmsys = u.get("f_xzqdmsys").toString().substring(0, 6);
                return f_xzqdmsys;
            }));
            HashMap xzqAndFile = new HashMap();
            for (Map.Entry<String, List<Map>> stringListEntry : xzqdmList.entrySet()) {
                String xzqh = stringListEntry.getKey();
                List<Map> value = stringListEntry.getValue();
                HashMap<String, List> jcbhAndAppMedia = new HashMap<String, List>();
                for (Map map : value) {
                    String jctbbh = map.get("f_jctbbh").toString();
                    String fId = map.get("f_id").toString();
                    File parentDir = new File(fixDir + File.separator + jctbbh);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    List appMediaList = this.appMediaRepository.queryByGid(fId);
                    this.makedirAndAddFile(fixDir + File.separator + jctbbh, appMediaList, "WY_", true);
                    jcbhAndAppMedia.put(jctbbh, appMediaList);
                }
                xzqAndFile.put(xzqh, jcbhAndAppMedia);
            }
        } else {
            rootPath = WpzfCallBackServiceImpl.getRootDirName(xh, regionCode);
            firstDir = "220000";
            secondDir = this.regionService.getRegion(regionCode).getPcode();
            String thirdDir = regionCode;
            String fixDir = this.tempDir + File.separator + rootPath + File.separator + firstDir + File.separator + secondDir + File.separator + thirdDir;
            Map<String, List<Map>> xzqdmList = mapList.stream().collect(Collectors.groupingBy(u -> {
                String f_xzqdmsys = u.get("f_xzqdmsys").toString().substring(0, 6);
                return f_xzqdmsys;
            }));
            HashMap xzqAndFile = new HashMap();
            for (Map.Entry<String, List<Map>> stringListEntry : xzqdmList.entrySet()) {
                String xzqh = stringListEntry.getKey();
                if (!xzqh.equals(regionCode)) continue;
                List<Map> value = stringListEntry.getValue();
                HashMap<String, List> jcbhAndAppMedia = new HashMap<String, List>();
                for (Map map : value) {
                    ArrayList<AppMedia> mediaList;
                    AppMedia appMedia;
                    String f_tbpdfj;
                    String jctbbh = map.get("f_jctbbh").toString();
                    String fId = map.get("f_id").toString();
                    File parentDir = new File(fixDir + File.separator + jctbbh);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    List appMediaList = this.appMediaRepository.queryByGid(fId);
                    String f_yszmwj = map.get("f_yszmwj") == null ? "" : map.get("f_yszmwj").toString();
                    String string = f_tbpdfj = map.get("f_tbpdfj") == null ? "" : map.get("f_tbpdfj").toString();
                    if (StringUtils.isNotBlank((CharSequence)f_yszmwj)) {
                        appMedia = new AppMedia();
                        appMedia.setServerpath(f_yszmwj);
                        appMedia.setId("1");
                        mediaList = new ArrayList<AppMedia>();
                        mediaList.add(appMedia);
                        this.makedirAndAddFile(fixDir + File.separator + jctbbh, mediaList, "NY", true);
                    }
                    if (StringUtils.isNotBlank((CharSequence)f_tbpdfj)) {
                        appMedia = new AppMedia();
                        appMedia.setServerpath(f_tbpdfj);
                        appMedia.setId("2");
                        mediaList = new ArrayList();
                        mediaList.add(appMedia);
                        this.makedirAndAddFile(fixDir + File.separator + jctbbh, mediaList, "NY", true);
                    }
                    ArrayList<AppMedia> wyMediaList = new ArrayList<AppMedia>();
                    int i = 0;
                    for (AppMedia appMedia2 : appMediaList) {
                        AppMedia appMedia1 = new AppMedia();
                        appMedia1.setId(++i + "");
                        appMedia1.setServerpath(appMedia2.getServerpath());
                        wyMediaList.add(appMedia1);
                    }
                    this.makedirAndAddFile(fixDir + File.separator + jctbbh, wyMediaList, "WY", true);
                    ArrayList<AppMedia> pwMediaList = new ArrayList<AppMedia>();
                    List pwListByTaskIdAndTbId = this.tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2", fId);
                    for (TbtskTaskDkpw tbtskTaskDkpw : pwListByTaskIdAndTbId) {
                        AppMedia appMedia3 = new AppMedia();
                        appMedia3.setServerpath(tbtskTaskDkpw.getfPwUrl());
                        appMedia3.setId(tbtskTaskDkpw.getfPzwh());
                        pwMediaList.add(appMedia3);
                    }
                    this.makedirAndAddFile(fixDir + File.separator + jctbbh, pwMediaList, "PW", false);
                    jcbhAndAppMedia.put(jctbbh, appMediaList);
                }
                xzqAndFile.put(xzqh, jcbhAndAppMedia);
            }
        }
        if (!(tartDirFile = new File(xmlPath = this.tempDir + File.separator + rootPath + File.separator + rootPath + ".xml")).exists()) {
            tartDirFile.createNewFile();
        }
        String xmlContent = this.getXmlContentByTbList(mapList, rootPath, secondDir, regionCode);
        WpzfCallBackServiceImpl.writeText2File(tartDirFile, xmlContent);
        EncryptionTools.encryptionOrDecryption(this.tempDir + File.separator + rootPath + File.separator + rootPath + ".xml", this.tempDir + File.separator + rootPath, rootPath + ".xml", true);
        String zip = Zip4jUtils.zip(this.tempDir + File.separator + rootPath, "gtdcywpzf2023@");
        memmap.put("zipFileFullPath", zip);
        String s = this.defaultOssOperatorService.sendObject2OssWithPublicRead("wpzf/result/upload/" + WpzfCallBackServiceImpl.getRootDirName(xh, regionCode) + ".zip", zip);
        return s;
    }

    private void makedirAndAddFile(String fixPath, List<AppMedia> appMediaList, String preffix, boolean nameContainFileId) throws IOException {
        List ossConfigs = this.ossConfigRepository.queryDefault();
        OssConfig ossConfig = null;
        if (!ossConfigs.isEmpty()) {
            ossConfig = (OssConfig)ossConfigs.get(0);
        }
        ObsClient obsClient = this.getObsClient();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        this.downloadFileDailyTaskService.createAndChangeNameTempFile(appMediaList, ossConfig, obsClient, inputStream, outputStream, fixPath, preffix, nameContainFileId);
    }

    private ObsClient getObsClient() {
        ObsClient obsClient = null;
        List ossConfigs = this.ossConfigRepository.queryDefault();
        OssConfig ossConfig = null;
        if (!ossConfigs.isEmpty()) {
            ossConfig = (OssConfig)ossConfigs.get(0);
        }
        String myEndPoint = ossConfig.getEndPoint();
        ObsConfiguration config = new ObsConfiguration();
        config.setSocketTimeout(30000);
        config.setConnectionTimeout(10000);
        config.setEndPoint(myEndPoint);
        config.setHttpsOnly(false);
        obsClient = new ObsClient(ossConfig.getKey(), ossConfig.getKeySecret(), config);
        return obsClient;
    }

    private File getXmlByTbList(List<Map> mapList) throws Exception {
        Message message = new Message();
        File file = null;
        if (mapList != null && mapList.size() > 0) {
            for (Map map : mapList) {
            }
        } else {
            message = WpzfCallBackServiceImpl.getExample();
            String filename = "d:\\data\\tempDir\\" + UUID.randomUUID() + ".xml";
            file = WpzfCallBackServiceImpl.buildXml(message.toXml(), filename);
        }
        return file;
    }

    private String getXmlContentByTbList(List<Map<String, Object>> mapList, String rootPath, String secondDir, String regionCode) throws Exception {
        Message message = new Message();
        String xmlStr = "";
        if (mapList != null && mapList.size() > 0) {
            Head head = new Head();
            head.setMsgID(rootPath);
            head.setXZQDM(regionCode);
            head.setCommitCode("220");
            head.setDataTransTime(TimeUtils.dateToString(new Date(), "yyyy-MM-dd HH:mm:ss"));
            Data data = new Data();
            ArrayList<Data.ResultTB> resultTBList = new ArrayList<Data.ResultTB>();
            ArrayList<Data.ResultDK> resultDKList = new ArrayList<Data.ResultDK>();
            for (Map<String, Object> map : mapList) {
                String sjpdlx;
                String sjshyj;
                String f_sdwbhlx;
                String f_yblqthfy;
                Data.ResultTB resultTB = new Data.ResultTB();
                Data.ResultDK resultDK = new Data.ResultDK();
                String jctbbh = map.get("f_jctbbh") == null ? "" : map.get("f_jctbbh").toString();
                resultTB.setJCBH(jctbbh);
                resultTB.setGeoDealType("0");
                resultTB.setXFSJ(map.get("xfsj") == null ? "" : map.get("xfsj").toString());
                resultTB.setSF_SK("0");
                resultTB.setDK_Count("1");
                long f_committime = Long.valueOf(map.get("f_committime").toString());
                String s = TimeUtils.dateToString(new Date(f_committime), "yyyy-MM-dd HH:mm:ss");
                if (map.get("f_committime") == null) {
                    resultTB.setGeoUpdateTime("");
                } else {
                    resultTB.setGeoUpdateTime(s);
                }
                ArrayList<Data.DK> dkList = new ArrayList<Data.DK>();
                Data.DK dk = new Data.DK();
                dk.setDKBH(map.get("f_dkbh") == null ? "" : map.get("f_dkbh").toString());
                dk.setDKMJ(map.get("f_dkmj") == null ? "" : map.get("f_dkmj").toString());
                dk.setNYDMJ(map.get("f_nydmj") == null ? "" : map.get("f_nydmj").toString());
                dk.setGDMJ(map.get("f_gdmj") == null ? "" : map.get("f_gdmj").toString());
                dk.setSTMJ(map.get("f_dksttxmj") == null ? "" : map.get("f_dksttxmj").toString());
                dk.setYJ_JBNTMJ(map.get("f_yjjbntmj") == null ? "" : map.get("f_yjjbntmj").toString());
                dk.setSTBHHXMJ(map.get("f_dkstbhhx") == null ? "0" : map.get("f_dkstbhhx").toString());
                String shape = map.get("f_shape").toString();
                dk.setShape(shape);
                dkList.add(dk);
                resultTB.setDKList(dkList);
                resultTBList.add(resultTB);
                resultDK.setMergeDKlist(new ArrayList());
                List appMediaList = this.appMediaRepository.queryByGid(map.get("f_id").toString());
                ArrayList<Data.PW> pwList = new ArrayList<Data.PW>();
                List dkpwList = this.tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2", map.get("f_id").toString());
                for (TbtskTaskDkpw tbtskTaskDkpw : dkpwList) {
                    Data.PW pw = new Data.PW();
                    pw.setPZWH(tbtskTaskDkpw.getfPzwh());
                    pw.setXMMC(tbtskTaskDkpw.getfXmmc() == null ? "" : tbtskTaskDkpw.getfXmmc());
                    pw.setPW_Source(tbtskTaskDkpw.getfPwSource() + "");
                    pw.setPWLX(StringUtils.isNotBlank((CharSequence)tbtskTaskDkpw.getfPwlx()) ? tbtskTaskDkpw.getfPwlx() : "");
                    pw.setPZSJ(tbtskTaskDkpw.getfPzsj() == null ? "" : tbtskTaskDkpw.getfPzsj());
                    pw.setYXQZ(tbtskTaskDkpw.getfYxqz() == null ? "" : tbtskTaskDkpw.getfYxqz());
                    pw.setPZJG(tbtskTaskDkpw.getfPzjg() == null ? "" : tbtskTaskDkpw.getfPzjg());
                    pw.setPZMJ(tbtskTaskDkpw.getfPzmj() == null ? "" : tbtskTaskDkpw.getfPzmj());
                    pw.setPZGDMJ(tbtskTaskDkpw.getfPzgdmj());
                    pw.setPZNYDMJ(tbtskTaskDkpw.getfPznydmj());
                    pw.setPZYJJBNTMJ(tbtskTaskDkpw.getfPzyjjbntmj());
                    pw.setPZJSYDMJ(tbtskTaskDkpw.getfPzjsydmj() == null ? "" : tbtskTaskDkpw.getfPzjsydmj());
                    pw.setPZWLYMJ(tbtskTaskDkpw.getfPzwlymj() == null ? "" : tbtskTaskDkpw.getfPzwlymj());
                    pw.setReason(tbtskTaskDkpw.getfReason() == null ? "" : tbtskTaskDkpw.getfReason());
                    String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + tbtskTaskDkpw.getfPwUrl().substring(tbtskTaskDkpw.getfPwUrl().lastIndexOf(".") + 1);
                    pw.setPW_URL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                    pw.setMD5(tbtskTaskDkpw.getfMd5());
                    pw.setLocationURL(StringUtils.isNotBlank((CharSequence)tbtskTaskDkpw.getfLocationurl()) ? tbtskTaskDkpw.getfLocationurl() : "");
                    pwList.add(pw);
                }
                resultDK.setPWlist(pwList);
                Data.DKAttributes dkAttributes = new Data.DKAttributes();
                resultDK.setFileList(this.getFileList(map, appMediaList, dkAttributes, secondDir, regionCode));
                dkAttributes.setDKBH(map.get("f_dkbh") == null ? "" : map.get("f_dkbh").toString());
                dkAttributes.setXFSJ(map.get("xfsj") == null ? "" : map.get("xfsj").toString());
                dkAttributes.setDK_Unit("1");
                dkAttributes.setDK_Count("1");
                String pdlx = map.get("f_hfpd").toString();
                dkAttributes.setPDLX(WpzfDicEnum.getCodeByTypeAndDesc((String)"pdlx", (String)pdlx));
                dkAttributes.setDKMJ(map.get("f_dkmj") == null ? "" : map.get("f_dkmj").toString());
                dkAttributes.setNYDMJ(map.get("f_nydmj") == null ? "" : map.get("f_nydmj").toString());
                dkAttributes.setGDMJ(map.get("f_gdmj") == null ? "" : map.get("f_gdmj").toString());
                dkAttributes.setSTMJ(map.get("f_dksttxmj") == null ? "" : map.get("f_dksttxmj").toString());
                dkAttributes.setYJ_JBNTMJ(map.get("f_yjjbntmj") == null ? "" : map.get("f_yjjbntmj").toString());
                dkAttributes.setSTBHHXMJ(map.get("f_stbhhxmj") == null ? "0" : map.get("f_stbhhxmj").toString());
                String sjshsj3 = map.get("f_sjshsj") == null ? "" : map.get("f_sjshsj").toString();
                String sjdxsj2 = map.get("f_sjdxsj") == null ? "" : map.get("f_sjdxsj").toString();
                String sjshsj = map.get("f_sjs_n3") == null ? "" : map.get("f_sjs_n3").toString();
                String sjdxsj1 = map.get("f_sjd_n1") == null ? "" : map.get("f_sjd_n1").toString();
                List fileList = resultDK.getFileList();
                if (StringUtils.isNotBlank((CharSequence)sjshsj3)) {
                    dkAttributes.setUpdateTime(sjshsj3);
                } else if (StringUtils.isNotBlank((CharSequence)sjdxsj2)) {
                    dkAttributes.setUpdateTime(TimeUtils.convertDateAndTimeFromOther(sjdxsj2));
                } else if (StringUtils.isNotBlank((CharSequence)sjshsj)) {
                    dkAttributes.setUpdateTime(sjshsj);
                } else if (StringUtils.isNotBlank((CharSequence)sjdxsj1)) {
                    dkAttributes.setUpdateTime(TimeUtils.convertDateAndTimeFromOther(sjdxsj1));
                } else {
                    String maxTime = s;
                    for (Data.File u : fileList) {
                        if (u.getUploadTime().compareTo(s) <= 0) continue;
                        maxTime = u.getUploadTime();
                    }
                    dkAttributes.setUpdateTime(maxTime);
                }
                dkAttributes.setPDYJ(map.get("f_pdyjsm") == null ? "" : map.get("f_pdyjsm").toString());
                dkAttributes.setJSYDMJ(map.get("f_jsydmj") == null ? "" : map.get("f_jsydmj").toString());
                dkAttributes.setWLYDMJ(map.get("f_wlydmj") == null ? "" : map.get("f_wlydmj").toString());
                dkAttributes.setXZJD(map.get("f_xzjd") == null ? "" : map.get("f_xzjd").toString());
                dkAttributes.setCUN(map.get("f_c_n5") == null ? "" : map.get("f_c_n5").toString());
                dkAttributes.setXXDZ(map.get("f_xxdz") == null ? "" : map.get("f_xxdz").toString());
                dkAttributes.setHF_SJYT(WpzfDicEnum.getCodeByTypeAndDesc((String)"sjyt", (String)(map.get("f_sjyt") == null ? "" : map.get("f_sjyt").toString())));
                String f_hflx = map.get("f_hflx") == null ? "" : map.get("f_hflx").toString();
                String string = f_yblqthfy = map.get("f_yblqthfy") == null ? "" : map.get("f_yblqthfy").toString();
                if (StringUtils.isNotBlank((CharSequence)f_yblqthfy)) {
                    dkAttributes.setHF_JTQX(WpzfDicEnum.getCodeByTypeAndDesc((String)"jtqx", (String)f_yblqthfy));
                } else {
                    dkAttributes.setHF_JTQX(WpzfDicEnum.getCodeByTypeAndDesc((String)"jtqx", (String)f_hflx));
                }
                String f_qtydsjyt = map.get("f_qtlx") == null ? "" : map.get("f_qtlx").toString();
                String string2 = f_sdwbhlx = map.get("f_sdwbhlx") == null ? "" : map.get("f_sdwbhlx").toString();
                if (StringUtils.isNotBlank((CharSequence)f_sdwbhlx)) {
                    dkAttributes.setQT_SJYT(WpzfDicEnum.getCodeByTypeAndDesc((String)"qtsjyt", (String)f_sdwbhlx));
                } else {
                    dkAttributes.setQT_SJYT(WpzfDicEnum.getCodeByTypeAndDesc((String)"qtsjyt", (String)f_qtydsjyt));
                }
                dkAttributes.setSF_LZGDJF(map.get("f_sfxzlzgd") == null ? "" : map.get("f_sfxzlzgd").toString());
                dkAttributes.setSF_DPF(map.get("f_sfdpf") == null ? "" : map.get("f_sfdpf").toString());
                dkAttributes.setWFQK_SJYT(WpzfDicEnum.getCodeByTypeAndDesc((String)"sjyt", (String)(map.get("f_sjyt") == null ? "" : map.get("f_sjyt").toString())));
                dkAttributes.setWFQK_SF_WHZJ(map.get("f_sfwhzj") == null ? "" : map.get("f_sfwhzj").toString());
                String f_wfpzzylx = map.get("f_wfpzzylx") == null ? "" : map.get("f_wfpzzylx").toString();
                String f_wfgdlx = map.get("f_wfgdlx") == null ? "" : map.get("f_wfgdlx").toString();
                String f_wfzdlx = map.get("f_wfzdlx") == null ? "" : map.get("f_wfzdlx").toString();
                String f_wgjylx = map.get("f_wgjylx") == null ? "" : map.get("f_wgjylx").toString();
                String f_clfnjswf = map.get("f_clfnjswf") == null ? "" : map.get("f_clfnjswf").toString();
                String f_nyssjswf = map.get("f_nyssjswf") == null ? "" : map.get("f_nyssjswf").toString();
                String f_sjfzlgyw = map.get("f_sjfzlgyw") == null ? "" : map.get("f_sjfzlgyw").toString();
                String wflx = "";
                if (StringUtils.isNotBlank((CharSequence)f_wfpzzylx)) {
                    wflx = f_wfpzzylx;
                } else if (StringUtils.isNotBlank((CharSequence)f_wfgdlx)) {
                    wflx = f_wfgdlx;
                } else if (StringUtils.isNotBlank((CharSequence)f_wfzdlx)) {
                    wflx = f_wfzdlx;
                } else if (StringUtils.isNotBlank((CharSequence)f_wgjylx)) {
                    wflx = f_wgjylx;
                } else if (StringUtils.isNotBlank((CharSequence)f_clfnjswf)) {
                    wflx = f_clfnjswf;
                } else if (StringUtils.isNotBlank((CharSequence)f_nyssjswf)) {
                    wflx = f_nyssjswf;
                } else if (StringUtils.isNotBlank((CharSequence)f_sjfzlgyw)) {
                    wflx = f_sjfzlgyw;
                }
                dkAttributes.setWFQK_WFLX(WpzfDicEnum.getCodeByTypeAndDesc((String)"wflx", (String)wflx));
                dkAttributes.setZGLX(WpzfDicEnum.getCodeByTypeAndDesc((String)"zglx", (String)(map.get("f_zglsqk") == null ? "" : map.get("f_zglsqk").toString())));
                dkAttributes.setYJQK_YJBM(map.get("f_yjdbm") == null ? "" : map.get("f_yjdbm").toString());
                dkAttributes.setSHENG_PDLX(map.get("f_sjdxdpdl") == null ? "" : map.get("f_sjdxdpdl").toString());
                dkAttributes.setSHENG_PDYJ(map.get("f_sjdxdpdy") == null ? "" : map.get("f_sjdxdpdy").toString());
                dkAttributes.setSHENG_PDR(map.get("f_sjdxrxm") == null ? "" : map.get("f_sjdxrxm").toString());
                dkAttributes.setSHENG_PDSJ(TimeUtils.convertDateAndTimeFromOther(map.get("f_sjdxsj") == null ? "" : map.get("f_sjdxsj").toString()));
                dkAttributes.setSPD_WFLX(map.get("f_sjdxwflx") == null ? "" : map.get("f_sjdxwflx").toString());
                dkAttributes.setSPD_SF_LZGDJF(map.get("f_sjdxsfxz") == null ? "" : map.get("f_sjdxsfxz").toString());
                dkAttributes.setSPD_SF_WHZJ(map.get("f_sjdxsfwh") == null ? "" : map.get("f_sjdxsfwh").toString());
                dkAttributes.setSPD_SF_DPF(map.get("f_sjdxsfdp") == null ? "" : map.get("f_sjdxsfdp").toString());
                dkAttributes.setSPD_SF_JJXM(map.get("f_sjdxsfjj") == null ? "" : map.get("f_sjdxsfjj").toString());
                dkAttributes.setSPD_SF_FZYQ(map.get("f_sjdxsfyf") == null ? "" : map.get("f_sjdxsfyf").toString());
                dkAttributes.setSPD_SF_BZXZF(map.get("f_sjdxsfbz") == null ? "" : map.get("f_sjdxsfbz").toString());
                dkAttributes.setSHI_PDLX(map.get("f_sjdxd_n1") == null ? "" : map.get("f_sjdxd_n1").toString());
                dkAttributes.setSHI_PDYJ(map.get("f_sjdxd_n2") == null ? "" : map.get("f_sjdxd_n2").toString());
                dkAttributes.setSHI_PDR(map.get("f_sjdx_n1") == null ? "" : map.get("f_sjdx_n1").toString());
                dkAttributes.setSHI_PDSJ(TimeUtils.convertDateAndTimeFromOther(map.get("f_sjd_n1") == null ? "" : map.get("f_sjd_n1").toString()));
                dkAttributes.setTBR(map.get("f_username") == null ? "" : map.get("f_username").toString());
                dkAttributes.setTBSJ(s);
                String sjshjg = map.get("f_sjshjg") == null ? "" : map.get("f_sjshjg").toString();
                dkAttributes.setSHENG_SHJG(sjshjg);
                if (StringUtils.isNotBlank((CharSequence)sjshjg)) {
                    String string3 = sjshyj = map.get("f_sjshyj") == null ? "" : map.get("f_sjshyj").toString();
                    if (StringUtils.isBlank((CharSequence)sjshyj)) {
                        dkAttributes.setSHENG_SHJG("\u540c\u610f");
                    } else {
                        dkAttributes.setSHENG_SHJG(sjshyj);
                    }
                } else {
                    sjshyj = map.get("f_sjshyj") == null ? "" : map.get("f_sjshyj").toString();
                    dkAttributes.setSHENG_SHJG(sjshyj);
                }
                dkAttributes.setSHENG_SHJG(map.get("f_sjshjg") == null ? "" : map.get("f_sjshjg").toString());
                dkAttributes.setSHENG_SHYJ(map.get("f_sjshyj") == null ? "" : map.get("f_sjshyj").toString());
                dkAttributes.setSHENG_SHR(map.get("f_sjshrxm") == null ? "" : map.get("f_sjshrxm").toString());
                dkAttributes.setSHENG_SHSJ(map.get("f_sjshsj") == null ? "" : map.get("f_sjshsj").toString());
                String string4 = sjpdlx = map.get("f_sjdxd_n1") == null ? "" : map.get("f_sjdxd_n1").toString();
                if (StringUtils.isNotBlank((CharSequence)sjpdlx)) {
                    String f_sjs_n2;
                    String string5 = f_sjs_n2 = map.get("f_sjs_n2") == null ? "" : map.get("f_sjs_n2").toString();
                    if (StringUtils.isBlank((CharSequence)f_sjs_n2)) {
                        dkAttributes.setSHI_SHYJ("\u540c\u610f");
                    } else {
                        dkAttributes.setSHI_SHYJ(map.get("f_sjs_n2") == null ? "" : map.get("f_sjs_n2").toString());
                    }
                } else {
                    dkAttributes.setSHI_SHYJ(map.get("f_sjs_n2") == null ? "" : map.get("f_sjs_n2").toString());
                }
                dkAttributes.setSHI_SHJG(map.get("f_sjs_n1") == null ? "" : map.get("f_sjs_n1").toString());
                dkAttributes.setSHI_SHR(map.get("f_sjdx_n1") == null ? "" : map.get("f_sjdx_n1").toString());
                dkAttributes.setSHI_SHSJ(map.get("f_sjs_n3") == null ? "" : map.get("f_sjs_n3").toString());
                dkAttributes.setWFXW_BH(map.get("f_wfxwbh") == null ? "" : map.get("f_wfxwbh").toString());
                dkAttributes.setXMLX(map.get("f_xmlx") == null ? "" : map.get("f_xmlx").toString());
                dkAttributes.setXMMC(map.get("f_xmmc") == null ? "" : map.get("f_xmmc").toString());
                dkAttributes.setXMZT(map.get("f_xmzt") == null ? "" : map.get("f_xmzt").toString());
                dkAttributes.setLXPZJG(map.get("f_lxpzjg") == null ? "" : map.get("f_lxpzjg").toString());
                dkAttributes.setLXPZWH(map.get("f_lxpzwh") == null ? "" : map.get("f_lxpzwh").toString());
                dkAttributes.setSF_FZYQ(map.get("f_sfyfyhfz") == null ? "" : map.get("f_sfyfyhfz").toString());
                dkAttributes.setSF_BZXZF(map.get("f_sfbzxajz") == null ? "" : map.get("f_sfbzxajz").toString());
                dkAttributes.setSF_JJXM(map.get("f_sfjjxm") == null ? "" : map.get("f_sfjjxm").toString());
                dkAttributes.setCLFS(map.get("f_clfs") == null ? "" : map.get("f_clfs").toString());
                dkAttributes.setLABH(map.get("f_labh") == null ? "" : map.get("f_labh").toString());
                dkAttributes.setSHENG_HCYJ(map.get("f_swyhcyj") == null ? "" : map.get("f_swyhcyj").toString());
                dkAttributes.setSHENG_HCR(map.get("f_swyhcr") == null ? "" : map.get("f_swyhcr").toString());
                dkAttributes.setSHENG_HCSJ(map.get("f_swyhcsj") == null ? "" : map.get("f_swyhcsj").toString());
                dkAttributes.setCCFGS_SHYJ(map.get("f_ccfgsnys") == null ? "" : map.get("f_ccfgsnys").toString());
                dkAttributes.setCCFGS_SHR(map.get("f_ccfgs_n1") == null ? "" : map.get("f_ccfgs_n1").toString());
                dkAttributes.setCCFGS_SHSJ(map.get("f_ccfgs_n2") == null ? "" : map.get("f_ccfgs_n2").toString());
                dkAttributes.setCCFGS_HCYJ(map.get("f_ccfgswyh") == null ? "" : map.get("f_ccfgswyh").toString());
                dkAttributes.setCCFGS_HCR(map.get("f_ccfgs_n3") == null ? "" : map.get("f_ccfgs_n3").toString());
                dkAttributes.setCCFGS_HCSJ(map.get("f_ccfgs_n4") == null ? "" : map.get("f_ccfgs_n4").toString());
                resultDK.setDKAttributes(dkAttributes);
                resultDKList.add(resultDK);
            }
            data.setResultTBList(resultTBList);
            data.setResultDKList(resultDKList);
            String encrypt = SM3Util.encrypt(data.toXml());
            head.setDigitalSign(encrypt);
            message.setHead(head);
            message.setData(data);
        } else {
            message = WpzfCallBackServiceImpl.getExample();
        }
        xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message.toXml();
        return xmlStr;
    }

    private List<Data.File> getFileList(Map map, List<AppMedia> appMediaList, Data.DKAttributes dkAttributes, String secondDir, String regionCode) {
        String fileName;
        LandUser landUser;
        Data.File file;
        String[] split;
        String path;
        String fileName2;
        LandUser landUser2;
        Object file2;
        String[] split2;
        ArrayList<Data.File> fileList = new ArrayList<Data.File>();
        String jctbbh = map.get("f_jctbbh") == null ? "" : map.get("f_jctbbh").toString();
        String f_yszmwj = map.get("f_yszmwj") == null ? "" : map.get("f_yszmwj").toString();
        String f_tbpdfj = map.get("f_tbpdfj") == null ? "" : map.get("f_tbpdfj").toString();
        List dkpwList = this.tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2", map.get("f_id").toString());
        List qtydpw = dkpwList.stream().filter(u -> "\u5176\u4ed6\u7528\u5730\u6279\u6587".equals(u.getfHfpwlx())).collect(Collectors.toList());
        List scbbsx = dkpwList.stream().filter(u -> "\u4e0a\u4f20\u8865\u529e\u624b\u7eed".equals(u.getfHfpwlx())).collect(Collectors.toList());
        List hfydpw = dkpwList.stream().filter(u -> "\u5408\u6cd5\u7528\u5730\u6279\u6587".equals(u.getfHfpwlx())).collect(Collectors.toList());
        int i = 0;
        for (AppMedia appMedia : appMediaList) {
            String path2 = appMedia.getServerpath();
            Data.File file3 = new Data.File();
            file3.setID(++i + "");
            file3.setX(appMedia.getLon() + "");
            file3.setY(appMedia.getLat() + "");
            file3.setAngle(appMedia.getAzimuth());
            file3.setFileName(path2.substring(path2.lastIndexOf("/") + 1));
            file3.setFileExt(path2.substring(path2.lastIndexOf(".") + 1));
            file3.setFileSource("2");
            if (StringUtils.isNotBlank((CharSequence)appMedia.getCreateTime())) {
                file3.setUploadTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getCreateTime()));
            } else {
                file3.setUploadTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getTime()));
            }
            file3.setShootTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getTime()));
            file3.setUploadUserName(appMedia.getUsername());
            String fileName3 = "WY_" + i + "_" + file3.getFileName();
            file3.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName3);
            fileList.add(file3);
        }
        if (StringUtils.isNotBlank((CharSequence)f_yszmwj)) {
            split2 = f_yszmwj.split("/");
            file2 = new Data.File();
            file2.setID("1");
            file2.setFileName(split2[split2.length - 1]);
            file2.setFileExt(f_yszmwj.substring(f_yszmwj.lastIndexOf(".") + 1));
            file2.setFileType("1");
            file2.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split2[split2.length - 2]));
            landUser2 = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(split2[split2.length - 4])));
            file2.setUploadUserName(landUser2.getName());
            file2.setFileSource("1");
            fileName2 = "NY_1_" + file2.getFileName();
            file2.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName2);
            fileList.add((Data.File)file2);
        }
        if (StringUtils.isNotBlank((CharSequence)f_tbpdfj)) {
            split2 = f_tbpdfj.split("/");
            ++i;
            file2 = new Data.File();
            file2.setID("2");
            file2.setFileName(f_tbpdfj.substring(f_tbpdfj.lastIndexOf("/") + 1));
            file2.setFileExt(f_tbpdfj.substring(f_tbpdfj.lastIndexOf(".") + 1));
            file2.setFileType("2");
            file2.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split2[split2.length - 2]));
            landUser2 = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(split2[split2.length - 4])));
            file2.setUploadUserName(landUser2.getName());
            file2.setFileSource("1");
            fileName2 = "NY_2_" + file2.getFileName();
            file2.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName2);
            fileList.add((Data.File)file2);
        }
        int pwCount = 0;
        if (qtydpw != null && qtydpw.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : qtydpw) {
                path = tbtskTaskDkpw.getfPwUrl();
                split = path.split("/");
                file = new Data.File();
                file.setID(++pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType("2");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                landUser = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(split[split.length - 4])));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }
        if (scbbsx != null && scbbsx.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : scbbsx) {
                path = tbtskTaskDkpw.getfPwUrl();
                split = path.split("/");
                file = new Data.File();
                file.setID(++pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType("1");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                landUser = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(split[split.length - 4])));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }
        if (hfydpw != null && hfydpw.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : hfydpw) {
                path = tbtskTaskDkpw.getfPwUrl();
                split = path.split("/");
                file = new Data.File();
                file.setID(++pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType("3");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                landUser = this.landUserRepository.queryUserById(Long.valueOf(Long.parseLong(split[split.length - 4])));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL("220000\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }
        dkAttributes.setPW_Count(pwCount + "");
        dkAttributes.setPhoto_Count(appMediaList.size() + "");
        int nyCount = 0;
        if (StringUtils.isNotBlank((CharSequence)f_yszmwj)) {
            ++nyCount;
        }
        if (StringUtils.isNotBlank((CharSequence)f_tbpdfj)) {
            ++nyCount;
        }
        dkAttributes.setZMCL_Count(nyCount + "");
        return fileList;
    }

    private String digitalSignEncryed(String content) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SM3");
            byte[] hash = digest.digest(content.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    private List<Map<String, Object>> getLastWeekendsForSubmitData(TskTaskBiz one, String regionCode) throws Exception {
        TbtskObjectinfo objectByTableId = this.tbtskObjectinfoRepository.getObjectByTableId(one.getTableId());
        Pair<String, String> lastNatureWeek = TimeUtils.getLastNatureWeek();
        String startTime = (String)lastNatureWeek.getLeft();
        String endTime = (String)lastNatureWeek.getRight();
        List tbtskSubmitReportRecordList = this.tbtskSubmitReportRecordRepository.queryByTaskIdAndRegionCodeAndTime(one.getId(), regionCode, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
        if (tbtskSubmitReportRecordList == null || tbtskSubmitReportRecordList.size() == 0) {
            throw new Exception("\u653f\u533a" + regionCode + ":" + startTime + "\u81f3" + endTime + "\u65f6\u95f4\u6bb5\u5185\uff0c\u65e0\u65b0\u63d0\u4ea4\u56fe\u6591");
        }
        List ids = tbtskSubmitReportRecordList.stream().map(u -> u.getDataid()).collect(Collectors.toList());
        String join = String.join((CharSequence)"','", ids);
        String sql = "with tem as(\n\tselect tar.*, row_number() over (partition by tar.f_dataid, tar.f_taskid order by tar.f_updatetime desc) from tbtsk_assign_record tar \n\twhere tar.f_taskid = '3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2'\n)\nselect ttztask.*, tem.f_createtime as xfsj, tu.f_username from tbtsk_task_znglrw_20231103095016456 ttztask\ninner join tem on ttztask.f_id = tem.f_dataid inner join tbsys_user tu on ttztask.f_submit_userid = tu.f_userid::TEXT where tem.row_number = 1 and ttztask.f_id in('" + join + "')";
        List maps = this.jdbcTemplate.queryForList(sql);
        maps.stream().forEach(u -> {
            if (u.containsKey("f_shape")) {
                Object shape = u.get("f_shape");
                if (shape != null && shape.toString().contains("4490")) {
                    String replace = shape.toString().replace("4490", "4326");
                    u.put("f_shape", replace);
                } else if (shape != null) {
                    String newShape = "SRID=4326;" + shape;
                    u.put("f_shape", newShape);
                }
            }
        });
        return maps;
    }

    public static String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }

    public static String getRootDirName(int xh, String regionCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)regionCode) || regionCode.length() < 6) {
            throw new Exception("\u56fe\u6591\u653f\u533a\u4ee3\u7801\u5f02\u5e38");
        }
        String xzqh = regionCode.substring(0, 6);
        Calendar instance = Calendar.getInstance();
        int year = instance.get(1);
        int month = instance.get(2) + 1;
        int day = instance.get(5);
        String date = "" + year + month + day;
        String platform = "220";
        String no = WpzfCallBackServiceImpl.getFixLengthNo(xh);
        return xzqh + date + platform + no;
    }

    private static String getFixLengthNo(int xh) {
        String no = "";
        if (xh > 999999) {
            no = xh + "";
        } else {
            int length = 7 - (xh + "").length();
            String repeat = StringUtils.repeat((String)"0", (int)length);
            no = repeat + xh;
        }
        return no;
    }

    public static void main(String[] args) {
        int xh = 33335608;
        String no = "";
        if (xh > 999999) {
            no = xh + "";
        } else {
            int length = 7 - (xh + "").length();
            String repeat = StringUtils.repeat((String)"0", (int)length);
            no = repeat + xh;
        }
        System.out.println(no + "=================");
    }

    public static File buildXml(String text, String filename) throws IllegalAccessException, IOException {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + text;
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        WpzfCallBackServiceImpl.writeText2File(file, xmlStr);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText2File(File file, String text) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsoluteFile()), StandardCharsets.UTF_8);
            writer.write(text);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText2File3(File file, String text) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.getEncoding();
            char[] chars = text.toCharArray();
            writer.write(chars);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean sendHttpRequest(TbGjhtCgtj tbGjhtCgtj, int xh, int tbs, int year, String zipname, String url, String token, String md5) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String gjurl = "https://dc2.landcloud.org.cn:9443/webapi/wpzf/DataRec";
        JSONObject result = new JSONObject();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(gjurl));
        httpPost.setHeader("Content-Type", "application/json");
        JSONObject param = new JSONObject();
        param.put("xh", (Object)xh);
        param.put("tbs", (Object)tbs);
        param.put("jgtype", (Object)220);
        param.put("nd", (Object)year);
        param.put("sumzip", (Object)1);
        param.put("cfdks", (Object)0);
        param.put("zipname", (Object)zipname);
        param.put("tbdks", (Object)0);
        param.put("url", (Object)url);
        param.put("token", (Object)token);
        param.put("md5", (Object)md5);
        httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8"));
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String httpEntityContent = WpzfCallBackServiceImpl.getHttpEntityContent(response);
        result = JSONObject.parseObject((String)httpEntityContent);
        if (result.containsKey((Object)"flag") && "true".equalsIgnoreCase(result.getString("flag"))) {
            tbGjhtCgtj.setMsg(result.getString("message"));
            return true;
        }
        tbGjhtCgtj.setMsg(result.getString("message"));
        return false;
    }

    public static Message getExample() throws IllegalAccessException {
        Message message = new Message();
        try {
            Head head = new Head();
            head.setMsgID("h111");
            head.setCommitCode("h222");
            head.setXZQDM("h333");
            head.setDataTransTime("h444");
            head.setDigitalSign("h555");
            Data data = new Data();
            ArrayList<Data.ResultDK> resultDKList = new ArrayList<Data.ResultDK>();
            Data.ResultDK resultDK1 = new Data.ResultDK();
            Data.ResultDK resultDK2 = new Data.ResultDK();
            WpzfCallBackServiceImpl.completeDk(resultDK1);
            resultDKList.add(resultDK1);
            resultDKList.add(resultDK2);
            ArrayList<Data.ResultTB> resultTBList = new ArrayList<Data.ResultTB>();
            Data.ResultTB resultTB1 = new Data.ResultTB();
            Data.ResultTB resultTB2 = new Data.ResultTB();
            WpzfCallBackServiceImpl.completeTB(resultTB1);
            resultTBList.add(resultTB1);
            resultTBList.add(resultTB2);
            data.setResultDKList(resultDKList);
            data.setResultTBList(resultTBList);
            message.setHead(head);
            message.setData(data);
            String s = message.toXml();
            System.out.println("===================");
            System.out.println(s);
            System.out.println("===================");
        }
        catch (Exception e) {
            System.out.println();
        }
        return message;
    }

    private static void completeTB(Data.ResultTB resultTB1) {
        resultTB1.setJCBH("tb11");
        resultTB1.setXFSJ("tb22");
        resultTB1.setSF_SK("tb33");
        resultTB1.setSK_UserName("tb44");
        resultTB1.setSK_UserPhone("tb55");
        resultTB1.setGeoUpdateTime("tb66");
        resultTB1.setSF_QR_CXBH("tb77");
        resultTB1.setGeoDealType("tb88");
        resultTB1.setDK_Count("tb99");
        ArrayList<Data.DK> dkList = new ArrayList<Data.DK>();
        Data.DK dk = new Data.DK();
        dk.setDKBH("dk11");
        dk.setDKMJ("dk22");
        dk.setNYDMJ("dk33");
        dk.setGDMJ("dk44");
        dk.setSTMJ("dk55");
        dk.setYJ_JBNTMJ("dk66");
        dk.setSTBHHXMJ("dk77");
        dk.setShape("POLYGON ((108.51562988500001 22.808178527999985, 108.51562988500001 22.808178527999985))");
        dkList.add(dk);
        resultTB1.setDKList(dkList);
    }

    private static void completeDk(Data.ResultDK resultDK1) {
        Data.DKAttributes attributes = new Data.DKAttributes();
        attributes.setCCFGS_HCR("attr11");
        attributes.setCCFGS_HCSJ("attr22");
        attributes.setDKBH("attr33");
        resultDK1.setDKAttributes(attributes);
        ArrayList<Data.PW> pwList = new ArrayList<Data.PW>();
        Data.PW pw = new Data.PW();
        Data.PW pw2 = new Data.PW();
        pw.setPZWH("pw11");
        pw.setPW_Source("pw22");
        pw.setLocationURL("pw33");
        pw.setPW_URL("pw44");
        pwList.add(pw);
        pwList.add(pw2);
        resultDK1.setPWlist(pwList);
        ArrayList<Data.File> fileList = new ArrayList<Data.File>();
        Data.File file = new Data.File();
        Data.File file2 = new Data.File();
        file.setID("file11");
        file.setX("file22");
        file.setFileURL("file3");
        fileList.add(file);
        fileList.add(file2);
        resultDK1.setFileList(fileList);
    }

    public static String getMD5Checksum(String filePath) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        try (FileInputStream fis = new FileInputStream(filePath);){
            int bytesRead;
            while ((bytesRead = ((InputStream)fis).read(buffer)) != -1) {
                md5Digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] digest = md5Digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

