/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.xzjsydmj;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.model.cffx.dto.AtlasTaskInfo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.cffx.MCffxTaskServiceImpl;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MXzjsydmjServiceImpl
implements MXzjsydmjService {
    private final GiLoger logger = GwLoger.getLoger(MCffxTaskServiceImpl.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${transmit.url:}")
    String transmitUrl;
    @Value(value="${transmit.xzjsydmj.appkey:}")
    String transmitAppkey;
    @Value(value="${transmit.xzjsydmj.module:}")
    String transmitModule;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SysConfigRepository sysConfigRepository;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    String key = "xzjsydmj-config";

    public boolean needXzjsydmj(String taskId) {
        JSONArray jsonArray;
        Optional<Object> op;
        JSONObject jsonConfig;
        SysConfig config = this.sysConfigService.findOne(this.key);
        return config != null && (jsonConfig = JSONObject.parseObject((String)config.getValue())).containsKey((Object)"tasks") && (op = (jsonArray = jsonConfig.getJSONArray("tasks")).stream().filter(t -> taskId.equals(((JSONObject)t).getString("taskId"))).findFirst()).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xzjsydmj(List<String> xzjsydmjSql, String table, String taskId, List<String> fields, String shapeField) {
        if (xzjsydmjSql == null || xzjsydmjSql.isEmpty()) {
            return;
        }
        SqlliteConnTool connTool = null;
        Statement statement = null;
        String destination = this.uploadDir + File.separator + UUID.randomUUID().toString() + ".db";
        try {
            connTool = this.createTable(null, table, fields);
            if (connTool == null) {
                return;
            }
            boolean insertSuc = this.insert(connTool, xzjsydmjSql, table, fields);
            if (!insertSuc) {
                return;
            }
            ArrayList<String> recordFields = new ArrayList<String>();
            recordFields.add("f_record_id");
            connTool = this.createTable(connTool, "task_record", recordFields);
            ArrayList<String> recordSqls = new ArrayList<String>();
            String recordId = UUID.randomUUID().toString();
            recordSqls.add("insert into task_record(f_record_id) values ('" + recordId + "')");
            insertSuc = this.insert(connTool, recordSqls, "task_record", recordFields);
            if (!insertSuc) {
                return;
            }
            statement = connTool.getConnection().createStatement();
            statement.executeUpdate("backup to '" + destination + "'");
            statement.close();
            connTool.Dispose();
            statement = null;
            connTool = null;
            JSONObject httpResult = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(destination), this.transmitUrl + "/monitor/trans/transData.action");
            if (httpResult == null || !"200".equals(httpResult.getString("code"))) {
                this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5931\u8d25,\u53d1\u9001\u6587\u4ef6\u5931\u8d25" + httpResult == null ? "" : httpResult.toJSONString(), new Object[0]);
                return;
            }
            TaskRecord record = new TaskRecord();
            record.setId(recordId);
            record.setTasktype(JobConstants.JOB_TYPE_XZJSYDMJ_INNER_ATLAS);
            record.setState(JobConstants.JOB_STATE_RUNNING);
            record.setBizId(taskId);
            this.taskRecordService.save(record);
        }
        catch (Exception ex) {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connTool != null) {
                    connTool.Dispose();
                }
            }
            catch (Exception e) {
                this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u91ca\u653edb\u5931\u8d25" + ExceptionUtil.getErrorString(e), new Object[0]);
            }
            this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(destination));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resoveInner(File recvFile) throws Exception {
        String resultname = null;
        String tablename = null;
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setTasktype(JobConstants.JOB_TYPE_XZJSYDMJ_INNER_ATLAS);
        record.setState(JobConstants.JOB_STATE_FAILED);
        record.setStarttime(new Date());
        try {
            String dbleft;
            SysConfig sysconfig = this.sysConfigService.findOne(this.key);
            if (sysconfig == null) {
                this.logger.error("\u5185\u7f51\u7f51\u95f4\u4f20\u8f93\u63a5\u6536XZJSYDMJ\u4efb\u52a1\u5904\u7406\u5931\u8d25,\u672a\u914d\u7f6e\u64e6\u9664\u6570\u636e\u53ca\u64e6\u9664\u5206\u6790\u670d\u52a1", new Object[0]);
                return;
            }
            XzjsydmjConfig config = (XzjsydmjConfig)JSONObject.parseObject((String)sysconfig.getValue(), XzjsydmjConfig.class);
            tablename = "temp_xzjs_" + UUID.randomUUID().toString().replace("-", "");
            String dbright = dbleft = this.getDB();
            if (StringUtils.isNotBlank((CharSequence)config.fjsydDb)) {
                dbright = config.fjsydDb;
            }
            resultname = "intersect_" + UUID.randomUUID().toString().replace("-", "");
            if (recvFile != null) {
                String id = this.importDbData(recvFile, tablename);
                record.setId(id);
            }
            String template = this.getTemplate("erase.json");
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("{left}", dbleft + "/" + tablename);
            mapParam.put("{leftPkField}", "aid");
            mapParam.put("{leftShapeField}", "f_shape");
            mapParam.put("{leftWhere}", "1=1");
            mapParam.put("{right}", dbright + "/" + config.fjsydTable);
            mapParam.put("{rightPkField}", config.fjsydPkField);
            mapParam.put("{rightShapeField}", config.fjsydShapeField);
            mapParam.put("{rightWhere}", "1=1");
            mapParam.put("{result}", resultname);
            mapParam.put("{resultdb}", dbleft + "/" + resultname);
            for (Map.Entry kv : mapParam.entrySet()) {
                template = template.replace((CharSequence)kv.getKey(), (CharSequence)kv.getValue());
            }
            this.logger.info("atlas service url:" + config.atlasUrl + " param:" + template, new Object[0]);
            String result = cn.hutool.http.HttpUtil.createPost((String)config.atlasUrl).body(template).execute().body();
            this.logger.info("atlas service url:" + config.atlasUrl + " http result: " + result, new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    TempParam param = new TempParam();
                    param.setAtlasId(taskId);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(1);
                    record.setParam(JSONObject.toJSONString((Object)param));
                    record.setState(JobConstants.JOB_STATE_CREATE);
                } else {
                    TempParam param = new TempParam();
                    param.setAtlasId(null);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(3);
                    record.setParam(JSONObject.toJSONString((Object)param));
                    record.setState(JobConstants.JOB_STATE_FAILED);
                    record.setLog("\u521b\u5efaatlas\u4efb\u52a1\u5931\u8d25");
                    TableUtil.dropTable(tablename, this.jdbcTemplate);
                }
            }
        }
        catch (Exception ex) {
            String msg;
            if (StringUtils.isNotBlank(tablename)) {
                TableUtil.dropTable(tablename, this.jdbcTemplate);
            }
            if (StringUtils.isBlank((CharSequence)(msg = ex.getMessage()))) {
                msg = ExceptionUtil.getStackTrace(ex);
            }
            record.setState(JobConstants.JOB_STATE_FAILED);
            this.logger.error("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8ba1\u7b97\u5931\u8d25\n" + msg, new Object[0]);
            if (msg.length() > 1000) {
                msg = msg.substring(0, 1000);
            }
            record.setLog(msg);
        }
        finally {
            this.taskRecordService.save(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTaskInner(TaskRecord record) {
        SysConfig sysconfig = this.sysConfigService.findOne(this.key);
        if (sysconfig == null) {
            this.logger.error("\u5185\u7f51\u7f51\u95f4\u4f20\u8f93\u63a5\u6536XZJSYDMJ\u4efb\u52a1\u5904\u7406\u5931\u8d25,\u672a\u914d\u7f6e\u64e6\u9664\u6570\u636e\u53ca\u64e6\u9664\u5206\u6790\u670d\u52a1", new Object[0]);
            return;
        }
        TempParam param = (TempParam)JSONObject.parseObject((String)record.getParam(), TempParam.class);
        if (param.getAtlasState() == null) return;
        if (!param.getAtlasState().equals(1)) return;
        XzjsydmjConfig config = (XzjsydmjConfig)JSONObject.parseObject((String)sysconfig.getValue(), XzjsydmjConfig.class);
        String atlasId = param.getAtlasId();
        String atlasUrl = config.atlasUrl;
        String url = atlasUrl.substring(0, atlasUrl.indexOf("/analysis"));
        url = url + "/task/get?id=" + atlasId;
        HttpRequest get = cn.hutool.http.HttpUtil.createGet((String)url);
        HttpResponse execute = get.execute();
        String bodyStr = execute.body();
        if (execute.getStatus() != 200) return;
        JSONObject body = JSONObject.parseObject((String)bodyStr);
        if (!body.get((Object)"code").equals(200)) return;
        AtlasTaskInfo taskDto = (AtlasTaskInfo)JSONObject.parseObject((String)body.get((Object)"data").toString(), AtlasTaskInfo.class);
        if (taskDto.getFinished().booleanValue()) {
            if (taskDto.getSucceed().booleanValue()) {
                param.setAtlasState(2);
                record.setParam(JSONObject.toJSONString((Object)param));
                record.setState(JobConstants.JOB_STATE_RUNNING);
            } else {
                param.setAtlasState(3);
                record.setParam(JSONObject.toJSONString((Object)param));
                record.setState(JobConstants.JOB_STATE_FAILED);
                TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
            }
        }
        this.taskRecordService.save(record);
        String destination = null;
        try {
            if (!param.getAtlasState().equals(2)) return;
            String resultTable = param.getResultTable();
            ArrayList<String> fields = new ArrayList<String>();
            fields.add("mj");
            fields.add("f_id");
            fields.add("f_taskid");
            fields.add("f_split");
            List maps = this.jdbcTemplate.queryForList("select f_taskid,f_id,f_split,sum(shapearean) as mj from " + resultTable + " group by f_taskid, f_id,f_split");
            destination = this.uploadDir + File.separator + record.getId() + ".db";
            this.xzjsydmj(destination, maps, fields, record.getId());
            JSONObject httpResult = HttpUtil.sendRrquestByFile(this.transmitAppkey, this.transmitModule, new File(destination), this.transmitUrl + "/monitor/trans/transData.action");
            if (httpResult != null && "200".equals(httpResult.getString("code"))) {
                record.setState(JobConstants.JOB_STATE_SUCCESS);
                this.taskRecordService.save(record);
                return;
            }
            this.logger.error("\u53d1\u9001\u6587\u4ef6\u5931\u8d25" + httpResult == null ? "" : httpResult.toJSONString(), new Object[0]);
            record.setLog("\u53d1\u9001\u6587\u4ef6\u5931\u8d25");
            record.setState(JobConstants.JOB_STATE_FAILED);
            this.taskRecordService.save(record);
            TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
            TableUtil.dropTable(param.resultTable, this.jdbcTemplate);
            FileUtils.deleteQuietly((File)new File(destination));
            return;
        }
        catch (Exception ex) {
            this.logger.error("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8ba1\u7b97\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
            record.setLog("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8ba1\u7b97\u5931\u8d25");
            record.setState(JobConstants.JOB_STATE_FAILED);
            this.taskRecordService.save(record);
            TableUtil.dropTable(param.tempTable, this.jdbcTemplate);
            TableUtil.dropTable(param.resultTable, this.jdbcTemplate);
            return;
        }
        finally {
            FileUtils.deleteQuietly((File)new File(destination));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resoveOuter(File recvFile) throws Exception {
        SqlliteConnTool connTool;
        TaskRecord taskRecord;
        block18: {
            taskRecord = null;
            connTool = new SqlliteConnTool(recvFile.getAbsolutePath());
            Object recordObj = connTool.queryScale("select f_record_id from task_record");
            String recordId = recordObj == null ? "" : recordObj.toString();
            taskRecord = this.taskRecordService.findOne(recordId);
            if (taskRecord != null) break block18;
            this.logger.error("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u4efb\u52a1:" + recordId + "\u4e0d\u5b58\u5728", new Object[0]);
            this.taskRecordService.save(taskRecord);
            return;
        }
        try {
            JSONArray jsonArray;
            Optional<Object> op;
            JSONObject jsonConfig;
            String bizId = taskRecord.getBizId();
            TskTaskBiz task = this.tskTaskBizService.findByTaskId(bizId);
            if (task == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,\u4e1a\u52a1\u4efb\u52a1:" + bizId + "\u4e0d\u5b58\u5728", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,\u4e1a\u52a1\u4efb\u52a1:" + bizId + "\u4e0d\u5b58\u5728");
            }
            TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            if (objectinfo == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,\u4e1a\u52a1\u4efb\u52a1:" + bizId + "\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,\u4e1a\u52a1\u4efb\u52a1:" + bizId + "\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            String xzjsydmjField = null;
            SysConfig config = this.sysConfigService.findOne(this.key);
            if (config != null && (jsonConfig = JSONObject.parseObject((String)config.getValue())).containsKey((Object)"tasks") && (op = (jsonArray = jsonConfig.getJSONArray("tasks")).stream().filter(t -> bizId.equals(((JSONObject)t).getString("taskId"))).findFirst()).isPresent()) {
                xzjsydmjField = ((JSONObject)op.get()).getString("xzjsydmjField");
            }
            if (StringUtils.isBlank(xzjsydmjField)) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5b57\u6bb5\u4e3a\u7a7a", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (!connTool.isTableExist("xzjsydmj")) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e0d\u5b58\u5728", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e0d\u5b58\u5728");
            }
            Object obj = connTool.queryScale("select count(*) as count from xzjsydmj");
            if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a");
            }
            int count = Integer.parseInt(obj.toString());
            if (count == 0) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a");
            }
            ResultSetInfo resutSetInfo = connTool.doQuery("select * from xzjsydmj");
            if (resutSetInfo == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25");
            }
            ResultSet resultSet = resutSetInfo.getResultSet();
            if (resultSet == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25");
            }
            DecimalFormat df = new DecimalFormat("#.00");
            while (resultSet.next()) {
                String tbid = resultSet.getString("f_id");
                String split = resultSet.getString("f_split");
                Double mj = resultSet.getDouble("mj");
                String mjStr = df.format(mj);
                if ("0".equals(split)) {
                    this.jdbcTemplate.execute("update " + objectinfo.getfTablename() + " set " + xzjsydmjField + " = " + mjStr + " where f_id ='" + tbid + "'");
                    continue;
                }
                if (!"1".equals(split)) continue;
                this.jdbcTemplate.execute("update " + objectinfo.getfTablename() + "_child set " + xzjsydmjField + " = " + mjStr + " where f_id ='" + tbid + "'");
            }
            taskRecord.setState(JobConstants.JOB_STATE_SUCCESS);
        }
        catch (Exception ex) {
            try {
                String msg = ex.getMessage();
                if (StringUtils.isBlank((CharSequence)msg)) {
                    msg = ExceptionUtil.getStackTrace(ex);
                }
                taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8ba1\u7b97\u5931\u8d25\n" + msg, new Object[0]);
                if (msg.length() > 1000) {
                    msg = msg.substring(0, 1000);
                }
                taskRecord.setLog(msg);
            }
            catch (Throwable throwable) {
                this.taskRecordService.save(taskRecord);
                throw throwable;
            }
            this.taskRecordService.save(taskRecord);
        }
        this.taskRecordService.save(taskRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xzjsydmj(String dbPath, List<Map<String, Object>> maps, List<String> fields, String recordId) throws Exception {
        SqlliteConnTool connTool = null;
        Statement statement = null;
        try {
            ArrayList<String> recordFields = new ArrayList<String>();
            recordFields.add("f_record_id");
            connTool = this.createTable(null, "task_record", recordFields);
            if (connTool == null) {
                throw new Exception("\u521b\u5efa\u4efb\u52a1\u8bb0\u5f55\u8868\u5931\u8d25");
            }
            ArrayList<String> recordSqls = new ArrayList<String>();
            recordSqls.add("insert into task_record(f_record_id) values ('" + recordId + "')");
            boolean insertSuc = this.insert(connTool, recordSqls, "task_record", recordFields);
            if (!insertSuc) {
                throw new Exception("\u5199\u4efb\u52a1\u8bb0\u5f55\u8868\u5931\u8d25");
            }
            if ((connTool = this.createTable(connTool, "xzjsydmj", fields)) == null) {
                throw new Exception("\u521b\u5efa\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8868\u5931\u8d25");
            }
            ArrayList<String> xzjsydmjSql = new ArrayList<String>();
            for (Map<String, Object> m : maps) {
                String insert = "insert into xzjsydmj (";
                String values = "";
                int index = 0;
                int size = fields.size();
                for (String f : fields) {
                    insert = insert + f;
                    values = values + "'" + m.get(f).toString() + "'";
                    if (++index >= size) continue;
                    insert = insert + ",";
                    values = values + ",";
                }
                insert = insert + ") values (" + values + ")";
                xzjsydmjSql.add(insert);
                if (xzjsydmjSql.size() != 100) continue;
                insertSuc = this.insert(connTool, xzjsydmjSql, "xzjsydmj", fields);
                if (!insertSuc) {
                    throw new Exception("\u5199\u5165\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8868\u5931\u8d25");
                }
                xzjsydmjSql.clear();
            }
            insertSuc = this.insert(connTool, xzjsydmjSql, "xzjsydmj", fields);
            if (!insertSuc) {
                throw new Exception("\u5199\u5165\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u8868\u5931\u8d25");
            }
            xzjsydmjSql.clear();
            statement = connTool.getConnection().createStatement();
            statement.executeUpdate("backup to '" + dbPath + "'");
            statement.close();
            connTool.Dispose();
            statement = null;
            connTool = null;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connTool != null) {
                    connTool.Dispose();
                }
            }
            catch (Exception e) {
                this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u91ca\u653edb\u5931\u8d25" + ExceptionUtil.getErrorString(e), new Object[0]);
            }
        }
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String importDbData(File file, String tableName) throws Exception {
        SqlliteConnTool connTool = null;
        ResultSetInfo resutSetInfo = null;
        try {
            String recordId;
            String db = file.getAbsolutePath();
            connTool = new SqlliteConnTool(db);
            Object recordObj = connTool.queryScale("select f_record_id from task_record");
            String string = recordId = recordObj == null ? "" : recordObj.toString();
            if (!connTool.isTableExist("xzjsydmj")) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e0d\u5b58\u5728", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e0d\u5b58\u5728");
            }
            Object obj = connTool.queryScale("select count(*) as count from xzjsydmj");
            if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a");
            }
            int count = Integer.parseInt(obj.toString());
            if (count == 0) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u4e3a\u7a7a");
            }
            resutSetInfo = connTool.doQuery("select * from xzjsydmj");
            if (resutSetInfo == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25");
            }
            ResultSet resultSet = resutSetInfo.getResultSet();
            if (resultSet == null) {
                this.logger.error("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25", new Object[0]);
                throw new RuntimeException("\u65b0\u589e\u5efa\u8bbe\u9762\u79ef\u8ba1\u7b97\u5f02\u5e38,db\u5185\u8868:xzjsydmj\u8bfb\u53d6\u5931\u8d25");
            }
            Map<String, String> mapFields = this.getTableColumns();
            this.createShpTable(mapFields, this.jdbcTemplate, tableName);
            List fields = mapFields.keySet().stream().collect(Collectors.toList());
            ArrayList tbList = new ArrayList();
            while (resultSet.next()) {
                HashMap<String, String> tb = new HashMap<String, String>();
                for (String f : fields) {
                    String v = resultSet.getString(f);
                    if (f.equals("f_shape") && !v.toLowerCase().startsWith("srid")) {
                        v = "srid=4490;" + v;
                    }
                    tb.put(f, v);
                }
                tbList.add(tb);
                if (tbList.size() != 100) continue;
                this.dataBizMapper.insertBatch(tableName, tbList, "f_shape");
                tbList.clear();
            }
            if (!tbList.isEmpty()) {
                this.dataBizMapper.insertBatch(tableName, tbList, "f_shape");
                tbList.clear();
            }
            String string2 = recordId;
            return string2;
        }
        finally {
            if (resutSetInfo != null) {
                resutSetInfo.Close();
            }
            if (connTool != null) {
                connTool.Dispose();
            }
        }
    }

    private void createShpTable(Map<String, String> mapFields, JdbcTemplate jdbcTemplate, String tableName) {
        if (!TableUtil.tableExist(tableName, jdbcTemplate)) {
            String sql = "create table " + tableName + " (";
            for (Map.Entry<String, String> kv : mapFields.entrySet()) {
                sql = sql + kv.getKey() + " " + kv.getValue() + ",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql = sql + " )";
            jdbcTemplate.execute(sql);
            jdbcTemplate.execute("select updategeometrysrid('" + tableName + "','f_shape',4490)");
            TableUtil.createSequence(tableName, "aid", tableName + "_aid", jdbcTemplate);
        }
    }

    private String getTemplate(String fileName) {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/" + fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u5206\u6790\u6a21\u578b\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
            return null;
        }
    }

    private Map<String, String> getTableColumns() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("f_id", "varchar(100) NULL");
        fields.put("f_taskid", "varchar(100) NULL");
        fields.put("f_split", "varchar(100) NULL");
        fields.put("f_shape", "public.geometry NOT NULL");
        return fields;
    }

    private SqlliteConnTool createTable(SqlliteConnTool dbHelper, String table, List<String> fields) {
        try {
            if (dbHelper == null) {
                dbHelper = new SqlliteConnTool();
            }
            dbHelper.beginTransaction();
            String sql = "CREATE TABLE " + table + "(";
            int i = 0;
            for (String f : fields) {
                sql = sql + f + " text";
                if (++i >= fields.size()) continue;
                sql = sql + ",";
            }
            sql = sql + ")";
            dbHelper.doSql(sql);
            return dbHelper;
        }
        catch (Exception ex) {
            if (dbHelper != null) {
                dbHelper.rollback();
            }
            this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5931\u8d25,create table error" + ExceptionUtil.getErrorString(ex), new Object[0]);
            return null;
        }
    }

    private boolean insert(SqlliteConnTool dbHelper, List<String> xzjsydmjSql, String table, List<String> fields) {
        try {
            dbHelper.beginTransaction();
            int i = 0;
            int page = (int)Math.ceil((double)xzjsydmjSql.size() * 1.0 / 100.0);
            for (i = 0; i < page; ++i) {
                int from = i * 100;
                int to = (i + 1) * 100;
                if (to >= xzjsydmjSql.size()) {
                    to = xzjsydmjSql.size();
                }
                List<String> subSql = xzjsydmjSql.subList(from, to);
                dbHelper.doSql(String.join((CharSequence)";", subSql));
            }
            dbHelper.commit();
            return true;
        }
        catch (Exception ex) {
            if (dbHelper != null) {
                dbHelper.rollback();
            }
            this.logger.error("\u8ba1\u7b97\u65b0\u589e\u5efa\u8bbe\u7528\u5730\u9762\u79ef\u5931\u8d25,insert sql error" + ExceptionUtil.getErrorString(ex), new Object[0]);
            return false;
        }
    }

    private class TempParam {
        private String atlasId;
        private String tempTable;
        private String resultTable;
        private Integer atlasState;

        private TempParam() {
        }

        public String getAtlasId() {
            return this.atlasId;
        }

        public void setAtlasId(String atlasId) {
            this.atlasId = atlasId;
        }

        public String getTempTable() {
            return this.tempTable;
        }

        public void setTempTable(String tempTable) {
            this.tempTable = tempTable;
        }

        public String getResultTable() {
            return this.resultTable;
        }

        public void setResultTable(String resultTable) {
            this.resultTable = resultTable;
        }

        public Integer getAtlasState() {
            return this.atlasState;
        }

        public void setAtlasState(Integer atlasState) {
            this.atlasState = atlasState;
        }
    }

    public class XzjsydmjConfig {
        private String atlasUrl;
        private String fjsydDb;
        private String fjsydTable;
        private String fjsydShapeField;
        private String fjsydPkField;

        public String getAtlasUrl() {
            return this.atlasUrl;
        }

        public void setAtlasUrl(String atlasUrl) {
            this.atlasUrl = atlasUrl;
        }

        public String getFjsydDb() {
            return this.fjsydDb;
        }

        public void setFjsydDb(String fjsydDb) {
            this.fjsydDb = fjsydDb;
        }

        public String getFjsydTable() {
            return this.fjsydTable;
        }

        public void setFjsydTable(String fjsydTable) {
            this.fjsydTable = fjsydTable;
        }

        public String getFjsydShapeField() {
            return this.fjsydShapeField;
        }

        public void setFjsydShapeField(String fjsydShapeField) {
            this.fjsydShapeField = fjsydShapeField;
        }

        public String getFjsydPkField() {
            return this.fjsydPkField;
        }

        public void setFjsydPkField(String fjsydPkField) {
            this.fjsydPkField = fjsydPkField;
        }
    }
}

