/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.zhdd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.zhdd.dto.DroneAlarmInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DroneAlarmStatisticalInfo;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDroneAlarm;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueGroupService;
import com.geoway.landteam.landcloud.servface.zhdd.DroneAlarmService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFieldGroupView;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DroneAlarmServiceImpl
implements DroneAlarmService {
    @Value(value="${clue.drone.id}")
    String droneClue;
    @Value(value="${clue.drone.ywfl:f_ywfl}")
    String droneClueYwfl;
    @Value(value="${clue.drone.location:f_location}")
    String droneClueLocation;
    @Autowired
    JcClueSourceService jcClueSourceService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    MJcClueGroupService jcClueGroupService;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    AppMediaDao appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    public DroneAlarmStatisticalInfo statistical() throws Exception {
        JcClueSource clueSource = this.jcClueSourceService.findOne(this.droneClue);
        if (clueSource == null) {
            throw new Exception("\u65e0\u4eba\u673a\u9884\u8b66\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        String tableName = clueSource.getfTablename();
        List maps = this.jdbcTemplate.queryForList("select " + this.droneClueYwfl + ",count(*) as f_count from " + tableName + " group by " + this.droneClueYwfl);
        DroneAlarmStatisticalInfo result = new DroneAlarmStatisticalInfo();
        result.setTotalCount(Integer.valueOf(0));
        result.setHyCount(Integer.valueOf(0));
        result.setKsCount(Integer.valueOf(0));
        result.setHyCount(Integer.valueOf(0));
        if (maps != null) {
            int totalCount = 0;
            for (Map map : maps) {
                Integer count = Integer.parseInt(map.get("f_count").toString());
                totalCount += count.intValue();
                String ywfl = map.get(this.droneClueYwfl) == null ? "" : map.get(this.droneClueYwfl).toString();
                if (!StringUtils.isNotBlank((CharSequence)ywfl)) continue;
                EnumDroneAlarm enumDroneAlarm = EnumDroneAlarm.valueOfName((String)ywfl);
                switch (enumDroneAlarm) {
                    case ks: {
                        result.setKsCount(count);
                        break;
                    }
                    case td: {
                        result.setTdCount(count);
                        break;
                    }
                    case hy: {
                        result.setHyCount(count);
                    }
                }
            }
            result.setTotalCount(Integer.valueOf(totalCount));
        }
        return result;
    }

    public List<Map<String, Object>> getShapes(Integer type) throws Exception {
        JcClueSource clueSource = this.jcClueSourceService.findOne(this.droneClue);
        if (clueSource == null) {
            throw new Exception("\u65e0\u4eba\u673a\u9884\u8b66\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        String tableName = clueSource.getfTablename();
        String where = "1=1";
        if (type == null || EnumDroneAlarm.all.getCode().equals(type)) {
            where = "1=1";
        } else if (type != null && EnumDroneAlarm.td.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.td.getName() + "'";
        } else if (type != null && EnumDroneAlarm.ks.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.ks.getName() + "'";
        } else if (type != null && EnumDroneAlarm.hy.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.hy.getName() + "'";
        }
        return this.jdbcTemplate.queryForList("select f_id,st_astext(f_shape) as f_shape from " + tableName + " where " + where);
    }

    public JSONObject getDetail(String id) throws Exception {
        JcClueSource clueSource = this.jcClueSourceService.findOne(this.droneClue);
        if (clueSource == null) {
            throw new Exception("\u65e0\u4eba\u673a\u9884\u8b66\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        String tableName = clueSource.getfTablename();
        List fieldGroupViews = this.jcClueGroupService.getFieldGroupByGroupCode(this.droneClue, "202");
        List jcFields = this.jcClueFieldsService.findByTableId(this.droneClue);
        JSONArray fieldArray = new JSONArray();
        for (JcClueFieldGroupView fg : fieldGroupViews) {
            JcClueFields f = jcFields.stream().filter(t -> t.getfFieldname().equals(fg.getfFieldname())).findFirst().orElse(null);
            if (f == null) continue;
            JSONObject fJson = (JSONObject)JSONObject.toJSON((Object)f);
            fJson.put("fGroup", (Object)fg.getfSubgroupname());
            fJson.put("fGroupOrder", (Object)fg.getfGrouporder());
            fieldArray.add((Object)fJson);
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List appMedias = new ArrayList();
        appMedias = this.appMediaDao.queryByGalleryids(ids);
        if (appMedias.size() > 0) {
            for (AppMedia appMedia : appMedias) {
                String url;
                if (appMedia.getServerpath() == null || appMedia.getServerpath().contains("AccessKeyId") || !StringUtils.isNotBlank((CharSequence)(url = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null)))) continue;
                appMedia.setServerpath(url);
            }
        }
        List fieldList = jcFields.stream().map(t -> t.getfFieldname()).collect(Collectors.toList());
        Map map = this.dataBizMapper.selectFieldByID(tableName, fieldList, "f_id", "'" + id + "'");
        JSONObject result = new JSONObject();
        result.put("tbInfo", (Object)map);
        result.put("fields", (Object)fieldArray);
        result.put("medias", appMedias);
        return result;
    }

    public JSONObject listPage(Integer type, Integer orderType, String time, Integer page, Integer rows) throws Exception {
        int count;
        JcClueSource clueSource = this.jcClueSourceService.findOne(this.droneClue);
        if (clueSource == null) {
            throw new Exception("\u65e0\u4eba\u673a\u9884\u8b66\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String tableName = clueSource.getfTablename();
        String where = "1=1";
        if (type == null || EnumDroneAlarm.all.getCode().equals(type)) {
            where = "1=1";
        } else if (type != null && EnumDroneAlarm.td.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.td.getName() + "'";
        } else if (type != null && EnumDroneAlarm.ks.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.ks.getName() + "'";
        } else if (type != null && EnumDroneAlarm.hy.getCode().equals(type)) {
            where = this.droneClueYwfl + " = '" + EnumDroneAlarm.hy.getName() + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)time)) {
            Date date = df.parse(time);
            long start = date.getTime() / 1000L;
            long end = start + 86400L;
            where = where + " and f_createtime >" + start + " and f_createtime<" + end;
        }
        String countSql = "select count(*) as f_count from " + tableName + " where " + where;
        Map map = this.jdbcTemplate.queryForMap(countSql);
        JSONObject result = new JSONObject();
        int n = count = map.get("f_count") == null ? 0 : Integer.parseInt(map.get("f_count").toString());
        if (count > 0) {
            int offset = (page - 1) * rows;
            int limit = rows;
            String sql = "select f_id,f_createtime," + this.droneClueLocation + " from " + tableName + " where " + where + " order by f_createtime " + (orderType != null && orderType.equals(0) ? "asc" : "desc") + " offset " + offset + " limit " + limit;
            List maps = this.jdbcTemplate.queryForList(sql);
            if (maps != null) {
                List medias;
                Calendar calendar = Calendar.getInstance();
                ArrayList<String> ids = new ArrayList<String>();
                ArrayList<DroneAlarmInfo> alarmInfos = new ArrayList<DroneAlarmInfo>();
                for (Map m : maps) {
                    String id = m.get("f_id").toString();
                    long createtime = Long.parseLong(m.get("f_createtime").toString());
                    String location = m.get(this.droneClueLocation) != null ? m.get(this.droneClueLocation).toString() : "";
                    calendar.setTimeInMillis(createtime * 1000L);
                    String cc = df.format(calendar.getTime());
                    DroneAlarmInfo alarmInfo = new DroneAlarmInfo();
                    alarmInfo.setId(id);
                    alarmInfo.setTime(cc);
                    alarmInfo.setLocation(location);
                    alarmInfos.add(alarmInfo);
                    ids.add(id);
                }
                if (!ids.isEmpty() && (medias = this.appMediaDao.queryByGalleryids(ids)) != null && !medias.isEmpty()) {
                    Map<String, List<AppMedia>> mapMedias = medias.stream().collect(Collectors.groupingBy(t -> t.getGalleryid()));
                    for (DroneAlarmInfo a : alarmInfos) {
                        if (!mapMedias.containsKey(a.getId())) continue;
                        AppMedia media = mapMedias.get(a.getId()).get(0);
                        String url = this.temporarySignedUrlService.getTemporarySignedUrl(null, media.getServerpath(), null);
                        a.setFjUrl(url);
                    }
                }
                result.put("data", alarmInfos);
            }
        }
        result.put("totalCount", (Object)count);
        return result;
    }

    public List<Map<String, Object>> mapCollect(String level, String leftTopX, String leftTopY, String rightBotX, String rightBotY) throws Exception {
        JcClueSource clueSource = this.jcClueSourceService.findOne(this.droneClue);
        if (clueSource == null) {
            throw new Exception("\u65e0\u4eba\u673a\u9884\u8b66\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        String tableName = clueSource.getfTablename();
        List maps = new ArrayList();
        if (Double.valueOf(level) <= 15.0) {
            String sql = "with t1 as (select f_id, st_x(st_centroid(f_shape)) as f_lon, st_y(st_centroid(f_shape)) as f_lat,f_shape from " + tableName + ")\nSELECT \nwidth_bucket(f_lon, " + leftTopX + " ," + rightBotX + " ,20) grid_x, \nwidth_bucket(f_lat, " + rightBotY + " , " + leftTopY + ", 20) grid_y,  \ncount(*),\nst_astext(st_centroid(st_collect(f_shape))) f_shape\nfrom t1\nwhere \nf_shape is not null and \nf_lon between " + leftTopX + " and " + rightBotX + " \nand \nf_lat between " + rightBotY + "  and " + leftTopY + " \nGROUP BY grid_x,grid_y";
            maps = this.jdbcTemplate.queryForList(sql);
        } else {
            String polygon = "SRID=4490;POLYGON((" + leftTopX + " " + leftTopY + "," + leftTopX + " " + rightBotY + "," + rightBotX + " " + rightBotY + "," + rightBotX + " " + leftTopY + "," + leftTopX + " " + leftTopY + "))";
            String query = "select f_id,st_astext(f_shape) as f_shape from " + tableName + " where st_intersects(st_geometryfromtext('" + polygon + "'),f_shape) = 'true'";
            maps = this.jdbcTemplate.queryForList(query);
        }
        return maps;
    }
}

