/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.zhdd;

import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.service.util.HmacUtil;
import com.geoway.landteam.landcloud.service.util.SpringContextHolder;
import com.meizu.push.sdk.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GetSignUtils {
    private static final String APP_KEY = "ttAppKey";
    private static final String APP_SECRET = "ttAppSecret";
    private static final String CUSTOMER_CODE = "ttCustomerCode";
    private static final String USER_CODE = "ttUserCode";

    public static Map<String, String> getHeaders(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        SysConfigService configService = SpringContextHolder.getBean(SysConfigService.class);
        SysConfig key = configService.findOne(APP_KEY);
        SysConfig secret = configService.findOne(APP_SECRET);
        SysConfig customerCode = configService.findOne(CUSTOMER_CODE);
        SysConfig userCode = configService.findOne(USER_CODE);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (key != null && secret != null && StringUtils.isNotBlank((CharSequence)key.getValue()) && StringUtils.isNotBlank((CharSequence)secret.getValue())) {
            String msgId = UUID.randomUUID().toString().toUpperCase();
            String requestTime = sf.format(new Date());
            String appKey = key.getValue();
            String appSecret = secret.getValue();
            String cCode = "";
            String uCode = "";
            if (customerCode != null && StringUtils.isNotBlank((CharSequence)customerCode.getValue())) {
                cCode = customerCode.getValue();
                map.put("X-CustomerCode", cCode);
            }
            if (userCode != null && StringUtils.isNotBlank((CharSequence)userCode.getValue())) {
                uCode = userCode.getValue();
                map.put("X-UserCode", uCode);
            }
            String temp = (path + appKey + msgId + requestTime + cCode + uCode).toUpperCase();
            String signature = HmacUtil.hmacSha1(temp, appSecret);
            map.put("X-MsgId", msgId);
            map.put("X-RequestTime", requestTime);
            map.put("X-AppKey", appKey);
            map.put("X-Signature", signature);
        }
        return map;
    }

    static String replacePath(String path, String deviceCode, String channelCode) {
        path = path.replace("{deviceCode}", "%s");
        path = path.replace("{channelCode}", "%s");
        path = String.format(path, deviceCode, channelCode);
        return path;
    }

    public static void main(String[] args) {
        String orginalpath = "/VIDEO-APPLY-API/devices/{deviceCode}/channels/{channelCode}/getVideoRealtimeUrl";
        String path = GetSignUtils.replacePath(orginalpath, "50011800831327000045", "50011800001310000018");
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String msgId = UUID.randomUUID().toString().toUpperCase();
        String requestTime = sf.format(new Date());
        String appKey = "e44e373cd2fc48329658e13ec451b73d";
        String appSecret = "2f810e5cc17b451ab3903106d672b20d";
        String cCode = "121109315";
        String uCode = "";
        map.put("X-CustomerCode", "121109315");
        String temp = (path + appKey + msgId + requestTime + cCode + uCode).toUpperCase();
        String signature = HmacUtil.hmacSha1(temp, appSecret);
        map.put("X-MsgId", msgId);
        map.put("X-RequestTime", requestTime);
        map.put("X-AppKey", appKey);
        map.put("X-Signature", signature);
        System.out.println(map);
    }
}

