/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.zhdd;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsGroupViewRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.pub.TbsysUserSubjectRelDao;
import com.geoway.landteam.landcloud.dao.zhdd.TbtskDispatchAttachDao;
import com.geoway.landteam.landcloud.dao.zhdd.TbtskDispatchInfoDao;
import com.geoway.landteam.landcloud.dao.zhdd.TbtskDispatchRecordDao;
import com.geoway.landteam.landcloud.dao.zhdd.TbtskDispatchTbTempDao;
import com.geoway.landteam.landcloud.dao.zhdd.TbtskDispatchUserDao;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchAttachDto;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchCreateInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchResultDto;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchResultInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchTaskInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchTaskSearchInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchTbDto;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchTbInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DispatchTbSearchInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.KsManageData;
import com.geoway.landteam.landcloud.model.zhdd.dto.LineJobParamDetailInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.LineJobParamInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.OnlineUserInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.QuotaDataDto;
import com.geoway.landteam.landcloud.model.zhdd.dto.SumRegionTaskDispatch;
import com.geoway.landteam.landcloud.model.zhdd.dto.TaskTbInfo;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDispatchSource;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDispatchType;
import com.geoway.landteam.landcloud.model.zhdd.entity.TbtskDispatchAttach;
import com.geoway.landteam.landcloud.model.zhdd.entity.TbtskDispatchInfo;
import com.geoway.landteam.landcloud.model.zhdd.entity.TbtskDispatchRecord;
import com.geoway.landteam.landcloud.model.zhdd.entity.TbtskDispatchTbTemp;
import com.geoway.landteam.landcloud.model.zhdd.entity.TbtskDispatchUser;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskAssignService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.servface.zhdd.TbtskDispatchService;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.GeometryTrasnUtil;
import com.geoway.landteam.landcloud.service.util.ShpObject;
import com.geoway.landteam.landcloud.service.util.ShpUtil;
import com.geoway.landteam.landcloud.service.util.excel.EnumTextLocation;
import com.geoway.landteam.landcloud.service.util.excel.ExcelColData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelRowData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelUtil;
import com.geoway.landteam.landcloud.service.zhdd.GetSignUtils;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.gpa.entity.GiEntityRemovable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TbtskDispatchServiceImpl
implements TbtskDispatchService {
    private final GiLoger logger = GwLoger.getLoger(TbtskDispatchServiceImpl.class);
    @Value(value="${project.downloadDir}")
    String localDownload;
    @Value(value="${project.uploadDir}")
    String localUpload;
    @Value(value="${third.url.ygb}")
    String ygbUrl;
    @Value(value="${third.url.fc}")
    String fcUrl;
    @Value(value="${third.url.dj}")
    String djUrl;
    private final String SERVICE_PATH = "ttServerPath";
    private final String X_Auth_Token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w";
    private final String namespaceId = "a9fa7f5236d62437d9896f6a45a3bd3d7";
    private final String ddTaskId = "f7518261-2daa-4aeb-b7a1-67c72edb464b";
    @Resource
    TbtskDispatchInfoDao dispatchInfoDao;
    @Resource
    TbtskDispatchTbTempDao dispatchTbTempDao;
    @Resource
    TbtskDispatchRecordDao dispatchRecordDao;
    @Resource
    TbtskDispatchUserDao dispatchUserDao;
    @Resource
    TbtskDispatchAttachDao dispatchAttachDao;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DataBizService dataBizService;
    @Autowired
    OauthUserService oauthUserService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;
    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Resource
    TbtskFieldsGroupViewRepository tbtskFieldsGroupViewRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbsysUserSubjectRelRepository tbsysUserSubjectRelRepository;
    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;
    @Resource
    AppMediaDao appMediaDao;
    @Autowired
    ImportOtherDataService importOtherDataService;
    @Autowired
    OssConfigRepository ossConfigRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Resource
    UserNameService userNameService;
    @Autowired
    MITaskAssignService taskAssignService;
    @Autowired
    TbsysUserSubjectRelDao tbsysUserSubjectRelDao;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TaskAssignJobService taskAssignJobService;
    private static Map<String, OssConfig> mapOssConfig = new HashMap<String, OssConfig>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDataAssign() throws Exception {
        TaskRecord record = this.taskRecordService.findOne("376d92d5-3bd4-40ea-bfb7-29e1a1f3ae78");
        try {
            record.setThreadstarttime(new Date());
            record.setState(Integer.valueOf(2));
            this.taskRecordService.save(record);
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            if ("checkFilter".equalsIgnoreCase(paramsObject.getString("filterType"))) {
                TaskDataDbParameter taskDataDbParameter = (TaskDataDbParameter)JSONObject.parseObject((String)paramsObject.getString("TaskDataDbParameter"), TaskDataDbParameter.class);
                this.taskAssignJobService.AssignData(taskDataDbParameter);
            } else if ("conditionFilter".equalsIgnoreCase(paramsObject.getString("filterType"))) {
                this.taskAssignJobService.assignDataByCondition(paramsObject);
            }
            this.taskRecordService.state2Success(record.getId());
        }
        catch (Exception e) {
            try {
                this.taskRecordService.state2Fail(record.getId(), e.getMessage());
            }
            catch (Throwable throwable) {
                this.logger.info("rateJobAssignTask--- \u7ed3\u675f: {}", new Object[]{record.getId()});
                throw throwable;
            }
            this.logger.info("rateJobAssignTask--- \u7ed3\u675f: {}", new Object[]{record.getId()});
        }
        this.logger.info("rateJobAssignTask--- \u7ed3\u675f: {}", new Object[]{record.getId()});
    }

    public List<Object> findKsjcYear() {
        String sql = "select distinct EXTRACT(year FROM f_fxsj) AS val FROM tbtsk_task_znglrw_20240731183049311 order by EXTRACT(year FROM f_fxsj)";
        List ls = this.jdbcTemplate.queryForList(sql);
        ArrayList<Object> res = new ArrayList<Object>();
        if (ls != null) {
            for (Map map : ls) {
                res.add(map.get("val"));
            }
        }
        return res;
    }

    public Map findHbRegionData() {
        HashMap<String, List> res = new HashMap<String, List>();
        String sql = "select f_xzqdm as xzqdm,f_xzqmc as xzqmc,f_pcode as pcode from tb_region where f_pcode = '130000'";
        List listCitys = this.jdbcTemplate.queryForList(sql);
        res.put("citys", listCitys);
        String sql2 = "select f_xzqdm as xzqdm,f_xzqmc as xzqmc,f_pcode as pcode from tb_region where f_pcode like '13%' and f_level = 3";
        List listTowns = this.jdbcTemplate.queryForList(sql2);
        res.put("towns", listTowns);
        String sql3 = "select xzqdm,xzqmc,pcode from tb_region_town where pcode like '13%' and f_level = 4";
        List listVil = this.jdbcTemplate.queryForList(sql3);
        res.put("vils", listVil);
        return res;
    }

    public Map<String, Object> statisticsKsDataByYear(String year) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String monthSql = "select EXTRACT(month FROM f_fxsj) as month_value,count(1) as ct from tbtsk_task_znglrw_20240731183049311 \nwhere EXTRACT(year FROM f_fxsj) = " + year + " group by EXTRACT(month FROM f_fxsj)";
        List ls = this.jdbcTemplate.queryForList(monthSql);
        HashMap<String, ArrayList<Object>> monthData = new HashMap<String, ArrayList<Object>>();
        ArrayList<String> lsMonthName = new ArrayList<String>(Arrays.asList("1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"));
        ArrayList<Integer> lsMonthData = new ArrayList<Integer>(Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        if (ls != null && !ls.isEmpty()) {
            for (Map data : ls) {
                Integer m = Integer.parseInt(data.get("month_value").toString());
                Integer ct = Integer.parseInt(data.get("ct").toString());
                lsMonthData.set(m - 1, ct);
            }
        }
        monthData.put("x", lsMonthName);
        monthData.put("y", lsMonthData);
        res.put("monthData", monthData);
        ArrayList<Map> ksTypes = new ArrayList<Map>();
        String sqlCkq = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_ltckqr,'') <> '' and EXTRACT(year FROM f_fxsj) = " + year;
        String sqlTkq = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_tkqr,'') <> '' and EXTRACT(year FROM f_fxsj) = " + year;
        String sqlKsstxf = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_tkqr,'')='' and coalesce(f_ltckqr,'')='' and EXTRACT(year FROM f_fxsj) = " + year;
        Map ckqMap = this.jdbcTemplate.queryForMap(sqlCkq);
        ckqMap.put("name", "\u91c7\u77ff\u6743");
        ckqMap.put("value", Integer.parseInt(ckqMap.get("ct").toString()));
        ksTypes.add(ckqMap);
        Map tkqMap = this.jdbcTemplate.queryForMap(sqlTkq);
        tkqMap.put("name", "\u63a2\u77ff\u6743");
        tkqMap.put("value", Integer.parseInt(tkqMap.get("ct").toString()));
        ksTypes.add(tkqMap);
        Map ksstxfMap = this.jdbcTemplate.queryForMap(sqlKsstxf);
        ksstxfMap.put("name", "\u77ff\u5c71\u751f\u6001\u4fee\u590d");
        ksstxfMap.put("value", Integer.parseInt(ksstxfMap.get("ct").toString()));
        ksTypes.add(ksstxfMap);
        res.put("ksTypeData", ksTypes);
        String xsfbSql = "select r.f_xzqdm  as xzqdm,r.f_xzqmc as xzqmc, count(1) as ct from tbtsk_task_znglrw_20240731183049311 t\ninner join tb_region r on r.f_xzqdm = left(t.f_xzqdm,4)||'00'\nwhere EXTRACT(year FROM t.f_fxsj) = " + year + " group by r.f_xzqdm,r.f_xzqmc\n order by r.f_xzqdm";
        List lsXsfb = this.jdbcTemplate.queryForList(xsfbSql);
        HashMap xsfbData = new HashMap();
        ArrayList<String> lsXzq = new ArrayList<String>();
        ArrayList<Integer> lsData = new ArrayList<Integer>();
        if (lsXsfb != null && !lsXsfb.isEmpty()) {
            for (Map data : lsXsfb) {
                lsXzq.add(data.get("xzqmc").toString());
                lsData.add(Integer.parseInt(data.get("ct").toString()));
            }
        }
        xsfbData.put("x", lsXzq);
        xsfbData.put("y", lsData);
        res.put("xsfbData", xsfbData);
        return res;
    }

    private void mapAddState(Map<String, Object> map, SimpleDateFormat sdf) throws ParseException {
        Long curret = System.currentTimeMillis();
        if (map.get("yxqz") != null) {
            String dateStr = map.get("yxqz").toString() + " 23:59:59";
            if (curret > sdf.parse(dateStr).getTime()) {
                map.put("state", 1);
            } else {
                map.put("state", 0);
            }
        } else {
            map.put("state", 0);
        }
    }

    public List<Map<String, Object>> findAllKsManageData() throws ParseException {
        String sql = "select id,xkzh,ksmc, \nshimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\nshape_leng,shape_area,st_astext(geom) as geom,data_type\nfrom tb_ks_tkckq";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List list = this.jdbcTemplate.queryForList(sql);
        for (Map map : list) {
            this.mapAddState(map, sdf);
        }
        return list;
    }

    public List<Map<String, Object>> findKsManageDataByParam(String dataType, String nodeType, String name) throws ParseException {
        String sql = "select id,xkzh,ksmc, \nshimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\nshape_leng,shape_area,st_astext(geom) as geom,data_type\nfrom tb_ks_tkckq where 1=1 ";
        sql = "1".equals(dataType) ? sql + " and data_type=1 " : sql + " and data_type=2 ";
        if ("2".equals(nodeType)) {
            sql = sql + " and shimc='" + name + "'";
        } else if ("3".equals(nodeType)) {
            sql = sql + " and xianmc='" + name + "'";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List list = this.jdbcTemplate.queryForList(sql);
        for (Map map : list) {
            this.mapAddState(map, sdf);
        }
        return list;
    }

    public Map<String, Object> getKsManageDataDetail(String id) throws ParseException {
        String sql = "select id,xkzh,ksmc, \nshimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\nshape_leng,shape_area,st_astext(geom) as geom,data_type\nfrom tb_ks_tkckq where id=" + id;
        Map map = this.jdbcTemplate.queryForMap(sql);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.mapAddState(map, sdf);
        return map;
    }

    public List<KsManageData> ksManageDataTree(String name) {
        ArrayList<KsManageData> resList = new ArrayList<KsManageData>();
        String sql = "select data_type,id,ksmc,shimc,xianmc from tb_ks_tkckq";
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            sql = sql + " where ksmc like '%" + name + "%'";
        }
        KsManageData ckq = new KsManageData();
        ckq.setId("ckq");
        ckq.setName("\u91c7\u77ff\u6743");
        ckq.setNodeType(Integer.valueOf(1));
        ckq.setChildMap(new HashMap());
        resList.add(ckq);
        KsManageData tkq = new KsManageData();
        tkq.setId("tkq");
        tkq.setName("\u63a2\u77ff\u6743");
        tkq.setNodeType(Integer.valueOf(1));
        tkq.setChildMap(new HashMap());
        resList.add(tkq);
        List listKs = this.jdbcTemplate.queryForList(sql);
        if (listKs != null && !listKs.isEmpty()) {
            for (Map data : listKs) {
                KsManageData xianMd;
                KsManageData shiMd;
                String dataType = data.get("data_type").toString();
                KsManageData root = "1".equals(dataType) ? ckq : tkq;
                String shimc = data.get("shimc").toString();
                if (root.getChildMap().containsKey(shimc)) {
                    shiMd = (KsManageData)root.getChildMap().get(shimc);
                } else {
                    shiMd = new KsManageData();
                    shiMd.setId(UUID.randomUUID().toString());
                    shiMd.setName(shimc);
                    shiMd.setNodeType(Integer.valueOf(2));
                    shiMd.setChildMap(new HashMap());
                    root.getChildMap().put(shimc, shiMd);
                }
                String xianmc = data.get("xianmc").toString();
                if (shiMd.getChildMap().containsKey(xianmc)) {
                    xianMd = (KsManageData)shiMd.getChildMap().get(xianmc);
                } else {
                    xianMd = new KsManageData();
                    xianMd.setId(UUID.randomUUID().toString());
                    xianMd.setName(xianmc);
                    xianMd.setNodeType(Integer.valueOf(3));
                    xianMd.setChildMap(new HashMap());
                    shiMd.getChildMap().put(xianmc, xianMd);
                }
                KsManageData ksMd = new KsManageData();
                ksMd.setId(data.get("id").toString());
                ksMd.setName(data.get("ksmc").toString());
                ksMd.setNodeType(Integer.valueOf(4));
                xianMd.getChildMap().put(ksMd.getId(), ksMd);
            }
        }
        return resList;
    }

    public Map<String, Object> ktdMainstatistics() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dcyw", 10);
        String sql1 = "select count(*) as ct from tbsys_user";
        Map res1 = this.jdbcTemplate.queryForMap(sql1);
        map.put("zcyhs", res1.get("ct"));
        String sql2 = "select ROUND(COUNT(*)*1.0 /10000,2) as ct from tb_app_media";
        Map res2 = this.jdbcTemplate.queryForMap(sql2);
        map.put("ljzp", res2.get("ct"));
        String sql3 = "select count(*) as ct from tbtsk_task_biz where coalesce(f_isdel,0) <>1 and f_classid in (select f_id from tbtsk_task_class)";
        Map res3 = this.jdbcTemplate.queryForMap(sql3);
        map.put("rws", res3.get("ct"));
        map.put("zczl", 1.8);
        return map;
    }

    public List<Map<String, Object>> statisticsBusinessDataByClassIdAndTaskId(String classId, String taskId) throws Exception {
        List listRegions;
        block13: {
            HashMap<String, Map> maps;
            block12: {
                TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
                if (task == null) {
                    throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728");
                }
                TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
                if (objectinfo == null) {
                    throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
                    throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
                }
                String sql = "select f_xzqdm,f_xzqmc,f_centerx,f_centery from tb_region where f_pcode = '130000'";
                listRegions = this.jdbcTemplate.queryForList(sql);
                maps = new HashMap<String, Map>();
                if (!"73".equals(classId)) break block12;
                if (listRegions != null && !listRegions.isEmpty()) {
                    for (Map temp : listRegions) {
                        ArrayList<QuotaDataDto> list = new ArrayList<QuotaDataDto>();
                        list.add(QuotaDataDto.create((String)"\u62c6\u9664\u56fe\u6591\u6570\u91cf", (String)"1", (BigDecimal)new BigDecimal(0)));
                        list.add(QuotaDataDto.create((String)"\u62c6\u9664\u56fe\u6591\u9762\u79ef", (String)"2", (BigDecimal)new BigDecimal(0)));
                        list.add(QuotaDataDto.create((String)"\u62c6\u9664\u8015\u5730\u9762\u79ef", (String)"3", (BigDecimal)new BigDecimal(0)));
                        temp.put("data", list);
                        maps.put(temp.get("f_xzqdm").toString(), temp);
                    }
                }
                String cctbslSql = "select f_sjxzqdm,f_sjxzqmc,count(*) as dct from (\n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + " where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n\tunion all \n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + "_child where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5'\n) tp group by f_sjxzqdm,f_sjxzqmc \n";
                List cctbslList = this.jdbcTemplate.queryForList(cctbslSql);
                for (Map temp : cctbslList) {
                    String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                    if (!maps.containsKey(xzqdm)) continue;
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map regionData = (Map)maps.get(xzqdm);
                    List list = (List)regionData.get("data");
                    ((QuotaDataDto)list.get(0)).setCount(count);
                }
                String cctbmjSql = "select f_sjxzqdm,f_sjxzqmc,sum(f_sjrdccmj) as dct \n from (\n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + " where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n\tunion all \n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + "_child where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5'\n) tp group by f_sjxzqdm,f_sjxzqmc ";
                List cctbmjList = this.jdbcTemplate.queryForList(cctbmjSql);
                for (Map temp : cctbmjList) {
                    String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                    if (!maps.containsKey(xzqdm)) continue;
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map regionData = (Map)maps.get(xzqdm);
                    List list = (List)regionData.get("data");
                    ((QuotaDataDto)list.get(1)).setCount(count.setScale(2, 4));
                }
                String ccgdmjSql = "select f_sjxzqdm,f_sjxzqmc,sum(f_sjrdccgd) as dct \n from (\n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + " where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n\tunion all \n\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() + "_child where f_sjrdzgqk like '%\u62c6\u9664\u590d\u8015%' and f_sjhfxpd ='\u8fdd\u6cd5'\n) tp group by f_sjxzqdm,f_sjxzqmc ";
                List ccgdmjList = this.jdbcTemplate.queryForList(ccgdmjSql);
                for (Map temp : ccgdmjList) {
                    String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                    if (!maps.containsKey(xzqdm)) continue;
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map regionData = (Map)maps.get(xzqdm);
                    List list = (List)regionData.get("data");
                    ((QuotaDataDto)list.get(2)).setCount(count.setScale(2, 4));
                }
                break block13;
            }
            if (!"106".equals(classId)) break block13;
            if (listRegions != null && !listRegions.isEmpty()) {
                for (Map temp : listRegions) {
                    ArrayList<QuotaDataDto> list = new ArrayList<QuotaDataDto>();
                    list.add(QuotaDataDto.create((String)"\u6c38\u4e45\u57fa\u672c\u519c\u7530\u50a8\u5907\u533a\u6838\u67e5", (String)"1", (BigDecimal)new BigDecimal(0)));
                    list.add(QuotaDataDto.create((String)"\u8015\u5730\u5b63\u5ea6\u536b\u7247\u76d1\u6d4b", (String)"2", (BigDecimal)new BigDecimal(0)));
                    list.add(QuotaDataDto.create((String)"\u8015\u5730\u548c\u57fa\u672c\u519c\u7530\u503e\u5012\u5efa\u7b51\u5783\u573e\u6838\u67e5", (String)"3", (BigDecimal)new BigDecimal(0)));
                    list.add(QuotaDataDto.create((String)"\u5386\u5e74\u7763\u5bdf\u8015\u5730\u975e\u7cae\u5316\u95ee\u9898\u56fe\u6591\u6838\u67e5", (String)"4", (BigDecimal)new BigDecimal(0)));
                    temp.put("data", list);
                    maps.put(temp.get("f_xzqdm").toString(), temp);
                }
            }
            String tjSql = "select left(f_xzqdm,4)||'00' as f_sjxzqdm,  CASE \n    WHEN f_taskid = '15f9abd6-21bb-427e-b369-d43b9f898dbb' THEN '\u8015\u5730\u5b63\u5ea6\u536b\u7247\u76d1\u6d4b'\n    WHEN f_taskid = '75ca2394-f7a6-41d8-9056-61fbeb0b14df' THEN '\u6c38\u4e45\u57fa\u672c\u519c\u7530\u50a8\u5907\u533a\u6838\u67e5'\n    WHEN f_taskid = 'a0891767-cae8-4433-b47d-2aab4544ec36' THEN '\u8015\u5730\u548c\u57fa\u672c\u519c\u7530\u503e\u5012\u5efa\u7b51\u5783\u573e\u6838\u67e5'\n    ELSE '\u5386\u5e74\u7763\u5bdf\u8015\u5730\u975e\u7cae\u5316\u95ee\u9898\u56fe\u6591\u6838\u67e5'\n  END AS tjname,sum(f_tbcount) as dct  from tbtsk_task_statis a  where a.f_taskid  in ('15f9abd6-21bb-427e-b369-d43b9f898dbb','75ca2394-f7a6-41d8-9056-61fbeb0b14df','a0891767-cae8-4433-b47d-2aab4544ec36','960b62d0-5e22-4d59-80ab-a7d7da7b5058') \ngroup by left(f_xzqdm,4)||'00',f_taskid";
            List tjList = this.jdbcTemplate.queryForList(tjSql);
            block5: for (Map temp : tjList) {
                String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                if (!maps.containsKey(xzqdm)) continue;
                BigDecimal count = new BigDecimal(temp.get("dct").toString());
                Map regionData = (Map)maps.get(xzqdm);
                List list = (List)regionData.get("data");
                for (QuotaDataDto dto : list) {
                    if (!dto.getName().equals(String.valueOf(temp.get("tjname")))) continue;
                    dto.setCount(count);
                    continue block5;
                }
            }
        }
        return listRegions;
    }

    public List<SumRegionTaskDispatch> sumTaskTbGroupByRegion(String taskId, String regionCode) throws Exception {
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if (objectinfo == null) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
        }
        List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
        if (fields == null || fields.isEmpty()) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a");
        }
        TbtskFields tbbhField = fields.stream().filter(t -> t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
        if (tbbhField == null) {
            List uniqueFields = fields.stream().filter(t -> t.getfUnique() != null && t.getfUnique().equals(1)).collect(Collectors.toList());
            if (uniqueFields == null | uniqueFields.isEmpty()) {
                throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728\u552f\u4e00\u503c\u5b57\u6bb5");
            }
            tbbhField = (TbtskFields)uniqueFields.get(0);
        }
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            if (regionCode.length() == 6) {
                if (regionCode.endsWith("0000")) {
                    wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 2) + "%'");
                } else if (regionCode.endsWith("00")) {
                    wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 4) + "%'");
                } else {
                    wheres.add("f_xzqdmsys like '%" + regionCode + "%'");
                }
            } else if (regionCode.length() == 9) {
                wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 9) + "%'");
            } else if (regionCode.length() == 12) {
                wheres.add("f_xzqdmsys = '" + regionCode + "'");
            }
        }
        String where = "";
        if (!wheres.isEmpty()) {
            where = StringUtils.join(wheres, (String)" and ");
        }
        JSONObject result = new JSONObject();
        String sql1 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() + " where f_xzqdmsys is not null and f_status <10 ";
        String sql2 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() + " where f_xzqdmsys is not null and f_status =10 and f_review_stage=101 ";
        String sql3 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() + " where f_xzqdmsys is not null ";
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql1 = sql1 + " and " + where;
            sql2 = sql2 + " and " + where;
            sql3 = sql3 + " and " + where;
        }
        sql1 = sql1 + " group by f_xzqdmsys";
        sql2 = sql2 + " group by f_xzqdmsys";
        sql3 = sql3 + " group by f_xzqdmsys";
        HashMap<String, SumRegionTaskDispatch> resMap = new HashMap<String, SumRegionTaskDispatch>();
        List maps1 = this.jdbcTemplate.queryForList(sql1);
        for (Object dt : maps1) {
            String rc = this.objToString(dt.get("f_xzqdmsys"));
            String ct = this.objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            sr.setRegionCode(rc);
            sr.setWsb(Long.valueOf(Long.parseLong(ct)));
            resMap.put(rc, sr);
        }
        List maps2 = this.jdbcTemplate.queryForList(sql2);
        for (Object dt : maps2) {
            String rc = this.objToString(dt.get("f_xzqdmsys"));
            String ct = this.objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            if (resMap.containsKey(rc)) {
                sr = (SumRegionTaskDispatch)resMap.get(rc);
            } else {
                sr.setRegionCode(rc);
                resMap.put(rc, sr);
            }
            sr.setHczs(Long.valueOf(Long.parseLong(ct)));
        }
        List maps3 = this.jdbcTemplate.queryForList(sql3);
        for (Map dt : maps3) {
            String rc = this.objToString(dt.get("f_xzqdmsys"));
            String ct = this.objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            if (resMap.containsKey(rc)) {
                sr = (SumRegionTaskDispatch)resMap.get(rc);
            } else {
                sr.setRegionCode(rc);
                resMap.put(rc, sr);
            }
            sr.setTotal(Long.valueOf(Long.parseLong(ct)));
        }
        ArrayList<SumRegionTaskDispatch> ls = new ArrayList<SumRegionTaskDispatch>(resMap.values());
        return ls;
    }

    public JSONObject getTaskTbInfo(String taskId, String regionCode, String tbbh, Integer page, Integer limit, String userId) throws Exception {
        TbtskObjectinfo objectinfo;
        ObjectMapper mapper;
        JsonNode rootNode;
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        String configArgs = task.getConfigArgs();
        String isWpzf = "";
        if (StringUtils.isNotBlank((CharSequence)configArgs) && ObjectUtils.isNotEmpty((Object)(rootNode = (mapper = new ObjectMapper()).readTree(configArgs))) && ObjectUtils.isNotEmpty((Object)rootNode.get("isWpzf"))) {
            isWpzf = rootNode.get("isWpzf").asText();
        }
        if ((objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId())) == null) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
        }
        List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
        if (fields == null || fields.isEmpty()) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a");
        }
        TbtskFields tbbhOrDkbhField = null;
        tbbhOrDkbhField = isWpzf.equals("1") ? (TbtskFields)fields.stream().filter(t -> t.getfFieldname().equals("f_dkbh")).findFirst().orElse(null) : (isWpzf.equals("2") ? (TbtskFields)fields.stream().filter(t -> t.getfFieldname().equals("f_gjbh")).findFirst().orElse(null) : (TbtskFields)fields.stream().filter(t -> t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null));
        if (tbbhOrDkbhField == null) {
            List uniqueFields = fields.stream().filter(t -> t.getfUnique() != null && t.getfUnique().equals(1)).collect(Collectors.toList());
            if (uniqueFields == null | uniqueFields.isEmpty()) {
                throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728\u552f\u4e00\u503c\u5b57\u6bb5");
            }
            tbbhOrDkbhField = (TbtskFields)uniqueFields.get(0);
        }
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            if (regionCode.length() == 6) {
                if (regionCode.endsWith("0000")) {
                    wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 2) + "%'");
                } else if (regionCode.endsWith("00")) {
                    wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 4) + "%'");
                } else {
                    wheres.add("f_xzqdmsys like '%" + regionCode + "%'");
                }
            } else if (regionCode.length() == 9) {
                wheres.add("f_xzqdmsys like '%" + regionCode.substring(0, 9) + "%'");
            } else if (regionCode.length() == 12) {
                wheres.add("f_xzqdmsys = '" + regionCode + "'");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tbbh)) {
            wheres.add(tbbhOrDkbhField.getfFieldname() + " like '%" + tbbh + "%'");
        }
        wheres.add(tbbhOrDkbhField.getfFieldname() + " is not null ");
        String where = "";
        if (!wheres.isEmpty()) {
            where = StringUtils.join(wheres, (String)" and ");
        }
        JSONObject result = new JSONObject();
        Integer count = this.dataBizService.getCount(objectinfo.getfTablename(), where);
        if (count == 0) {
            result.put("totalCount", (Object)0);
            return result;
        }
        String sql = "select f_id, st_astext(f_shape) as f_shape, coalesce(f_tbmj,0) f_tbmj,f_xzqdmsys," + tbbhOrDkbhField.getfFieldname() + " from " + objectinfo.getfTablename();
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql = sql + " where " + where;
        }
        sql = sql + " order by " + tbbhOrDkbhField.getfFieldname();
        int offset = (page - 1) * limit;
        sql = sql + " offset " + offset + " limit " + limit;
        List maps = this.jdbcTemplate.queryForList(sql);
        ArrayList<TbtskDispatchTbTemp> temps = new ArrayList<TbtskDispatchTbTemp>();
        WKTReader reader = new WKTReader();
        for (Map map : maps) {
            String id = this.objToString(map.get("f_id"));
            String ftbmj = this.objToString(map.get("f_tbmj"));
            String ftbbh = this.objToString(map.get(tbbhOrDkbhField.getfFieldname()));
            String fshape = this.objToString(map.get("f_shape"));
            TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
            info.setId(id);
            info.setSource(EnumDispatchSource.task.getCode());
            info.setTbmj(Double.valueOf(Double.parseDouble(ftbmj)));
            if (StringUtils.isNotEmpty((CharSequence)fshape)) {
                if (fshape.toLowerCase().startsWith("srid")) {
                    fshape = fshape.substring(10);
                }
                Geometry geo = reader.read(fshape);
                HashMap<String, Object> mapRegion = this.getXzqdmSys((Geometry)geo.getCentroid(), fshape, GeometryTrasnUtil.getProjNum(geo));
                fshape = "SRID=4490;" + fshape;
                if (mapRegion != null) {
                    info.setRegionCode(mapRegion.get("xzqdmsys").toString());
                    info.setRegionName(mapRegion.get("location").toString());
                }
            }
            info.setShape(fshape);
            info.setTbbh(ftbbh);
            info.setTbid(id);
            info.setTaskId(taskId);
            temps.add(info);
        }
        result.put("totalCount", (Object)count);
        result.put("dispatchTbs", temps);
        return result;
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public List<TbtskDispatchTbTemp> getShpList(MultipartFile multipartFile, String userId) throws Exception {
        double size = (double)multipartFile.getSize() / 1024.0 / 1024.0;
        if (size > 2.5) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u53ef\u5927\u4e8e2.5M");
        }
        File downdirectory = new File(this.localDownload);
        File uploaddirectory = new File(this.localUpload);
        if (!downdirectory.exists() && downdirectory.isDirectory()) {
            downdirectory.mkdir();
        }
        if (!uploaddirectory.exists() && uploaddirectory.isDirectory()) {
            uploaddirectory.mkdir();
        }
        if (!multipartFile.getOriginalFilename().endsWith(".zip")) {
            throw new RuntimeException("\u8bf7\u4e0a\u4f20zip\u538b\u7f29\u5305");
        }
        String originalFilename = multipartFile.getOriginalFilename().substring(0, multipartFile.getOriginalFilename().lastIndexOf(".")) + System.currentTimeMillis();
        try (FileOutputStream outputStream = null;){
            File localZip = File.createTempFile(originalFilename, ".zip", downdirectory);
            outputStream = new FileOutputStream(localZip);
            outputStream.write(multipartFile.getBytes());
            outputStream.close();
            File file = new File(this.localDownload + File.separator + originalFilename);
            if (!file.exists()) {
                file.mkdir();
            }
            ZipUtil1s.unZip(localZip.getAbsolutePath(), file.getAbsolutePath());
        }
        String filePath = this.localDownload + File.separator + originalFilename;
        ArrayList<File> shpList = new ArrayList<File>();
        this.getFileByType(new File(filePath), ".shp", shpList);
        if (shpList.isEmpty()) {
            throw new RuntimeException("\u672a\u627e\u5230shp\u6587\u4ef6");
        }
        List<TbtskDispatchTbTemp> infos = this.shpInfoList(shpList.stream().map(r -> r.getAbsolutePath()).collect(Collectors.toList()), userId);
        this.dispatchTbTempDao.insertBatch(infos);
        infos.forEach(t -> t.setTbInfo(null));
        return infos;
    }

    public TbtskDispatchTbTemp getDrawList(String wkt, String userId) throws Exception {
        WKTReader wktReader = new WKTReader();
        Geometry geo = wktReader.read(wkt);
        if (geo == null) {
            throw new RuntimeException("\u7ed8\u5236\u56fe\u5f62\u4e3a\u7a7a");
        }
        if (!geo.getGeometryType().toLowerCase().equals("polygon") && !geo.getGeometryType().toLowerCase().equals("multipolygon")) {
            throw new RuntimeException("\u7ed8\u5236\u4e0d\u662f\u9762\u56fe\u5f62");
        }
        int num = GeometryTrasnUtil.getProjNum(geo);
        TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
        info.setId(UUID.randomUUID().toString().replace("-", ""));
        info.setSource(EnumDispatchSource.draw.getCode());
        info.setUserId(userId);
        HashMap<String, Object> map = this.getXzqdmSys((Geometry)geo.getCentroid(), wkt, num);
        if (map == null) {
            throw new Exception("\u7ed8\u5236\u8303\u56f4\u4e0d\u5728\u89c4\u5b9a\u533a\u57df\u5185");
        }
        DecimalFormat df = new DecimalFormat("#.00");
        info.setRegionCode(map.get("xzqdmsys").toString());
        info.setRegionName(map.get("location").toString());
        info.setTbmj(Double.valueOf(Double.parseDouble(df.format(Double.parseDouble(map.get("area").toString())))));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = sdf.format(new Date());
        info.setTbbh("TBHZ" + date);
        info.setShape("SRID=4490;" + wkt);
        this.dispatchTbTempDao.gwAccess((GiEntitySaveable)info);
        return info;
    }

    public void deleteTbTemp(String tempId) {
        this.dispatchTbTempDao.gwDeleteByPK((Serializable)((Object)tempId));
    }

    public void deleteDispatchTb(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (tbtskDispatchInfo != null) {
            if (StringUtils.isNotEmpty((CharSequence)tbtskDispatchInfo.getPlanTaskid())) {
                String tableName = this.getTableNameByTaskId(tbtskDispatchInfo.getPlanTaskid());
                this.dataBizService.delete(tableName, "f_tbID", tbtskDispatchInfo.getPlanTbid());
            }
            this.dispatchAttachDao.deleteByTbid(tbid);
            this.dispatchInfoDao.gwDeleteByPK((Serializable)((Object)tbid));
        }
    }

    private String getTableNameByTaskId(String taskid) throws Exception {
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskid);
        if (tskTaskBiz == null) {
            throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (objectinfo == null) {
            throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
            throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
        }
        return objectinfo.getfTablename();
    }

    private Map<String, Object> createPlanTaskTb(String ddid, TbtskDispatchInfo tb, WKTReader reader) throws org.locationtech.jts.io.ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String id = UUID.randomUUID().toString().replace("-", "");
        map.put("f_id", id);
        map.put("f_tbID", id);
        map.put("f_tbmc", tb.getTbbh());
        map.put("f_tbbh", tb.getTbbh());
        map.put("f_xzqdm", tb.getRegionCode());
        map.put("f_xzqmc", tb.getRegionName());
        map.put("f_tbmj", tb.getTbmj());
        map.put("f_ddrwID", ddid);
        map.put("f_status", 1);
        if (StringUtils.isNotEmpty((CharSequence)tb.getRegionCode()) && tb.getRegionCode().length() >= 6) {
            if (tb.getRegionCode().length() > 9) {
                map.put("f_xzqdmsys", tb.getRegionCode());
                map.put("f_xzqdmtown", tb.getRegionCode().substring(0, 9));
            } else if (tb.getRegionCode().length() > 6 && tb.getRegionCode().length() < 10) {
                map.put("f_xzqdmtown", tb.getRegionCode());
            }
            map.put("f_xzqdmcounty", tb.getRegionCode().substring(0, 6));
            map.put("f_xzqdmcity", tb.getRegionCode().substring(0, 4) + "00");
        }
        if (tb.getShape() != null) {
            String wkt = tb.getShape();
            if (tb.getShape().toUpperCase().contains("SRID")) {
                wkt = tb.getShape().substring(10);
            }
            Geometry geo = reader.read(wkt);
            Point p = geo.getCentroid();
            map.put("f_zxdjd", p.getX());
            map.put("f_zxdwd", p.getY());
            map.put("f_shape", wkt);
        }
        tb.setPlanTbid(id);
        return map;
    }

    public List<Map<String, Object>> getTbDdls(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (tbtskDispatchInfo == null) {
            throw new Exception("\u56fe\u6591\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String tableName = this.getTableNameByTaskId("f7518261-2daa-4aeb-b7a1-67c72edb464b");
        String sql = "select t.f_ddsj as ddsj,t.f_ddr_n1 as ddr,t.f_bddzy_n1 as bddzy,t.f_ddjl as ddjl,t.f_ddjl as ddyj,r.f_name as ddname from " + tableName + " t left join tbtsk_dispatch_record r on t.f_ddrwID=r.f_id where t.f_ddzt='1' and t.f_tbbh='" + tbtskDispatchInfo.getTbbh() + "' order by t.f_ddsj desc";
        List lsMap = this.jdbcTemplate.queryForList(sql);
        return lsMap;
    }

    public void saveTbJl(String tbid, String zyyid, String ddjl, String ddyj, MultipartFile[] files, String ddr) throws Exception {
        Integer ddlx = 1;
        TbtskDispatchInfo tbtskDispatchInfo = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (tbtskDispatchInfo == null) {
            throw new Exception("\u56fe\u6591\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TbsysUserSubjectRel tbsysUserSubjectRel = (TbsysUserSubjectRel)this.tbsysUserSubjectRelDao.gwSearchByPK((Serializable)Long.valueOf(Long.parseLong(zyyid)));
        if (!zyyid.equals(tbtskDispatchInfo.getUserid())) {
            tbtskDispatchInfo.setDdzy(ddlx);
            tbtskDispatchInfo.setUserid(zyyid);
            tbtskDispatchInfo.setUserName(tbsysUserSubjectRel.getRealName());
            tbtskDispatchInfo.setPhone(tbsysUserSubjectRel.getPhoneNumber());
        }
        tbtskDispatchInfo.setDispatch(Integer.valueOf(1));
        tbtskDispatchInfo.setJl(ddjl);
        tbtskDispatchInfo.setYj(ddyj);
        this.dispatchInfoDao.gwUpdateByPK((GiEntityAlterable)tbtskDispatchInfo);
        TbtskDispatchAttach search = new TbtskDispatchAttach();
        search.setInfoId(tbid);
        List dbList = this.dispatchAttachDao.gwSearch((GiEntityQueryable)search);
        if (dbList != null && !dbList.isEmpty()) {
            for (TbtskDispatchAttach t : dbList) {
                String key = "ddtask/" + tbid + "/" + t.getName();
                try {
                    this.ossOperatorService.deleteObject(key);
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), new Object[0]);
                }
                this.dispatchAttachDao.gwDeleteByPK((Serializable)((Object)t.getId()));
            }
        }
        if (files != null) {
            ArrayList<TbtskDispatchAttach> ls = new ArrayList<TbtskDispatchAttach>();
            for (TbtskDispatchAttach file : files) {
                String name = file.getOriginalFilename();
                String key = "ddtask/" + tbid + "/" + name;
                String url = this.ossOperatorService.sendObject2Oss(key, file.getInputStream());
                TbtskDispatchAttach tbtskDispatchAttach = new TbtskDispatchAttach();
                tbtskDispatchAttach.setId(UUID.randomUUID().toString().replace("-", ""));
                tbtskDispatchAttach.setInfoId(tbid);
                tbtskDispatchAttach.setName(name);
                tbtskDispatchAttach.setTime(new Date());
                tbtskDispatchAttach.setUrl(url);
                ls.add(tbtskDispatchAttach);
            }
            this.dispatchAttachDao.insertBatch(ls);
        }
        String tableName = this.getTableNameByTaskId("f7518261-2daa-4aeb-b7a1-67c72edb464b");
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put("f_bddzylx", ddlx == 1 ? "\u4eba\u5458" : "\u65e0\u4eba\u673a");
        updateMap.put("f_ddyj", ddyj);
        updateMap.put("f_ddjl", ddjl);
        updateMap.put("f_ddzt", 1);
        updateMap.put("f_bddzy_n1", tbsysUserSubjectRel.getRealName());
        updateMap.put("f_ddr_n1", ddr);
        this.dataBizService.updateData(tableName, updateMap, "f_tbID='" + tbtskDispatchInfo.getPlanTbid() + "'");
        this.jdbcTemplate.update("update " + tableName + " set f_ddsj=now() where f_tbID='" + tbtskDispatchInfo.getPlanTbid() + "'");
    }

    public DispatchResultDto curretTbDdJl(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (tbtskDispatchInfo == null) {
            throw new Exception("\u56fe\u6591\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String tableName = this.getTableNameByTaskId("f7518261-2daa-4aeb-b7a1-67c72edb464b");
        String sql = "select * from " + tableName + " where f_tbID='" + tbtskDispatchInfo.getPlanTbid() + "'";
        List lsMap = this.jdbcTemplate.queryForList(sql);
        if (lsMap != null && !lsMap.isEmpty()) {
            Map map = (Map)lsMap.get(0);
            DispatchResultDto dispatchResultDto = new DispatchResultDto();
            dispatchResultDto.setDdjl(String.valueOf(map.get("f_ddjl")));
            dispatchResultDto.setDdyj(String.valueOf(map.get("f_ddyj")));
            dispatchResultDto.setTbbh(tbtskDispatchInfo.getTbbh());
            TbtskDispatchAttach tbtskDispatchAttach = new TbtskDispatchAttach();
            tbtskDispatchAttach.setInfoId(tbid);
            List attachList = this.dispatchAttachDao.gwSearch((GiEntityQueryable)tbtskDispatchAttach);
            for (TbtskDispatchAttach attach : attachList) {
                attach.setUrl(this.temporarySignedUrlService.getTemporarySignedUrl("", attach.getUrl(), null));
            }
            dispatchResultDto.setAttacheList(attachList);
            List<AppMediaDTO> lsMedia = this.getMedia(tbtskDispatchInfo.getPlanTbid());
            ArrayList<AppMediaDTO> temp = new ArrayList<AppMediaDTO>();
            if (lsMedia != null) {
                for (AppMediaDTO appMediaDTO : lsMedia) {
                    if (appMediaDTO.getType() != 1) continue;
                    temp.add(appMediaDTO);
                }
            }
            dispatchResultDto.setMediaList(temp);
            return dispatchResultDto;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TbtskDispatchRecord createTask(DispatchCreateInfo createInfo) throws Exception {
        String xh;
        TbtskDispatchInfo tb;
        int count;
        List temps;
        if (createInfo == null) {
            throw new Exception("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,\u8c03\u5ea6\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)createInfo.getDispatchName())) {
            throw new Exception("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,\u8c03\u5ea6\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a");
        }
        boolean hasShp = true;
        boolean hasDraw = true;
        boolean hasTask = true;
        if (createInfo.getShpTbids() == null || createInfo.getShpTbids().isEmpty()) {
            hasShp = false;
        }
        if (createInfo.getDrawTbids() == null || createInfo.getDrawTbids().isEmpty()) {
            hasDraw = false;
        }
        if (createInfo.getTaskTbids() == null || createInfo.getTaskTbids().isEmpty()) {
            hasTask = false;
        }
        if (!(hasShp || hasDraw || hasTask)) {
            throw new Exception("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,\u8c03\u5ea6\u56fe\u6591\u4e3a\u7a7a");
        }
        WKTReader reader = new WKTReader();
        TbtskDispatchRecord task = null;
        boolean insert = false;
        boolean update = false;
        if (StringUtils.isBlank((CharSequence)createInfo.getDispatchId())) {
            task = new TbtskDispatchRecord();
            task.setName(createInfo.getDispatchName());
            task.setId(UUID.randomUUID().toString().replace("-", ""));
            task.setTime(new Date());
            task.setUserId(createInfo.getUserId());
            task.setStatus(Integer.valueOf(-1));
            insert = true;
        } else {
            task = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)createInfo.getDispatchId()));
            if (task == null) {
                throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            if (!createInfo.getDispatchName().equals(task.getName())) {
                task.setName(createInfo.getDispatchName());
                update = true;
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(new Date());
        ArrayList<TbtskDispatchInfo> tbs = new ArrayList<TbtskDispatchInfo>();
        ArrayList<Map<String, Object>> taskTbs = new ArrayList<Map<String, Object>>();
        if (hasShp) {
            temps = this.dispatchTbTempDao.ListByIds(createInfo.getShpTbids());
            if (temps == null || temps.isEmpty()) {
                throw new Exception("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,\u8c03\u5ea6\u56fe\u6591[shp\u5bfc\u5165]\u4e0d\u5b58\u5728");
            }
            count = 0;
            for (TbtskDispatchTbTemp temp : temps) {
                tb = new TbtskDispatchInfo();
                BeanUtils.copyProperties((Object)temp, (Object)tb);
                tb.setDispatch(Integer.valueOf(0));
                tb.setImportFc(Integer.valueOf(0));
                tb.setDispatchId(task.getId());
                xh = String.valueOf(++count);
                xh = StringUtils.leftPad((String)xh, (int)4, (char)'0');
                tb.setTbbh("TBSC" + date + xh);
                taskTbs.add(this.createPlanTaskTb(task.getId(), tb, reader));
                tb.setPlanTaskid("f7518261-2daa-4aeb-b7a1-67c72edb464b");
                tbs.add(tb);
            }
        }
        if (hasDraw) {
            temps = this.dispatchTbTempDao.ListByIds(createInfo.getDrawTbids());
            if (temps == null || temps.isEmpty()) {
                throw new Exception("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,\u8c03\u5ea6\u56fe\u6591[\u7ed8\u5236\u5bfc\u5165]\u4e0d\u5b58\u5728");
            }
            count = 0;
            for (TbtskDispatchTbTemp temp : temps) {
                tb = new TbtskDispatchInfo();
                BeanUtils.copyProperties((Object)temp, (Object)tb);
                tb.setDispatch(Integer.valueOf(0));
                tb.setImportFc(Integer.valueOf(0));
                tb.setDispatchId(task.getId());
                xh = String.valueOf(++count);
                xh = StringUtils.leftPad((String)xh, (int)4, (char)'0');
                tb.setTbbh("TBHZ" + date + xh);
                taskTbs.add(this.createPlanTaskTb(task.getId(), tb, reader));
                tb.setPlanTaskid("f7518261-2daa-4aeb-b7a1-67c72edb464b");
                tbs.add(tb);
            }
        }
        if (hasTask) {
            List taskTbInfos = createInfo.getTaskTbids();
            for (TaskTbInfo tbInfo : taskTbInfos) {
                if (StringUtils.isBlank((CharSequence)tbInfo.getTaskId())) {
                    throw new Exception("\u4e1a\u52a1\u4efb\u52a1id\u4e3a\u7a7a");
                }
                if (tbInfo.getTbids() == null || tbInfo.getTbids().isEmpty()) {
                    throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u56fe\u6591id\u4e3a\u7a7a");
                }
                TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(tbInfo.getTaskId());
                if (tskTaskBiz == null) {
                    throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u4e0d\u5b58\u5728");
                }
                TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                if (objectinfo == null) {
                    throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
                    throw new Exception("\u4e1a\u52a1\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
                }
                List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
                if (fields == null || fields.isEmpty()) {
                    throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a");
                }
                TbtskFields tbbhField = fields.stream().filter(t -> t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
                if (tbbhField == null) {
                    List uniqueFields = fields.stream().filter(t -> t.getfUnique() != null && t.getfUnique().equals(1)).collect(Collectors.toList());
                    if (uniqueFields == null | uniqueFields.isEmpty()) {
                        throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728\u552f\u4e00\u503c\u5b57\u6bb5");
                    }
                    tbbhField = (TbtskFields)uniqueFields.get(0);
                }
                String sql = "select f_id, st_astext(f_shape) as f_shape, f_tbmj,f_xzqdmsys," + tbbhField.getfFieldname() + " from " + objectinfo.getfTablename();
                sql = sql + " where f_id in('" + StringUtils.join((Iterable)tbInfo.getTbids(), (String)"','") + "')";
                List maps = this.jdbcTemplate.queryForList(sql);
                for (Map map : maps) {
                    String id = map.get("f_id").toString();
                    String ftbmj = map.get("f_tbmj").toString();
                    String fxzqdm = map.get("f_xzqdmsys").toString();
                    String ftbbh = map.get(tbbhField.getfFieldname()).toString();
                    String fshape = map.get("f_shape").toString();
                    if (fshape.toLowerCase().startsWith("srid")) {
                        fshape = fshape.substring(10);
                    }
                    Geometry geo = reader.read(fshape);
                    HashMap<String, Object> mapRegion = this.getXzqdmSys((Geometry)geo.getCentroid(), fshape, GeometryTrasnUtil.getProjNum(geo));
                    fshape = "SRID=4490;" + fshape;
                    TbtskDispatchInfo info = new TbtskDispatchInfo();
                    info.setId(UUID.randomUUID().toString().replace("-", ""));
                    info.setSource(EnumDispatchSource.task.getCode());
                    info.setDispatch(Integer.valueOf(0));
                    info.setTbmj(Double.valueOf(Double.parseDouble(ftbmj)));
                    info.setShape(fshape);
                    info.setTbbh(ftbbh);
                    info.setDispatchId(task.getId());
                    info.setImportFc(Integer.valueOf(0));
                    if (mapRegion != null) {
                        info.setRegionCode(mapRegion.get("xzqdmsys").toString());
                        info.setRegionName(mapRegion.get("location").toString());
                    }
                    info.setTbid(id);
                    info.setTaskId(tbInfo.getTaskId());
                    taskTbs.add(this.createPlanTaskTb(task.getId(), info, reader));
                    info.setPlanTaskid("f7518261-2daa-4aeb-b7a1-67c72edb464b");
                    tbs.add(info);
                }
            }
        }
        if (insert) {
            this.dispatchRecordDao.gwAccess((GiEntitySaveable)task);
        } else if (update) {
            this.dispatchRecordDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        this.dispatchInfoDao.insertBatch(tbs);
        this.dataBizService.insertDatasBatch(this.getTableNameByTaskId("f7518261-2daa-4aeb-b7a1-67c72edb464b"), taskTbs, "f_shape");
        TbtskDispatchTbTemp delete = new TbtskDispatchTbTemp();
        delete.setUserId(String.valueOf(createInfo.getUserId()));
        this.dispatchTbTempDao.gwDeleteBy((GiEntityRemovable)delete);
        return task;
    }

    public JSONObject getTaskTbList(DispatchTbSearchInfo searchInfo, Integer page, Integer limit) throws org.locationtech.jts.io.ParseException {
        String regionCode;
        JSONObject result = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)searchInfo.getRegionCode()) && (regionCode = searchInfo.getRegionCode()).length() == 6) {
            if (regionCode.endsWith("0000")) {
                regionCode = regionCode.substring(0, 2);
            } else if (regionCode.endsWith("00")) {
                regionCode = regionCode.substring(0, 4);
            }
            searchInfo.setRegionCode(regionCode);
        }
        int count = this.dispatchInfoDao.count(searchInfo);
        result.put("totalCount", (Object)count);
        if (count == 0) {
            return result;
        }
        Integer offset = (page - 1) * limit;
        List tbs = this.dispatchInfoDao.selectPage(searchInfo, offset, limit);
        ArrayList<DispatchTbDto> dtos = new ArrayList<DispatchTbDto>();
        WKTReader reader = new WKTReader();
        for (TbtskDispatchInfo tb : tbs) {
            DispatchTbDto dto = new DispatchTbDto();
            BeanUtils.copyProperties((Object)tb, (Object)dto);
            try {
                Geometry geo = reader.read(tb.getShape());
                Point p = geo.getCentroid();
                dto.setLon(Double.valueOf(p.getX()));
                dto.setLat(Double.valueOf(p.getY()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            dtos.add(dto);
        }
        result.put("dispatchTbs", dtos);
        return result;
    }

    public JSONObject getTaskList(DispatchTaskSearchInfo searchInfo, Integer page, Integer limit) {
        JSONObject result = new JSONObject();
        int count = this.dispatchRecordDao.count(searchInfo);
        result.put("totalCount", (Object)count);
        if (count == 0) {
            return result;
        }
        Integer offset = (page - 1) * limit;
        List records = this.dispatchRecordDao.selectPage(searchInfo, offset, limit);
        List dispatchIds = records.stream().map(TbtskDispatchRecord::getId).collect(Collectors.toList());
        String sql = "select f_dispatch_id, f_dispatch,count(*) as count from tbtsk_dispatch_info where f_dispatch_id in ('" + StringUtils.join(dispatchIds, (String)"','") + "') group by f_dispatch_id,f_dispatch";
        List maps = this.jdbcTemplate.queryForList(sql);
        ArrayList<DispatchTaskInfo> tasks = new ArrayList<DispatchTaskInfo>();
        for (TbtskDispatchRecord record : records) {
            DispatchTaskInfo task = new DispatchTaskInfo();
            BeanUtils.copyProperties((Object)record, (Object)task);
            task.setDispatchCount(Integer.valueOf(0));
            task.setUnDispatchCount(Integer.valueOf(0));
            task.setTotalCount(Integer.valueOf(0));
            task.setFinished(Boolean.valueOf(false));
            tasks.add(task);
        }
        for (Map map : maps) {
            String id = map.get("f_dispatch_id").toString();
            String dispatch = map.get("f_dispatch").toString();
            Object c = map.get("count");
            Integer disatchCount = 0;
            if (c != null && StringUtils.isNotBlank((CharSequence)c.toString())) {
                disatchCount = Integer.parseInt(c.toString());
            }
            DispatchTaskInfo task = tasks.stream().filter(t -> t.getId().equals(id)).findFirst().get();
            switch (dispatch) {
                case "1": {
                    task.setDispatchCount(disatchCount);
                    break;
                }
                case "0": {
                    task.setUnDispatchCount(disatchCount);
                }
            }
        }
        tasks.forEach(t -> {
            t.setTotalCount(Integer.valueOf(t.getDispatchCount() + t.getUnDispatchCount()));
            t.setFinished(Boolean.valueOf(t.getUnDispatchCount().equals(0)));
        });
        result.put("dispatchTasks", tasks);
        return result;
    }

    public List<TbtskDispatchInfo> searchUnDispatchInfo(String dispathcId) {
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(dispathcId);
        search.setDispatch(Integer.valueOf(0));
        List tbs = this.dispatchInfoDao.gwSearch((GiEntityQueryable)search);
        return tbs;
    }

    public void batchSaveDispatchInfo(String jsonStr) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return;
        }
        List ls = JSONArray.parseArray((String)jsonStr, TbtskDispatchInfo.class);
        for (TbtskDispatchInfo tb : ls) {
            if (StringUtils.isNotBlank((CharSequence)tb.getPhone())) {
                TbsysUserSubjectRel tbsysUserSubjectRel = new TbsysUserSubjectRel();
                tbsysUserSubjectRel.setPhoneNumber(tb.getPhone());
                TbsysUserSubjectRel dbuser = (TbsysUserSubjectRel)this.tbsysUserSubjectRelDao.gwSearchFirst((GiEntityQueryable)tbsysUserSubjectRel);
                if (dbuser == null) {
                    throw new IllegalStateException("\u624b\u673a\u53f7:" + tb.getPhone() + "\u672a\u6ce8\u518c\u7528\u6237");
                }
                String realName = dbuser.getRealName();
                tb.setUserName(realName);
                tb.setUserid(dbuser.getUserId().toString());
            }
            this.dispatchInfoDao.gwUpdateByPK((GiEntityAlterable)tb);
        }
    }

    public TbtskDispatchInfo setDispatchInfo(DispatchTbInfo dispatchInfo) throws Exception {
        TbtskDispatchInfo tb = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)dispatchInfo.getId()));
        if (tb == null) {
            throw new IllegalStateException("\u8c03\u5ea6\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        if (tb.getDispatch() != null && tb.getDispatch().equals(1)) {
            throw new IllegalStateException("\u5f53\u524d\u56fe\u6591\u5df2\u5b8c\u6210\u8c03\u5ea6\uff0c\u4e0d\u80fd\u66f4\u65b0\u8c03\u5ea6\u4fe1\u606f");
        }
        if (StringUtils.isNotBlank((CharSequence)dispatchInfo.getPhone())) {
            TbsysUserSubjectRel tbsysUserSubjectRel = new TbsysUserSubjectRel();
            tbsysUserSubjectRel.setPhoneNumber(dispatchInfo.getPhone());
            TbsysUserSubjectRel dbuser = (TbsysUserSubjectRel)this.tbsysUserSubjectRelDao.gwSearchFirst((GiEntityQueryable)tbsysUserSubjectRel);
            if (dbuser == null) {
                throw new IllegalStateException("\u624b\u673a\u53f7:" + dispatchInfo.getPhone() + "\u672a\u6ce8\u518c\u7528\u6237");
            }
            String realName = dbuser.getRealName();
            tb.setDdzy(dispatchInfo.getDdzy());
            tb.setPhone(dispatchInfo.getPhone());
            tb.setUserName(realName);
            tb.setUserid(dbuser.getUserId().toString());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)dispatchInfo.getTime())) {
            Date time = null;
            try {
                time = df.parse(dispatchInfo.getTime());
            }
            catch (Exception ex) {
                throw new Exception("\u8ba1\u5212\u8c03\u5ea6\u65f6\u95f4:" + dispatchInfo.getTime() + "\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            tb.setTime(time);
        }
        this.dispatchInfoDao.gwUpdateByPK((GiEntityAlterable)tb);
        return tb;
    }

    public Integer planTaskAssign(AuthUserInfo userInfo, String ddid) throws IllegalStateException {
        TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)ddid));
        if (record == null) {
            throw new IllegalStateException("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(ddid);
        search.setDispatch(Integer.valueOf(0));
        List tbs = this.dispatchInfoDao.gwSearch((GiEntityQueryable)search);
        if (tbs == null || tbs.isEmpty()) {
            throw new IllegalStateException("\u6ca1\u6709\u627e\u5230\u672a\u8c03\u5ea6\u56fe\u6591");
        }
        HashMap userTbMap = new HashMap();
        String taskId = "f7518261-2daa-4aeb-b7a1-67c72edb464b";
        Integer count = 0;
        for (TbtskDispatchInfo tb : tbs) {
            if (!StringUtils.isNotEmpty((CharSequence)tb.getUserid())) continue;
            if (!userTbMap.containsKey(tb.getUserid())) {
                userTbMap.put(tb.getUserid(), new ArrayList());
            }
            ((List)userTbMap.get(tb.getUserid())).add(tb.getPlanTbid());
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        if (userTbMap.isEmpty()) {
            throw new IllegalStateException("\u672a\u8c03\u5ea6\u56fe\u6591\u90fd\u672a\u8bbe\u7f6e\u4eba\u5458,\u8bf7\u5148\u8fdb\u884c\u8ba1\u5212\u7f16\u8f91");
        }
        for (String userid : userTbMap.keySet()) {
            JSONArray orgs = new JSONArray();
            JSONObject cacheArray = new JSONObject();
            JSONArray userids = new JSONArray();
            userids.add((Object)userid);
            cacheArray.put("userids", (Object)userids);
            orgs.add((Object)cacheArray);
            JSONArray tasks = JSONArray.parseArray((String)JSONObject.toJSONString(userTbMap.get(userid)), (Feature[])new Feature[0]);
            this.taskAssignService.assignTask(userInfo.getUserId(), taskId, tasks, new JSONArray(), orgs);
        }
        return count;
    }

    public void setDispatchInfo(MultipartFile multipartFile, String dispatchId) throws Exception {
        TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)dispatchId));
        if (record == null) {
            throw new IllegalStateException("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(dispatchId);
        List tbs = this.dispatchInfoDao.gwSearch((GiEntityQueryable)search);
        if (tbs == null || tbs.isEmpty()) {
            throw new IllegalStateException("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u8c03\u5ea6\u56fe\u6591");
        }
        if ((tbs = tbs.stream().filter(t -> t.getDispatch().equals(0)).collect(Collectors.toList())) == null || tbs.isEmpty()) {
            throw new IllegalStateException("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u672a\u8c03\u5ea6\u56fe\u6591");
        }
        File downdirectory = new File(this.localDownload);
        File uploaddirectory = new File(this.localUpload);
        if (!downdirectory.exists() && downdirectory.isDirectory()) {
            downdirectory.mkdir();
        }
        if (!uploaddirectory.exists() && uploaddirectory.isDirectory()) {
            uploaddirectory.mkdir();
        }
        if (!multipartFile.getOriginalFilename().endsWith(".xlsx")) {
            throw new RuntimeException("\u8bf7\u4e0a\u4f20xlsx\u6587\u4ef6");
        }
        FileOutputStream outputStream = null;
        String originalFilename = multipartFile.getOriginalFilename().substring(0, multipartFile.getOriginalFilename().lastIndexOf(".")) + System.currentTimeMillis();
        File excel = null;
        try {
            excel = File.createTempFile(originalFilename, ".xlsx", downdirectory);
            outputStream = new FileOutputStream(excel);
            outputStream.write(multipartFile.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        List<List<Object>> datas = ExcelUtil.readExcelFirstSheet(excel);
        if (datas == null || datas.isEmpty() || datas.size() < 2) {
            throw new Exception("excel\u5185\u65e0\u5f85\u66f4\u65b0\u6570\u636e");
        }
        List<Object> colNames = datas.get(0);
        int tbbhFieldIndex = -1;
        int phoneFieldIndex = -1;
        int timeFieldIndex = -1;
        block20: for (int i = 0; i < colNames.size(); ++i) {
            String name;
            Object obj = colNames.get(i);
            switch (name = obj != null ? obj.toString() : "") {
                case "\u7f16\u53f7": {
                    tbbhFieldIndex = i;
                    continue block20;
                }
                case "\u8c03\u5ea6\u4eba\u624b\u673a\u53f7": {
                    phoneFieldIndex = i;
                    continue block20;
                }
                case "\u8c03\u5ea6\u65f6\u95f4": {
                    timeFieldIndex = i;
                }
            }
        }
        if (tbbhFieldIndex == -1) {
            throw new Exception("excel \u672a\u5305\u542b\u56fe\u6591\u7f16\u53f7\u5b57\u6bb5");
        }
        if (phoneFieldIndex == -1) {
            throw new Exception("excel \u672a\u5305\u542b\u8c03\u5ea6\u4eba\u624b\u673a\u53f7\u5b57\u6bb5");
        }
        if (timeFieldIndex == -1) {
            throw new Exception("excel \u672a\u5305\u542b\u8c03\u5ea6\u65f6\u95f4\u5b57\u6bb5");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ArrayList<TbtskDispatchInfo> updates = new ArrayList<TbtskDispatchInfo>();
        for (int i = 1; i < datas.size(); ++i) {
            String time;
            List<Object> data = datas.get(i);
            Object tbbhObj = data.get(tbbhFieldIndex);
            Object phoneObj = data.get(phoneFieldIndex);
            Object timeObj = data.get(timeFieldIndex);
            String tbbh = tbbhObj != null ? tbbhObj.toString().trim() : "";
            String phone = phoneObj != null ? phoneObj.toString().trim() : "";
            String string = time = timeObj != null ? timeObj.toString().trim() : "";
            if (StringUtils.isBlank((CharSequence)tbbh)) {
                throw new Exception("excel \u5b58\u5728\u56fe\u6591\u7f16\u53f7\u4e3a\u7a7a\u7684\u8bb0\u5f55");
            }
            if (StringUtils.isBlank((CharSequence)phone)) {
                throw new Exception("excel \u5b58\u5728\u8c03\u5ea6\u624b\u673a\u53f7\u4e3a\u7a7a\u7684\u8bb0\u5f55");
            }
            if (StringUtils.isBlank((CharSequence)time)) {
                throw new Exception("excel \u5b58\u5728\u8c03\u5ea6\u65f6\u95f4\u4e3a\u7a7a\u7684\u8bb0\u5f55");
            }
            TbtskDispatchInfo tb = tbs.stream().filter(t -> t.getTbbh().equals(tbbh)).findFirst().orElse(null);
            if (tb == null) continue;
            Date dTime = null;
            if (timeObj instanceof Date) {
                dTime = (Date)timeObj;
            } else {
                try {
                    dTime = df.parse(time);
                }
                catch (Exception ex) {
                    try {
                        dTime = df1.parse(time);
                    }
                    catch (Exception ex1) {
                        throw new Exception("excel \u56fe\u6591\u7f16\u53f7\u4e3a:" + tbbh + "\u7684\u8bb0\u5f55\u8c03\u5ea6\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                    }
                }
            }
            tb.setTime(dTime);
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                BusUserInfoReso reso = this.oauthUserService.getBusUserByPhone(phone);
                if (reso == null) {
                    throw new Exception("\u624b\u673a\u53f7:" + phone + "\u672a\u6ce8\u518c");
                }
                String userRealName = reso.getRealName();
                if (StringUtils.isNotBlank((CharSequence)userRealName)) {
                    userRealName = this.oauthUserService.getRealName(reso.getBusUserId());
                }
                tb.setUserName(userRealName);
            }
            updates.add(tb);
        }
        if (updates == null || updates.isEmpty()) {
            throw new Exception("excel \u672a\u5305\u542b\u5f85\u66f4\u65b0\u8bb0\u5f55");
        }
        this.dispatchInfoDao.gwUpdateByPK(updates);
    }

    public JSONObject getDispatchTbDetialInfo(String tbid) throws Exception {
        TbtskDispatchInfo tb = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (tb == null) {
            throw new Exception("\u8c03\u5ea6\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        WKTReader reader = new WKTReader();
        JSONObject result = new JSONObject();
        if (!tb.getSource().equals(EnumDispatchSource.task.getCode())) {
            JSONArray fieldList = new JSONArray();
            JSONObject tbbh = new JSONObject();
            tbbh.put("fFieldname", (Object)"tbbh");
            tbbh.put("fAlias", (Object)"\u56fe\u6591\u7f16\u53f7");
            tbbh.put("fGroup", (Object)"\u57fa\u672c\u4fe1\u606f");
            tbbh.put("fGroupOrder", (Object)0);
            fieldList.add((Object)tbbh);
            JSONObject regionCode = new JSONObject();
            regionCode.put("fFieldname", (Object)"regionCode");
            regionCode.put("fAlias", (Object)"\u884c\u653f\u533a\u4ee3\u7801");
            regionCode.put("fGroup", (Object)"\u57fa\u672c\u4fe1\u606f");
            regionCode.put("fGroupOrder", (Object)0);
            fieldList.add((Object)regionCode);
            JSONObject regionName = new JSONObject();
            regionName.put("fFieldname", (Object)"regionName");
            regionName.put("fAlias", (Object)"\u884c\u653f\u533a\u540d\u79f0");
            regionName.put("fGroup", (Object)"\u57fa\u672c\u4fe1\u606f");
            regionName.put("fGroupOrder", (Object)0);
            fieldList.add((Object)regionName);
            JSONObject tbmj = new JSONObject();
            tbmj.put("fFieldname", (Object)"tbmj");
            tbmj.put("fAlias", (Object)"\u56fe\u6591\u9762\u79ef(m2)");
            tbmj.put("fGroup", (Object)"\u57fa\u672c\u4fe1\u606f");
            tbmj.put("fGroupOrder", (Object)0);
            fieldList.add((Object)tbmj);
            result.put("tbInfo", (Object)tb);
            result.put("fields", (Object)fieldList);
            List<AppMediaDTO> medias = this.getMedia(tb.getId());
            result.put("medias", medias);
        } else {
            String taskId = tb.getTaskId();
            String taskTbid = tb.getTbid();
            TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
            if (task == null) {
                throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            if (objectinfo == null) {
                throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
                throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
            }
            List fields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
            if (fields == null || fields.isEmpty()) {
                throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a");
            }
            List fieldGroupViews = this.tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(task.getTableId(), "web", "202");
            List groupFields = fieldGroupViews.stream().map(TbtskFieldGroupView::getfFieldname).collect(Collectors.toList());
            List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
            JSONArray fieldArray = new JSONArray();
            for (TbtskFieldGroupView fg : fieldGroupViews) {
                TbtskFields f = allFields.stream().filter(t -> t.getfFieldname().equals(fg.getfFieldname())).findFirst().orElse(null);
                if (f == null) continue;
                JSONObject fJson = (JSONObject)JSONObject.toJSON((Object)f);
                fJson.put("fGroup", (Object)fg.getfSubgroupname());
                fJson.put("fGroupOrder", (Object)fg.getfGrouporder());
                fieldArray.add((Object)fJson);
            }
            Map map = this.jdbcTemplate.queryForMap("select " + StringUtils.join(groupFields, (String)",") + " from " + objectinfo.getfTablename() + " where f_id ='" + taskTbid + "'");
            result.put("tbInfo", (Object)map);
            result.put("fields", (Object)fieldArray);
            List<AppMediaDTO> medias = this.getMedia(taskTbid);
            result.put("medias", medias);
            List records = this.tbtskFlowService.findApproveRecordForThird(taskId, taskTbid);
            result.put("approve", (Object)records);
        }
        result.put("ddls", this.getTbDdls(tbid));
        return result;
    }

    public void exportDispatchExcel(HttpServletResponse response, String dispatchId) throws IOException {
        response.setHeader("Access-Control-Expose-Headers", "status,Content-disposition");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            byte[] bytes;
            TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)dispatchId));
            if (record == null) {
                throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            File file = this.exportDispatchExcel(record, this.localDownload);
            if (file != null && file.exists()) {
                FileInputStream fis = null;
                ByteArrayOutputStream baos = null;
                bytes = null;
                try {
                    int len;
                    fis = new FileInputStream(file);
                    baos = new ByteArrayOutputStream((int)file.length());
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    fis.close();
                    baos.close();
                    bytes = baos.toByteArray();
                    fis = null;
                    baos = null;
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                    try {
                        FileUtils.deleteQuietly((File)file);
                    }
                    catch (Exception exception) {}
                }
            }
            throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591excel\u5931\u8d25");
            response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".xlsx");
            response.setHeader("status", "OK");
            response.setContentType("application/octet-stream");
            response.getOutputStream().write(bytes);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), new Object[]{ex});
            String msg = ex.getMessage();
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = "\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591excel\u5931\u8d25";
            }
            response.setContentType("application/json");
            response.setHeader("status", "FAILD");
            response.getOutputStream().write(msg.getBytes("UTF-8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDispatchShp(HttpServletResponse response, String dispatchId) throws IOException {
        File zipFile;
        block24: {
            response.setHeader("Access-Control-Expose-Headers", "status,Content-disposition");
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            File shpFolder = null;
            zipFile = null;
            try {
                byte[] bytes;
                TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)dispatchId));
                if (record == null) {
                    throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
                }
                String folder = this.localDownload + File.separator + record.getId() + "_" + System.currentTimeMillis();
                shpFolder = new File(folder);
                shpFolder.mkdir();
                File shpFile = this.exportDispatchShp(record, folder);
                if (shpFile == null || !shpFile.exists()) {
                    throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5931\u8d25");
                }
                String zipPath = folder + ".zip";
                ZipUtil1s.zip(folder, zipPath);
                zipFile = new File(zipPath);
                if (zipFile.exists()) {
                    FileInputStream fis = null;
                    ByteArrayOutputStream baos = null;
                    bytes = null;
                    try {
                        int len;
                        fis = new FileInputStream(zipFile);
                        baos = new ByteArrayOutputStream((int)zipFile.length());
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) != -1) {
                            baos.write(buffer, 0, len);
                        }
                        fis.close();
                        baos.close();
                        bytes = baos.toByteArray();
                        fis = null;
                        baos = null;
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                        if (baos != null) {
                            baos.close();
                        }
                        try {
                            FileUtils.deleteQuietly((File)zipFile);
                        }
                        catch (Exception exception) {}
                    }
                }
                throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5931\u8d25,\u538b\u7f29shp\u5931\u8d25");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".zip");
                response.setHeader("status", "OK");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(bytes);
                if (shpFolder == null || !shpFolder.exists()) break block24;
            }
            catch (Exception ex) {
                block25: {
                    try {
                        this.logger.error(ex.getMessage(), new Object[]{ex});
                        String msg = ex.getMessage();
                        if (StringUtils.isBlank((CharSequence)msg)) {
                            msg = "\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5931\u8d25";
                        }
                        response.setContentType("application/json");
                        response.setHeader("status", "FAILD");
                        response.getOutputStream().write(msg.getBytes("UTF-8"));
                        if (shpFolder == null || !shpFolder.exists()) break block25;
                    }
                    catch (Throwable throwable) {
                        if (shpFolder != null && shpFolder.exists()) {
                            FileUtils.deleteQuietly((File)shpFolder);
                        }
                        if (zipFile != null & zipFile.exists()) {
                            FileUtils.deleteQuietly((File)zipFile);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteQuietly((File)shpFolder);
                }
                if (zipFile != null & zipFile.exists()) {
                    FileUtils.deleteQuietly((File)zipFile);
                }
            }
            FileUtils.deleteQuietly((File)shpFolder);
        }
        if (zipFile != null & zipFile.exists()) {
            FileUtils.deleteQuietly((File)zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDispatchPackage(HttpServletResponse response, String dispatchId) throws IOException {
        File rootFolder;
        block26: {
            response.setHeader("Access-Control-Expose-Headers", "status,Content-disposition");
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            rootFolder = null;
            File zipFile = null;
            try {
                byte[] bytes;
                TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)dispatchId));
                if (record == null) {
                    throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
                }
                String rootPath = this.localDownload + File.separator + record.getId() + "_" + System.currentTimeMillis();
                rootFolder = new File(rootPath);
                rootFolder.mkdir();
                File shpFolder = new File(rootPath + File.separator + record.getId() + "_shp");
                shpFolder.mkdir();
                File shp = this.exportDispatchShp(record, shpFolder.getPath());
                if (shp == null || !shp.exists()) {
                    throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5931\u8d25");
                }
                File excel = this.exportDispatchExcel(record, rootPath);
                if (excel == null || !excel.exists()) {
                    throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591excel\u5931\u8d25");
                }
                File db = this.exportDispatchDb(record, rootPath);
                if (db == null || !db.exists()) {
                    throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591db\u5931\u8d25");
                }
                File attachFolder = new File(rootPath + File.separator + record.getId() + "_attach");
                attachFolder.mkdir();
                this.exportDispatchAtt(record, attachFolder.getPath());
                String zipPath = rootFolder + ".zip";
                ZipUtil1s.zip(rootPath, zipPath);
                zipFile = new File(zipPath);
                if (zipFile.exists()) {
                    FileInputStream fis = null;
                    ByteArrayOutputStream baos = null;
                    bytes = null;
                    try {
                        int len;
                        fis = new FileInputStream(zipFile);
                        baos = new ByteArrayOutputStream((int)zipFile.length());
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) != -1) {
                            baos.write(buffer, 0, len);
                        }
                        fis.close();
                        baos.close();
                        bytes = baos.toByteArray();
                        fis = null;
                        baos = null;
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                        if (baos != null) {
                            baos.close();
                        }
                        try {
                            FileUtils.deleteQuietly((File)zipFile);
                        }
                        catch (Exception exception) {}
                    }
                }
                throw new Exception("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591\u6570\u636e\u5305\u5931\u8d25,\u538b\u7f29\u5931\u8d25");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".zip");
                response.setHeader("status", "OK");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(bytes);
                if (!(zipFile != null & zipFile.exists())) break block26;
            }
            catch (Exception ex) {
                block27: {
                    try {
                        this.logger.error(ex.getMessage(), new Object[]{ex});
                        String msg = ex.getMessage();
                        if (StringUtils.isBlank((CharSequence)msg)) {
                            msg = "\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591\u6570\u636e\u5305\u5931\u8d25";
                        }
                        response.setContentType("application/json");
                        response.setHeader("status", "FAILD");
                        response.getOutputStream().write(msg.getBytes("UTF-8"));
                        if (!(zipFile != null & zipFile.exists())) break block27;
                    }
                    catch (Throwable throwable) {
                        if (zipFile != null & zipFile.exists()) {
                            FileUtils.deleteQuietly((File)zipFile);
                        }
                        if (rootFolder != null && rootFolder.exists()) {
                            FileUtils.deleteQuietly((File)rootFolder);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteQuietly((File)zipFile);
                }
                if (rootFolder != null && rootFolder.exists()) {
                    FileUtils.deleteQuietly((File)rootFolder);
                }
            }
            FileUtils.deleteQuietly((File)zipFile);
        }
        if (rootFolder != null && rootFolder.exists()) {
            FileUtils.deleteQuietly((File)rootFolder);
        }
    }

    public JSONArray getNearByDron(Double lon, Double lat, Double distance) throws Exception {
        String sevice = this.fcUrl + "/fczx-server/api/devices/v1/nearby/radius?lon=" + lon + "&lat=" + lat;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONArray result = new JSONArray();
        JSONArray jsonArray = JSONArray.parseArray((String)body, (Feature[])new Feature[0]);
        if (jsonArray != null && !jsonArray.isEmpty()) {
            if (distance != null && distance > 0.0) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    double dis;
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (!jsonObject.containsKey((Object)"distance") || !((dis = jsonObject.getDouble("distance").doubleValue()) <= distance)) continue;
                    result.add((Object)jsonObject);
                }
            } else {
                result = jsonArray;
            }
        }
        return result;
    }

    public JSONArray getNearByCamera(Double lon, Double lat, Double distance) throws Exception {
        HttpResponse response;
        String sevice = this.ygbUrl + "/api/third/getDeviceListByRegionAndName";
        String param = "{\"regionCode\":\"500000\",\"name\":\"\",\"streamType\":\"1\",\"netType\":\"1\",\"protocolType\":\"5\",\"contain\":1}";
        if (distance == null) {
            distance = 5000.0;
        }
        if (!(response = HttpUtil.createPost((String)sevice).body(param).execute()).isOk()) {
            this.logger.error("\u94c1\u5854\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u94c1\u5854\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONArray rows = null;
        JSONObject bodyResult = JSONObject.parseObject((String)body);
        if (bodyResult.containsKey((Object)"status") && bodyResult.getString("status").equalsIgnoreCase("OK")) {
            rows = bodyResult.getJSONArray("rows");
        }
        JSONArray result = new JSONArray();
        if (rows != null && !rows.isEmpty()) {
            HashMap<Integer, CoordinateReferenceSystem> mapRef = new HashMap<Integer, CoordinateReferenceSystem>();
            WKTReader reader = new WKTReader();
            Geometry geo1 = reader.read("POINT(" + lon + " " + lat + ")");
            int num = GeometryTrasnUtil.getProjNum(geo1);
            CoordinateReferenceSystem ref1 = GeometryTrasnUtil.getCgcsPrjCoordinateReferenceSystem(num);
            geo1 = GeometryTrasnUtil.transCgcs2000ToPrj(geo1, ref1);
            mapRef.put(num, ref1);
            if (distance != null && distance > 0.0) {
                for (int i = 0; i < rows.size(); ++i) {
                    String lonlat;
                    JSONObject jsonObject = rows.getJSONObject(i);
                    if (!jsonObject.containsKey((Object)"lonlat") || !StringUtils.isNotBlank((CharSequence)(lonlat = jsonObject.getString("lonlat")))) continue;
                    String[] ll = StringUtils.split((String)lonlat, (String)",");
                    Double lona = Double.parseDouble(ll[0]);
                    Double lata = Double.parseDouble(ll[1]);
                    Geometry geo2 = reader.read("POINT(" + lona + " " + lata + ")");
                    num = GeometryTrasnUtil.getProjNum(geo2);
                    CoordinateReferenceSystem ref2 = null;
                    if (!mapRef.containsKey(num)) {
                        ref2 = GeometryTrasnUtil.getCgcsPrjCoordinateReferenceSystem(num);
                        mapRef.put(num, ref2);
                    } else {
                        ref2 = (CoordinateReferenceSystem)mapRef.get(num);
                    }
                    geo2 = GeometryTrasnUtil.transCgcs2000ToPrj(geo2, ref2);
                    double leng = geo1.distance(geo2);
                    if (!(leng <= distance)) continue;
                    result.add((Object)jsonObject);
                }
            } else {
                result = rows;
            }
        }
        return result;
    }

    public JSONObject getPageNearUser(String name, Double lon, Double lat, Double distance, Integer page, Integer limit) throws Exception {
        if (distance == null) {
            distance = 5000.0;
        }
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql = String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\nt3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\nt4 as (select * from t3 where f_distance <%s order by f_distance)\nselect  t5.f_userid,t5.f_username,t5.f_mid_userid,t5.f_subject_userid,t4.f_distance,t4.f_lon,t4.f_lat from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid", before5, lon, lat, distance);
        String countSql = String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\nt3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\nt4 as (select * from t3 where f_distance <%s order by f_distance)\nselect count(1) from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid", before5, lon, lat, distance);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            countSql = countSql + " where t5.f_username like '%" + name + "%'";
            sql = sql + " where t5.f_username like '%" + name + "%'";
        }
        JSONObject result = new JSONObject();
        Map mapCount = this.jdbcTemplate.queryForMap(countSql);
        int count = Integer.parseInt(mapCount.get("count").toString());
        result.put("count", (Object)count);
        if (count == 0) {
            return result;
        }
        int offset = (page - 1) * limit;
        List maps = this.jdbcTemplate.queryForList(sql = sql + " order by f_userid offset " + offset + " limit " + limit);
        if (maps == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<OnlineUserInfo> users = new ArrayList<OnlineUserInfo>();
        for (Map map : maps) {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            BusUserInfoReso reso = this.oauthUserService.getBusUser(busId);
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.valueOf(Long.parseLong(userId)));
            user.setUserName(map.get("f_username").toString());
            if (reso != null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setDistance(Double.valueOf(Double.parseDouble(map.get("f_distance").toString())));
            user.setLon(Double.valueOf(Double.parseDouble(map.get("f_lon").toString())));
            user.setLat(Double.valueOf(Double.parseDouble(map.get("f_lat").toString())));
            users.add(user);
        }
        result.put("list", users);
        return result;
    }

    public List<OnlineUserInfo> getNearByUser(String name, Double lon, Double lat, Double distance) throws Exception {
        List maps;
        if (distance == null) {
            distance = 5000.0;
        }
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql = String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\nt3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\nt4 as (select * from t3 where f_distance <%s order by f_distance)\nselect  t5.f_userid,t5.f_username,t5.f_mid_userid,t5.f_subject_userid,t4.f_distance,t4.f_lon,t4.f_lat from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid", before5, lon, lat, distance);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sql = sql + " where t5.f_username like '%" + name + "%'";
        }
        if ((maps = this.jdbcTemplate.queryForList(sql)) == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<OnlineUserInfo> users = new ArrayList<OnlineUserInfo>();
        for (Map map : maps) {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            BusUserInfoReso reso = this.oauthUserService.getBusUser(busId);
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.valueOf(Long.parseLong(userId)));
            user.setUserName(map.get("f_username").toString());
            if (reso != null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setDistance(Double.valueOf(Double.parseDouble(map.get("f_distance").toString())));
            user.setLon(Double.valueOf(Double.parseDouble(map.get("f_lon").toString())));
            user.setLat(Double.valueOf(Double.parseDouble(map.get("f_lat").toString())));
            users.add(user);
        }
        return users;
    }

    public JSONObject getAllOnlineDron(String name) throws Exception {
        String sevice = this.fcUrl + "/fczx-server/api/devices/v1/list?status=true&withChild=true";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray datas = new JSONArray();
        JSONArray jsonArray = JSONArray.parseArray((String)body, (Feature[])new Feature[0]);
        if (jsonArray != null && !jsonArray.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String nickname;
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (!jsonObject.containsKey((Object)"nickname") || !StringUtils.isNotBlank((CharSequence)(nickname = jsonObject.getString("nickname"))) || !nickname.contains(name)) continue;
                    datas.add((Object)jsonObject);
                }
            } else {
                datas = jsonArray;
            }
        }
        result.put("totalCount", (Object)datas.size());
        result.put("data", (Object)datas);
        return result;
    }

    public JSONObject getAllOnlineCamera(String name) throws Exception {
        String sevice = this.ygbUrl + "/api/third/getDeviceListByRegionAndName";
        String param = "{\"regionCode\":\"500000\",\"name\":\"\",\"streamType\":\"1\",\"netType\":\"1\",\"protocolType\":\"5\",\"contain\":1}";
        HttpResponse response = HttpUtil.createPost((String)sevice).body(param).execute();
        if (!response.isOk()) {
            this.logger.error("\u94c1\u5854\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u94c1\u5854\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONArray rows = null;
        JSONObject bodyResult = JSONObject.parseObject((String)body);
        if (bodyResult.containsKey((Object)"status") && bodyResult.getString("status").equalsIgnoreCase("OK")) {
            rows = bodyResult.getJSONArray("rows");
        }
        JSONObject result = new JSONObject();
        JSONArray datas = new JSONArray();
        if (rows != null && !rows.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                for (int i = 0; i < rows.size(); ++i) {
                    String nickname;
                    JSONObject jsonObject = rows.getJSONObject(i);
                    if (!jsonObject.containsKey((Object)"name") || !StringUtils.isNotBlank((CharSequence)(nickname = jsonObject.getString("name"))) || !nickname.contains(name)) continue;
                    datas.add((Object)jsonObject);
                }
            } else {
                datas = rows;
            }
        }
        result.put("totalCount", (Object)datas.size());
        result.put("data", (Object)datas);
        return result;
    }

    public JSONObject getPageOnlineUser(String name, Integer page, Integer limit) throws Exception {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String countSql = String.format("select count(*) as count from tbsys_user  where f_userid in (select distinct (f_userid) from tb_devicetrack td where f_updatetime > '%s')", before5);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            countSql = countSql + " and f_username like '%" + name + "%'";
        }
        JSONObject result = new JSONObject();
        Map mapCount = this.jdbcTemplate.queryForMap(countSql);
        int count = Integer.parseInt(mapCount.get("count").toString());
        result.put("count", (Object)count);
        if (count == 0) {
            return result;
        }
        String sql = String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\nt3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime)\nselect  t4.f_userid,t4.f_username,t4.f_mid_userid,t4.f_subject_userid,t3.f_lon,t3.f_lat from tbsys_user t4 inner join t3 on t4.f_userid  = t3.f_userid", before5);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sql = sql + " and t4.f_username like '%" + name + "%'";
        }
        int offset = (page - 1) * limit;
        List maps = this.jdbcTemplate.queryForList(sql = sql + " order by f_userid offset " + offset + " limit " + limit);
        if (maps == null || maps.isEmpty()) {
            return result;
        }
        ArrayList<OnlineUserInfo> users = new ArrayList<OnlineUserInfo>();
        for (Map map : maps) {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.valueOf(Long.parseLong(userId)));
            user.setUserName(map.get("f_username").toString());
            BusUserInfoReso reso = this.oauthUserService.getBusUser(busId);
            if (reso != null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setLon(Double.valueOf(Double.parseDouble(map.get("f_lon").toString())));
            user.setLat(Double.valueOf(Double.parseDouble(map.get("f_lat").toString())));
            users.add(user);
        }
        result.put("list", users);
        return result;
    }

    public JSONObject getAllOnlineUser(String name) {
        List maps;
        JSONObject result = new JSONObject();
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql = String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\nt3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime)\nselect  t4.f_userid,t4.f_username,t4.f_mid_userid,t4.f_subject_userid,t3.f_lon,t3.f_lat from tbsys_user t4 inner join t3 on t4.f_userid  = t3.f_userid", before5);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sql = sql + " and t4.f_username like '%" + name + "'";
        }
        if ((maps = this.jdbcTemplate.queryForList(sql)) == null || maps.isEmpty()) {
            result.put("totalCount", (Object)0);
            return result;
        }
        ArrayList<OnlineUserInfo> users = new ArrayList<OnlineUserInfo>();
        for (Map map : maps) {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.valueOf(Long.parseLong(userId)));
            user.setUserName(map.get("f_username").toString());
            user.setLon(Double.valueOf(Double.parseDouble(map.get("f_lon").toString())));
            user.setLat(Double.valueOf(Double.parseDouble(map.get("f_lat").toString())));
            users.add(user);
        }
        result.put("totalCount", (Object)users.size());
        result.put("data", users);
        return result;
    }

    public OnlineUserInfo getUserInfo(Long userId) {
        List rels = this.tbsysUserSubjectRelRepository.findByUserId(userId);
        if (rels == null || rels.isEmpty()) {
            return null;
        }
        String busId = ((TbsysUserSubjectRel)rels.get(0)).getSubjectUserId();
        if (StringUtils.isBlank((CharSequence)busId)) {
            return null;
        }
        BusUserInfoReso reso = this.oauthUserService.getBusUser(busId);
        if (reso != null) {
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserPhone(reso.getPhone());
            user.setUserOrg(reso.getOrgName());
            user.setUserId(userId);
            return user;
        }
        return null;
    }

    public JSONObject getCameraVideoRealtimeUrl(String channelCode, String deviceCode) throws Exception {
        String sevice = this.ygbUrl + "/api/third/getVideoRealtimeUrl";
        String param = String.format("{\"deviceCode\":\"%s\",\"channelCode\":\"%s\",\"streamType\":\"1\",\"protocolType\":\"5\",\"netType\":\"1\"}", deviceCode, channelCode);
        return this.getVideoRealtimeUrl(JSONObject.parseObject((String)param));
    }

    public String getCameraUrl(String channelCode, String deviceCode) throws Exception {
        JSONObject object2 = new JSONObject();
        object2.put("streamType", (Object)2);
        object2.put("protocolType", (Object)4);
        object2.put("netType", (Object)1);
        object2.put("deviceCode", (Object)deviceCode);
        object2.put("channelCode", (Object)channelCode);
        JSONObject result = this.getVideoRealtimeUrl(object2);
        String url = result.getString("streamUrl");
        return url;
    }

    public JSONArray getDronCapacity() throws Exception {
        String sevice = this.djUrl + "/dji-cloud-server/manage/api/v1/live/capacity";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (result.containsKey((Object)"data")) {
            return result.getJSONArray("data");
        }
        return null;
    }

    public JSONObject startDronLive(JSONObject param) throws Exception {
        if (param == null) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"url")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"url_type")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"video_id")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"video_quality")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        String sevice = this.djUrl + "/dji-cloud-server/manage/api/v1/live/streams/start";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(param.toJSONString()).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (result.containsKey((Object)"data")) {
            return result.getJSONObject("data");
        }
        return null;
    }

    public JSONObject stopDronLive(JSONObject param) throws Exception {
        if (param == null) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"url")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"url_type")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"video_id")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (!param.containsKey((Object)"video_quality")) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        String sevice = this.djUrl + "/dji-cloud-server/manage/api/v1/live/streams/stop";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(param.toJSONString()).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (result.containsKey((Object)"data")) {
            return result.getJSONObject("data");
        }
        return null;
    }

    public JSONArray getWaylinesCalcRange(JSONObject param) throws Exception {
        String sevice = this.fcUrl + "/fczx-server/api/waylines/v1/calc/range";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(param.toJSONString()).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        JSONArray result = JSONArray.parseArray((String)body, (Feature[])new Feature[0]);
        return result;
    }

    public JSONObject getWaylinesJob(String jobId) throws Exception {
        String sevice = String.format(this.fcUrl + "/fczx-server/api/waylines/v1/job/%s", jobId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u83b7\u53d6\u4efb\u52a1\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)body);
        return result;
    }

    public JSONObject createDronWaylinesJobs(LineJobParamDetailInfo detailInfo) throws Exception {
        if (detailInfo == null) {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
        if (detailInfo.getIds() == null || detailInfo.getIds().size() == 0) {
            throw new Exception("\u672a\u8bbe\u7f6e\u8c03\u5ea6\u56fe\u6591id");
        }
        if (StringUtils.isBlank((CharSequence)detailInfo.getDockSn())) {
            throw new Exception("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u7f16\u53f7");
        }
        List ids = detailInfo.getIds();
        List tbs = this.dispatchInfoDao.selectByIds(ids);
        if (tbs == null || tbs.isEmpty()) {
            throw new Exception("\u8c03\u5ea6\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        if (tbs.size() != ids.size()) {
            List notExist = ids.stream().filter(t -> tbs.stream().filter(s -> !s.getId().equals(t)).findFirst().isPresent()).collect(Collectors.toList());
            throw new Exception("\u8c03\u5ea6\u56fe\u6591" + StringUtils.join(notExist, (String)",") + "\u4e0d\u5b58\u5728");
        }
        TbtskDispatchRecord record = (TbtskDispatchRecord)this.dispatchRecordDao.gwSearchByPK((Serializable)((Object)((TbtskDispatchInfo)tbs.get(0)).getDispatchId()));
        if (record == null) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        List needImport = tbs.stream().filter(t -> t.getImportFc() == null || t.getImportFc() == 0).collect(Collectors.toList());
        if (needImport != null && !needImport.isEmpty()) {
            File zipFile = null;
            File shpFolder = null;
            try {
                String folder1;
                String folder = this.localUpload + File.separator + "a9fa7f5236d62437d9896f6a45a3bd3d7" + System.currentTimeMillis();
                shpFolder = new File(folder);
                if (!shpFolder.exists()) {
                    shpFolder.mkdir();
                }
                if (!(shpFolder = new File(folder1 = folder + File.separator + System.currentTimeMillis())).exists()) {
                    shpFolder.mkdir();
                }
                File shpFile = this.exportDispatchShpToImport(folder1, needImport.stream().map(TbtskDispatchInfo::getId).collect(Collectors.toList()));
                ZipUtil1s.zip(folder1, folder1 + ".zip");
                zipFile = new File(folder1 + ".zip");
            }
            catch (Exception ex) {
                this.logger.error("\u4e0b\u8f7d\u8c03\u5ea6\u56fe\u6591\u4e3ashp\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            if (shpFolder != null && shpFolder.exists()) {
                FileUtils.deleteQuietly((File)shpFolder);
            }
            if (zipFile == null || !zipFile.exists()) {
                throw new Exception("\u5f53\u524d\u56fe\u6591\u672a\u63a8\u9001\u5230\u65e0\u4eba\u673a\u5de1\u67e5\u7cfb\u7edf");
            }
            try {
                String importUrl = this.fcUrl + "/fczx-server/api/spots/v1/import/shape";
                HttpResponse response = HttpUtil.createPost((String)importUrl).form("attributeMap['bsm']", (Object)"f_id").form("attributeMap['dlbm']", (Object)"f_dlbm").form("attributeMap['dlmc']", (Object)"f_dlmc").form("attributeMap['zldwdm']", (Object)"f_zldwdm").form("attributeMap['zldwmc']", (Object)"f_zldwmc").form("attributeMap['tbmj']", (Object)"f_tbmj").form("attributeMap['geom']", (Object)"the_geom").form("charset", (Object)"GBK").form("namespaceId", (Object)"a9fa7f5236d62437d9896f6a45a3bd3d7").form("file", zipFile).execute();
                String body = response.body();
                boolean sucImport = false;
                if (!StringUtils.isBlank((CharSequence)body)) {
                    sucImport = true;
                    try {
                        JSONObject json = JSONObject.parseObject((String)body);
                        if (json.containsKey((Object)"status") && !json.getString("status").equalsIgnoreCase("ok")) {
                            sucImport = false;
                        }
                    }
                    catch (Exception json) {
                        // empty catch block
                    }
                }
                if (!sucImport) {
                    throw new Exception("\u5f53\u524d\u56fe\u6591\u63a8\u9001\u5230\u65e0\u4eba\u673a\u5de1\u67e5\u7cfb\u7edf\u5931\u8d25");
                }
                this.dispatchInfoDao.updateImport(ids);
            }
            catch (Exception ex) {
                this.logger.error("\u5f53\u524d\u56fe\u6591\u63a8\u9001\u5230\u65e0\u4eba\u673a\u5de1\u67e5\u7cfb\u7edf\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
                throw new Exception("\u5f53\u524d\u56fe\u6591\u63a8\u9001\u5230\u65e0\u4eba\u673a\u5de1\u67e5\u7cfb\u7edf\u5931\u8d25");
            }
            finally {
                FileUtils.deleteQuietly((File)zipFile);
            }
        }
        String name = "\u7a7a\u5929\u5730__" + (String)ids.get(0);
        if (StringUtils.isBlank((CharSequence)detailInfo.getJobType())) {
            detailInfo.setJobType("waypoint");
        }
        ArrayList ids2 = new ArrayList();
        ids2.addAll(ids);
        LineJobParamInfo param = new LineJobParamInfo();
        param.setIds(ids2);
        param.setName(name);
        param.setRestrict(new ArrayList());
        param.setNamespaceId("a9fa7f5236d62437d9896f6a45a3bd3d7");
        detailInfo.setXcmj(Double.valueOf(tbs.stream().mapToDouble(TbtskDispatchInfo::getTbmj).sum()));
        ArrayList<LineJobParamDetailInfo> details = new ArrayList<LineJobParamDetailInfo>();
        details.add(detailInfo);
        param.setDetails(details);
        String sevice = this.fcUrl + "/fczx-server/api/waylines/v1/make/job";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(JSONObject.toJSONString((Object)param)).addHeaders(headers)).execute();
        if (!response.isOk()) {
            String body = response.body();
            JSONObject result = JSONObject.parseObject((String)body);
            if (result.containsKey((Object)"status") && result.getString("status").equals("error")) {
                throw new Exception(result.getString("message"));
            }
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body() + " param:" + JSONObject.toJSONString((Object)param), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        JSONObject result = JSONObject.parseObject((String)body);
        String jobId = (String)result.keySet().stream().collect(Collectors.toList()).get(0);
        for (TbtskDispatchInfo info : tbs) {
            TbtskDispatchInfo newInfo = new TbtskDispatchInfo();
            newInfo.setId(info.getId());
            newInfo.setDronJob(jobId);
            newInfo.setImportFc(Integer.valueOf(1));
            this.dispatchInfoDao.gwUpdateByPKSelective((GiEntityAlterable)newInfo);
        }
        return result;
    }

    public JSONArray getJobLine(String jobId) throws Exception {
        String sevice = String.format(this.fcUrl + "/fczx-server/api/waylines/v1/polygon/line?jobId=%s", jobId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u8702\u5de2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u83b7\u53d6\u4efb\u52a1\u822a\u7ebf\u5931\u8d25");
        }
        JSONArray result = JSONArray.parseArray((String)body, (Feature[])new Feature[0]);
        return result;
    }

    public void stopDronJob(String workspaceId, String jobId) throws Exception {
        String sevice = String.format(this.djUrl + "/wayline/api/v1/workspaces/%s/jobs/%s", workspaceId, jobId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        JSONObject param = new JSONObject();
        param.put("status", (Object)0);
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(param.toJSONString()).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u7ec8\u6b62\u98de\u884c\u4efb\u52a1\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (!result.containsKey((Object)"code") || !result.getString("code").equals(0)) {
            throw new Exception("\u7ec8\u6b62\u98de\u884c\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void restartDronJob(String workspaceId, String jobId) throws Exception {
        String sevice = String.format(this.djUrl + "/wayline/api/v1/workspaces/%s/jobs/%s", workspaceId, jobId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        JSONObject param = new JSONObject();
        param.put("status", (Object)1);
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).body(param.toJSONString()).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u6062\u590d\u98de\u884c\u4efb\u52a1\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (!result.containsKey((Object)"code") || !result.getString("code").equals(0)) {
            throw new Exception("\u6062\u590d\u98de\u884c\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void returnHomeDron(String deviceSn) throws Exception {
        String sevice = String.format(this.djUrl + "/control/api/v1/devices/%s/jobs/return_home", deviceSn);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (!result.containsKey((Object)"code") || !result.getString("code").equals(0)) {
            throw new Exception("\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25");
        }
    }

    public void cancleReturnHomeDron(String deviceSn) throws Exception {
        String sevice = String.format(this.djUrl + "/control/api/v1/devices/%s/jobs/return_home_cancel", deviceSn);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)sevice).addHeaders(headers)).execute();
        if (!response.isOk()) {
            this.logger.error("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + response.body(), new Object[0]);
            throw new Exception("\u5927\u7586\u4e91\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        String body = response.body();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new Exception("\u53d6\u6d88\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)body);
        if (!result.containsKey((Object)"code") || !result.getString("code").equals(0)) {
            throw new Exception("\u53d6\u6d88\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25");
        }
    }

    public void setUserDispatchRecord(JSONObject json) {
        TbtskDispatchAttach attach;
        String id = json.getString("dispatchId");
        String url = json.getString("url");
        String snapshotUrl = json.getString("snapshotUrl");
        String fileName = json.getString("fileName");
        String objName = "zhhd/" + id + "/" + fileName;
        try {
            url = this.uploadFile(url, objName);
        }
        catch (Exception ex) {
            this.logger.error("\u4e0a\u4f20\u4eba\u5458\u8c03\u5ea6\u5f55\u5c4f\u4fe1\u606f\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)snapshotUrl)) {
            String objName2 = "zhhd/" + id + "/" + fileName.toLowerCase().replace(".mp4", ".png");
            try {
                snapshotUrl = this.uploadFile(snapshotUrl, objName2);
            }
            catch (Exception ex) {
                this.logger.error("\u4e0a\u4f20\u4eba\u5458\u8c03\u5ea6\u5f55\u5c4f\u9996\u9875\u4fe1\u606f\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
        }
        Date time = new Date();
        ArrayList<TbtskDispatchAttach> attaches = new ArrayList<TbtskDispatchAttach>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-", ""));
            attach.setUrl(url);
            attach.setInfoId(id);
            attach.setTime(time);
            attaches.add(attach);
        }
        if (StringUtils.isNotBlank((CharSequence)snapshotUrl)) {
            attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-", ""));
            attach.setUrl(snapshotUrl);
            attach.setInfoId(id);
            attach.setTime(time);
            attaches.add(attach);
        }
        this.dispatchAttachDao.insertBatch(attaches);
    }

    public TbtskDispatchUser stopDispatch(DispatchResultInfo resultInfo) throws Exception {
        if (resultInfo == null) {
            throw new Exception("\u8c03\u5ea6\u7ed3\u679c\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)resultInfo.getJl())) {
            throw new Exception("\u8c03\u5ea6\u7ed3\u8bba\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)resultInfo.getYj())) {
            throw new Exception("\u8c03\u5ea6\u610f\u89c1\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)resultInfo.getDispatchTbId())) {
            throw new Exception("\u8c03\u5ea6\u56fe\u6591id\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)resultInfo.getConnectId())) {
            throw new Exception("\u8c03\u5ea6(\u4eba\u5458\u3001\u6444\u50cf\u5934\u3001\u65e0\u4eba\u673a)id\u4e3a\u7a7a");
        }
        if (resultInfo.getDispatchType() == null) {
            throw new Exception("\u8c03\u5ea6(\u4eba\u5458\u3001\u6444\u50cf\u5934\u3001\u65e0\u4eba\u673a)\u65b9\u5f0f\u4e3a\u7a7a");
        }
        EnumDispatchType dispatchType = EnumDispatchType.valueOf((Integer)resultInfo.getDispatchType());
        if (dispatchType == null) {
            throw new Exception("\u8c03\u5ea6(\u4eba\u5458\u3001\u6444\u50cf\u5934\u3001\u65e0\u4eba\u673a)\u65b9\u5f0f\u9519\u8bef");
        }
        TbtskDispatchInfo info = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)resultInfo.getDispatchTbId()));
        if (info == null) {
            throw new Exception("\u8c03\u5ea6\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        TbtskDispatchUser user = new TbtskDispatchUser();
        user.setId(UUID.randomUUID().toString().replace("-", ""));
        user.setInfoId(resultInfo.getDispatchTbId());
        user.setConclusion(resultInfo.getJl());
        user.setOpinion(resultInfo.getYj());
        user.setConnectId(resultInfo.getConnectId());
        user.setType(resultInfo.getDispatchType());
        user.setTime(new Date());
        user.setDispatchId(info.getDispatchId());
        this.dispatchUserDao.gwAccess((GiEntitySaveable)user);
        info.setDispatch(Integer.valueOf(1));
        info.setJl(resultInfo.getJl());
        info.setYj(resultInfo.getYj());
        this.dispatchInfoDao.gwUpdateByPK((GiEntityAlterable)info);
        this.logger.info("\u5b8c\u6210\u8c03\u5ea6\uff0c\u8c03\u5ea6\u56fe\u6591id:" + info.getId(), new Object[0]);
        if (resultInfo.getDispatchType().equals(EnumDispatchType.draw.getCode())) {
            this.logger.info("\u5b8c\u6210\u65e0\u4eba\u673a\u8c03\u5ea6\uff0c\u8c03\u5ea6\u56fe\u6591id:" + info.getId(), new Object[0]);
            CompletableFuture.runAsync(() -> this.getDronJpg(info.getDronJob(), info.getTbid(), info.getTaskId(), info.getId()));
        }
        return user;
    }

    public List<TbtskDispatchAttach> uploadAttach(MultipartFile[] files, String tbid) throws Exception {
        if (StringUtils.isBlank((CharSequence)tbid)) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591id");
        }
        if (files == null || files.length == 0) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        TbtskDispatchInfo info = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        if (info == null) {
            throw new Exception("\u8c03\u5ea6\u56fe\u6591\u4e0d\u5b58\u5728");
        }
        File uploaddirectory = new File(this.localUpload);
        if (!uploaddirectory.exists() && uploaddirectory.isDirectory()) {
            uploaddirectory.mkdir();
        }
        String uploadFolderPath = this.localUpload + File.separator + tbid + System.currentTimeMillis();
        File uploadFolder = new File(uploadFolderPath);
        uploadFolder.mkdir();
        ArrayList<String> urls = new ArrayList<String>();
        for (MultipartFile file : files) {
            Object outputStream = null;
            String originalFilename = file.getOriginalFilename();
            String objName = "zhhd/" + tbid + "/" + originalFilename;
            String url = this.defaultOssOperatorService.sendObject2Oss(objName, file.getInputStream());
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new Exception("\u4e0a\u4f20\u6587\u4ef6:" + originalFilename + "\u5931\u8d25");
            }
            urls.add(url);
        }
        Date time = new Date();
        ArrayList<TbtskDispatchAttach> attaches = new ArrayList<TbtskDispatchAttach>();
        for (String url : urls) {
            TbtskDispatchAttach attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-", ""));
            attach.setUrl(url);
            attach.setInfoId(tbid);
            attach.setTime(time);
            attaches.add(attach);
        }
        this.dispatchAttachDao.insertBatch(attaches);
        return attaches;
    }

    public JSONObject getDispatchResult(String tbid) {
        TbtskDispatchInfo tb = (TbtskDispatchInfo)this.dispatchInfoDao.gwSearchByPK((Serializable)((Object)tbid));
        TbtskDispatchAttach attach = new TbtskDispatchAttach();
        attach.setInfoId(tbid);
        List attaches = this.dispatchAttachDao.gwSearch((GiEntityQueryable)attach);
        ArrayList<DispatchAttachDto> attachDtos = new ArrayList<DispatchAttachDto>();
        if (attaches != null && !attaches.isEmpty()) {
            for (TbtskDispatchAttach a : attaches) {
                String[] names = StringUtils.split((String)a.getUrl(), (String)"/");
                String name = names[names.length - 1];
                String ext = name.substring(name.lastIndexOf(".") + 1);
                name = name.substring(0, name.lastIndexOf("."));
                a.setUrl(this.temporarySignedUrlService.getTemporarySignedUrl("", a.getUrl(), null));
                DispatchAttachDto dto = new DispatchAttachDto();
                BeanUtils.copyProperties((Object)a, (Object)dto);
                dto.setName(name);
                dto.setExt(ext);
                attachDtos.add(dto);
            }
        }
        JSONObject result = new JSONObject();
        result.put("dispatchTb", (Object)tb);
        result.put("attachs", attachDtos);
        return result;
    }

    public void deleteAttach(String attachId) {
        this.dispatchAttachDao.gwDeleteByPK((Serializable)((Object)attachId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportDispatchExcel(TbtskDispatchRecord record, String rootFolder) throws Exception {
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(record.getId());
        List tbs = this.dispatchInfoDao.gwSearch((GiEntityQueryable)search);
        if (tbs == null || tbs.isEmpty()) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u8c03\u5ea6\u56fe\u6591");
        }
        tbs.sort((a, b) -> a.getTbbh().compareTo(b.getTbbh()));
        String report = rootFolder + File.separator + record.getId() + "_" + System.currentTimeMillis() + ".xlsx";
        SXSSFWorkbook excelWorkBook = ExcelUtil.CreateSXSSExcel();
        Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, record.getName());
        ArrayList<Integer> colWidth = new ArrayList<Integer>();
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        for (int i = 0; i < colWidth.size(); ++i) {
            excelSheet.setColumnWidth(i, (Integer)colWidth.get(i) * 200);
        }
        ArrayList<ExcelRowData> rows = new ArrayList<ExcelRowData>();
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("\u7f16\u53f7");
        headers.add("\u653f\u533a");
        headers.add("\u9762\u79ef(m2)");
        headers.add("\u72b6\u6001");
        headers.add("\u8c03\u5ea6\u4eba");
        headers.add("\u8c03\u5ea6\u4eba\u624b\u673a\u53f7");
        headers.add("\u8c03\u5ea6\u65f6\u95f4");
        headers.add("\u7ed3\u8bba");
        headers.add("\u610f\u89c1");
        ArrayList<ExcelColData> herderCols = new ArrayList<ExcelColData>();
        for (int i = 0; i < headers.size(); ++i) {
            ExcelColData header1 = new ExcelColData();
            header1.setMergeCell(false);
            header1.setBold(true);
            header1.setValue((String)headers.get(i));
            header1.setFontSize(16);
            header1.setTextLocation(EnumTextLocation.middle);
            header1.setColIndex(i);
            herderCols.add(header1);
        }
        ExcelRowData excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(herderCols);
        excelRow1.setRowIndex(0);
        rows.add(excelRow1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<ExcelColData> dataCols = new ArrayList<ExcelColData>();
        int count = 0;
        for (TbtskDispatchInfo tb : tbs) {
            ++count;
            ExcelColData data1 = new ExcelColData();
            data1.setMergeCell(false);
            data1.setBold(false);
            data1.setValue(tb.getTbbh());
            data1.setFontSize(16);
            data1.setTextLocation(EnumTextLocation.middle);
            data1.setColIndex(0);
            dataCols.add(data1);
            ExcelColData data2 = new ExcelColData();
            data2.setMergeCell(false);
            data2.setBold(false);
            data2.setValue(tb.getRegionName());
            data2.setFontSize(16);
            data2.setTextLocation(EnumTextLocation.middle);
            data2.setColIndex(1);
            dataCols.add(data2);
            ExcelColData data3 = new ExcelColData();
            data3.setMergeCell(false);
            data3.setBold(false);
            data3.setValue(tb.getTbmj().toString());
            data3.setFontSize(16);
            data3.setTextLocation(EnumTextLocation.middle);
            data3.setColIndex(2);
            dataCols.add(data3);
            ExcelColData data4 = new ExcelColData();
            data4.setMergeCell(false);
            data4.setBold(false);
            data4.setValue(tb.getDispatch().equals(1) ? "\u5df2\u8c03\u5ea6" : "\u672a\u8c03\u5ea6");
            data4.setFontSize(16);
            data4.setTextLocation(EnumTextLocation.middle);
            data4.setColIndex(3);
            dataCols.add(data4);
            ExcelColData data5 = new ExcelColData();
            data5.setMergeCell(false);
            data5.setBold(false);
            data5.setValue(tb.getUserName());
            data5.setFontSize(16);
            data5.setTextLocation(EnumTextLocation.middle);
            data5.setColIndex(4);
            dataCols.add(data5);
            ExcelColData data6 = new ExcelColData();
            data6.setMergeCell(false);
            data6.setBold(false);
            data6.setValue(tb.getPhone());
            data6.setFontSize(16);
            data6.setTextLocation(EnumTextLocation.middle);
            data6.setColIndex(5);
            dataCols.add(data6);
            ExcelColData data7 = new ExcelColData();
            data7.setMergeCell(false);
            data7.setBold(false);
            data7.setValue(tb.getTime() != null ? df.format(tb.getTime()) : "");
            data7.setFontSize(16);
            data7.setTextLocation(EnumTextLocation.middle);
            data7.setColIndex(6);
            dataCols.add(data7);
            ExcelColData data8 = new ExcelColData();
            data8.setMergeCell(false);
            data8.setBold(false);
            data8.setValue(tb.getJl());
            data8.setFontSize(16);
            data8.setTextLocation(EnumTextLocation.middle);
            data8.setColIndex(7);
            dataCols.add(data8);
            ExcelColData data9 = new ExcelColData();
            data9.setMergeCell(false);
            data9.setBold(false);
            data9.setValue(tb.getYj());
            data9.setFontSize(16);
            data9.setTextLocation(EnumTextLocation.middle);
            data9.setColIndex(8);
            dataCols.add(data9);
            ExcelRowData dataRow = new ExcelRowData();
            dataRow.setColDataList(dataCols);
            dataRow.setRowIndex(count);
            rows.add(dataRow);
        }
        ExcelUtil.write(excelSheet, rows);
        FileOutputStream os = null;
        File file = null;
        try {
            file = new File(report);
            os = new FileOutputStream(file);
            excelWorkBook.write((OutputStream)os);
        }
        catch (Exception ex) {
            this.logger.error("\u4fdd\u5b58excel\u5230\u672c\u5730\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            File file2 = null;
            return file2;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (excelWorkBook != null) {
                excelWorkBook.close();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportDispatchShp(TbtskDispatchRecord record, String rootFolder) throws Exception {
        List maps = this.jdbcTemplate.queryForList("select f_tbbh,f_regioncode,f_regionname,f_tbmj,f_dispatch,f_username,f_phone,f_time,f_jl,f_yj,st_astext(f_shape) as f_shape from tbtsk_dispatch_info where f_dispatch_id ='" + record.getId() + "' order by f_tbbh");
        if (maps == null || maps.isEmpty()) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u8c03\u5ea6\u56fe\u6591");
        }
        ArrayList<String> shpFields = new ArrayList<String>();
        shpFields.add("f_id");
        shpFields.add("f_tbbh");
        shpFields.add("f_regioncode");
        shpFields.add("f_regionname");
        shpFields.add("f_tbmj");
        shpFields.add("f_dispatch");
        shpFields.add("f_username");
        shpFields.add("f_phone");
        shpFields.add("f_time");
        shpFields.add("f_jl");
        shpFields.add("f_yj");
        File shpFolder = new File(rootFolder);
        if (!shpFolder.exists()) {
            shpFolder.mkdir();
        }
        String shpPath = rootFolder + File.separator + record.getId() + ".shp";
        ShpObject shpObject = ShpUtil.createShape(shpPath, "GB2312", "MultiPolygon", "f_shape", shpFields);
        try {
            ShpUtil.appendShape(shpObject, "f_shape", maps, shpFields, 100, new Consumer<Integer>(){

                @Override
                public void accept(Integer integer) {
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            File file = null;
            return file;
        }
        finally {
            if (shpObject != null) {
                ShpUtil.dispose(shpObject);
            }
        }
        return new File(shpPath);
    }

    private File exportDispatchDb(TbtskDispatchRecord record, String rootFolder) throws Exception {
        List maps = this.jdbcTemplate.queryForList("select f_tbbh,f_regioncode,f_regionname,f_tbmj,f_dispatch,f_username,f_phone,f_time,st_astext(f_shape) as f_shape from tbtsk_dispatch_info where f_dispatch_id ='" + record.getId() + "' order by f_tbbh");
        if (maps == null || maps.isEmpty()) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u8c03\u5ea6\u56fe\u6591");
        }
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("f_tbbh");
        fields.add("f_regioncode");
        fields.add("f_regionname");
        fields.add("f_tbmj");
        fields.add("f_dispatch");
        fields.add("f_username");
        fields.add("f_phone");
        fields.add("f_time");
        fields.add("f_jl");
        fields.add("f_yj");
        fields.add("f_shape");
        SqlliteConnTool sqlliteConnTool = new SqlliteConnTool();
        String createTaskSql = "create table dispatch_task(f_id varchar(36),f_name varchar(255),f_time varchar(255),f_userid varchar(255))";
        String createTbSql = "create table dispatch_tb(f_tbbh varchar(36),f_regionname varchar(255),f_tbmj varchar(255),f_dispatch varchar(255),f_phone varchar(255),f_username varchar(255),f_time varchar(255),f_jl varchar(255),f_yj varchar(255),f_shape text)";
        sqlliteConnTool.doSql(createTaskSql);
        sqlliteConnTool.doSql(createTbSql);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String insertSql = String.format("insert into dispatch_task(f_id,f_name,f_time,f_userid) values ('%s','%s','%s','%s')", record.getId(), record.getName(), df.format(record.getTime()), record.getUserId());
        sqlliteConnTool.doSql(insertSql);
        ArrayList<String> sqls = new ArrayList<String>();
        for (Map map : maps) {
            String tbbh = map.get("f_tbbh") != null ? map.get("f_tbbh").toString() : "";
            String regionname = map.get("f_regionname") != null ? map.get("f_regionname").toString() : "";
            String tbmj = map.get("f_tbmj") != null ? map.get("f_tbmj").toString() : "";
            String dispatch = map.get("f_dispatch") != null ? map.get("f_dispatch").toString() : "";
            String phone = map.get("f_phone") != null ? map.get("f_phone").toString() : "";
            String username = map.get("f_username") != null ? map.get("f_username").toString() : "";
            String time = map.get("f_time") != null ? map.get("f_time").toString() : "";
            String jl = map.get("f_jl") != null ? map.get("f_jl").toString() : "";
            String yj = map.get("f_yj") != null ? map.get("f_yj").toString() : "";
            String shape = map.get("f_shape").toString();
            sqls.add(String.format("insert into dispatch_tb(f_tbbh,f_regionname,f_tbmj,f_dispatch,f_phone,f_username,f_time,f_jl,f_yj,f_shape) values('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')", tbbh, regionname, tbmj, dispatch, phone, username, time, jl, yj, shape));
        }
        sqlliteConnTool.doSql(StringUtils.join(sqls, (String)";"));
        String filePath = rootFolder + File.separator + record.getId() + "_" + System.currentTimeMillis() + ".db";
        this.store(sqlliteConnTool, filePath);
        return new File(filePath);
    }

    private void exportDispatchAtt(TbtskDispatchRecord record, String rootFolder) {
        String sql = String.format("select * from tbtsk_dispatch_attach where f_info_id in (select f_id from tbtsk_dispatch_info where f_dispatch_id ='%s')", record.getId());
        List maps = this.jdbcTemplate.queryForList(sql);
        if (maps == null || maps.isEmpty()) {
            return;
        }
        Map<String, List<Map>> groupMaps = maps.stream().collect(Collectors.groupingBy(t -> t.get("f_info_id").toString()));
        for (Map.Entry<String, List<Map>> kv : groupMaps.entrySet()) {
            File folder = new File(rootFolder + File.separator + kv.getKey());
            folder.mkdir();
            for (Map map : kv.getValue()) {
                String url = map.get("f_url").toString();
                try {
                    String tempUrl = this.temporarySignedUrlService.getTemporarySignedUrl(null, url, null);
                    String[] paths = url.split("/");
                    String fileName = paths[paths.length - 1];
                    if (fileName.indexOf("?") > -1) {
                        fileName = fileName.substring(0, fileName.indexOf("?"));
                    }
                    File lsFile = new File(folder, fileName);
                    FileUtils.copyURLToFile((URL)new URL(tempUrl), (File)lsFile);
                }
                catch (Exception ex) {
                    this.logger.error("\u4e0b\u8f7d\u9644\u4ef6:" + url + "\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportDispatchShpToImport(String rootFolder, List<String> ids) throws Exception {
        List maps = this.jdbcTemplate.queryForList("select f_id,f_regioncode as f_zldwdm ,f_regionname as f_zldwmc,f_tbmj,'' as f_dlmc,'' as f_dlbm,st_astext(f_shape) as the_geom from tbtsk_dispatch_info where f_id in('" + StringUtils.join(ids, (String)"','") + "') order by f_tbbh");
        if (maps == null || maps.isEmpty()) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728\u8c03\u5ea6\u56fe\u6591");
        }
        ArrayList<String> shpFields = new ArrayList<String>();
        shpFields.add("f_id");
        shpFields.add("f_zldwdm");
        shpFields.add("f_zldwmc");
        shpFields.add("f_tbmj");
        shpFields.add("f_dlmc");
        shpFields.add("f_dlbm");
        File shpFolder = new File(rootFolder);
        if (!shpFolder.exists()) {
            shpFolder.mkdir();
        }
        String shpPath = rootFolder + File.separator + System.currentTimeMillis() + ".shp";
        ShpObject shpObject = ShpUtil.createShape(shpPath, "GBK", "MultiPolygon", "the_geom", shpFields);
        try {
            ShpUtil.appendShape(shpObject, "the_geom", maps, shpFields, 100, new Consumer<Integer>(){

                @Override
                public void accept(Integer integer) {
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("\u5bfc\u51fa\u8c03\u5ea6\u4efb\u52a1\u56fe\u6591shp\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
            File file = null;
            return file;
        }
        finally {
            if (shpObject != null) {
                ShpUtil.dispose(shpObject);
            }
        }
        return new File(shpPath);
    }

    private void getDronJpg(String jobId, String taskTbId, String taskId, String dispatchId) {
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247 jobId:" + jobId + " dispatchId:" + dispatchId, new Object[0]);
        String sevice = String.format(this.fcUrl + "/fczx-server/api/files/v1/wayline/job/%s", jobId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Auth-Token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w");
        int count = 0;
        JSONArray result = null;
        while (count < 4) {
            ++count;
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)sevice).addHeaders(headers)).execute();
            if (response.isOk()) {
                String body = response.body();
                if (!StringUtils.isBlank((CharSequence)body)) {
                    result = JSONArray.parseArray((String)body, (Feature[])new Feature[0]);
                    if (result != null && !result.isEmpty()) break;
                    this.logger.warn("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u83b7\u53d6\u8fd4\u56de\u7a7a jobId:" + jobId, new Object[0]);
                    continue;
                }
                this.logger.warn("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u83b7\u53d6\u5931\u8d25 jobId:" + jobId, new Object[0]);
                continue;
            }
            this.logger.warn("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u83b7\u53d6\u5931\u8d25 jobId:" + jobId + " " + response.body(), new Object[0]);
        }
        if (result == null) {
            this.logger.error("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u83b7\u53d6\u8fd4\u56de\u7a7a jobId:" + jobId, new Object[0]);
            return;
        }
        this.logger.info("\u83b7\u53d6\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247 jobId:" + jobId + " dispatchId:" + dispatchId + " size:" + result.size(), new Object[0]);
        sevice = String.format(this.fcUrl + "/fczx-server/api/files/v1/original", new Object[0]);
        for (int i = 0; i < result.size(); ++i) {
            String fileName = result.getJSONObject(i).getString("fileName");
            String objectKey = result.getJSONObject(i).getString("objectKey");
            String createTime = String.valueOf(System.currentTimeMillis());
            this.logger.info("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u5f00\u59cb\u83b7\u53d6\u6d41\u6587\u4ef6 objectKey:" + objectKey, new Object[0]);
            String url = sevice + "?objectKey=" + objectKey;
            HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders(headers)).execute();
            if (!response.isOk()) {
                this.logger.error("\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247\u83b7\u53d6\u6d41\u6587\u4ef6\u5931\u8d25 objectKey:" + objectKey, new Object[0]);
                continue;
            }
            InputStream is = response.bodyStream();
            String objName = "zhhd/" + dispatchId + "/dron/" + fileName;
            String obsUrl = this.defaultOssOperatorService.sendObject2Oss(objName, is);
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AppMedia appMedia = new AppMedia();
            appMedia.setGalleryid(dispatchId);
            if (StringUtils.isNotBlank((CharSequence)taskTbId)) {
                appMedia.setGalleryid(taskTbId);
            }
            appMedia.setServerpath(obsUrl);
            appMedia.setBizId(taskId);
            if (StringUtils.isBlank((CharSequence)taskId)) {
                appMedia.setBizId("zhdd_shp_draw");
            }
            appMedia.setTime(createTime);
            appMedia.setCreateTime(createTime);
            appMedia.setId(UUID.randomUUID().toString());
            this.appMediaDao.gwAccess((GiEntitySaveable)appMedia);
            this.logger.info("\u8f6c\u5b58\u65e0\u4eba\u673a\u8c03\u5ea6\u7167\u7247 jobId:" + jobId + " dispatchId:" + dispatchId + " fileName:" + fileName, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean store(SqlliteConnTool connection, String destination) throws SQLException {
        try (Statement statement = null;){
            statement = connection.getConnection().createStatement();
            statement.executeUpdate("backup to '" + destination + "'");
            Boolean bl = true;
            return bl;
        }
    }

    public List<File> getFileByType(File file, String type, List<File> list) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            if (file1.isDirectory()) {
                list = this.getFileByType(file1, type, list);
                continue;
            }
            String name = file1.getName();
            if (!name.endsWith(type)) continue;
            list.add(file1);
        }
        return list;
    }

    public List<TbtskDispatchTbTemp> shpInfoList(List<String> shpFilePath, String userId) throws Exception {
        ArrayList<TbtskDispatchTbTemp> dispatchInfos = new ArrayList<TbtskDispatchTbTemp>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = sdf.format(new Date());
        int count = 0;
        DecimalFormat df = new DecimalFormat("#.00");
        for (int i = 0; i < shpFilePath.size(); ++i) {
            ShapefileDataStore shpDataStore = TbtskDispatchServiceImpl.buildDataStore(shpFilePath.get(i));
            shpDataStore.setCharset(Charset.forName("GBK"));
            CoordinateReferenceSystem crs = shpDataStore.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (crs == null) {
                throw new Exception("shp\u7a7a\u95f4\u53c2\u8003\u672a\u5b9a\u4e49");
            }
            String wkt = crs.toWKT();
            if (wkt.contains("PROJCS")) {
                throw new Exception("shp\u7a7a\u95f4\u53c2\u8003\u9519\u8bef,\u8981\u6c42CGCS2000\u5730\u7406\u5750\u6807");
            }
            if (wkt.contains("SPHEROID")) {
                wkt = wkt.substring(wkt.indexOf("SPHEROID"));
                wkt = wkt.substring(0, wkt.indexOf("]"));
                wkt = wkt.replace("SPHEROID[", "");
                String[] info = StringUtils.split((String)(wkt = wkt.replace("]", "")), (String)",");
                if (info.length != 3) {
                    throw new Exception("shp\u7a7a\u95f4\u53c2\u8003\u9519\u8bef,\u8981\u6c42CGCS2000\u5730\u7406\u5750\u6807");
                }
                String SPHEROID = info[0];
                SPHEROID = SPHEROID.trim();
                SPHEROID = SPHEROID.replace("\"", "");
                if (!(SPHEROID = SPHEROID.trim()).equals("CGCS2000")) {
                    throw new Exception("shp\u7a7a\u95f4\u53c2\u8003\u9519\u8bef,\u8981\u6c42CGCS2000\u5730\u7406\u5750\u6807");
                }
            } else {
                throw new Exception("shp\u7a7a\u95f4\u53c2\u8003\u9519\u8bef,\u8981\u6c42CGCS2000\u5730\u7406\u5750\u6807");
            }
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
            Query query = new Query();
            int tbcount = 0;
            try {
                tbcount = featureSource.getCount(query);
            }
            catch (Exception ex) {
                this.logger.error("shp\u6587\u4ef6\u8ba1\u7b97\u56fe\u6591\u6570\u91cf\u5f02\u5e38:" + shpFilePath.get(i) + ExceptionUtil.getErrorString(ex), new Object[0]);
            }
            if (tbcount == 0) {
                throw new RuntimeException("shp\u6587\u4ef6\u56fe\u6591\u6570\u91cf\u4e3a0");
            }
            Map<String, String> mapFields = null;
            try {
                mapFields = ShpUtil.getShpToTableColumns(shpDataStore);
            }
            catch (Exception ex) {
                this.logger.error("shp\u5b57\u6bb5\u83b7\u53d6\u5f02\u5e38:" + shpFilePath.get(i) + ExceptionUtil.getErrorString(ex), new Object[0]);
                throw new RuntimeException("shp\u5b57\u6bb5\u83b7\u53d6\u5f02\u5e38");
            }
            List<String> fields = mapFields.keySet().stream().collect(Collectors.toList());
            fields.removeIf(t -> t.toLowerCase().startsWith("shape_"));
            FeatureCollection collection = null;
            try {
                collection = featureSource.getFeatures();
            }
            catch (Exception ex) {
                this.logger.error("shp\u83b7\u53d6\u8981\u7d20\u96c6\u5408\u5f02\u5e38:" + shpFilePath.get(i) + ExceptionUtil.getErrorString(ex), new Object[0]);
                throw new RuntimeException("shp\u83b7\u53d6\u8981\u7d20\u96c6\u5408\u5f02\u5e38");
            }
            FeatureIterator itertor = collection.features();
            SimpleFeature sf = null;
            while (itertor.hasNext()) {
                sf = (SimpleFeature)itertor.next();
                Geometry geo = (Geometry)sf.getDefaultGeometry();
                if (geo == null) {
                    throw new RuntimeException("shp\u56fe\u5f62\u4e3a\u7a7a");
                }
                if (!geo.getGeometryType().toLowerCase().equals("polygon") && !geo.getGeometryType().toLowerCase().equals("multipolygon")) {
                    throw new RuntimeException("shp\u4e0d\u662f\u9762\u56fe\u5f62");
                }
                int num = GeometryTrasnUtil.getProjNum(geo);
                Map<String, Object> tb = ShpUtil.getFromSimpleFeatureWithoutShape(sf, fields);
                TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
                info.setId(UUID.randomUUID().toString().replace("-", ""));
                info.setUserId(userId);
                info.setSource(EnumDispatchSource.shp.getCode());
                info.setTbInfo(JSONObject.toJSONString(tb));
                HashMap<String, Object> map = this.getXzqdmSys((Geometry)geo.getCentroid(), WKTUtil.geomToWkt((Geometry)geo), num);
                if (map == null) {
                    throw new Exception("\u7ed8\u5236\u8303\u56f4\u4e0d\u5728\u89c4\u5b9a\u533a\u57df\u5185");
                }
                info.setRegionCode(map.get("xzqdmsys").toString());
                info.setRegionName(map.get("location").toString());
                info.setTbmj(Double.valueOf(Double.parseDouble(df.format(Double.parseDouble(map.get("area").toString())))));
                String xh = String.valueOf(++count);
                if (count < 9999) {
                    xh = StringUtils.leftPad((String)xh, (int)4, (String)"0");
                }
                info.setTbbh("TBSC" + date + xh);
                info.setShape("SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
                dispatchInfos.add(info);
            }
            itertor.close();
            shpDataStore.dispose();
        }
        return dispatchInfos;
    }

    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore)factory.createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("GB2312"));
            }
            return dataStore;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HashMap<String, Object> getXzqdmSys(Geometry pt, String wkt, int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\nunion\n(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\nunion\n(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";
            List maps = this.jdbcTemplate.queryForList(sql);
            Map region = null;
            Map regionTown = null;
            Map regionVillage = null;
            for (int i = 0; i < maps.size(); ++i) {
                Object xzqdm = ((Map)maps.get(i)).get("xzqdm");
                if (xzqdm == null) continue;
                if (xzqdm.toString().length() == 12) {
                    regionVillage = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() == 9) {
                    regionTown = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() != 6) continue;
                region = (Map)maps.get(i);
            }
            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage != null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                String string = xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown != null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region != null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }
            String areasql = "select util_computearea(ST_GeomFromText('" + wkt + "',4490)) as area";
            Map areaMap = this.jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            map.put("area", area);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return map;
    }

    private HashMap<String, Object> getXzqdmSys(String villageCode) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String townCode = villageCode.substring(0, 9);
        String countyCode = villageCode.substring(0, 6);
        try {
            String sql = "select f_xzqmc,f_xzqdm from tb_region where f_xzqdm ='" + countyCode + "'\nunion\nselect xzqmc as f_xzqmc,xzqdm as f_xzqdm from tb_region_town where f_xzqdm ='" + townCode + "'\nunion\nselect xzqmc as f_xzqmc,xzqdm as f_xzqdm from tb_region_village where f_xzqdm ='" + villageCode + "'";
            List maps = this.jdbcTemplate.queryForList(sql);
            Map region = null;
            Map regionTown = null;
            Map regionVillage = null;
            for (int i = 0; i < maps.size(); ++i) {
                Object xzqdm = ((Map)maps.get(i)).get("xzqdm");
                if (xzqdm == null) continue;
                if (xzqdm.toString().length() == 12) {
                    regionVillage = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() == 9) {
                    regionTown = (Map)maps.get(i);
                    continue;
                }
                if (xzqdm.toString().length() != 6) continue;
                region = (Map)maps.get(i);
            }
            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage != null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                String string = xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown != null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region != null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank((CharSequence)xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return map;
    }

    private JSONObject getVideoRealtimeUrl(JSONObject param) {
        String path = "/VIDEO-APPLY-API/devices/{deviceCode}/channels/{channelCode}/getVideoRealtimeUrl";
        String deviceCode = param.getString("deviceCode");
        String channelCode = param.getString("channelCode");
        String streamUuid = UUID.randomUUID().toString();
        String plugId = "";
        String streamType = param.getString("streamType");
        String protocolType = param.getString("protocolType");
        String netType = param.getString("netType");
        if (com.meizu.push.sdk.utils.StringUtils.isBlank((CharSequence)netType)) {
            netType = "1";
        }
        path = this.replacePath(path, deviceCode, channelCode);
        Map<String, String> headers = GetSignUtils.getHeaders(path);
        headers.put("X-StreamUuid", streamUuid);
        headers.put("X-PlugId", plugId);
        JSONObject body = new JSONObject();
        body.put("streamType", (Object)streamType);
        body.put("protocolType", (Object)protocolType);
        body.put("netType", (Object)netType);
        JSONObject result = null;
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)this.getUrl(path)).body(body.toJSONString()).addHeaders(headers)).execute();
        if (response.isOk()) {
            result = JSONObject.parseObject((String)response.body());
        }
        response.close();
        return (JSONObject)this.dealResult(result);
    }

    private Object dealResult(JSONObject object) {
        String result = null;
        if (object != null) {
            if (object.containsKey((Object)"returnCode") && "8888".equals(object.getString("returnCode")) || object.containsKey((Object)"code") && !"200".equals(object.getString("code"))) {
                if (object.containsKey((Object)"returnCode")) {
                    throw new RuntimeException(object.getString("errorMsg"));
                }
                if (object.containsKey((Object)"code")) {
                    throw new RuntimeException(object.getString("msg"));
                }
            } else {
                if (object.getString("data") != null && object.getString("data").startsWith("{")) {
                    return object.getJSONObject("data");
                }
                if (object.getString("data") != null && object.getString("data").startsWith("[")) {
                    return object.getJSONArray("data");
                }
                result = object.getString("data");
            }
        }
        return result;
    }

    private String replacePath(String path, String deviceCode, String channelCode) {
        path = path.replace("{deviceCode}", "%s");
        path = path.replace("{channelCode}", "%s");
        path = String.format(path, deviceCode, channelCode);
        return path;
    }

    private String getUrl(String path) {
        SysConfig one = this.sysConfigService.findOne("ttServerPath");
        return one.getValue() + path;
    }

    private List<AppMediaDTO> getMedia(String tbid) {
        List appMedias = this.appMediaDao.queryALLByGid(tbid);
        ArrayList<AppMediaDTO> result = new ArrayList<AppMediaDTO>();
        ArrayList<AppMediaDTO> ja = new ArrayList<AppMediaDTO>();
        for (int i = 0; i < appMedias.size(); ++i) {
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtil.copyProperties(appMedias.get(i), (Object)newMedia);
            if (StringUtils.isBlank((CharSequence)newMedia.getServerpath()) && StringUtils.isNotBlank((CharSequence)newMedia.getDownloadUrl())) {
                newMedia.setServerpath(newMedia.getDownloadUrl());
            }
            if (newMedia.getServerpath() != null) {
                if (StringUtils.isBlank((CharSequence)newMedia.getFromSource())) {
                    String url = newMedia.getServerpath();
                    if (url.contains("?")) {
                        url = StringUtils.split((String)url, (String)"?")[0];
                    }
                    String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                    newMedia.setFileName(fiename);
                    url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
                    if (GutilStr.isNotBlank((CharSequence)url)) {
                        newMedia.setServerpath(url);
                    }
                } else {
                    String from = newMedia.getFromSource();
                    if (from.startsWith(this.importOtherDataService.getMediaSourcePrefix())) {
                        ja.add(newMedia);
                        continue;
                    }
                    OssConfig ossConfig = null;
                    if (mapOssConfig.containsKey(from)) {
                        ossConfig = mapOssConfig.get(from);
                    } else {
                        ossConfig = this.ossConfigRepository.queryBySource(from);
                        mapOssConfig.put(from, ossConfig);
                    }
                    if (ossConfig != null) {
                        String url = newMedia.getServerpath();
                        if (url.contains("?")) {
                            url = StringUtils.split((String)url, (String)"?")[0];
                        }
                        String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                        newMedia.setFileName(fiename);
                        url = this.temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                        if (GutilStr.isNotBlank((CharSequence)url)) {
                            newMedia.setServerpath(url);
                        }
                    }
                }
            }
            result.add(newMedia);
        }
        if (!ja.isEmpty()) {
            try {
                List urls = ja.stream().map(AppMediaDTO::getServerpath).distinct().collect(Collectors.toList());
                urls = this.importOtherDataService.getTempUrl(urls);
                if (urls != null) {
                    for (String url : urls) {
                        List temps = ja.stream().filter(t -> url.startsWith(t.getServerpath())).collect(Collectors.toList());
                        if (temps == null || temps.isEmpty()) continue;
                        for (AppMediaDTO temp : temps) {
                            temp.setServerpath(url);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("JA\u83b7\u53d6\u4e34\u65f6\u5bf9\u8c61\u5b58\u50a8\u8def\u5f84\u5931\u8d25", new Object[]{ex});
            }
            result.addAll(ja);
        }
        return result;
    }

    private String uploadFile(String downloadUrl, String objectName) throws IOException {
        URL url = new URL(downloadUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        String uploadUrl = this.defaultOssOperatorService.sendObject2Oss(objectName, inputStream);
        inputStream.close();
        conn.disconnect();
        return uploadUrl;
    }
}

