/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.zhjgapprove;

import cn.hutool.http.HttpUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.service.task.AuditJobService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.dao.zhjgapprove.ZhjgApproveAtlasTaskDao;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveConfig;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveDataDto;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveShowField;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveShowFieldValue;
import com.geoway.landteam.landcloud.model.zhjgapprove.enm.ZhjgapproveStateEnum;
import com.geoway.landteam.landcloud.model.zhjgapprove.entity.ZhjgApproveAtlasTask;
import com.geoway.landteam.landcloud.servface.zhjgapprove.MZhjgApproveAtlasService;
import com.geoway.landteam.landcloud.service.autoapprove.MAutoApproveServiceImpl;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ZhjgApproveAtlasServiceImpl
implements MZhjgApproveAtlasService {
    private final GiLoger logger = GwLoger.getLoger(MAutoApproveServiceImpl.class);
    @Autowired
    SysConfigRepository sysConfigRepository;
    @Resource
    TskTaskBizRepository tskTaskBizRepository;
    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Resource
    ZhjgApproveAtlasTaskDao zhjgApproveAtlasTaskDao;
    @Resource
    AuditJobService auditJobService;
    @Resource
    JdbcTemplate jdbcTemplate;
    String param;
    final String ZHJC_APPROVE_RESULT = "tb_zhjg_approve_result";

    public void startAtlas() throws Exception {
        ZhjgApproveConfig config = this.getConfig();
        if (config == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)config.getServiceUrl())) {
            this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef,\u5ba1\u6838\u6a21\u578b\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", new Object[0]);
            return;
        }
        if (StringUtils.isBlank((CharSequence)config.getAtlasUrl())) {
            this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef,atlas\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", new Object[0]);
            return;
        }
        if (config.getDatas() == null || config.getDatas().isEmpty()) {
            return;
        }
        for (ZhjgApproveDataDto data : config.getDatas()) {
            if (StringUtils.isBlank((CharSequence)data.getId()) || StringUtils.isBlank((CharSequence)data.getName())) {
                this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef,\u4efb\u52a1\u6570\u636eid\u6216\u8868\u540d\u4e3a\u7a7a", new Object[0]);
                continue;
            }
            Optional task = this.tskTaskBizRepository.findById((Object)data.getId());
            if (!task.isPresent()) {
                this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef,\u4efb\u52a1\u6570\u636e:" + data.getId() + "\u4e0d\u5b58\u5728", new Object[0]);
                continue;
            }
            TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(((TskTaskBiz)task.get()).getTableId());
            if (objectinfo == null) {
                this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef,\u4efb\u52a1\u6570\u636e:" + data.getId() + "\u4e0d\u5b58\u5728", new Object[0]);
                continue;
            }
            String id = UUID.randomUUID().toString();
            String resultTable = "temp_zhjg_" + id.replace("-", "");
            ZhjgApproveAtlasTask zhjgApproveAtlasTask = new ZhjgApproveAtlasTask();
            zhjgApproveAtlasTask.setId(id);
            zhjgApproveAtlasTask.setTaskId(data.getId());
            zhjgApproveAtlasTask.setResult(resultTable);
            zhjgApproveAtlasTask.setCreateTime(new Date());
            zhjgApproveAtlasTask.setStatus(Short.valueOf(ZhjgapproveStateEnum.create.getCode().shortValue()));
            String filter = "f_status >=10";
            String db = this.getDB();
            if (StringUtils.isBlank((CharSequence)this.param)) {
                this.param = this.getTemplate();
            }
            String curParam = this.param;
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("{source}", db + "/" + objectinfo.getfTablename());
            mapParam.put("{sourceId}", data.getId());
            mapParam.put("{sourceFilter}", filter);
            mapParam.put("{result}", db + "/" + resultTable);
            for (Map.Entry kv : mapParam.entrySet()) {
                curParam = curParam.replace((CharSequence)kv.getKey(), (CharSequence)kv.getValue());
            }
            this.logger.info("zhjgapprove service url:" + config.getServiceUrl() + " param:" + curParam, new Object[0]);
            String result = HttpUtil.createPost((String)config.getServiceUrl()).body(curParam).execute().body();
            this.logger.info("zhjgapprove service url:" + config.getServiceUrl() + " http result: " + result, new Object[0]);
            if (StringUtils.isBlank((CharSequence)result)) {
                zhjgApproveAtlasTask.setStatus(Short.valueOf(ZhjgapproveStateEnum.error.getCode().shortValue()));
                zhjgApproveAtlasTask.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                zhjgApproveAtlasTask.setEndTime(new Date());
            } else {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        zhjgApproveAtlasTask.setAtlasId(taskId);
                        zhjgApproveAtlasTask.setStatus(Short.valueOf(ZhjgapproveStateEnum.runing.getCode().shortValue()));
                    } else {
                        zhjgApproveAtlasTask.setStatus(Short.valueOf(ZhjgapproveStateEnum.error.getCode().shortValue()));
                        zhjgApproveAtlasTask.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                        zhjgApproveAtlasTask.setEndTime(new Date());
                    }
                } else {
                    zhjgApproveAtlasTask.setStatus(Short.valueOf(ZhjgapproveStateEnum.error.getCode().shortValue()));
                    zhjgApproveAtlasTask.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                    zhjgApproveAtlasTask.setEndTime(new Date());
                }
            }
            this.zhjgApproveAtlasTaskDao.gwAccess((GiEntitySaveable)zhjgApproveAtlasTask);
        }
    }

    public List<ZhjgApproveAtlasTask> list(Short state) {
        ZhjgApproveAtlasTask search = new ZhjgApproveAtlasTask();
        search.setStatus(state);
        return this.zhjgApproveAtlasTaskDao.gwSearch((GiEntityQueryable)search);
    }

    public void progressQuery(ZhjgApproveAtlasTask task) {
        ZhjgApproveConfig config = this.getConfig();
        if (config == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)config.getAtlasUrl())) {
            this.logger.error("atlas\u81ea\u52a8\u5ba1\u6838\u9519\u8bef\u8fdb\u5ea6\u67e5\u8be2\u5931\u8d25,atlas\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", new Object[0]);
            return;
        }
        String atlasUrl = config.getAtlasUrl();
        atlasUrl = atlasUrl + "/atlas/task/get?id=" + task.getAtlasId();
        this.logger.info("cffx atlas task url:" + atlasUrl, new Object[0]);
        String result = HttpUtil.createGet((String)atlasUrl).execute().body();
        if (StringUtils.isBlank((CharSequence)result)) {
            task.setMsg("\u83b7\u53d6\u5206\u6790\u4efb\u52a1\u8fdb\u5ea6\u4fe1\u606f\u5931\u8d25");
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            this.logger.error("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838:" + task.getId() + "\u83b7\u53d6\u5206\u6790\u4efb\u52a1\u8fdb\u5ea6\u4fe1\u606f\u5931\u8d25", new Object[0]);
            return;
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        String state = "";
        Boolean flag = false;
        if (!resultJson.containsKey((Object)"State") || !resultJson.containsKey((Object)"IsSucceed")) {
            this.logger.error("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838:" + task.getId() + "\u5206\u6790\u4efb\u52a1\u6682\u672a\u5b8c\u6210", new Object[0]);
            return;
        }
        state = resultJson.getString("State");
        flag = resultJson.getBoolean("IsSucceed");
        if (!state.equalsIgnoreCase("finished")) {
            this.logger.error("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838:" + task.getId() + "\u5206\u6790\u4efb\u52a1\u6682\u672a\u5b8c\u6210", new Object[0]);
            return;
        }
        if (!flag.booleanValue()) {
            task.setMsg("\u5206\u6790\u4efb\u52a1\u6267\u884c\u5931\u8d25");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.error.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            this.logger.error("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838:" + task.getId() + "\u5206\u6790\u4efb\u52a1\u6267\u884c\u5931\u8d25", new Object[0]);
        } else {
            task.setMsg("\u5206\u6790\u4efb\u52a1\u6267\u884c\u6210\u529f");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.success.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApprove(ZhjgApproveAtlasTask task) {
        ZhjgApproveConfig config = this.getConfig();
        if (StringUtils.isBlank((CharSequence)config.getTbidField())) {
            task.setMsg("\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u914d\u7f6e\u56fe\u6591id\u5b57\u6bb5");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approveerror.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        if (StringUtils.isBlank((CharSequence)config.getTaskidField())) {
            task.setMsg("\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u914d\u7f6e\u4efb\u52a1id\u5b57\u6bb5");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approveerror.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        if (config.getShowFields() == null || config.getShowFields().isEmpty()) {
            task.setMsg("\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u914d\u7f6e\u5206\u6790\u7ed3\u679c\u4fe1\u606f\u5b57\u6bb5");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approveerror.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        if (StringUtils.isBlank((CharSequence)config.getApproveUser()) || config.getUserId() == null) {
            task.setMsg("\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u914d\u7f6e\u5ba1\u6838\u7528\u6237\u4fe1\u606f");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approveerror.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        try {
            this.handResult(config, task.getResult(), task.getTaskId());
            this.approve(config, task.getResult(), task.getTaskId());
            task.setMsg("");
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approvesuccess.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        catch (Exception ex) {
            this.logger.error("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838\u5f02\u5e38" + ExceptionUtil.getStackTrace(ex), new Object[0]);
            task.setMsg("\u7efc\u5408\u76d1\u7ba1\u6279\u91cf\u5ba1\u6838\u5f02\u5e38" + ex.getMessage());
            task.setStatus(Short.valueOf(ZhjgapproveStateEnum.approveerror.getCode().shortValue()));
            this.zhjgApproveAtlasTaskDao.gwUpdateByPK((GiEntityAlterable)task);
        }
        finally {
            TableUtil.dropTable(task.getResult(), this.jdbcTemplate);
        }
    }

    public List<List<ZhjgApproveShowFieldValue>> getDetial(String taskId, String tbid) {
        ZhjgApproveConfig config = this.getConfig();
        if (config.getDatas() != null && config.getDatas().isEmpty()) {
            return null;
        }
        if (config.getDatas().stream().filter(t -> t.getId().equals(taskId)).findFirst().isPresent()) {
            List showFields = config.getShowFields();
            if (showFields == null || showFields.isEmpty()) {
                return null;
            }
            String sql = "select * from tb_zhjg_approve_result where " + config.getTaskidField() + " = '" + taskId + "' and " + config.getTbidField() + " ='" + tbid + "'";
            List maps = this.jdbcTemplate.queryForList(sql);
            if (maps == null || maps.isEmpty()) {
                return null;
            }
            ArrayList<List<ZhjgApproveShowFieldValue>> results = new ArrayList<List<ZhjgApproveShowFieldValue>>();
            for (Map map : maps) {
                ArrayList<ZhjgApproveShowFieldValue> values = new ArrayList<ZhjgApproveShowFieldValue>();
                for (ZhjgApproveShowField f : showFields) {
                    if (!map.containsKey(f.getName())) continue;
                    String value = map.get(f.getName()) == null ? "" : map.get(f.getName()).toString();
                    ZhjgApproveShowFieldValue v = new ZhjgApproveShowFieldValue();
                    v.setAlias(f.getAlias());
                    v.setName(f.getName());
                    v.setValue(value);
                    values.add(v);
                }
                results.add(values);
            }
            return results;
        }
        return null;
    }

    private void handResult(ZhjgApproveConfig config, String tempResultTable, String taskid) {
        if (!TableUtil.tableExist("tb_zhjg_approve_result", this.jdbcTemplate)) {
            String createSql = "create table tb_zhjg_approve_result (" + config.getTbidField() + " varchar(100) NOT NULL," + config.getTaskidField() + " varchar(100) NOT NULL," + config.getPassField() + " varchar(100) NOT NULL";
            if (config.getShowFields() != null && !config.getShowFields().isEmpty()) {
                for (ZhjgApproveShowField f : config.getShowFields()) {
                    createSql = createSql + "," + f.getName() + " varchar(100)";
                }
            }
            createSql = createSql + ");CREATE INDEX tb_zhjg_approve_result_union_idx ON public.tb_zhjg_approve_result USING btree (" + config.getTbidField() + "," + config.getTaskidField() + ");";
            this.jdbcTemplate.execute(createSql);
        }
        String deleteSql = String.format("delete from %s where %s in (select %s from %s t) and %s = '%s'", "tb_zhjg_approve_result", config.getTbidField(), config.getTbidField(), tempResultTable, config.getTaskidField(), taskid);
        this.jdbcTemplate.execute(deleteSql);
        String insertSql = "insert into tb_zhjg_approve_result(" + config.getTbidField() + "," + config.getTaskidField() + "," + config.getPassField();
        if (config.getShowFields() != null && !config.getShowFields().isEmpty()) {
            for (ZhjgApproveShowField f : config.getShowFields()) {
                insertSql = insertSql + "," + f.getName();
            }
        }
        insertSql = insertSql + ") select " + config.getTbidField() + "," + config.getTaskidField() + "," + config.getPassField();
        if (config.getShowFields() != null && !config.getShowFields().isEmpty()) {
            for (ZhjgApproveShowField f : config.getShowFields()) {
                insertSql = insertSql + "," + f.getName();
            }
        }
        insertSql = insertSql + " from " + tempResultTable;
        this.jdbcTemplate.execute(insertSql);
    }

    private void approve(ZhjgApproveConfig config, String tempResultTable, String taskId) {
        String autoApproveFilter;
        Integer option = 0;
        if (config.getIsPass() != null && config.getIsPass().booleanValue()) {
            option = 1;
        }
        if (StringUtils.isBlank((CharSequence)(autoApproveFilter = config.getApproveFilter()))) {
            autoApproveFilter = "1=1";
        }
        String filter = "f_id in (select " + config.getTbidField() + " from " + tempResultTable + " where " + autoApproveFilter + ")";
        this.auditJobService.batchApproveSj(taskId, filter, option, "\u81ea\u52a8\u6279\u91cf\u5ba1\u6838\u901a\u8fc7", "\u81ea\u52a8\u6279\u91cf\u5ba1\u6838\u901a\u8fc7", config.getUserId().longValue(), config.getApproveUser());
    }

    private ZhjgApproveConfig getConfig() {
        SysConfig config = this.sysConfigRepository.queryByKey("zhjgApproveConfig");
        ZhjgApproveConfig zhjgApproveConfig = null;
        if (config != null) {
            zhjgApproveConfig = (ZhjgApproveConfig)JSONObject.parseObject((String)config.getValue(), ZhjgApproveConfig.class);
        }
        return zhjgApproveConfig;
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/zhjgapprove.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u6a21\u578b\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }
}

