package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.landcloud.oauth.config.GacOauth2Config;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class InitGacOauth2ClientService {
    private final GiLoger logger = GwLoger.getLoger(Res3SdkClientAuthProvider.class);
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-id:}")
    private  String client_id;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-secret:}")
    private  String client_secret;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.provider:}")
    private  String gas_provider;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private  String loginBack_uri;
    @Value("${spring.security.oauth2.client.provider.gas-cqfzx.issuer-uri:}")
    private  String issuer_uri;

    public String getGas_provider() {
        return gas_provider;
    }
    @Autowired
    private DataBizService dataBizService;

    @Autowired
    private GacOauth2Config gacOauth2Config;

    public String getClientRegisterId(boolean isApp,String clientName)
    {
        return gacOauth2Config.getClientRegisterId(isApp,clientName);

    }
    public String getCodeRegisterId(boolean isApp,String clientName)
    {
        return gacOauth2Config.getCodeRegisterId(isApp,clientName);
    }
    public ClientCredentialsClientRegistration getClientCredentialsClientRegistration(String clientName,Boolean isApp) {
        String registrationId =getClientRegisterId(isApp,clientName);
        ClientCredentialsClientRegistration   clientRegistration =Oauth2ClientRegistration.findById(registrationId);
        if( clientRegistration== null){
            //初始化默认配置
            try {
                String clientId = client_id;
                String clientSecret = client_secret;

                if(isApp)
                {
                    String sql = " select * from bus_apps_config where f_apps_id  ='"+clientName+"';";
                    List<Map> map = dataBizService.queryDataBySql(sql);
                    if (map != null && map.size() > 0 ) {
                        if (map.get(0).get("f_app_key") != null) {
                            clientId = map.get(0).get("f_app_key").toString();
                            clientSecret = map.get(0).get("f_app_secret").toString();
                        }
                        else
                        {
                            logger.error("应用:"+clientName+"初始化认证信息失败,bus_apps_config表无对应数据");
                            return null;
                        }
                    }
                    else
                    {
                        logger.error("应用:"+clientName+"初始化认证信息失败,bus_apps_config表无对应数据");
                        return null;
                    }
                }
                gacOauth2Config.initGacOauth2Client(gas_provider,clientName, clientId, clientSecret, issuer_uri, loginBack_uri,isApp);
                clientRegistration =Oauth2ClientRegistration.findById(registrationId);

            }
            catch (Exception ex)
            {
                logger.error("init initGacOauth2Client:"+clientName+"异常"+ ExceptionUtil.getStackTrace(ex));
                return null;
            }
        }
        return clientRegistration;
    }
    public AuthorizationCodeClientRegistration getAuthorizationCodeClientRegistration(String clientName,Boolean isApp )  {
        String registrationId =getCodeRegisterId(isApp,clientName);

        AuthorizationCodeClientRegistration   codeRegistration =Oauth2ClientRegistration.findById(registrationId);
        if( codeRegistration== null){
            //初始化默认配置
            try {
                String clientId = client_id;
                String clientSecret = client_secret;
                if(isApp)
                {
                    String sql = " select * from bus_apps_config where f_apps_id  ='"+clientName+"';";
                    List<Map> map = dataBizService.queryDataBySql(sql);
                    if (map != null && map.size() > 0 ) {
                        if (map.get(0).get("f_app_key") != null) {
                            clientId = map.get(0).get("f_app_key").toString();
                            clientSecret = map.get(0).get("f_app_secret").toString();
                        }
                        else
                        {
                            logger.error("应用:"+clientName+"初始化认证信息失败,bus_apps_config表无对应数据");
                            return null;
                        }
                    }
                    else
                    {
                        logger.error("应用:"+clientName+"初始化认证信息失败,bus_apps_config表无对应数据");
                        return null;
                    }
                }
                gacOauth2Config.initGacOauth2Client(gas_provider, clientName, clientId, clientSecret, issuer_uri, loginBack_uri,isApp);
                codeRegistration =Oauth2ClientRegistration.findById(registrationId);

            }
            catch (Exception ex)
            {
                logger.error("init initGacOauth2Client:"+clientName+"异常"+ ExceptionUtil.getStackTrace(ex));
                return null;
            }
        }
        return codeRegistration;
    }
}
