package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2Client;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2ClientInfo;
import com.geoway.landteam.landcloud.oauth.config.GacOauth2Config;
import com.geoway.landteam.platform.apps.AppsRes3Sdk;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.permission.PermissionRes3Sdk;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.platform.gac.res3.sdk.core.Res3RequestParamProvider;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.web.util.GwHttpServletHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Service
public class Res3SdkClientAuthProvider implements Res3RequestParamProvider {

    private final GiLoger logger = GwLoger.getLoger(Res3SdkClientAuthProvider.class);

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-id:}")
    private  String client_id;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-secret:}")
    private  String client_secret;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.provider:}")
    private  String gas_provider;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private  String loginBack_uri;
    @Value("${spring.security.oauth2.client.provider.gas-cqfzx.issuer-uri:}")
    private  String issuer_uri;

    @Autowired
    private GacOauth2Config gacOauth2Config;
    @Autowired
    private InitGacOauth2ClientService initGacOauth2ClientService;
    @PostConstruct
    public void run() throws Exception {
        PermissionRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        BusinessRes3Sdk.getRes3RemoteServiceProvider().setRequestParamProvider(this);
        UcsRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        OrganizationRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        AppsRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        try {
            GacOauth2Tool.setIssuer(issuer_uri);
            Oauth2Client client1 = GacOauth2Tool.initGasClient(client_id, client_secret);//注册一个默认名称的客户端--不注册的话app 用户名密码登录会有问题
        }
        catch (Exception ex)
        {
            //防止重复注册
        }
        /*
        try{
            GacOauth2Tool.setIssuer("https://oauth.cqlandcloud.org.cn/gas");
            Oauth2Client client = GacOauth2Tool.initGasClient(client_id,client_secret);
            GacOauth2Tool.getGasAuthorizationCodeClientRegistration().setRedirectUri(redirectUrl);
            GacOauth2Tool.getProvider();
        }catch (Exception e) {
            logger.info("已经包含名称为:gas 的GacOauth2Provider");
        }
        */
        //app 或者 其他客户端
        if(Oauth2ClientRegistration.findById(initGacOauth2ClientService.getClientRegisterId(false,gas_provider)) == null){
            //初始化默认配置
            gacOauth2Config.initOauth2Provider(gas_provider,issuer_uri);
            gacOauth2Config.initGacOauth2Client(gas_provider,gas_provider,client_id,client_secret,issuer_uri,loginBack_uri,false);
        }
        logger.warn("Res3SdkClientAuthProvider init main client success");
    }

    //动态获取头部信息
    @Override
    public MultiValueMap<String, String> getHeaders() {

        HttpHeaders headers = new HttpHeaders();
        HttpServletRequest request = GwHttpServletHelper.getRequest();
        String appsId ="";
        if(request!=null) {
            boolean hasAppsId = request.getHeader("appsId") != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(request.getHeader("appsId"));
            if (hasAppsId) {
                appsId = request.getHeader("appsId");
            }
        }
        GacOauth2ClientInfo clientInfo = null;
        if(StringUtils.isNotBlank(appsId))
        {
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = initGacOauth2ClientService.getClientCredentialsClientRegistration(appsId,true); //Oauth2ClientRegistration.findById("gas"+appsId+"_client__SSO1");
            clientInfo =clientCredentialsClientRegistration.getOAuth2ClientInfo();

        }
        else
        {
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = initGacOauth2ClientService.getClientCredentialsClientRegistration(gas_provider,false);//Oauth2ClientRegistration.findById(gas_provider+"_code__SSO1");
            clientInfo =clientCredentialsClientRegistration.getOAuth2ClientInfo();
        }
        if (clientInfo == null) {
            throw new RuntimeException("sdk调用必须有认证客户端信息");
        }
        headers.add("Authorization", "Bearer " + clientInfo.getAccessToken());//客户端的token值

        return headers;
    }

    @Override
    public MultiValueMap<String, Object> getParams() {
        return null;
    }
}
