package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.platform.bususer.BusUserRes3Sdk;
import com.geoway.landteam.platform.mgruser.MgrUserRes3Sdk;
import com.geoway.landteam.platform.organization.OrganizationRes3UserSdk;
import com.geoway.landteam.platform.permission.PermissionRes3UserSdk;
import com.geoway.landteam.platform.ucs.UcsRes3UserSdk;
import com.geoway.platform.gac.res3.sdk.core.Res3RequestParamProvider;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.web.util.GwHttpServletHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;

@Component
public class Res3SdkUserAuthProvider implements Res3RequestParamProvider {

    private final GiLoger logger = GwLoger.getLoger(Res3SdkUserAuthProvider.class);

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-id:}")
    private  String client_id;
    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.client-secret:}")
    private  String client_secret;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.gas-issuer:}")
    private String gasIssuer;

    @Value("${spring.security.oauth2.client.registration.gas-cqfzx.redirect-uri:}")
    private String redirectUrl;

    @PostConstruct
    public void run() throws Exception {
        UcsRes3UserSdk.getRes3ServiceProvider().setRequestParamProvider(this);
        BusUserRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        MgrUserRes3Sdk.getRes3ServiceProvider().setRequestParamProvider(this);
        OrganizationRes3UserSdk.getRes3ServiceProvider().setRequestParamProvider(this);
        PermissionRes3UserSdk.getRes3ServiceProvider().setRequestParamProvider(this);
    }

    //动态获取头部信息
    @Override
    public MultiValueMap<String, String> getHeaders() {
        HttpHeaders headers = new HttpHeaders();

        HttpSession session = GwHttpServletHelper.getRequest().getSession(true);
        Object token = session.getAttribute("access_token");
        if(token == null) {
            throw new RuntimeException("sdk调用必须有认证用户信息");
        }
        headers.add("Authorization", "Bearer "+ token.toString());//系统的token值

        //headers.add("Authorization", "xxxxxxxxxxxxxxxxxx");//系统的token值
        return headers;
    }

    @Override
    public MultiValueMap<String, Object> getParams() {
        return null;
    }
}
