package com.geoway.landteam.landcloud.oauth.config;

import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2ClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Component
public class AuthenticationInterceptor implements HandlerInterceptor  {
    
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    	if (handler instanceof HandlerMethod) {
    		
    		HttpSession session = request.getSession(true);
			GacOauth2ClientInfo user = (GacOauth2ClientInfo)session.getAttribute("gacOAuth2User");
            if(user == null) {
            	
            	/*
            	GacOauth2ClientRegistrationAuthorizationCode sso = GacOauth2ClientRegistration.findById("gasSSO1");
            	
            	OAuth2AuthorizedClient ac = sso.getOAuth2AuthorizedClient(session.getId());
            	
            	request.
            	
            	if(ac == null) {
            		response.sendRedirect(sso.getAuthorizationRequestURI(session.getId()).toString());
            	}else {
            		session.setAttribute("userName",ac.getAccessToken().getValue());
            	}
            	*/

				String  uri = request.getRequestURI();

            	response.sendRedirect("/cqfzx-wds/user/login?redirect_url="+uri);
            	return false;
            }
        }
    	return true;
	}
	
	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
			@Nullable Exception ex) throws Exception {
	}
    
}
