package com.geoway.landteam.landcloud.oauth.config;

import com.geoway.landteam.gac.oauth2.mini.as.Oauth2Provider;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2Client;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.landcloud.oauth.component.RedisOAuth2AuthorizedClientService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class GacOauth2Config {
    private  GiLoger logger = GwLoger.getLoger(GacOauth2Config.class);
    /*
	private static String gas_provider ="gas-cqfzx";
	private static String redirect_uri ="http://127.0.0.1:9304/landCloudWork/cqfzx-wds/user/loginBack";
	private static String redirect_uri_pro ="http://business.cqlandcloud.org.cn/landCloudWork/cqfzx-wds/user/loginBack";
	private static String issuer_uri = "http://business.cqlandcloud.org.cn/gas";
    */
    //public static Map<String,ClientCredentialsClientRegistration>  clientCredentialsClientRegistrationMap=null;
    //public static Map<String,AuthorizationCodeClientRegistration> authorizationCodeClientRegistrationMap=null;

    @Resource
    private RedisOAuth2AuthorizedClientService redisOAuth2AuthorizedClientService;
    public String getClientRegisterId(boolean isApp,String clientName)
    {
        String registrationId = clientName+"_client_SSO1";
        return registrationId;
    }
    public String getCodeRegisterId(boolean isApp,String clientName)
    {
        String registrationId = clientName+"_code_SSO1";
        return registrationId;
    }
    public  void initOauth2Provider(String providerName,String issuerUri)
    {
        //只调用一次
        logger.warn("initOauth2Provider providerName:"+providerName+" begin");
        Oauth2Provider provider =Oauth2Provider.build(providerName, issuerUri,redisOAuth2AuthorizedClientService);
        logger.warn("initOauth2Provider providerName:"+providerName+" end");
        if (provider == null)
        {
            logger.warn("Oauth2Provider.build error,providerName:"+providerName+" issuerUri:"+issuerUri);
            logger.error("Oauth2Provider.build error,providerName:"+providerName+" issuerUri:"+issuerUri);
        }

    }
    public  void initGacOauth2Client(String providerName,String clientName,String clientId,String clientSecret,String issuerUri,
                                           String loginBackUri,boolean isApp) throws Exception {
        try {

            //初始化一个认证提供者
            Oauth2Client client = Oauth2Client.init(clientName, providerName, clientId, clientSecret);//注册一个指定名称的客户端
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = client.registerClientCredentials(getClientRegisterId(isApp,clientName));//初始化一个ClientCredentials认证模式的客户端
            AuthorizationCodeClientRegistration authorizationCodeClientRegistration = client.registerAuthorizationCode(getCodeRegisterId(isApp,clientName), loginBackUri);//初始化一个AuthorizationCode码模式的客户端
        }
        catch (Exception ex)
        {
            logger.error("initGacOauth2Client error"+ ExceptionUtil.getStackTrace(ex));
        }
    }

    public  String initGacOauth2Client2(String providerName,String clientId,String clientSecret,String issuerUri,String loginBackUri) throws Exception{
        String token = "";
        Oauth2Provider provider = Oauth2Provider.build(providerName,issuerUri);//只要一次
        //初始化一个认证提供者
        Oauth2Client client = Oauth2Client.init(providerName,provider,clientId,clientSecret);//初始化客户端账号 多次
        //
        client.registerAuthorizationCode(providerName+"SSO1",loginBackUri);//初始化一个AuthorizationCode码模式的客户端
        ClientCredentialsClientRegistration ccr = client.registerClientCredentials(providerName+"SSO1");//初始化一个ClientCredentials认证模式的客户端
        OAuth2AuthorizedClient authedclient = ccr.getOAuth2AuthorizedClient(clientId);
        if(authedclient!=null){
            token = authedclient.getAccessToken().getTokenValue();
        }
        return token;
    }


}
