/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.landcloud.oauth.component.Res3SdkClientAuthProvider;
import com.geoway.landteam.landcloud.oauth.config.GacOauth2Config;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InitGacOauth2ClientService {
    private final GiLoger logger = GwLoger.getLoger(Res3SdkClientAuthProvider.class);
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.client-id:}")
    private String client_id;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.client-secret:}")
    private String client_secret;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.provider:}")
    private String gas_provider;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private String loginBack_uri;
    @Value(value="${spring.security.oauth2.client.provider.gas-cqfzx.issuer-uri:}")
    private String issuer_uri;
    @Autowired
    private DataBizService dataBizService;
    @Autowired
    private GacOauth2Config gacOauth2Config;

    public String getGas_provider() {
        return this.gas_provider;
    }

    public String getClientRegisterId(boolean isApp, String clientName) {
        return this.gacOauth2Config.getClientRegisterId(isApp, clientName);
    }

    public String getCodeRegisterId(boolean isApp, String clientName) {
        return this.gacOauth2Config.getCodeRegisterId(isApp, clientName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientCredentialsClientRegistration getClientCredentialsClientRegistration(String clientName, Boolean isApp) {
        String registrationId = this.getClientRegisterId(isApp, clientName);
        ClientCredentialsClientRegistration clientRegistration = (ClientCredentialsClientRegistration)Oauth2ClientRegistration.findById((String)registrationId);
        if (clientRegistration != null) return clientRegistration;
        try {
            String clientId = this.client_id;
            String clientSecret = this.client_secret;
            if (isApp.booleanValue()) {
                String sql = " select * from bus_apps_config where f_apps_id  ='" + clientName + "';";
                List map = this.dataBizService.queryDataBySql(sql);
                if (map != null && map.size() > 0) {
                    if (((Map)map.get(0)).get("f_app_key") == null) {
                        this.logger.error("\u5e94\u7528:" + clientName + "\u521d\u59cb\u5316\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25,bus_apps_config\u8868\u65e0\u5bf9\u5e94\u6570\u636e", new Object[0]);
                        return null;
                    }
                    clientId = ((Map)map.get(0)).get("f_app_key").toString();
                    clientSecret = ((Map)map.get(0)).get("f_app_secret").toString();
                } else {
                    this.logger.error("\u5e94\u7528:" + clientName + "\u521d\u59cb\u5316\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25,bus_apps_config\u8868\u65e0\u5bf9\u5e94\u6570\u636e", new Object[0]);
                    return null;
                }
            }
            this.gacOauth2Config.initGacOauth2Client(this.gas_provider, clientName, clientId, clientSecret, this.issuer_uri, this.loginBack_uri, isApp);
            return (ClientCredentialsClientRegistration)Oauth2ClientRegistration.findById((String)registrationId);
        }
        catch (Exception ex) {
            this.logger.error("init initGacOauth2Client:" + clientName + "\u5f02\u5e38" + ExceptionUtil.getStackTrace((Exception)ex), new Object[0]);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthorizationCodeClientRegistration getAuthorizationCodeClientRegistration(String clientName, Boolean isApp) {
        String registrationId = this.getCodeRegisterId(isApp, clientName);
        AuthorizationCodeClientRegistration codeRegistration = (AuthorizationCodeClientRegistration)Oauth2ClientRegistration.findById((String)registrationId);
        if (codeRegistration != null) return codeRegistration;
        try {
            String clientId = this.client_id;
            String clientSecret = this.client_secret;
            if (isApp.booleanValue()) {
                String sql = " select * from bus_apps_config where f_apps_id  ='" + clientName + "';";
                List map = this.dataBizService.queryDataBySql(sql);
                if (map != null && map.size() > 0) {
                    if (((Map)map.get(0)).get("f_app_key") == null) {
                        this.logger.error("\u5e94\u7528:" + clientName + "\u521d\u59cb\u5316\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25,bus_apps_config\u8868\u65e0\u5bf9\u5e94\u6570\u636e", new Object[0]);
                        return null;
                    }
                    clientId = ((Map)map.get(0)).get("f_app_key").toString();
                    clientSecret = ((Map)map.get(0)).get("f_app_secret").toString();
                } else {
                    this.logger.error("\u5e94\u7528:" + clientName + "\u521d\u59cb\u5316\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25,bus_apps_config\u8868\u65e0\u5bf9\u5e94\u6570\u636e", new Object[0]);
                    return null;
                }
            }
            this.gacOauth2Config.initGacOauth2Client(this.gas_provider, clientName, clientId, clientSecret, this.issuer_uri, this.loginBack_uri, isApp);
            return (AuthorizationCodeClientRegistration)Oauth2ClientRegistration.findById((String)registrationId);
        }
        catch (Exception ex) {
            this.logger.error("init initGacOauth2Client:" + clientName + "\u5f02\u5e38" + ExceptionUtil.getStackTrace((Exception)ex), new Object[0]);
            return null;
        }
    }
}

