/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClientService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.util.Assert;
import com.geoway.landteam.landcloud.service.util.RedisCacheUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RedisOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    @Resource
    RedisCacheUtils<OAuth2AuthorizedClient> redisCacheUtils;

    public RedisOAuth2AuthorizedClientService(RedisCacheUtils<OAuth2AuthorizedClient> redisCacheUtils) {
        this.redisCacheUtils = redisCacheUtils;
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        String key = clientRegistrationId + "_" + principalName;
        OAuth2AuthorizedClient oAuth2AuthorizedClient = (OAuth2AuthorizedClient)this.redisCacheUtils.getObject(key);
        return (T)oAuth2AuthorizedClient;
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        String key = authorizedClient.getClientRegistrationId() + "_" + authorizedClient.getPrincipalName();
        Long ms = authorizedClient.getAccessToken().getExpiresAt().toEpochMilli();
        Long ms2 = System.currentTimeMillis();
        Long seconds = (ms - ms2) / 1000L;
        this.redisCacheUtils.setObject(key, (Object)authorizedClient, seconds.longValue());
    }

    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Oauth2ClientRegistration registration = Oauth2ClientRegistration.findById((String)clientRegistrationId);
        if (registration != null) {
            String key = clientRegistrationId + "_" + principalName;
            this.redisCacheUtils.removeObj(key);
        }
    }
}

