/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.oauth.component;

import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2Client;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.sub.GacOauth2ClientInfo;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.oauth.component.InitGacOauth2ClientService;
import com.geoway.landteam.landcloud.oauth.config.GacOauth2Config;
import com.geoway.landteam.platform.apps.AppsRes3Sdk;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.permission.PermissionRes3Sdk;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.platform.gac.res3.sdk.core.Res3RequestParamProvider;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.web.util.GwHttpServletHelper;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class Res3SdkClientAuthProvider
implements Res3RequestParamProvider {
    private final GiLoger logger = GwLoger.getLoger(Res3SdkClientAuthProvider.class);
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.client-id:}")
    private String client_id;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.client-secret:}")
    private String client_secret;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.provider:}")
    private String gas_provider;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private String loginBack_uri;
    @Value(value="${spring.security.oauth2.client.provider.gas-cqfzx.issuer-uri:}")
    private String issuer_uri;
    @Autowired
    private GacOauth2Config gacOauth2Config;
    @Autowired
    private InitGacOauth2ClientService initGacOauth2ClientService;

    @PostConstruct
    public void run() throws Exception {
        PermissionRes3Sdk.getRes3ServiceProvider().setRequestParamProvider((Res3RequestParamProvider)this);
        BusinessRes3Sdk.getRes3RemoteServiceProvider().setRequestParamProvider((Res3RequestParamProvider)this);
        UcsRes3Sdk.getRes3ServiceProvider().setRequestParamProvider((Res3RequestParamProvider)this);
        OrganizationRes3Sdk.getRes3ServiceProvider().setRequestParamProvider((Res3RequestParamProvider)this);
        AppsRes3Sdk.getRes3ServiceProvider().setRequestParamProvider((Res3RequestParamProvider)this);
        try {
            GacOauth2Tool.setIssuer((String)this.issuer_uri);
            Oauth2Client oauth2Client = GacOauth2Tool.initGasClient((String)this.client_id, (String)this.client_secret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Oauth2ClientRegistration.findById((String)this.initGacOauth2ClientService.getClientRegisterId(false, this.gas_provider)) == null) {
            this.gacOauth2Config.initOauth2Provider(this.gas_provider, this.issuer_uri);
            this.gacOauth2Config.initGacOauth2Client(this.gas_provider, this.gas_provider, this.client_id, this.client_secret, this.issuer_uri, this.loginBack_uri, false);
        }
        this.logger.warn("Res3SdkClientAuthProvider init main client success", new Object[0]);
    }

    public MultiValueMap<String, String> getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        HttpServletRequest request = GwHttpServletHelper.getRequest();
        String appsId = "";
        if (request != null) {
            boolean hasAppsId;
            boolean bl = hasAppsId = request.getHeader("appsId") != null && StringUtils.isNotBlank((CharSequence)request.getHeader("appsId"));
            if (hasAppsId) {
                appsId = request.getHeader("appsId");
            }
        }
        GacOauth2ClientInfo clientInfo = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appsId)) {
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = this.initGacOauth2ClientService.getClientCredentialsClientRegistration(appsId, true);
            clientInfo = clientCredentialsClientRegistration.getOAuth2ClientInfo();
        } else {
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = this.initGacOauth2ClientService.getClientCredentialsClientRegistration(this.gas_provider, false);
            clientInfo = clientCredentialsClientRegistration.getOAuth2ClientInfo();
        }
        if (clientInfo == null) {
            throw new RuntimeException("sdk\u8c03\u7528\u5fc5\u987b\u6709\u8ba4\u8bc1\u5ba2\u6237\u7aef\u4fe1\u606f");
        }
        headers.add("Authorization", "Bearer " + clientInfo.getAccessToken());
        return headers;
    }

    public MultiValueMap<String, Object> getParams() {
        return null;
    }
}

