/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.oauth.config;

import com.geoway.landteam.gac.oauth2.mini.as.Oauth2Provider;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClientService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2Client;
import com.geoway.landteam.gac.oauth2.mini.client.support.AuthorizationCodeClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.landcloud.oauth.component.RedisOAuth2AuthorizedClientService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GacOauth2Config {
    private GiLoger logger = GwLoger.getLoger(GacOauth2Config.class);
    @Resource
    private RedisOAuth2AuthorizedClientService redisOAuth2AuthorizedClientService;

    public String getClientRegisterId(boolean isApp, String clientName) {
        String registrationId = clientName + "_client_SSO1";
        return registrationId;
    }

    public String getCodeRegisterId(boolean isApp, String clientName) {
        String registrationId = clientName + "_code_SSO1";
        return registrationId;
    }

    public void initOauth2Provider(String providerName, String issuerUri) {
        this.logger.warn("initOauth2Provider providerName:" + providerName + " begin", new Object[0]);
        Oauth2Provider provider = Oauth2Provider.build((String)providerName, (String)issuerUri, (OAuth2AuthorizedClientService)this.redisOAuth2AuthorizedClientService);
        this.logger.warn("initOauth2Provider providerName:" + providerName + " end", new Object[0]);
        if (provider == null) {
            this.logger.warn("Oauth2Provider.build error,providerName:" + providerName + " issuerUri:" + issuerUri, new Object[0]);
            this.logger.error("Oauth2Provider.build error,providerName:" + providerName + " issuerUri:" + issuerUri, new Object[0]);
        }
    }

    public void initGacOauth2Client(String providerName, String clientName, String clientId, String clientSecret, String issuerUri, String loginBackUri, boolean isApp) throws Exception {
        try {
            Oauth2Client client = Oauth2Client.init((String)clientName, (String)providerName, (String)clientId, (String)clientSecret);
            ClientCredentialsClientRegistration clientCredentialsClientRegistration = client.registerClientCredentials(this.getClientRegisterId(isApp, clientName));
            AuthorizationCodeClientRegistration authorizationCodeClientRegistration = client.registerAuthorizationCode(this.getCodeRegisterId(isApp, clientName), loginBackUri);
        }
        catch (Exception ex) {
            this.logger.error("initGacOauth2Client error" + ExceptionUtil.getStackTrace((Exception)ex), new Object[0]);
        }
    }

    public String initGacOauth2Client2(String providerName, String clientId, String clientSecret, String issuerUri, String loginBackUri) throws Exception {
        String token = "";
        Oauth2Provider provider = Oauth2Provider.build((String)providerName, (String)issuerUri);
        Oauth2Client client = Oauth2Client.init((String)providerName, (Oauth2Provider)provider, (String)clientId, (String)clientSecret);
        client.registerAuthorizationCode(providerName + "SSO1", loginBackUri);
        ClientCredentialsClientRegistration ccr = client.registerClientCredentials(providerName + "SSO1");
        OAuth2AuthorizedClient authedclient = ccr.getOAuth2AuthorizedClient(clientId);
        if (authedclient != null) {
            token = authedclient.getAccessToken().getTokenValue();
        }
        return token;
    }
}

