/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.config;

import com.geoway.design.biz.config.ProjectConfig;
import com.geoway.sso.client.NsSsoContainer;
import com.geoway.sso.client.config.PermitResource;
import com.geoway.sso.client.enums.LoginThemeEnum;
import com.geoway.sso.client.filter.AppLoginFilter;
import com.geoway.sso.client.filter.AppLogoutFilter;
import com.geoway.sso.client.filter.ClientFilter;
import com.geoway.sso.client.filter.RestLoginFilter;
import com.geoway.sso.client.filter.RestLogoutFilter;
import com.geoway.sso.client.listener.LogoutListener;
import com.geoway.sso.client.session.SessionMappingStorage;
import com.geoway.sso.client.session.redis.RedisSessionMappingStorage;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.events.AbstractSessionEvent;
import org.springframework.session.web.http.SessionEventHttpSessionListenerAdapter;

@Configuration
@ConditionalOnProperty(value={"sso.enable"}, havingValue="true")
public class NsSsoConfig {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private PermitResource permitResource;
    @Autowired
    private SessionMappingStorage sessionMappingStorage;

    @Bean
    public SessionMappingStorage sessionMappingStorage() {
        return new RedisSessionMappingStorage();
    }

    @Bean
    public ApplicationListener<AbstractSessionEvent> LogoutListener() {
        ArrayList<LogoutListener> httpSessionListeners = new ArrayList<LogoutListener>();
        LogoutListener logoutListener = new LogoutListener();
        logoutListener.setSessionMappingStorage(this.sessionMappingStorage);
        httpSessionListeners.add(logoutListener);
        return new SessionEventHttpSessionListenerAdapter(httpSessionListeners);
    }

    @Bean
    public FilterRegistrationBean<NsSsoContainer> ssoContainer() {
        NsSsoContainer ssoContainer = new NsSsoContainer();
        ssoContainer.setServerUrl(this.projectConfig.getSsoServerUrl());
        ssoContainer.setAppId(this.projectConfig.getSsoAppId());
        ssoContainer.setAppSecret(this.projectConfig.getSsoAppSecret());
        ssoContainer.setLoginApi(this.projectConfig.getSsoAppLoginApi());
        List excludeUrls = this.permitResource.getPermitList();
        String urls = StringUtils.joinWith((String)",", (Object[])new Object[]{excludeUrls});
        ssoContainer.setExcludeUrls(urls);
        if (this.projectConfig.getLoginPageType().equalsIgnoreCase(LoginThemeEnum.CUSTOM.getValue())) {
            ssoContainer.setFilters(new ClientFilter[]{new AppLogoutFilter(), new AppLoginFilter()});
        } else {
            ssoContainer.setFilters(new ClientFilter[]{new RestLogoutFilter(), new RestLoginFilter()});
        }
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)ssoContainer);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(1);
        registration.setName("ssoContainer");
        return registration;
    }
}

