/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.config;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import io.swagger.models.auth.In;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@EnableKnife4j
public class SwaggerConfig
implements WebMvcConfigurer {
    @Value(value="${swagger.enabled}")
    private boolean enabled;
    @Autowired
    private OpenApiExtensionResolver openApiExtensionResolver;

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.OAS_30).enable(this.enabled).select().apis(RequestHandlerSelectors.basePackage((String)"com.geoway.design.api.controller")).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts()).apiInfo(new ApiInfoBuilder().title("\u96c6\u6210\u6846\u67b6\u5f0f\u540e\u53f0\u670d\u52a1\u63a5\u53e3").version("1.0.0").description("").build()).extensions(this.openApiExtensionResolver.buildSettingExtensions());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        try {
            Field registrationsField = FieldUtils.getField(InterceptorRegistry.class, (String)"registrations", (boolean)true);
            List registrations = (List)ReflectionUtils.getField((Field)registrationsField, (Object)registry);
            if (registrations != null) {
                for (InterceptorRegistration interceptorRegistration : registrations) {
                    interceptorRegistration.excludePathPatterns(new String[]{"/swagger**/**"}).excludePathPatterns(new String[]{"/webjars/**"}).excludePathPatterns(new String[]{"/v3/**"}).excludePathPatterns(new String[]{"/doc.html"});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<SecurityScheme> securitySchemes() {
        ApiKey apiKey = new ApiKey("access_token", "access_token", In.HEADER.toValue());
        return Collections.singletonList(apiKey);
    }

    private List<SecurityContext> securityContexts() {
        return Collections.singletonList(SecurityContext.builder().securityReferences(Collections.singletonList(new SecurityReference("access_token", new AuthorizationScope[]{new AuthorizationScope("global", "")}))).build());
    }
}

