/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.config;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import com.geoway.design.base.config.SsoConfigProp;
import com.geoway.design.base.support.spring.SpringUtils;
import com.geoway.design.biz.dto.UserSyncDTO;
import com.geoway.design.biz.service.dev.IUserSyncService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class UserSyncConfig {
    private static final Logger log = LoggerFactory.getLogger(UserSyncConfig.class);
    @Value(value="${userSync.cron:0 0/10 * * * *}")
    private String cron;
    @Value(value="${userSync.enable:false}")
    private boolean enable;
    @Autowired
    private SsoConfigProp ssoConfigProp;

    @Bean
    public void syncUser() {
        if (!this.enable) {
            return;
        }
        CronUtil.schedule((String)this.cron, (Task)new Task(){

            public void execute() {
                List syncServices = UserSyncConfig.this.getSyncServices();
                for (IUserSyncService service : syncServices) {
                    System.out.println("\u5f00\u59cb\u540c\u6b65\u7528\u6237");
                    log.error("\u5f00\u59cb\u540c\u6b65\u7528\u6237");
                    UserSyncDTO userSyncDTO = service.getUserInfo();
                    String msg = service.syncUserInfo(userSyncDTO);
                    log.error("\u540c\u6b65\u7528\u6237\u7ed3\u675f:" + msg);
                    System.out.println("\u540c\u6b65\u7528\u6237\u7ed3\u675f:" + msg);
                }
            }
        });
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start((boolean)true);
    }

    private List<IUserSyncService> getSyncServices() {
        List<Object> loginTypes = new ArrayList<String>();
        if (StrUtil.isBlank((CharSequence)this.ssoConfigProp.getLoginType())) {
            loginTypes.add("1");
        } else {
            loginTypes = Arrays.stream(this.ssoConfigProp.getLoginType().split(",")).collect(Collectors.toList());
        }
        List wholeBeans = SpringUtils.getBeansOfType(IUserSyncService.class);
        ArrayList<IUserSyncService> result = new ArrayList<IUserSyncService>();
        loginTypes.forEach(f -> {
            IUserSyncService loginService = wholeBeans.stream().filter(g -> g.getType().equals(f)).findFirst().orElse(null);
            if (loginService != null) {
                result.add(loginService);
            }
        });
        return result;
    }
}

