/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysApplication;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.service.sys.IApplicationSysService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5e94\u7528\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/application"})
public class ApplicationSysController {
    @Autowired
    IApplicationSysService applicationSysService;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u4e00\u6761\u5e94\u7528", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveOrUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUpApplication(SysApplication sysApplication, String groupId, @RequestParam(value="file", required=false) MultipartFile file) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.applicationSysService.saveOrUp(sysApplication, groupId, file);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u5e94\u7528", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteApplication(@RequestParam(value="id", required=false) String id, @RequestParam(value="ids", required=false) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String validIds = StrUtil.isBlank((CharSequence)ids) ? id : ids;
            this.applicationSysService.deleteApplications(validIds);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2")
    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryApplication(String params, Integer page, Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage applicationSysIPage = this.applicationSysService.queryApplication(params, page, size);
            responseDataBase.put((Object)"data", (Object)applicationSysIPage);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List sysApplications = this.applicationSysService.queryList(filterParam);
            responseDataBase.put((Object)"data", (Object)sysApplications);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u5e94\u7528\u7ec4")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u5e94\u7528\u7ec4", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(SysGroup group) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.applicationSysService.saveGroup(group);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u7ec4")
    @RequestMapping(value={"/appGroups"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppGroups() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List groups = this.applicationSysService.queryAppGroups();
            responseDataBase.put((Object)"data", (Object)groups);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u7ec4")
    @OpLog(name="\u5220\u9664\u5e94\u7528\u7ec4", opType=OpLog.OpType.del)
    @RequestMapping(value={"/deleteGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(String groupId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.applicationSysService.deleteGroup(groupId);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u4e2a\u6570")
    @RequestMapping(value={"/queryAppCount"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppCount() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            int count = this.applicationSysService.queryAppCount();
            responseDataBase.put((Object)"data", (Object)count);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

