/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.service.hunan.BimService;
import com.geoway.design.biz.service.hunan.IDPService;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import com.iam.Codec.IamFacade;
import com.iam.Codec.Sm3Signature;
import com.iam.Codec.Sm4Cipher;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u81ea\u7136\u8d44\u6e90\u5385\u7edf\u4e00\u8eab\u4efd\u9a8c\u8bc1"})
@ApiSort(value=1)
@RestController
@RequestMapping(value={"/authCenter"})
public class AuthCenterController {
    private static final Logger log = LoggerFactory.getLogger(AuthCenterController.class);
    @Value(value="${hunan.BIM.secretKey:}")
    private String bimSecretKey;
    private final String smType = "SM4";
    private final String signType = "SM3";
    @Resource
    private IDPService idpService;
    @Resource
    private BimService bimService;

    @ApiOperation(value="\u6d4b\u8bd5\u52a0\u5bc6\u7528\u6237")
    @RequestMapping(value={"/EncryptionTesting"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String EncryptionTesting(@RequestParam(value="type") Integer type) {
        String originalStr;
        String bimRemoteUser = "test";
        String bimRemotePwd = "test";
        Sm3Signature signature = new Sm3Signature();
        Sm4Cipher sm4Cipher = new Sm4Cipher();
        String source = "";
        if (type == 1) {
            originalStr = String.format("bimRemoteUser=%s&bimRequestId=%s&bimRemotePwd=%s", bimRemoteUser, "9e928d12ec8a4c1bb75283b8df71308d", bimRemotePwd);
            System.out.println(originalStr);
            String signatureStr = signature.signature(originalStr);
            source = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"signature\":\"" + signatureStr + "\"}";
        } else if (type == 2) {
            originalStr = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"userid\":\"20123123fsfs1239123\",\"usercode\":\"1001001\",\"orgid\":\"5110114311\",\"username\":\"\u6d4b\u8bd5\u8d26\u53f701\",\"alisname\":\"\u6d4b\u8bd5\u8d26\u53f7\",\"tel\":\"13678906789\",\"email\":\"ab@163.com\",\"sex\":\"1\",\"xzqdm\":\"430000\"}";
            String signatureStr = signature.signature(originalStr);
            source = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"signature\":\"" + signatureStr + "\",\"userid\":\"20123123fsfs1239123\",\"usercode\":\"1001001\",\"orgid\":\"5110114311\",\"username\":\"\u6d4b\u8bd5\u8d26\u53f701\",\"alisname\":\"\u6d4b\u8bd5\u8d26\u53f7\",\"tel\":\"13678906789\",\"email\":\"ab@163.com\",\"sex\":\"1\",\"xzqdm\":\"430000\"}";
        } else if (type == 3) {
            originalStr = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"userId\":\"20123123fsfs1239123\",\"userCode\":\"1001001\",\"orgId\":\"5110114311\",\"username\":\"\u6d4b\u8bd5\u8d26\u53f701\",\"alisname\":\"\u6d4b\u8bd5\u8d26\u53f7\",\"tel\":\"13678906789\",\"email\":\"ab@163.com\",\"sex\":\"2\",\"xzqdm\":\"430000\",\"bimUid\":\"970515386103496704\"}";
            String signatureStr = signature.signature(originalStr);
            source = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"signature\":\"" + signatureStr + "\",\"userid\":\"20123123fsfs1239123\",\"userCode\":\"1001001\",\"orgid\":\"5110114311\",\"username\":\"\u6d4b\u8bd5\u8d26\u53f701\",\"alisname\":\"\u6d4b\u8bd5\u8d26\u53f7\",\"tel\":\"13678906789\",\"email\":\"ab@163.com\",\"sex\":\"2\",\"xzqdm\":\"430000\",\"bimUid\":\"970515386103496704\"}";
        } else if (type == 4) {
            originalStr = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"orgId\":\"5110114311\",\"orgCode\":\"1001\",\"parentId\":\"41100111\",\"rolename\":\"\u6d4b\u8bd5\u7ec4\u7ec7\",\"level\":\"0\"}";
            String signatureStr = signature.signature(originalStr);
            source = "{\"bimRemoteUser\":\"" + bimRemoteUser + "\",\"bimRequestId\":\"9e928d12ec8a4c1bb75283b8df71308d\",\"bimRemotePwd\":\"" + bimRemotePwd + "\",\"signature\":\"" + signatureStr + "\",\"orgid\":\"5110114311\",\"orgcode\":\"1001\",\"parentId\":\"41100111\",\"orgname\":\"\u6d4b\u8bd5\u7ec4\u7ec711\",\"level\":\"1\"}";
        }
        String target = sm4Cipher.encrypt(source, this.bimSecretKey);
        return target;
    }

    @ApiOperation(value="\u7edf\u4e00\u8eab\u4efd\u9a8c\u8bc1")
    @RequestMapping(value={"/Login"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @OpLog(name="\u7edf\u4e00\u8eab\u4efd\u9a8c\u8bc1", opType=OpLog.OpType.login)
    public ResponseDataBase Login(HttpServletRequest request, @RequestParam(value="code") String code) {
        ResponseDataBase response = new ResponseDataBase();
        try {
            response = this.idpService.loginByAuthCode(request, code);
        }
        catch (Exception ex) {
            log.error("\u7edf\u4e00\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25", (Throwable)ex);
            response = ResponseDataBase.error((String)ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u767b\u51fa")
    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @OpLog(name="\u9000\u51fa\u767b\u5f55", detail="\u9000\u51fa\u767b\u5f55", opType=OpLog.OpType.loginout)
    public ResponseDataBase logout(HttpServletRequest request, @RequestParam(value="accessToken") String accessToken) {
        ResponseDataBase response = new ResponseDataBase();
        try {
            this.idpService.logoutByAccessToken(accessToken);
        }
        catch (Exception ex) {
            log.error("\u9000\u51fa\u767b\u5f55\u5931\u8d25", (Throwable)ex);
            response = ResponseDataBase.error((String)ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u4e2d\u201c\u8d26\u53f7\u201d\uff0c\u201c\u7ec4\u7ec7\u673a\u6784\u201d\u7b49\u5bf9\u8c61\u5168\u90e8\u5c5e\u6027\u4fe1\u606f")
    @RequestMapping(value={"/SchemaService"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String SchemaService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.queryUserOrgSchema(jsonObject);
    }

    @ApiOperation(value="\u8d26\u53f7\u521b\u5efa")
    @RequestMapping(value={"/UserCreateService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u8d26\u53f7\u521b\u5efa", opType=OpLog.OpType.update)
    public String UserCreateService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.saveUser(jsonObject);
    }

    @ApiOperation(value="\u8d26\u53f7\u4fee\u6539")
    @RequestMapping(value={"/UserUpdateService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u8d26\u53f7\u4fee\u6539", opType=OpLog.OpType.update)
    public String UserUpdateService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.saveUser(jsonObject);
    }

    @ApiOperation(value="\u8d26\u53f7\u5220\u9664")
    @RequestMapping(value={"/UserDeleteService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u8d26\u53f7\u5220\u9664", opType=OpLog.OpType.del)
    public String UserDeleteService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.deleteUser(jsonObject);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u521b\u5efa")
    @RequestMapping(value={"/OrgCreateService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u7ec4\u7ec7\u673a\u6784\u521b\u5efa", opType=OpLog.OpType.update)
    public String OrgCreateService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.saveOrg(jsonObject);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fee\u6539")
    @RequestMapping(value={"/OrgUpdateService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u7ec4\u7ec7\u673a\u6784\u4fee\u6539", opType=OpLog.OpType.update)
    public String OrgUpdateService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.saveOrg(jsonObject);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u5220\u9664")
    @RequestMapping(value={"/OrgDeleteService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    @OpLog(name="\u7ec4\u7ec7\u673a\u6784\u5220\u9664", opType=OpLog.OpType.del)
    public String OrgDeleteService(HttpServletRequest req, HttpServletResponse resp) {
        JSONObject jsonObject = this.getPlaintext(this.getRequestBody(req));
        return this.bimService.deleteOrg(jsonObject);
    }

    private JSONObject getPlaintext(String bodyparam) {
        String plaintext = IamFacade.decrypt((String)bodyparam, (String)this.bimSecretKey, (String)"SM4");
        return JSONObject.parseObject((String)plaintext);
    }

    private String getRequestBody(HttpServletRequest request) {
        return ServletUtil.getBody((ServletRequest)request);
    }
}

