/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.dto.FunctionDTO;
import com.geoway.design.biz.entity.SysFunction;
import com.geoway.design.biz.entity.SysMenu;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.IFunctionSysService;
import com.geoway.design.biz.service.sys.INsMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u529f\u80fd\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/function"})
public class FunctionSysController {
    @Autowired
    private IFunctionSysService functionSysService;
    @Autowired
    private INsMenuService menuService;
    @Autowired
    private IOauth2Service auth2Service;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u529f\u80fd\u70b9", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveOrUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUpApplication(SysFunction sysFunction) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.functionSysService.saveOrUp(sysFunction);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u529f\u80fd\u70b9", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteApplication(SysFunction sysFunction) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.functionSysService.deleteFunctionSys(sysFunction.getId(), sysFunction.getSort(), sysFunction.getPid(), sysFunction.getAppId());
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2")
    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryApplication(String params, Integer page, Integer size, String uid, String token) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage functionSysIPage = this.functionSysService.queryFunctionSys(params, page, size, uid, "");
            responseDataBase.put((Object)"data", (Object)functionSysIPage);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6811")
    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryTree(String params, Integer page, Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            IPage functionSysIPage = this.functionSysService.queryTree(params, page, size);
            responseDataBase.put((Object)"data", (Object)functionSysIPage);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u83dc\u5355\u6811")
    @RequestMapping(value={"/queryAppMenuTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppMenuTree(HttpServletRequest request, String systemId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String userId = this.auth2Service.queryCurrentUserId(request);
            List appMenuTrees = this.functionSysService.queryAppMenus(userId, systemId);
            responseDataBase.put((Object)"data", (Object)appMenuTrees);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @RequestMapping(value={"/queryInfo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryInfo(String functionId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            FunctionDTO functionDTO = this.functionSysService.queryInfo(functionId);
            responseDataBase.put((Object)"data", (Object)functionDTO);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6392\u5e8f")
    @RequestMapping(value={"/upSort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase upSort(String id, String pid, Integer sort, String appId, Integer flag) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.functionSysService.upSort(appId, id, pid, sort, flag);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6302\u63a5\u529f\u80fd\u67e5\u8be2\u6811")
    @RequestMapping(value={"/queryFunctionTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryFunctionTree() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List functionDTOS = this.functionSysService.queryFunctionTreeByGroup();
            responseDataBase.put((Object)"data", (Object)functionDTOS);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6302\u63a5\u529f\u80fd")
    @RequestMapping(value={"/hitchFunction"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase hitchFunction(@RequestParam(name="menuId") String menuId, @RequestParam(name="functionId", required=false) String functionId, @RequestParam(name="open", defaultValue="0") Integer open, @RequestParam(name="linkOneMap", defaultValue="0") Integer linkOneMap, @RequestParam(name="noLogin", defaultValue="1") Integer noLogin, @RequestParam(name="funType", required=false, defaultValue="1") Integer funType, @RequestParam(name="otherStyle", defaultValue="") String otherStyle) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            if (StrUtil.isBlank((CharSequence)functionId)) {
                this.menuService.updateType(menuId, Integer.valueOf(0), "", funType);
            }
            this.menuService.updateType(menuId, Integer.valueOf(2), functionId, funType);
            SysFunction sysFunction = new SysFunction();
            sysFunction.setId(functionId);
            sysFunction.setOpen(open);
            sysFunction.setLinkOneMap(linkOneMap);
            sysFunction.setNoLogin(noLogin);
            sysFunction.setOtherStyle(otherStyle);
            this.functionSysService.updateInfo(sysFunction);
            SysMenu menu = (SysMenu)this.menuService.getById((Serializable)((Object)menuId));
            if (menu != null) {
                menu.setOpen(open);
                menu.setOtherStyle(otherStyle);
                this.menuService.saveOrUp(menu);
            }
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

