/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.entity.SysGroup;
import com.geoway.design.biz.entity.SysNsSystem;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.INsSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7cfb\u7edf\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/system"})
public class NsSystemContorller {
    @Autowired
    private INsSystemService nsSystemService;
    @Autowired
    private IOauth2Service auth2Service;

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u4fe1\u606f")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u4fe1\u606f", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveOrUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveOrUp(SysNsSystem sysNsSystem, @RequestParam(value="logofile", required=false) MultipartFile logofile, @RequestParam(value="bgfile", required=false) MultipartFile bgfile) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.nsSystemService.saveOrUp(sysNsSystem, logofile, bgfile);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664")
    @OpLog(name="\u5220\u9664\u7cfb\u7edf\u4fe1\u606f", opType=OpLog.OpType.del)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase deleteInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="ids", required=false) String ids) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String validIds = StrUtil.isBlank((CharSequence)ids) ? id : ids;
            this.nsSystemService.deleteSystems(validIds);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u76f8\u5173\u4fe1\u606f\u4ee5\u53ca\u83dc\u5355")
    @RequestMapping(value={"/queryBaseByKey"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryByKey(HttpServletRequest request, String key) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            HashMap map = this.nsSystemService.querySystemBaseInfoByKey(key);
            responseDataBase.put((Object)"data", (Object)map);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u76f8\u5173\u4fe1\u606f\u4ee5\u53ca\u83dc\u5355")
    @RequestMapping(value={"/query"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryInfo(HttpServletRequest request, String key) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String userId = this.auth2Service.queryCurrentUserId(request);
            HashMap map = this.nsSystemService.querySystemInfoByUser(userId, key);
            responseDataBase.put((Object)"data", (Object)map);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6388\u6743\u7684\u5e94\u7528\u5217\u8868")
    @RequestMapping(value={"/queryListByUser"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryListByUser(HttpServletRequest request, String userId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            if (StringUtils.isEmpty((CharSequence)userId)) {
                userId = this.auth2Service.queryCurrentUserId(request);
            }
            List systemList = this.nsSystemService.querySystemListByUser(userId);
            responseDataBase.put((Object)"data", (Object)systemList);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryList() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List sysNSystems = this.nsSystemService.queryList();
            responseDataBase.put((Object)"data", (Object)sysNSystems);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u72b6\u6001\u542f\u7528")
    @OpLog(name="\u4fee\u6539\u7cfb\u7edf\u72b6\u6001", opType=OpLog.OpType.update)
    @RequestMapping(value={"/stateUp"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase stateUp(String id, Integer state) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.nsSystemService.stateUp(id, state);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u4fe1\u606f")
    @RequestMapping(value={"/queryAll"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAll() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List sysNSystems = this.nsSystemService.queryAll();
            responseDataBase.put((Object)"data", (Object)sysNSystems);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u5206\u7ec4")
    @OpLog(name="\u65b0\u589e\u6216\u4fee\u6539\u7cfb\u7edf\u5206\u7ec4", opType=OpLog.OpType.update)
    @RequestMapping(value={"/saveGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(SysGroup group) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.nsSystemService.saveGroup(group);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u5206\u7ec4")
    @RequestMapping(value={"/systemGroups"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryAppGroups() {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List groups = this.nsSystemService.querySystemGroups();
            responseDataBase.put((Object)"data", (Object)groups);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u7ec4")
    @OpLog(name="\u5220\u9664\u5e94\u7528\u7ec4", opType=OpLog.OpType.del)
    @RequestMapping(value={"/deleteGroup"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase saveGroup(String groupId) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.nsSystemService.deleteGroup(groupId);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

