/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.design.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.design.base.base.dto.ResponseDataBase;
import com.geoway.design.biz.annotation.OpLog;
import com.geoway.design.biz.dto.UserRegistDTO;
import com.geoway.design.biz.entity.SysUserRegister;
import com.geoway.design.biz.service.dev.IOrganizationService;
import com.geoway.design.biz.service.oauth2.IOauth2Service;
import com.geoway.design.biz.service.sys.ISysRegionService;
import com.geoway.design.biz.service.sys.ISysUserRegisterService;
import com.geoway.design.biz.service.sys.ISysUserService;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u6ce8\u518c\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/register"})
public class RegisterController {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IOrganizationService sysOrganizationService;
    @Autowired
    private ISysUserRegisterService sysUserRegisterService;
    @Autowired
    private ISysRegionService sysRegionService;
    @Autowired
    private IOauth2Service auth2Service;
    @Autowired
    private AccessTokenManager accessTokenManager;

    @ApiOperation(value="\u68c0\u67e5\u8d26\u53f7\u662f\u5426\u91cd\u590d")
    @RequestMapping(value={"/checkAccoutRepeat"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase checkAccoutRepeat(@RequestParam String accout) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            responseDataBase.put((Object)"data", (Object)this.sysUserRegisterService.checkAccoutRepeat(accout));
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u68c0\u67e5\u624b\u673a\u53f7\u662f\u5426\u91cd\u590d")
    @RequestMapping(value={"/checkTelRepeat"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase checkTelRepeat(@RequestParam String tel) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            responseDataBase.put((Object)"data", (Object)this.sysUserRegisterService.checkTelRepeat(tel));
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6ce8\u518c\u7528\u6237")
    @OpLog(name="\u6ce8\u518c\u7528\u6237", opType=OpLog.OpType.update)
    @RequestMapping(value={"/registerUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase registerUser(SysUserRegister user) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserRegisterService.registerUser(user);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase queryPage(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String accessToken = request.getHeader("access_token");
            AccessTokenContent accessTokenContent = this.accessTokenManager.get(accessToken);
            String userId = accessTokenContent.getUser().getId();
            Integer userCatalog = accessTokenContent.getUser().getCatalog();
            IPage pages = this.sysUserRegisterService.queryPage(filterParam, page.intValue(), size.intValue(), userId, userCatalog);
            responseDataBase.put((Object)"data", (Object)pages);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u5ba1\u6838\u6ce8\u518c")
    @OpLog(name="\u5ba1\u6838\u6ce8\u518c", opType=OpLog.OpType.update)
    @RequestMapping(value={"/audit"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResponseDataBase audit(HttpServletRequest request, @RequestParam String id, @RequestParam Boolean passed, String auditOpinion) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            String userId = this.auth2Service.queryCurrentUserId(request);
            boolean result = this.sysUserRegisterService.audit(userId, id, passed, auditOpinion);
            responseDataBase.put((Object)"data", (Object)result);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u6ce8\u518c\u7528\u6237")
    @OpLog(name="\u6ce8\u518c\u7528\u6237", opType=OpLog.OpType.update)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseDataBase userRegister(@Valid UserRegistDTO userDtO) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            this.sysUserService.userRegistrer(userDtO);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @RequestMapping(value={"/queryOrgTree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseDataBase getOrgTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        List orgTree = null;
        try {
            orgTree = this.sysOrganizationService.queryTreeNoUser(filterParam);
            responseDataBase.put((Object)"data", (Object)orgTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @RequestMapping(value={"/queryRegionTree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseDataBase queryRegionTree(String filterParam) {
        ResponseDataBase responseDataBase = new ResponseDataBase();
        try {
            List regionTree = this.sysRegionService.queryTree(filterParam, "SORT_code_ASC");
            responseDataBase.put((Object)"data", (Object)regionTree);
        }
        catch (Exception e) {
            return ResponseDataBase.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

